/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.freemarker;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.ClassPathResource;

public class FreemarkerUtil {
    public static final String UTF_8 = "UTF-8";
    private static Configuration conf = new Configuration();

    public static void init(String path, String pro) throws Exception {
        conf.setOutputEncoding(UTF_8);
        conf.setDefaultEncoding(UTF_8);
        if (StringUtils.isBlank((String)path)) {
            path = "/freemarker/";
        }
        if (StringUtils.isBlank((String)pro)) {
            path = "freemarker/prop/freemarker.properties";
        }
        conf.setClassForTemplateLoading(FreemarkerUtil.class, path);
        try {
            ClassPathResource res = new ClassPathResource(pro);
            conf.setSettings(res.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void translate(Object data, String tplName, String output) throws Exception {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        rootObj.put("data", data);
        Template t = conf.getTemplate(tplName, UTF_8);
        File outputFile = new File(output);
        outputFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(outputFile);
        t.process(rootObj, (Writer)writer);
        rootObj.clear();
    }

    public static void translateByString(Object data, String templateStr, String output) throws Exception {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        rootObj.put("data", data);
        Template template = new Template("template", (Reader)new StringReader(templateStr), conf);
        template.setEncoding(UTF_8);
        File outputFile = new File(output);
        outputFile.getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), UTF_8));
        template.process(rootObj, (Writer)writer);
        rootObj.clear();
    }

    public static String returnTranslateByString(Object data, String templateStr) {
        HashMap<String, Object> rootObj = new HashMap<String, Object>(3);
        rootObj.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        rootObj.put("static", BeansWrapper.getDefaultInstance().getStaticModels());
        rootObj.put("data", data);
        try {
            Template template = new Template("template", (Reader)new StringReader(templateStr), conf);
            template.setEncoding(UTF_8);
            StringWriter writer = new StringWriter();
            template.process(rootObj, (Writer)writer);
            rootObj.clear();
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> getExtValue(String templateStr) {
        try {
            Template template = new Template("template", (Reader)new StringReader(templateStr), conf);
            template.setEncoding(UTF_8);
            int i = template.getRootTreeNode().getChildNodes().size();
            ArrayList<String> plist = new ArrayList<String>();
            for (int j = 0; j < i; ++j) {
                String str;
                StringModel a = (StringModel)template.getRootTreeNode().getChildNodes().get(j);
                if (!"freemarker.core.DollarVariable".equals(a.getWrappedObject().getClass().getName()) || null == (str = a.getAsString())) continue;
                str = str.replace(" ", "").replace("${data.", "").replace("}", "");
                plist.add(str);
            }
            return plist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String s = "<!DOCTYPE html> <html> \"${data.v324321 }\" <body> <div id=\"page-wrapper\" menuComcode=\"01000189\" > \t${data.c134132} \t<div class=\"main\" menuComcode=\"01000185\"> \t${data.banner}  \t\t</body> </html>";
        List<String> custom = FreemarkerUtil.getExtValue(s);
        System.out.println(custom);
        if (null == custom) {
            return;
        }
        for (String string : custom) {
            System.out.println(string);
        }
    }
}

