/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ftp.service.impl;

import com.yqbsoft.laser.service.adapter.ftp.FtpClientUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.ftp.FtpBaseUser;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ftp.dao.FtpFtpuserMapper;
import com.yqbsoft.laser.service.ftp.domain.FtpFtpuserDomainBean;
import com.yqbsoft.laser.service.ftp.model.FtpFtpserver;
import com.yqbsoft.laser.service.ftp.model.FtpFtpuser;
import com.yqbsoft.laser.service.ftp.service.FtpserverService;
import com.yqbsoft.laser.service.ftp.service.FtpuserService;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FtpuserServiceImpl
extends BaseServiceImpl
implements FtpuserService {
    public static final String SYS_CODE = "ftp.BUG.FtpuserServiceImpl";
    private FtpFtpuserMapper ftpFtpuserMapper;
    private FtpserverService ftpserverService;

    public void setFtpserverService(FtpserverService ftpserverService) {
        this.ftpserverService = ftpserverService;
    }

    public void setFtpFtpuserMapper(FtpFtpuserMapper ftpFtpuserMapper) {
        this.ftpFtpuserMapper = ftpFtpuserMapper;
    }

    private String check(FtpFtpuserDomainBean ftpFtpuserDomainBean) {
        if (null == ftpFtpuserDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ftpFtpuserDomainBean.getFtpuserCode())) {
            msg = msg + "FtpuserCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ftpFtpuserDomainBean.getFtpuserPswd())) {
            msg = msg + "FtpuserPswd\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ftpFtpuserDomainBean.getFtpuserHdir())) {
            msg = msg + "FtpuserHdir\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(FtpFtpuser ftpFtpuser) {
        if (null == ftpFtpuser) {
            return;
        }
        if (null == ftpFtpuser.getDataState()) {
            ftpFtpuser.setDataState(0);
        }
        if (null == ftpFtpuser.getGmtCreate()) {
            ftpFtpuser.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)ftpFtpuser.getFtpuserCode())) {
            int code = this.getMaxCode();
            ftpFtpuser.setFtpuserCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ftpFtpuserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpdataDefault(FtpFtpuser ftpFtpuser) {
        if (null == ftpFtpuser) {
            return;
        }
        if (null == ftpFtpuser.getDataState()) {
            ftpFtpuser.setDataState(0);
        }
        if (null == ftpFtpuser.getGmtCreate()) {
            ftpFtpuser.setGmtCreate(this.getSysDate());
        }
    }

    private int saveFtpuserModel(FtpFtpuser ftpFtpuser) throws ApiException {
        if (null == ftpFtpuser) {
            return 0;
        }
        try {
            return this.ftpFtpuserMapper.insert(ftpFtpuser);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.saveFtpuserModel.ex");
        }
    }

    private FtpFtpuser getFtpuserModelById(Integer ftpuserId) {
        if (null == ftpuserId) {
            return null;
        }
        try {
            return this.ftpFtpuserMapper.selectByPrimaryKey(ftpuserId);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.getFtpuserModelById", (Throwable)e);
            return null;
        }
    }

    public FtpFtpuser getFtpuserModelByCode(String ftpuserCode) {
        if (null == ftpuserCode) {
            return null;
        }
        try {
            return this.ftpFtpuserMapper.selectByCode(ftpuserCode);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.getFtpuserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void deleteFtpuserModel(Integer ftpuserId) throws ApiException {
        if (null == ftpuserId) {
            return;
        }
        int i = 0;
        try {
            i = this.ftpFtpuserMapper.deleteByPrimaryKey(ftpuserId);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.deleteFtpuserModel.ex");
        }
        if (1 != i) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.deleteFtpuserModel.num");
        }
    }

    private void updateFtpuserModel(FtpFtpuser ftpFtpuser) throws ApiException {
        if (null == ftpFtpuser) {
            return;
        }
        try {
            this.ftpFtpuserMapper.updateByPrimaryKey(ftpFtpuser);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.updateFtpuserModel.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.ftpFtpuserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void updateStateFtpuserMode(Integer ftpuserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ftpuserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ftpuserId", ftpuserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ftpFtpuserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.updateStateFtpuserModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.updateStateFtpuserModel.null");
        }
    }

    private List<FtpFtpuser> queryFtpuserModelPage(Map<String, Object> parammap) {
        try {
            return this.ftpFtpuserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.queryFtpuserModel", (Throwable)e);
            return null;
        }
    }

    private FtpFtpuser makeFtpuser(FtpFtpuserDomainBean ftpFtpuserDomainBean, FtpFtpuser ftpFtpuser) {
        if (null == ftpFtpuserDomainBean) {
            return null;
        }
        if (null == ftpFtpuser) {
            ftpFtpuser = new FtpFtpuser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ftpFtpuser, (Object)ftpFtpuserDomainBean);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.makeFtpuser", (Throwable)e);
        }
        if (!"admin".equals(ftpFtpuser.getFtpuserCode())) {
            FtpFtpuser admin = this.getFtpuserModelByCode("admin");
            if (null != admin) {
                List list;
                ftpFtpuser.setFtpuserRoot(admin.getFtpuserRoot());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("appmanageIcode", ServletMain.getAppName());
                QueryResult<FtpFtpserver> relist = this.ftpserverService.queryFtpserverPage(map);
                if (null != relist && null != (list = relist.getList()) && !list.isEmpty()) {
                    FtpClientUtil ftpClientUtil = new FtpClientUtil();
                    for (FtpFtpserver ftpFtpserver : list) {
                        ftpClientUtil.createFtp(ftpFtpserver.getFtpserverUrl(), Integer.valueOf(ftpFtpserver.getFtpserverPort()).intValue(), "admin", admin.getMemo(), ftpFtpuser.getFtpuserHdir(), null);
                    }
                }
            }
        } else {
            List list;
            ftpFtpuser.setFtpuserHdir("");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appmanageIcode", ServletMain.getAppName());
            QueryResult<FtpFtpserver> relist = this.ftpserverService.queryFtpserverPage(map);
            if (null != relist && null != (list = relist.getList()) && !list.isEmpty()) {
                ftpFtpuser.setFtpuserRoot(((FtpFtpserver)list.get(0)).getFtpserverPath());
            }
        }
        return ftpFtpuser;
    }

    private int countFtpuser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ftpFtpuserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpuserServiceImpl.countFtpuser", (Throwable)e);
        }
        return i;
    }

    @Override
    public FtpFtpuser saveFtpuser(FtpFtpuserDomainBean ftpFtpuserDomainBean) throws ApiException {
        String msg = this.check(ftpFtpuserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.saveFtpuser.check", msg);
        }
        FtpFtpuser ftpFtpuser = this.makeFtpuser(ftpFtpuserDomainBean, null);
        this.setDefault(ftpFtpuser);
        this.saveFtpuserModel(ftpFtpuser);
        return ftpFtpuser;
    }

    @Override
    public void updateFtpuserState(Integer ftpuserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFtpuserMode(ftpuserId, dataState, oldDataState);
    }

    @Override
    public void updateFtpuser(FtpFtpuserDomainBean ftpFtpuserDomainBean) throws ApiException {
        String msg = this.check(ftpFtpuserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.updateFtpuser.check", msg);
        }
        FtpFtpuser oldFtpFtpuser = this.getFtpuserModelById(ftpFtpuserDomainBean.getFtpuserId());
        if (null == oldFtpFtpuser) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.updateFtpuser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FtpFtpuser ftpFtpuser = this.makeFtpuser(ftpFtpuserDomainBean, oldFtpFtpuser);
        this.setUpdataDefault(ftpFtpuser);
        this.updateFtpuserModel(ftpFtpuser);
    }

    @Override
    public FtpFtpuser getFtpuser(Integer ftpuserId) {
        return this.getFtpuserModelById(ftpuserId);
    }

    @Override
    public FtpFtpuser getFtpuserByCode(String ftpuserCode) {
        return this.getFtpuserModelByCode(ftpuserCode);
    }

    @Override
    public void deleteFtpuser(Integer ftpuserId) throws ApiException {
        this.deleteFtpuserModel(ftpuserId);
    }

    @Override
    public QueryResult<FtpFtpuser> queryFtpuserPage(Map<String, Object> map) {
        List<FtpFtpuser> ftpFtpuserList = this.queryFtpuserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFtpuser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ftpFtpuserList);
        return queryResult;
    }

    @Override
    public void queryFtpuserLoadCache() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        List<FtpFtpuser> ftpFtpuserList = this.queryFtpuserModelPage(parammap);
        String key = "EsftpFtpuser-list";
        if (null == ftpFtpuserList || ftpFtpuserList.isEmpty()) {
            DisUtil.del((String)key);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            for (FtpFtpuser ftpFtpuser : ftpFtpuserList) {
                map.put(ftpFtpuser.getFtpuserCode(), JsonUtil.buildNormalBinder().toJson((Object)this.getUserByCode(ftpFtpuser)));
            }
            DisUtil.setMap((String)key, map);
        }
    }

    private FtpBaseUser getUserByCode(FtpFtpuser ftpFtpuser) {
        if (null == ftpFtpuser) {
            return null;
        }
        FtpBaseUser thisUser = new FtpBaseUser();
        thisUser.setName(ftpFtpuser.getFtpuserCode());
        thisUser.setPassword(ftpFtpuser.getFtpuserPswd());
        thisUser.setHomeDirectory(ftpFtpuser.getFtpuserRoot() + (null == ftpFtpuser.getFtpuserHdir() ? "" : ftpFtpuser.getFtpuserHdir()));
        thisUser.setEnabled(false);
        if (null != ftpFtpuser.getDataState() && "1".equals(ftpFtpuser.getDataState().toString())) {
            thisUser.setEnabled(true);
        }
        thisUser.setWriteper(false);
        if (null != ftpFtpuser.getFtpuserWriteper() && "1".equals(ftpFtpuser.getFtpuserWriteper().toString())) {
            thisUser.setWriteper(true);
        }
        thisUser.setMaxIdleTime(ftpFtpuser.getFtpuserIdletime());
        thisUser.setMaxln(ftpFtpuser.getFtpuserMaxln());
        thisUser.setMaxlpip(ftpFtpuser.getFtpuserMaxlpip());
        thisUser.setDownloadrate(ftpFtpuser.getFtpuserDownloadrate());
        thisUser.setUploadrate(ftpFtpuser.getFtpuserUploadrate());
        return thisUser;
    }

    @Override
    public void updateFtpuserPermis(String ftpuserCode, Integer ftpuserWriteper) throws ApiException {
        FtpFtpuser oldFtpFtpuser = this.getFtpuserByCode(ftpuserCode);
        if (null == oldFtpFtpuser) {
            throw new ApiException("ftp.BUG.FtpuserServiceImpl.updateFtpuserPermis.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldFtpFtpuser.setFtpuserWriteper(ftpuserWriteper);
        this.updateFtpuserModel(oldFtpFtpuser);
    }
}

