/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftCardMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftCardDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftCardReDomain;
import com.yqbsoft.laser.service.gt.model.GtGiftCard;
import com.yqbsoft.laser.service.gt.service.GtGiftCardService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftCardServiceImpl
extends BaseServiceImpl
implements GtGiftCardService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftCardServiceImpl";
    private GtGiftCardMapper gtGiftCardMapper;

    public void setGtGiftCardMapper(GtGiftCardMapper gtGiftCardMapper) {
        this.gtGiftCardMapper = gtGiftCardMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftCardMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftCard(GtGiftCardDomain gtGiftCardDomain) {
        if (null == gtGiftCardDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftCardDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftCardDefault(GtGiftCard gtGiftCard) {
        if (null == gtGiftCard) {
            return;
        }
        if (null == gtGiftCard.getDataState()) {
            gtGiftCard.setDataState(0);
        }
        if (null == gtGiftCard.getGmtCreate()) {
            gtGiftCard.setGmtCreate(this.getSysDate());
        }
        gtGiftCard.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftCard.getGiftCardCode())) {
            gtGiftCard.setGiftCardCode(this.createUUIDString());
        }
    }

    private int getGiftCardMaxCode() {
        int code = 0;
        try {
            return this.gtGiftCardMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.getGiftCardMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftCardUpdataDefault(GtGiftCard gtGiftCard) {
        if (null == gtGiftCard) {
            return;
        }
        gtGiftCard.setGmtModified(this.getSysDate());
    }

    private void saveGiftCardModel(GtGiftCard gtGiftCard) throws ApiException {
        if (null == gtGiftCard) {
            return;
        }
        try {
            this.gtGiftCardMapper.insert(gtGiftCard);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.saveGiftCardModel.ex", (Throwable)e);
        }
    }

    private void saveGiftCardBatchModel(List<GtGiftCard> gtGiftCardList) throws ApiException {
        if (null == gtGiftCardList || gtGiftCardList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftCardMapper.insertBatch(gtGiftCardList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.saveGiftCardBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftCard getGiftCardModelById(Integer giftCardId) {
        if (null == giftCardId) {
            return null;
        }
        try {
            return this.gtGiftCardMapper.selectByPrimaryKey(giftCardId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.getGiftCardModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftCard getGiftCardModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftCardMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.getGiftCardModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftCardModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftCardMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.delGiftCardModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.delGiftCardModelByCode.num");
        }
    }

    private void deleteGiftCardModel(Integer giftCardId) throws ApiException {
        if (null == giftCardId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftCardMapper.deleteByPrimaryKey(giftCardId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.deleteGiftCardModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.deleteGiftCardModel.num");
        }
    }

    private void updateGiftCardModel(GtGiftCard gtGiftCard) throws ApiException {
        if (null == gtGiftCard) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftCardMapper.updateByPrimaryKeySelective(gtGiftCard);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateGiftCardModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateGiftCardModel.num");
        }
    }

    private void updateStateGiftCardModel(Integer giftCardId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftCardId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftCardId", giftCardId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftCardMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateStateGiftCardModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateStateGiftCardModel.null");
        }
    }

    private void updateStateGiftCardModelByCode(String tenantCode, String giftCardCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftCardCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCardCode", giftCardCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftCardMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateStateGiftCardModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateStateGiftCardModelByCode.null");
        }
    }

    private GtGiftCard makeGiftCard(GtGiftCardDomain gtGiftCardDomain, GtGiftCard gtGiftCard) {
        if (null == gtGiftCardDomain) {
            return null;
        }
        if (null == gtGiftCard) {
            gtGiftCard = new GtGiftCard();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftCard, (Object)gtGiftCardDomain);
            return gtGiftCard;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.makeGiftCard", (Throwable)e);
            return null;
        }
    }

    private GtGiftCardReDomain makeGtGiftCardReDomain(GtGiftCard gtGiftCard) {
        if (null == gtGiftCard) {
            return null;
        }
        GtGiftCardReDomain gtGiftCardReDomain = new GtGiftCardReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftCardReDomain, (Object)gtGiftCard);
            return gtGiftCardReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.makeGtGiftCardReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftCard> queryGiftCardModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftCardMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.queryGiftCardModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftCard(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftCardMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftCardServiceImpl.countGiftCard", (Throwable)e);
        }
        return i;
    }

    private GtGiftCard createGtGiftCard(GtGiftCardDomain gtGiftCardDomain) {
        String msg = this.checkGiftCard(gtGiftCardDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.saveGiftCard.checkGiftCard", msg);
        }
        GtGiftCard gtGiftCard = this.makeGiftCard(gtGiftCardDomain, null);
        this.setGiftCardDefault(gtGiftCard);
        return gtGiftCard;
    }

    @Override
    public String saveGiftCard(GtGiftCardDomain gtGiftCardDomain) throws ApiException {
        GtGiftCard gtGiftCard = this.createGtGiftCard(gtGiftCardDomain);
        this.saveGiftCardModel(gtGiftCard);
        return gtGiftCard.getGiftCardCode();
    }

    @Override
    public String saveGiftCardBatch(List<GtGiftCardDomain> gtGiftCardDomainList) throws ApiException {
        if (null == gtGiftCardDomainList || gtGiftCardDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftCard> gtGiftCardList = new ArrayList<GtGiftCard>();
        String code = "";
        for (GtGiftCardDomain gtGiftCardDomain : gtGiftCardDomainList) {
            GtGiftCard gtGiftCard = this.createGtGiftCard(gtGiftCardDomain);
            code = gtGiftCard.getGiftCardCode();
            gtGiftCardList.add(gtGiftCard);
        }
        this.saveGiftCardBatchModel(gtGiftCardList);
        return code;
    }

    @Override
    public void updateGiftCardState(Integer giftCardId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftCardModel(giftCardId, dataState, oldDataState);
    }

    @Override
    public void updateGiftCardStateByCode(String tenantCode, String giftCardCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftCardModelByCode(tenantCode, giftCardCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftCard(GtGiftCardDomain gtGiftCardDomain) throws ApiException {
        String msg = this.checkGiftCard(gtGiftCardDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateGiftCard.checkGiftCard", msg);
        }
        GtGiftCard oldGtGiftCard = this.getGiftCardModelById(gtGiftCardDomain.getGiftCardId());
        if (null == oldGtGiftCard) {
            throw new ApiException("gt.GIFT.GtGiftCardServiceImpl.updateGiftCard.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftCard gtGiftCard = this.makeGiftCard(gtGiftCardDomain, oldGtGiftCard);
        this.setGiftCardUpdataDefault(gtGiftCard);
        this.updateGiftCardModel(gtGiftCard);
    }

    @Override
    public GtGiftCard getGiftCard(Integer giftCardId) {
        return this.getGiftCardModelById(giftCardId);
    }

    @Override
    public void deleteGiftCard(Integer giftCardId) throws ApiException {
        this.deleteGiftCardModel(giftCardId);
    }

    @Override
    public QueryResult<GtGiftCard> queryGiftCardPage(Map<String, Object> map) {
        List<GtGiftCard> gtGiftCardList = this.queryGiftCardModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftCard(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftCardList);
        return queryResult;
    }

    @Override
    public GtGiftCard getGiftCardByCode(String tenantCode, String giftCardCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCardCode", giftCardCode);
        return this.getGiftCardModelByCode(map);
    }

    @Override
    public void deleteGiftCardByCode(String tenantCode, String giftCardCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCardCode", giftCardCode);
        this.delGiftCardModelByCode(map);
    }
}

