/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.healthy.controller;

import com.yqbsoft.laser.service.adapter.mq.JmsConnetServiceImpl;
import com.yqbsoft.laser.service.adapter.mq.ProducerCall;
import com.yqbsoft.laser.service.adapter.mq.ProducerSession;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.sync.SyncInvokeFuture;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/laserDirect/healthy"})
public class HealthyController {
    private static final String RESULT_OK = "ok";
    private static final String RESULT_ERROR = "error";
    private static final int HEARTBEAT_CHECK_TIME = 2000;
    private static OpenLogUtil logger = new OpenLogUtil(HealthyController.class);

    @RequestMapping(method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map producerMap;
        String ok = SupDisUtil.get((String)RESULT_OK);
        if (StringUtils.isBlank((String)ok)) {
            SupDisUtil.set((String)RESULT_OK, (String)RESULT_OK);
            ok = SupDisUtil.get((String)RESULT_OK);
        }
        if (!RESULT_OK.equals(ok)) {
            response.setStatus(500);
            response.getWriter().print("redis is error");
        }
        if (null == (producerMap = JmsConnetServiceImpl.producerSessionMap) || producerMap.isEmpty()) {
            logger.error("HealthyController.get.producerMap");
            response.setStatus(200);
            response.getWriter().print(RESULT_OK);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : producerMap.keySet()) {
            ProducerSession psession = (ProducerSession)producerMap.get(key);
            try {
                ObjectMessage textMessage = psession.getSession().createObjectMessage();
                textMessage.setStringProperty("mq_filter_appKey", ServletMain.getAppKey());
                textMessage.setBooleanProperty("heartbeat", true);
                textMessage.setJMSReplyTo(psession.getRepDest());
                String jmsId = UUID.randomUUID().toString();
                textMessage.setJMSCorrelationID(jmsId);
                SyncInvokeFuture syncInvokeFuture = new SyncInvokeFuture();
                ProducerCall.putSync((String)jmsId, (SyncInvokeFuture)syncInvokeFuture, (long)2000L);
                psession.getProducer().send((Message)textMessage, psession.getProducer().getDeliveryMode(), 9, 2000L);
                OutMessage obj = syncInvokeFuture.get(2000L);
                if (obj == null || obj.isError()) {
                    result.put(key, RESULT_ERROR);
                    continue;
                }
                result.put(key, RESULT_OK);
            }
            catch (Exception e) {
                logger.error("HealthyController.get.ex", (Object)(key + "=" + psession.getName()), (Throwable)e);
                result.put(key, RESULT_ERROR);
            }
        }
        boolean success = false;
        StringBuffer sb = new StringBuffer();
        for (String qstate : result.keySet()) {
            sb.append(qstate + ":" + (String)result.get(qstate) + "\n");
            if (!((String)result.get(qstate)).equals(RESULT_OK)) continue;
            success = true;
        }
        if (success) {
            response.setStatus(200);
            response.getWriter().print(RESULT_OK);
        } else {
            response.setStatus(500);
            response.getWriter().print(sb.toString());
        }
    }
}

