/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.imsg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.imsg.dao.ImsgImsgMapper;
import com.yqbsoft.laser.service.imsg.domain.ImsgImsgDomainBean;
import com.yqbsoft.laser.service.imsg.model.ImsgImsg;
import com.yqbsoft.laser.service.imsg.service.ImsgService;
import com.yqbsoft.laser.service.imsg.service.ImsgtemplateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class ImsgServiceImpl
extends BaseServiceImpl
implements ImsgService {
    public static final String SYS_CODE = "imsg.IMSG.ImsgServiceImpl";
    private ImsgImsgMapper imsgImsgMapper;
    private ImsgtemplateService imsgtemplateService;

    public void setImsgImsgMapper(ImsgImsgMapper imsgImsgMapper) {
        this.imsgImsgMapper = imsgImsgMapper;
    }

    private Date getSysDate() {
        try {
            return this.imsgImsgMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkImsg(ImsgImsgDomainBean imsgImsgDomainBean) {
        if (null == imsgImsgDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setImsgDefault(ImsgImsg imsgImsg) {
        if (null == imsgImsg) {
            return;
        }
        if (null == imsgImsg.getDataState()) {
            imsgImsg.setDataState(0);
        }
        if (null == imsgImsg.getGmtCreate()) {
            imsgImsg.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)imsgImsg.getImsgCode())) {
            int code = this.getMaxCode();
            imsgImsg.setImsgCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.imsgImsgMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setImsgUpdataDefault(ImsgImsg imsgImsg) {
        if (null == imsgImsg) {
            return;
        }
    }

    private void saveImsgModel(ImsgImsg imsgImsg) throws ApiException {
        if (null == imsgImsg) {
            return;
        }
        try {
            this.imsgImsgMapper.insert(imsgImsg);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.saveFtpserverModel.ex");
        }
    }

    private ImsgImsg getImsgModelById(Integer imsgId) {
        if (null == imsgId) {
            return null;
        }
        try {
            return this.imsgImsgMapper.selectByPrimaryKey(imsgId);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgServiceImpl.getImsgModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteImsgModel(Integer imsgId) throws ApiException {
        if (null == imsgId) {
            return;
        }
        int i = 0;
        try {
            i = this.imsgImsgMapper.deleteByPrimaryKey(imsgId);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.deleteImsgModel.ex");
        }
        if (1 != i) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.deleteImsgModel.num");
        }
    }

    private void updateImsgModel(ImsgImsg imsgImsg) throws ApiException {
        if (null == imsgImsg) {
            return;
        }
        try {
            this.imsgImsgMapper.updateByPrimaryKeySelective(imsgImsg);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateImsgModel.ex");
        }
    }

    private void updateStateImsgModel(Integer imsgId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == imsgId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imsgId", imsgId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.imsgImsgMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateStateImsgModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateStateImsgModel.null");
        }
    }

    private void updateStateByManualmsgCodeModel(String manualmsgCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == manualmsgCode || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("manualmsgCode", manualmsgCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.imsgImsgMapper.updateStateByManualmsgCode(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateStateByManualmsgCodeModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateStateByManualmsgCodeModel.null");
        }
    }

    private ImsgImsg makeImsg(ImsgImsgDomainBean imsgImsgDomainBean, ImsgImsg imsgImsg) {
        if (null == imsgImsgDomainBean) {
            return null;
        }
        if (null == imsgImsg) {
            imsgImsg = new ImsgImsg();
        }
        try {
            BeanUtils.copyAllPropertys((Object)imsgImsg, (Object)imsgImsgDomainBean);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgServiceImpl.makeImsg", (Throwable)e);
        }
        return imsgImsg;
    }

    private List<ImsgImsg> queryImsgModelPage(Map<String, Object> parammap) {
        try {
            return this.imsgImsgMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgServiceImpl.queryImsgModel", (Throwable)e);
            return null;
        }
    }

    private int countImsg(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.imsgImsgMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgServiceImpl.countImsg", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveImsg(ImsgImsgDomainBean imsgImsgDomainBean) throws ApiException {
        String msg = this.checkImsg(imsgImsgDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.saveImsg.checkImsg", msg);
        }
        ImsgImsg imsgImsg = this.makeImsg(imsgImsgDomainBean, null);
        this.setImsgDefault(imsgImsg);
        this.saveImsgModel(imsgImsg);
    }

    @Override
    public void saveImsgByMap(Map<String, String> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        ImsgImsg imsgImsg = this.makeImsgByMap(map);
        this.setImsgDefault(imsgImsg);
        this.saveImsgModel(imsgImsg);
    }

    private ImsgImsg makeImsgByMap(Map<String, String> map) {
        ImsgImsg imsgImsg = new ImsgImsg();
        imsgImsg.setImsgSubject(map.get("imsgSubject"));
        imsgImsg.setImsgContent(map.get("imsgContent"));
        imsgImsg.setImsgType(map.get("imsgType"));
        imsgImsg.setImsgSuserCode(map.get("imsgSuserCode"));
        imsgImsg.setImsgSuserName(map.get("imsgSuserName"));
        imsgImsg.setImsgAuserCode(map.get("imsgAuserCode"));
        imsgImsg.setImsgAuserName(map.get("imsgAuserName"));
        return imsgImsg;
    }

    @Override
    public void saveImsgBatch(List<ImsgImsgDomainBean> list) throws ApiException {
        if (null != list && list.size() > 0) {
            for (ImsgImsgDomainBean imsgImsg : list) {
                this.saveImsg(imsgImsg);
            }
        }
    }

    @Override
    public void updateImsgState(Integer imsgId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateImsgModel(imsgId, dataState, oldDataState);
    }

    @Override
    public void updateImsg(ImsgImsgDomainBean imsgImsgDomainBean) throws ApiException {
        String msg = this.checkImsg(imsgImsgDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateImsg.checkImsg", msg);
        }
        ImsgImsg oldImsgImsg = this.getImsgModelById(imsgImsgDomainBean.getImsgId());
        if (null == oldImsgImsg) {
            throw new ApiException("imsg.IMSG.ImsgServiceImpl.updateImsg.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ImsgImsg imsgImsg = this.makeImsg(imsgImsgDomainBean, oldImsgImsg);
        this.setImsgUpdataDefault(imsgImsg);
        this.updateImsgModel(imsgImsg);
    }

    @Override
    public ImsgImsg getImsg(Integer imsgId) {
        return this.getImsgModelById(imsgId);
    }

    @Override
    public void deleteImsg(Integer imsgId) throws ApiException {
        this.deleteImsgModel(imsgId);
    }

    @Override
    public QueryResult<ImsgImsg> queryImsgPage(Map<String, Object> map) {
        List<ImsgImsg> imsgImsgList = this.queryImsgModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countImsg(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(imsgImsgList);
        return queryResult;
    }

    @Override
    public List<ImsgImsg> queryImsgList(Map<String, Object> map) {
        List<ImsgImsg> imsgImsgList = this.queryImsgModelPage(map);
        return imsgImsgList;
    }

    @Override
    public void saveImsgByNotContent(ImsgImsgDomainBean imsgImsgDomainBean, Map<String, Object> map, String imsgtemplateCode) throws ApiException {
        String content = this.imsgtemplateService.getImsgtemplateContent(imsgtemplateCode, map);
        if (imsgImsgDomainBean != null) {
            imsgImsgDomainBean.setImsgContent(content);
        }
        this.saveImsg(imsgImsgDomainBean);
    }

    @Override
    public void saveImsgByMns(Map<String, String> map) throws ApiException {
        ImsgImsgDomainBean imsgImsgDomain = (ImsgImsgDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(map), ImsgImsgDomainBean.class);
        this.saveImsg(imsgImsgDomain);
    }

    @Override
    public void saveImsgByTask(Map<String, Object> map) throws ApiException {
        ImsgImsgDomainBean imsgImsgDomainBean = new ImsgImsgDomainBean();
        imsgImsgDomainBean.setImsgSubject(map.get("mnslistSubject").toString());
        imsgImsgDomainBean.setImsgContent(map.get("mnslistContent").toString());
        imsgImsgDomainBean.setImsgExp(JsonUtil.buildNormalBinder().toJson(map));
        List auserList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(String.valueOf(map.get("auser")), Map.class);
        if (!CollectionUtils.isEmpty((Collection)auserList)) {
            for (int i = 0; i < auserList.size(); ++i) {
                Map mapAuser = (Map)auserList.get(i);
                String auserCode = String.valueOf(mapAuser.get("auserCode"));
                String auserName = String.valueOf(mapAuser.get("auserName"));
                imsgImsgDomainBean.setImsgType("0");
                imsgImsgDomainBean.setImsgAuserName(auserName);
                imsgImsgDomainBean.setImsgAuserCode(auserCode);
                imsgImsgDomainBean.setImsgSuserCode("sys");
                imsgImsgDomainBean.setImsgSuserName("sys");
                imsgImsgDomainBean.setImsgCheckFlag("1");
                this.saveImsg(imsgImsgDomainBean);
            }
        }
    }

    @Override
    public void updateStateByManualmsgCode(String manualmsgCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateByManualmsgCodeModel(manualmsgCode, dataState, oldDataState);
    }
}

