/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.imsg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.imsg.dao.ImsgPushmsgHistoryMapper;
import com.yqbsoft.laser.service.imsg.domain.ImsgPushmsgHistoryDomain;
import com.yqbsoft.laser.service.imsg.model.ImsgPushmsgHistory;
import com.yqbsoft.laser.service.imsg.service.ImsgPushmsgHistoryService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImsgPushmsgHistoryServiceImpl
extends BaseServiceImpl
implements ImsgPushmsgHistoryService {
    public static final String SYS_CODE = "imsg.IMSG.ImsgPushmsgHistoryServiceImpl";
    private ImsgPushmsgHistoryMapper imsgPushmsgHistoryMapper;

    public void setImsgPushmsgHistoryMapper(ImsgPushmsgHistoryMapper imsgPushmsgHistoryMapper) {
        this.imsgPushmsgHistoryMapper = imsgPushmsgHistoryMapper;
    }

    private Date getSysDate() {
        try {
            return this.imsgPushmsgHistoryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPushmsgHistory(ImsgPushmsgHistoryDomain imsgPushmsgHistoryDomain) {
        if (null == imsgPushmsgHistoryDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPushmsgHistoryDefault(ImsgPushmsgHistory imsgPushmsgHistory) {
        if (null == imsgPushmsgHistory) {
            return;
        }
        if (null == imsgPushmsgHistory.getDataState()) {
            imsgPushmsgHistory.setDataState(0);
        }
        if (null == imsgPushmsgHistory.getGmtCreate()) {
            imsgPushmsgHistory.setGmtCreate(this.getSysDate());
        }
        imsgPushmsgHistory.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)imsgPushmsgHistory.getPushmsgCode())) {
            imsgPushmsgHistory.setPushmsgCode(this.createUUIDString());
        }
    }

    private int getPushmsgHistoryMaxCode() {
        int code = 0;
        try {
            return this.imsgPushmsgHistoryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.getPushmsgHistoryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPushmsgHistoryUpdataDefault(ImsgPushmsgHistory imsgPushmsgHistory) {
        if (null == imsgPushmsgHistory) {
            return;
        }
        imsgPushmsgHistory.setGmtModified(this.getSysDate());
    }

    private int savePushmsgHistoryModel(ImsgPushmsgHistory imsgPushmsgHistory) throws ApiException {
        if (null == imsgPushmsgHistory) {
            return 0;
        }
        try {
            return this.imsgPushmsgHistoryMapper.insert(imsgPushmsgHistory);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.savePushmsgHistoryModel.ex", (Throwable)e);
        }
    }

    private ImsgPushmsgHistory getPushmsgHistoryModelById(Integer pushmsgId) {
        if (null == pushmsgId) {
            return null;
        }
        try {
            return this.imsgPushmsgHistoryMapper.selectByPrimaryKey(pushmsgId);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.getPushmsgHistoryModelById", (Throwable)e);
            return null;
        }
    }

    public ImsgPushmsgHistory getPushmsgHistoryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.imsgPushmsgHistoryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.getPushmsgHistoryModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPushmsgHistoryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.imsgPushmsgHistoryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.delPushmsgHistoryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.delPushmsgHistoryModelByCode.num");
        }
    }

    private void deletePushmsgHistoryModel(Integer pushmsgId) throws ApiException {
        if (null == pushmsgId) {
            return;
        }
        int i = 0;
        try {
            i = this.imsgPushmsgHistoryMapper.deleteByPrimaryKey(pushmsgId);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.deletePushmsgHistoryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.deletePushmsgHistoryModel.num");
        }
    }

    private void updatePushmsgHistoryModel(ImsgPushmsgHistory imsgPushmsgHistory) throws ApiException {
        if (null == imsgPushmsgHistory) {
            return;
        }
        try {
            this.imsgPushmsgHistoryMapper.updateByPrimaryKeySelective(imsgPushmsgHistory);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.updatePushmsgHistoryModel.ex", (Throwable)e);
        }
    }

    private void updateStatePushmsgHistoryModel(Integer pushmsgId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pushmsgId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pushmsgId", pushmsgId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.imsgPushmsgHistoryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.updateStatePushmsgHistoryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.updateStatePushmsgHistoryModel.null");
        }
    }

    private ImsgPushmsgHistory makePushmsgHistory(ImsgPushmsgHistoryDomain imsgPushmsgHistoryDomain, ImsgPushmsgHistory imsgPushmsgHistory) {
        if (null == imsgPushmsgHistoryDomain) {
            return null;
        }
        if (null == imsgPushmsgHistory) {
            imsgPushmsgHistory = new ImsgPushmsgHistory();
        }
        try {
            BeanUtils.copyAllPropertys((Object)imsgPushmsgHistory, (Object)imsgPushmsgHistoryDomain);
            return imsgPushmsgHistory;
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.makePushmsgHistory", (Throwable)e);
            return null;
        }
    }

    private List<ImsgPushmsgHistory> queryPushmsgHistoryModelPage(Map<String, Object> parammap) {
        try {
            return this.imsgPushmsgHistoryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.queryPushmsgHistoryModel", (Throwable)e);
            return null;
        }
    }

    private int countPushmsgHistory(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.imsgPushmsgHistoryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.countPushmsgHistory", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePushmsgHistory(ImsgPushmsgHistoryDomain imsgPushmsgHistoryDomain) throws ApiException {
        String msg = this.checkPushmsgHistory(imsgPushmsgHistoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.savePushmsgHistory.checkPushmsgHistory", msg);
        }
        ImsgPushmsgHistory imsgPushmsgHistory = this.makePushmsgHistory(imsgPushmsgHistoryDomain, null);
        this.setPushmsgHistoryDefault(imsgPushmsgHistory);
        this.savePushmsgHistoryModel(imsgPushmsgHistory);
    }

    @Override
    public void updatePushmsgHistoryState(Integer pushmsgId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePushmsgHistoryModel(pushmsgId, dataState, oldDataState);
    }

    @Override
    public void updatePushmsgHistory(ImsgPushmsgHistoryDomain imsgPushmsgHistoryDomain) throws ApiException {
        String msg = this.checkPushmsgHistory(imsgPushmsgHistoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.updatePushmsgHistory.checkPushmsgHistory", msg);
        }
        ImsgPushmsgHistory oldImsgPushmsgHistory = this.getPushmsgHistoryModelById(imsgPushmsgHistoryDomain.getPushmsgId());
        if (null == oldImsgPushmsgHistory) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgHistoryServiceImpl.updatePushmsgHistory.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ImsgPushmsgHistory imsgPushmsgHistory = this.makePushmsgHistory(imsgPushmsgHistoryDomain, oldImsgPushmsgHistory);
        this.setPushmsgHistoryUpdataDefault(imsgPushmsgHistory);
        this.updatePushmsgHistoryModel(imsgPushmsgHistory);
    }

    @Override
    public ImsgPushmsgHistory getPushmsgHistory(Integer pushmsgId) {
        return this.getPushmsgHistoryModelById(pushmsgId);
    }

    @Override
    public void deletePushmsgHistory(Integer pushmsgId) throws ApiException {
        this.deletePushmsgHistoryModel(pushmsgId);
    }

    @Override
    public QueryResult<ImsgPushmsgHistory> queryPushmsgHistoryPage(Map<String, Object> map) {
        List<ImsgPushmsgHistory> imsgPushmsgHistoryList = this.queryPushmsgHistoryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPushmsgHistory(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(imsgPushmsgHistoryList);
        return queryResult;
    }

    @Override
    public ImsgPushmsgHistory getPushmsgHistoryByCode(Map<String, Object> map) {
        return this.getPushmsgHistoryModelByCode(map);
    }

    @Override
    public void delPushmsgHistoryByCode(Map<String, Object> map) throws ApiException {
        this.delPushmsgHistoryModelByCode(map);
    }

    @Override
    public boolean savePushmsgHistoryList(List<ImsgPushmsgHistory> imsgPushmsgHistories) {
        boolean flag = false;
        for (ImsgPushmsgHistory history : imsgPushmsgHistories) {
            int i = this.savePushmsgHistoryModel(history);
            if (i != 0) continue;
            flag = true;
            throw new ApiException("\u6570\u636e\u5f55\u5165\u5f02\u5e38");
        }
        return flag;
    }
}

