/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.imsg.support;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.DefaultResult;
import cn.jpush.api.device.AliasDeviceListResult;
import cn.jpush.api.device.TagListResult;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JPushSupport {
    public static final SupperLogUtil logger = new SupperLogUtil(JPushSupport.class);

    public static PushPayload buildPushAll(String message) {
        return PushPayload.alertAll((String)message);
    }

    public static PushPayload buildPushByAlias(List<String> aliases, String message) {
        return JPushSupport.buildPushByAlias(aliases, message, null);
    }

    public static PushPayload buildPushByTags(List<String> tags, String message) {
        return JPushSupport.buildPushByTags(tags, message, null);
    }

    public static PushPayload buildPushByAlias(List<String> aliases, String message, Map<String, String> extras) {
        PushPayload.Builder builder = PushPayload.newBuilder();
        builder.setAudience(Audience.alias(aliases));
        builder.setPlatform(Platform.android_ios());
        builder.setMessage(JPushSupport.buildMessage(message, extras));
        builder.setOptions(JPushSupport.buildOptions());
        return builder.build();
    }

    public static PushPayload buildPushByTags(List<String> tags, String message, Map<String, String> extras) {
        PushPayload.Builder builder = PushPayload.newBuilder();
        builder.setAudience(Audience.tag(tags));
        builder.setPlatform(Platform.android_ios());
        builder.setMessage(JPushSupport.buildMessage(message, extras));
        return builder.build();
    }

    public static PushPayload buildPushByFull(List<String> variable, String message, Map<String, String> extras, String messageType, String jpushType) {
        PushPayload.Builder builder = PushPayload.newBuilder();
        Audience audience = null;
        if ("0".equals(messageType)) {
            audience = Audience.alias(variable);
        } else if ("1".equals(messageType)) {
            audience = Audience.tag(variable);
        } else {
            return PushPayload.alertAll((String)message);
        }
        builder.setOptions(JPushSupport.buildOptions());
        builder.setAudience(audience);
        builder.setPlatform(Platform.android_ios());
        if ("0".equals(jpushType)) {
            builder.setNotification(JPushSupport.buildNotification(message, extras));
        } else {
            builder.setMessage(JPushSupport.buildMessage(message, extras));
        }
        return builder.build();
    }

    private static Options buildOptions() {
        return Options.newBuilder().setApnsProduction(JPushSupport.getOptions()).build();
    }

    public static boolean getOptions() {
        return Boolean.valueOf(DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-jpush-TEST"));
    }

    private static Message buildMessage(String message, Map<String, String> extras) {
        if (message == null) {
            throw new ApiException("JPushSupport.push.buildMessage", "message is null");
        }
        Message.Builder builder = Message.newBuilder().setMsgContent(message);
        if (MapUtil.isNotEmpty(extras)) {
            builder.addExtras(extras);
        }
        return builder.build();
    }

    private static Notification buildNotification(String message, Map<String, String> extras) {
        if (message == null) {
            throw new ApiException("JPushSupport.push.buildNotification", "message is null");
        }
        Notification.Builder builder = Notification.newBuilder();
        if (MapUtil.isNotEmpty(extras)) {
            IosNotification iosnfc = ((IosNotification.Builder)IosNotification.newBuilder().setContentAvailable(true).setAlert((Object)message).addExtras(extras)).build();
            AndroidNotification androidnfc = ((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)message).addExtras(extras)).build();
            builder.addPlatformNotification((PlatformNotification)iosnfc);
            builder.addPlatformNotification((PlatformNotification)androidnfc);
        }
        return builder.build();
    }

    private static JPushClient getJPushClient(String appmanageIcode) {
        String param = "";
        if (!StringUtils.isEmpty((String)appmanageIcode)) {
            param = "-" + appmanageIcode;
        }
        String masterSecret = DisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-jpush-masterSecret" + param));
        String appKey = DisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-jpush-appKey" + param));
        if (StringUtils.isEmpty((String)masterSecret) || StringUtils.isEmpty((String)appKey)) {
            logger.error("masterSecret\u548cappKey\u4e3a\u7a7a\uff0cappmanageIcode\u4e3a" + appmanageIcode + "\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u65b9\u662f\u5426\u4f20\u5165\u6b63\u786e\u7684appName");
            return null;
        }
        JPushClient jpushClient = new JPushClient(masterSecret, appKey);
        return jpushClient;
    }

    public static boolean deleteTag(String i_tag, String appmanageIcode) throws APIRequestException {
        boolean deleteSucc = false;
        try {
            boolean exists = JPushSupport.tagHasExists(i_tag, appmanageIcode);
            if (exists) {
                JPushClient jPushClient = JPushSupport.getJPushClient(appmanageIcode);
                if (jPushClient == null) {
                    return false;
                }
                DefaultResult result = jPushClient.deleteTag(i_tag, "android,ios");
                if (result.getResponseCode() == 200) {
                    deleteSucc = true;
                }
            }
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
        return deleteSucc;
    }

    public static boolean tagHasExists(String i_tag, String appmanageIcode) throws APIConnectionException, APIRequestException {
        JPushClient jPushClient = JPushSupport.getJPushClient(appmanageIcode);
        if (jPushClient == null) {
            return false;
        }
        TagListResult tagListResult = jPushClient.getTagList();
        boolean succ = false;
        boolean regFlag = false;
        if (200 == tagListResult.getResponseCode()) {
            succ = true;
        }
        for (String o_tag : tagListResult.tags) {
            if (!succ || !i_tag.equals(o_tag)) continue;
            regFlag = true;
            break;
        }
        return regFlag;
    }

    public static String addOptionProperty(String consumer) {
        consumer = JPushSupport.getOptions() ? "online" + consumer : "test" + consumer;
        return consumer;
    }

    private static JPushClient getJPushClient(int i) {
        String masterSecret = "ad25ebb534532bb827a93961";
        String appKey = "86308d5e3b59773d0436470d";
        JPushClient jpushClient = new JPushClient(masterSecret, appKey);
        return jpushClient;
    }

    public static void clearOtherRegistrationID(String registrationID, String consumer, String appmanageIcode) {
        try {
            JPushClient jPushClient = JPushSupport.getJPushClient(appmanageIcode);
            if (jPushClient == null) {
                return;
            }
            AliasDeviceListResult devices = jPushClient.getAliasDeviceList(JPushSupport.addOptionProperty(consumer), "android,ios");
            List regs = devices.registration_ids;
            ArrayList<String> newRegs = new ArrayList<String>();
            for (String reg : regs) {
                if (reg.equals(registrationID)) continue;
                newRegs.add(reg);
            }
            if (newRegs.size() > 0) {
                JPushSupport.clearOtherRegistrationID(newRegs, appmanageIcode);
            }
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
    }

    public static void clearOtherRegistrationID(List<String> regs, String appmanageIcode) {
        for (String reg : regs) {
            JPushSupport.clearDeviceTagAlias(reg, appmanageIcode);
        }
    }

    public static void clearDeviceTagAlias(String registration_id, String appmanageIcode) {
        try {
            JPushClient jPushClient = JPushSupport.getJPushClient(appmanageIcode);
            if (jPushClient == null) {
                return;
            }
            DefaultResult dr = jPushClient.updateDeviceTagAlias(registration_id, true, true);
            if (dr.getResponseCode() == 200) {
                logger.info("\u8bbe\u5907\u53f7\uff1a" + registration_id + "\u6e05\u9664alias\u548ctag\u6210\u529f");
            }
        }
        catch (APIConnectionException e) {
            e.printStackTrace();
        }
        catch (APIRequestException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            AliasDeviceListResult reg = JPushSupport.getJPushClient(1).getAliasDeviceList("test2010100017", "android,ios");
            List list = reg.registration_ids;
            System.out.println(list);
        }
        catch (APIConnectionException | APIRequestException e) {
            e.printStackTrace();
        }
    }

    public static boolean push(PushPayload payload, String appmanageIcode) throws APIRequestException {
        boolean pushFlag = true;
        try {
            JPushClient jPushClient = JPushSupport.getJPushClient(appmanageIcode);
            if (jPushClient == null) {
                return false;
            }
            PushResult result = jPushClient.sendPush(payload);
            logger.debug("JPushSupport.push", (Object)result);
        }
        catch (APIConnectionException e) {
            logger.error((Throwable)e);
            throw new ApiException("JPushSupport.push.connection.ex", (Throwable)e);
        }
        catch (APIRequestException e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 1000 || errorCode == 1030 || errorCode == 1011) {
                throw e;
            }
            pushFlag = false;
        }
        return pushFlag;
    }
}

