/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.imsg.service.impl;

import cn.jpush.api.push.model.PushPayload;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.imsg.dao.ImsgPushmsgMapper;
import com.yqbsoft.laser.service.imsg.domain.ImsgPushmsgDomain;
import com.yqbsoft.laser.service.imsg.model.ImsgPushmsg;
import com.yqbsoft.laser.service.imsg.service.ImsgPushmsgService;
import com.yqbsoft.laser.service.imsg.support.JPushSupport;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImsgPushmsgServiceImpl
extends BaseServiceImpl
implements ImsgPushmsgService {
    public static final String SYS_CODE = "imsg.IMSG.ImsgPushmsgServiceImpl";
    private ImsgPushmsgMapper imsgPushmsgMapper;

    public void setImsgPushmsgMapper(ImsgPushmsgMapper imsgPushmsgMapper) {
        this.imsgPushmsgMapper = imsgPushmsgMapper;
    }

    private Date getSysDate() {
        try {
            return this.imsgPushmsgMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPushmsg(ImsgPushmsgDomain imsgPushmsgDomain) {
        if (null == imsgPushmsgDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPushmsgDefault(ImsgPushmsg imsgPushmsg) {
        if (null == imsgPushmsg) {
            return;
        }
        if (null == imsgPushmsg.getDataState()) {
            imsgPushmsg.setDataState(0);
        }
        if (null == imsgPushmsg.getGmtCreate()) {
            imsgPushmsg.setGmtCreate(this.getSysDate());
        }
        imsgPushmsg.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)imsgPushmsg.getPushmsgCode())) {
            imsgPushmsg.setPushmsgCode(this.createUUIDString());
        }
    }

    private int getPushmsgMaxCode() {
        int code = 0;
        try {
            return this.imsgPushmsgMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.getPushmsgMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPushmsgUpdataDefault(ImsgPushmsg imsgPushmsg) {
        if (null == imsgPushmsg) {
            return;
        }
        imsgPushmsg.setGmtModified(this.getSysDate());
    }

    private void savePushmsgModel(ImsgPushmsg imsgPushmsg) throws ApiException {
        if (null == imsgPushmsg) {
            return;
        }
        try {
            this.imsgPushmsgMapper.insert(imsgPushmsg);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.savePushmsgModel.ex", (Throwable)e);
        }
    }

    private ImsgPushmsg getPushmsgModelById(Integer pushmsgId) {
        if (null == pushmsgId) {
            return null;
        }
        try {
            return this.imsgPushmsgMapper.selectByPrimaryKey(pushmsgId);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.getPushmsgModelById", (Throwable)e);
            return null;
        }
    }

    public ImsgPushmsg getPushmsgModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.imsgPushmsgMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.getPushmsgModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPushmsgModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.imsgPushmsgMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.delPushmsgModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.delPushmsgModelByCode.num");
        }
    }

    private void deletePushmsgModel(Integer pushmsgId) throws ApiException {
        if (null == pushmsgId) {
            return;
        }
        int i = 0;
        try {
            i = this.imsgPushmsgMapper.deleteByPrimaryKey(pushmsgId);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.deletePushmsgModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.deletePushmsgModel.num");
        }
    }

    private void updatePushmsgModel(ImsgPushmsg imsgPushmsg) throws ApiException {
        if (null == imsgPushmsg) {
            return;
        }
        try {
            this.imsgPushmsgMapper.updateByPrimaryKeySelective(imsgPushmsg);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updatePushmsgModel.ex", (Throwable)e);
        }
    }

    private void updateStatePushmsgModel(Integer pushmsgId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pushmsgId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pushmsgId", pushmsgId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.imsgPushmsgMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updateStatePushmsgModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updateStatePushmsgModel.null");
        }
    }

    private void updateStatePushmsgModel(Integer pushmsgId, Integer dataState, Integer oldDataState, Boolean pushCountFlag) throws ApiException {
        if (null == pushmsgId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pushmsgId", pushmsgId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("pushCountFlag", pushCountFlag);
        int i = 0;
        try {
            i = this.imsgPushmsgMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updateStatePushmsgModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updateStatePushmsgModel.null");
        }
    }

    private ImsgPushmsg makePushmsg(ImsgPushmsgDomain imsgPushmsgDomain, ImsgPushmsg imsgPushmsg) {
        if (null == imsgPushmsgDomain) {
            return null;
        }
        if (null == imsgPushmsg) {
            imsgPushmsg = new ImsgPushmsg();
        }
        try {
            BeanUtils.copyAllPropertys((Object)imsgPushmsg, (Object)imsgPushmsgDomain);
            return imsgPushmsg;
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.makePushmsg", (Throwable)e);
            return null;
        }
    }

    private List<ImsgPushmsg> queryPushmsgModelPage(Map<String, Object> parammap) {
        try {
            return this.imsgPushmsgMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.queryPushmsgModel", (Throwable)e);
            return null;
        }
    }

    private int countPushmsg(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.imsgPushmsgMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.countPushmsg", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePushmsg(ImsgPushmsgDomain imsgPushmsgDomain) throws ApiException {
        String msg = this.checkPushmsg(imsgPushmsgDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.savePushmsg.checkPushmsg", msg);
        }
        ImsgPushmsg imsgPushmsg = this.makePushmsg(imsgPushmsgDomain, null);
        this.setPushmsgDefault(imsgPushmsg);
        if (imsgPushmsg.getValidDay() != null && imsgPushmsg.getValidDay() == 0) {
            imsgPushmsg.setValidDay(null);
        }
        this.savePushmsgModel(imsgPushmsg);
        if (imsgPushmsgDomain.getHasInstantPush() != null && imsgPushmsgDomain.getHasInstantPush() == 1) {
            this.executeSend(imsgPushmsg);
        }
    }

    @Override
    public void updatePushmsgState(Integer pushmsgId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePushmsgModel(pushmsgId, dataState, oldDataState);
    }

    public void updatePushmsgState(Integer pushmsgId, Integer dataState, Integer oldDataState, Boolean pushCountFlag) throws ApiException {
        this.updateStatePushmsgModel(pushmsgId, dataState, oldDataState, pushCountFlag);
    }

    @Override
    public void updatePushmsg(ImsgPushmsgDomain imsgPushmsgDomain) throws ApiException {
        String msg = this.checkPushmsg(imsgPushmsgDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updatePushmsg.checkPushmsg", msg);
        }
        ImsgPushmsg oldImsgPushmsg = this.getPushmsgModelById(imsgPushmsgDomain.getPushmsgId());
        if (null == oldImsgPushmsg) {
            throw new ApiException("imsg.IMSG.ImsgPushmsgServiceImpl.updatePushmsg.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ImsgPushmsg imsgPushmsg = this.makePushmsg(imsgPushmsgDomain, oldImsgPushmsg);
        this.setPushmsgUpdataDefault(imsgPushmsg);
        this.updatePushmsgModel(imsgPushmsg);
    }

    @Override
    public ImsgPushmsg getPushmsg(Integer pushmsgId) {
        return this.getPushmsgModelById(pushmsgId);
    }

    @Override
    public void deletePushmsg(Integer pushmsgId) throws ApiException {
        this.deletePushmsgModel(pushmsgId);
    }

    @Override
    public QueryResult<ImsgPushmsg> queryPushmsgPage(Map<String, Object> map) {
        List<ImsgPushmsg> imsgPushmsgList = this.queryPushmsgModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPushmsg(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(imsgPushmsgList);
        return queryResult;
    }

    @Override
    public List<ImsgPushmsg> getPushmsgByAuserCode(Map<String, Object> map) {
        List<ImsgPushmsg> imsgPushmsgList = this.queryPushmsgModelPage(map);
        return imsgPushmsgList;
    }

    @Override
    public ImsgPushmsg getPushmsgByCode(Map<String, Object> map) {
        return this.getPushmsgModelByCode(map);
    }

    @Override
    public void delPushmsgByCode(Map<String, Object> map) throws ApiException {
        this.delPushmsgModelByCode(map);
    }

    @Override
    public List<ImsgPushmsg> queryPushmsgWaitSend(Map<String, Object> parammap) {
        try {
            return this.imsgPushmsgMapper.queryWaitSend(parammap);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.queryPushmsgWaitSend", (Throwable)e);
            return null;
        }
    }

    private boolean callValidate(String temp) {
        Boolean result = true;
        if (!StringUtils.isEmpty((String)temp)) {
            try {
                Map paramMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(temp, String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)paramMap)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("map", JsonUtil.buildNonDefaultBinder().toJson((Object)paramMap));
                    Object callUrl = paramMap.get("callValidateUrl");
                    if (callUrl == null || "".equals(callUrl)) {
                        callUrl = paramMap.get("url");
                    }
                    String jsonObj = this.internalInvoke(callUrl.toString(), param);
                    Integer ret = (Integer)JsonUtil.buildNonNullBinder().getJsonToObject(jsonObj, Integer.class);
                    if (ret == 0) {
                        result = false;
                        this.logger.info(SYS_CODE, (Object)("\u6d88\u606f\u6821\u9a8c\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u505c\u6b62\u63a8\u9001\uff0c\u4e1a\u52a1CODE\uff1a" + paramMap.get("code")));
                    } else if (ret == -1) {
                        this.logger.error(SYS_CODE, (Object)("\u6d88\u606f\u6821\u9a8c\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u4e1a\u52a1CODE\uff1a" + paramMap.get("code")));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("imsg.IMSG.ImsgPushmsgServiceImplexecuteSend", (Object)("\u6d88\u606f\u6821\u9a8c\u56de\u8c03\u5931\u8d25" + e.getMessage()));
            }
        }
        return result;
    }

    @Override
    public void executeSend(ImsgPushmsg imsgPushmsg) {
        block13: {
            if (imsgPushmsg == null) {
                return;
            }
            if (imsgPushmsg.getDataState() == null || imsgPushmsg.getDataState() == 1) {
                return;
            }
            boolean result = this.callValidate(imsgPushmsg.getCallValidateUrl());
            if (!result) {
                this.logger.debug(SYS_CODE, (Object)("\u672c\u6761\u6d88\u606f\u505c\u6b62\u63a8\u9001\uff0cpushmsgCode\u4e3a\uff1a" + imsgPushmsg.getPushmsgCode()));
                this.updatePushmsgState(imsgPushmsg.getPushmsgId(), 3, imsgPushmsg.getDataState(), true);
                return;
            }
            this.updatePushmsgState(imsgPushmsg.getPushmsgId(), 1, imsgPushmsg.getDataState(), true);
            PushPayload payload = null;
            Map extras = (Map)JsonUtil.buildNormalBinder().getJsonToMap(imsgPushmsg.getPushmsgExp(), String.class, String.class);
            extras.put("pushmsgCode", imsgPushmsg.getPushmsgCode());
            String consumer = imsgPushmsg.getPushmsgAuserCode();
            String appmanageIcode = imsgPushmsg.getAppmanageIcode();
            if (StringUtils.isBlank((String)consumer) || StringUtils.isBlank((String)imsgPushmsg.getPushmsgContent())) {
                this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.executeSend", (Object)"consumer or content is null");
                this.updatePushmsgState(imsgPushmsg.getPushmsgId(), 2, imsgPushmsg.getDataState(), true);
            }
            ArrayList<String> consumers = new ArrayList<String>();
            if (JPushSupport.getOptions()) {
                consumers.add(consumer);
            }
            consumers.add(JPushSupport.addOptionProperty(consumer));
            String messageType = "";
            if ("0".equals(imsgPushmsg.getPushmsgType())) {
                messageType = "0";
            } else if ("1".equals(imsgPushmsg.getPushmsgType())) {
                messageType = "1";
            } else if ("2".equals(imsgPushmsg.getPushmsgType())) {
                messageType = "2";
            }
            payload = JPushSupport.buildPushByFull(consumers, imsgPushmsg.getPushmsgContent(), extras, messageType, imsgPushmsg.getPushmsgJpushType());
            try {
                boolean pushFlag = JPushSupport.push(payload, appmanageIcode);
                if (!pushFlag) {
                    this.updatePushmsgState(imsgPushmsg.getPushmsgId(), 2, 1, true);
                }
                this.logger.info("imsg.IMSG.ImsgPushmsgServiceImpl.executeSend", (Object)("pushmsgId=" + imsgPushmsg.getPushmsgId() + ", push success!l"));
            }
            catch (Exception e) {
                this.updatePushmsgState(imsgPushmsg.getPushmsgId(), 0, 1, true);
                if (imsgPushmsg.getHasInstantPush() != 0) break block13;
                throw new ApiException("\u63a8\u9001\u5931\u8d25,\u4e0b\u6b21\u91cd\u8bd5");
            }
        }
    }

    @Override
    public void clearOtherRegistrationID(Map<String, Object> map) {
        if (map == null || map.get("registrationID") == null || map.get("userCode") == null || map.get("appmanageIcode") == null) {
            return;
        }
        JPushSupport.clearOtherRegistrationID((String)map.get("registrationID"), (String)map.get("userCode"), (String)map.get("appmanageIcode"));
    }

    @Override
    public List<ImsgPushmsg> queryPushmsgWaitTransfer(Map<String, Object> map) {
        return this.queryPushmsgWaitTransferModel(map);
    }

    private List<ImsgPushmsg> queryPushmsgWaitTransferModel(Map<String, Object> map) {
        try {
            return this.imsgPushmsgMapper.queryWaitTransfer(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.queryPushmsgWaitSend", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean deletePushmsgByIds(List<Integer> pushmsgIds) {
        for (Integer pushmsgId : pushmsgIds) {
            this.deletePushmsgModel(pushmsgId);
        }
        return true;
    }

    @Override
    public int countAnyDayData(Map<String, Integer> map) {
        return this.countAnyDayDataModel(map);
    }

    private int countAnyDayDataModel(Map<String, Integer> map) {
        try {
            return this.imsgPushmsgMapper.countAnyDayData(map);
        }
        catch (Exception e) {
            this.logger.error("imsg.IMSG.ImsgPushmsgServiceImpl.countAnyDayDataModel", (Throwable)e);
            return 0;
        }
    }
}

