/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.imsg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.imsg.model.ImsgPushmsg;
import com.yqbsoft.laser.service.imsg.model.ImsgPushmsgHistory;
import com.yqbsoft.laser.service.imsg.service.ImsgPushmsgHistoryService;
import com.yqbsoft.laser.service.imsg.service.ImsgPushmsgService;
import com.yqbsoft.laser.service.imsg.service.ImsgTaskService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ImsgTaskServiceImpl
extends BaseServiceImpl
implements ImsgTaskService {
    public static final String SYS_CODE = "imsg.IMSG.ImsgPushmsgServiceImpl";
    private ImsgPushmsgService imsgPushmsgService;
    private ImsgPushmsgHistoryService imsgPushmsgHistoryService;

    public void setImsgPushmsgService(ImsgPushmsgService imsgPushmsgService) {
        this.imsgPushmsgService = imsgPushmsgService;
    }

    public void setImsgPushmsgHistoryService(ImsgPushmsgHistoryService imsgPushmsgHistoryService) {
        this.imsgPushmsgHistoryService = imsgPushmsgHistoryService;
    }

    @Override
    public synchronized void autoSendPushmsg() throws ApiException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataState", 0);
        paramMap.put("startRow", 0);
        paramMap.put("endRow", 1000);
        List<ImsgPushmsg> mnsMnslistList = this.imsgPushmsgService.queryPushmsgWaitSend(paramMap);
        if (mnsMnslistList == null || mnsMnslistList.isEmpty()) {
            return;
        }
        for (ImsgPushmsg imsgPushmsg : mnsMnslistList) {
            try {
                this.imsgPushmsgService.executeSend(imsgPushmsg);
            }
            catch (Exception e) {
                this.logger.error("ImsgTaskServiceImpl.autoSendPushmsg.error");
            }
        }
    }

    private void executeTransfer(int startRow, int endRow, int anyDay) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("startRow", startRow);
        paramMap.put("endRow", endRow);
        paramMap.put("anyDay", anyDay);
        List<ImsgPushmsg> imsgPushmsgs = this.imsgPushmsgService.queryPushmsgWaitTransfer(paramMap);
        String transferBatchNum = DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHHmmss");
        ArrayList<ImsgPushmsgHistory> histories = new ArrayList<ImsgPushmsgHistory>();
        ArrayList<Integer> pushmsgIds = new ArrayList<Integer>();
        for (ImsgPushmsg imsgPushmsg : imsgPushmsgs) {
            ImsgPushmsgHistory history = new ImsgPushmsgHistory();
            try {
                BeanUtils.copyAllPropertys((Object)history, (Object)imsgPushmsg);
                history.setTransferBatchNum(transferBatchNum);
                histories.add(history);
                pushmsgIds.add(imsgPushmsg.getPushmsgId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean succ = this.imsgPushmsgHistoryService.savePushmsgHistoryList(histories);
        if (!succ) {
            this.imsgPushmsgService.deletePushmsgByIds(pushmsgIds);
        }
    }

    @Override
    public void batchTransferToPushmsgHistory() throws ApiException {
        int count;
        Integer anyDay = Integer.valueOf(DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-imsg-pushmsgTransferDay"));
        Integer basicNum = Integer.valueOf(DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-imsg-pushmsgTransferTotal"));
        anyDay = anyDay == null || anyDay == 0 ? Integer.valueOf(-30) : Integer.valueOf(-anyDay.intValue());
        if (basicNum == 0) {
            basicNum = 10000;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("anyDay", anyDay);
        if (count > 0) {
            if (count / basicNum > 0) {
                for (count = this.imsgPushmsgService.countAnyDayData(map); count > 0; count -= basicNum.intValue()) {
                    this.executeTransfer(0, basicNum, anyDay);
                }
            } else {
                this.executeTransfer(0, count, anyDay);
            }
        } else {
            this.logger.info("ImsgTaskServiceImpl.batchTransferToPushmsgHistory." + Math.abs(anyDay) + "\u5929\u524d\u672a\u4ea7\u751f\u6d88\u606f\u8bb0\u5f55");
        }
    }
}

