/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.invoice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.invoice.dao.InvInvlistMapper;
import com.yqbsoft.laser.service.invoice.domain.InvInvlistDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvlistReDomain;
import com.yqbsoft.laser.service.invoice.model.InvInvlist;
import com.yqbsoft.laser.service.invoice.service.InvInvlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvInvlistServiceImpl
extends BaseServiceImpl
implements InvInvlistService {
    private static final String SYS_CODE = "inv.InvInvlistServiceImpl";
    private InvInvlistMapper invInvlistMapper;

    public void setInvInvlistMapper(InvInvlistMapper invInvlistMapper) {
        this.invInvlistMapper = invInvlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.invInvlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInvlist(InvInvlistDomain invInvlistDomain) {
        if (null == invInvlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)invInvlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInvlistDefault(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return;
        }
        if (null == invInvlist.getDataState()) {
            invInvlist.setDataState(0);
        }
        if (null == invInvlist.getGmtCreate()) {
            invInvlist.setGmtCreate(this.getSysDate());
        }
        invInvlist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)invInvlist.getInvlistCode())) {
            invInvlist.setInvlistCode(this.createUUIDString());
        }
    }

    private int getInvlistMaxCode() {
        int code = 0;
        try {
            return this.invInvlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getInvlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInvlistUpdataDefault(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return;
        }
        invInvlist.setGmtModified(this.getSysDate());
    }

    private void saveInvlistModel(InvInvlist invInvlist) throws ApiException {
        if (null == invInvlist) {
            return;
        }
        try {
            this.invInvlistMapper.insert(invInvlist);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.saveInvlistModel.ex", (Throwable)e);
        }
    }

    private void saveInvlistBatchModel(List<InvInvlist> invInvlistList) throws ApiException {
        if (null == invInvlistList || invInvlistList.isEmpty()) {
            return;
        }
        try {
            this.invInvlistMapper.insertBatch(invInvlistList);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.saveInvlistBatchModel.ex", (Throwable)e);
        }
    }

    private InvInvlist getInvlistModelById(Integer invlistId) {
        if (null == invlistId) {
            return null;
        }
        try {
            return this.invInvlistMapper.selectByPrimaryKey(invlistId);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getInvlistModelById", (Throwable)e);
            return null;
        }
    }

    private InvInvlist getInvlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.invInvlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getInvlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInvlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.delInvlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.delInvlistModelByCode.num");
        }
    }

    private void deleteInvlistModel(Integer invlistId) throws ApiException {
        if (null == invlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.deleteByPrimaryKey(invlistId);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.deleteInvlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.deleteInvlistModel.num");
        }
    }

    private void updateInvlistModel(InvInvlist invInvlist) throws ApiException {
        if (null == invInvlist) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateByPrimaryKey(invInvlist);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlistModel.num");
        }
    }

    private void updateStateInvlistModel(Integer invlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == invlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invlistId", invlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModel.null");
        }
    }

    private void updateStateInvlistModelByCode(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)invlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModelByCode.null");
        }
    }

    private InvInvlist makeInvlist(InvInvlistDomain invInvlistDomain, InvInvlist invInvlist) {
        if (null == invInvlistDomain) {
            return null;
        }
        if (null == invInvlist) {
            invInvlist = new InvInvlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)invInvlist, (Object)invInvlistDomain);
            return invInvlist;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvlist", (Throwable)e);
            return null;
        }
    }

    private InvInvlistReDomain makeInvInvlistReDomain(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = new InvInvlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)invInvlistReDomain, (Object)invInvlist);
            return invInvlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<InvInvlist> queryInvlistModelPage(Map<String, Object> parammap) {
        try {
            return this.invInvlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.queryInvlistModel", (Throwable)e);
            return null;
        }
    }

    private int countInvlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.invInvlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.countInvlist", (Throwable)e);
        }
        return i;
    }

    private InvInvlist createInvInvlist(InvInvlistDomain invInvlistDomain) {
        String msg = this.checkInvlist(invInvlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvlistServiceImpl.saveInvlist.checkInvlist", msg);
        }
        InvInvlist invInvlist = this.makeInvlist(invInvlistDomain, null);
        this.setInvlistDefault(invInvlist);
        return invInvlist;
    }

    @Override
    public String saveInvlist(InvInvlistDomain invInvlistDomain) throws ApiException {
        InvInvlist invInvlist = this.createInvInvlist(invInvlistDomain);
        this.saveInvlistModel(invInvlist);
        return invInvlist.getInvlistCode();
    }

    @Override
    public String saveInvlistBatch(List<InvInvlistDomain> invInvlistDomainList) throws ApiException {
        if (null == invInvlistDomainList || invInvlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<InvInvlist> invInvlistList = new ArrayList<InvInvlist>();
        String code = "";
        for (InvInvlistDomain invInvlistDomain : invInvlistDomainList) {
            InvInvlist invInvlist = this.createInvInvlist(invInvlistDomain);
            code = invInvlist.getInvlistCode();
            invInvlistList.add(invInvlist);
        }
        this.saveInvlistBatchModel(invInvlistList);
        return code;
    }

    @Override
    public void updateInvlistState(Integer invlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvlistModel(invlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateInvlistStateByCode(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvlistModelByCode(tenantCode, invlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateInvlist(InvInvlistDomain invInvlistDomain) throws ApiException {
        String msg = this.checkInvlist(invInvlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlist.checkInvlist", msg);
        }
        InvInvlist oldInvInvlist = this.getInvlistModelById(invInvlistDomain.getInvlistId());
        if (null == oldInvInvlist) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        InvInvlist invInvlist = this.makeInvlist(invInvlistDomain, oldInvInvlist);
        this.setInvlistUpdataDefault(invInvlist);
        this.updateInvlistModel(invInvlist);
    }

    @Override
    public InvInvlist getInvlist(Integer invlistId) {
        return this.getInvlistModelById(invlistId);
    }

    @Override
    public void deleteInvlist(Integer invlistId) throws ApiException {
        this.deleteInvlistModel(invlistId);
    }

    @Override
    public QueryResult<InvInvlist> queryInvlistPage(Map<String, Object> map) {
        List<InvInvlist> invInvlistList = this.queryInvlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInvlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(invInvlistList);
        return queryResult;
    }

    @Override
    public InvInvlist getInvlistByCode(String tenantCode, String invlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        return this.getInvlistModelByCode(map);
    }

    @Override
    public void deleteInvlistByCode(String tenantCode, String invlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        this.delInvlistModelByCode(map);
    }
}

