/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.invoice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.invoice.dao.InvInvrateMapper;
import com.yqbsoft.laser.service.invoice.domain.InvInvrateDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvrateReDomain;
import com.yqbsoft.laser.service.invoice.model.InvInvrate;
import com.yqbsoft.laser.service.invoice.service.InvInvrateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvInvrateServiceImpl
extends BaseServiceImpl
implements InvInvrateService {
    private static final String SYS_CODE = "inv.InvInvrateServiceImpl";
    private InvInvrateMapper invInvrateMapper;

    public void setInvInvrateMapper(InvInvrateMapper invInvrateMapper) {
        this.invInvrateMapper = invInvrateMapper;
    }

    private Date getSysDate() {
        try {
            return this.invInvrateMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInvrate(InvInvrateDomain invInvrateDomain) {
        if (null == invInvrateDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)invInvrateDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInvrateDefault(InvInvrate invInvrate) {
        if (null == invInvrate) {
            return;
        }
        if (null == invInvrate.getDataState()) {
            invInvrate.setDataState(0);
        }
        if (null == invInvrate.getGmtCreate()) {
            invInvrate.setGmtCreate(this.getSysDate());
        }
        invInvrate.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)invInvrate.getInvrateCode())) {
            invInvrate.setInvrateCode(this.createUUIDString());
        }
    }

    private int getInvrateMaxCode() {
        int code = 0;
        try {
            return this.invInvrateMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.getInvrateMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInvrateUpdataDefault(InvInvrate invInvrate) {
        if (null == invInvrate) {
            return;
        }
        invInvrate.setGmtModified(this.getSysDate());
    }

    private void saveInvrateModel(InvInvrate invInvrate) throws ApiException {
        if (null == invInvrate) {
            return;
        }
        try {
            this.invInvrateMapper.insert(invInvrate);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.saveInvrateModel.ex", (Throwable)e);
        }
    }

    private void saveInvrateBatchModel(List<InvInvrate> invInvrateList) throws ApiException {
        if (null == invInvrateList || invInvrateList.isEmpty()) {
            return;
        }
        try {
            this.invInvrateMapper.insertBatch(invInvrateList);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.saveInvrateBatchModel.ex", (Throwable)e);
        }
    }

    private InvInvrate getInvrateModelById(Integer invrateId) {
        if (null == invrateId) {
            return null;
        }
        try {
            return this.invInvrateMapper.selectByPrimaryKey(invrateId);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.getInvrateModelById", (Throwable)e);
            return null;
        }
    }

    private InvInvrate getInvrateModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.invInvrateMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.getInvrateModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInvrateModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvrateMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.delInvrateModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvrateServiceImpl.delInvrateModelByCode.num");
        }
    }

    private void deleteInvrateModel(Integer invrateId) throws ApiException {
        if (null == invrateId) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvrateMapper.deleteByPrimaryKey(invrateId);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.deleteInvrateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvrateServiceImpl.deleteInvrateModel.num");
        }
    }

    private void updateInvrateModel(InvInvrate invInvrate) throws ApiException {
        if (null == invInvrate) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvrateMapper.updateByPrimaryKey(invInvrate);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateInvrateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateInvrateModel.num");
        }
    }

    private void updateStateInvrateModel(Integer invrateId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == invrateId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invrateId", invrateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvrateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateStateInvrateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateStateInvrateModel.null");
        }
    }

    private void updateStateInvrateModelByCode(String tenantCode, String invrateCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)invrateCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invrateCode", invrateCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvrateMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateStateInvrateModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateStateInvrateModelByCode.null");
        }
    }

    private InvInvrate makeInvrate(InvInvrateDomain invInvrateDomain, InvInvrate invInvrate) {
        if (null == invInvrateDomain) {
            return null;
        }
        if (null == invInvrate) {
            invInvrate = new InvInvrate();
        }
        try {
            BeanUtils.copyAllPropertys((Object)invInvrate, (Object)invInvrateDomain);
            return invInvrate;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.makeInvrate", (Throwable)e);
            return null;
        }
    }

    private InvInvrateReDomain makeInvInvrateReDomain(InvInvrate invInvrate) {
        if (null == invInvrate) {
            return null;
        }
        InvInvrateReDomain invInvrateReDomain = new InvInvrateReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)invInvrateReDomain, (Object)invInvrate);
            return invInvrateReDomain;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.makeInvInvrateReDomain", (Throwable)e);
            return null;
        }
    }

    private List<InvInvrate> queryInvrateModelPage(Map<String, Object> parammap) {
        try {
            return this.invInvrateMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.queryInvrateModel", (Throwable)e);
            return null;
        }
    }

    private int countInvrate(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.invInvrateMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvrateServiceImpl.countInvrate", (Throwable)e);
        }
        return i;
    }

    private InvInvrate createInvInvrate(InvInvrateDomain invInvrateDomain) {
        String msg = this.checkInvrate(invInvrateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvrateServiceImpl.saveInvrate.checkInvrate", msg);
        }
        InvInvrate invInvrate = this.makeInvrate(invInvrateDomain, null);
        this.setInvrateDefault(invInvrate);
        return invInvrate;
    }

    @Override
    public String saveInvrate(InvInvrateDomain invInvrateDomain) throws ApiException {
        InvInvrate invInvrate = this.createInvInvrate(invInvrateDomain);
        this.saveInvrateModel(invInvrate);
        return invInvrate.getInvrateCode();
    }

    @Override
    public String saveInvrateBatch(List<InvInvrateDomain> invInvrateDomainList) throws ApiException {
        if (null == invInvrateDomainList || invInvrateDomainList.isEmpty()) {
            return null;
        }
        ArrayList<InvInvrate> invInvrateList = new ArrayList<InvInvrate>();
        String code = "";
        for (InvInvrateDomain invInvrateDomain : invInvrateDomainList) {
            InvInvrate invInvrate = this.createInvInvrate(invInvrateDomain);
            code = invInvrate.getInvrateCode();
            invInvrateList.add(invInvrate);
        }
        this.saveInvrateBatchModel(invInvrateList);
        return code;
    }

    @Override
    public void updateInvrateState(Integer invrateId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvrateModel(invrateId, dataState, oldDataState, map);
    }

    @Override
    public void updateInvrateStateByCode(String tenantCode, String invrateCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvrateModelByCode(tenantCode, invrateCode, dataState, oldDataState, map);
    }

    @Override
    public void updateInvrate(InvInvrateDomain invInvrateDomain) throws ApiException {
        String msg = this.checkInvrate(invInvrateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateInvrate.checkInvrate", msg);
        }
        InvInvrate oldInvInvrate = this.getInvrateModelById(invInvrateDomain.getInvrateId());
        if (null == oldInvInvrate) {
            throw new ApiException("inv.InvInvrateServiceImpl.updateInvrate.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        InvInvrate invInvrate = this.makeInvrate(invInvrateDomain, oldInvInvrate);
        this.setInvrateUpdataDefault(invInvrate);
        this.updateInvrateModel(invInvrate);
    }

    @Override
    public InvInvrate getInvrate(Integer invrateId) {
        return this.getInvrateModelById(invrateId);
    }

    @Override
    public void deleteInvrate(Integer invrateId) throws ApiException {
        this.deleteInvrateModel(invrateId);
    }

    @Override
    public QueryResult<InvInvrate> queryInvratePage(Map<String, Object> map) {
        List<InvInvrate> invInvrateList = this.queryInvrateModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInvrate(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(invInvrateList);
        return queryResult;
    }

    @Override
    public InvInvrate getInvrateByCode(String tenantCode, String invrateCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invrateCode", invrateCode);
        return this.getInvrateModelByCode(map);
    }

    @Override
    public void deleteInvrateByCode(String tenantCode, String invrateCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invrateCode", invrateCode);
        this.delInvrateModelByCode(map);
    }
}

