/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.invoice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.invoice.dao.InvInvlistMapper;
import com.yqbsoft.laser.service.invoice.domain.InvChannelsendDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvlistDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvlistGoodsDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvlistReDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvsendDomain;
import com.yqbsoft.laser.service.invoice.domain.OcContractDomain;
import com.yqbsoft.laser.service.invoice.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.invoice.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.invoice.domain.OcRefundDomain;
import com.yqbsoft.laser.service.invoice.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.invoice.domain.RsSkuDomain;
import com.yqbsoft.laser.service.invoice.domain.SgOccontractGoods;
import com.yqbsoft.laser.service.invoice.domain.SgSendgoodsGoods;
import com.yqbsoft.laser.service.invoice.model.InvChannelsend;
import com.yqbsoft.laser.service.invoice.model.InvInvlist;
import com.yqbsoft.laser.service.invoice.model.InvInvrate;
import com.yqbsoft.laser.service.invoice.model.InvUserinv;
import com.yqbsoft.laser.service.invoice.service.InvChannelsendBaseService;
import com.yqbsoft.laser.service.invoice.service.InvChannelsendService;
import com.yqbsoft.laser.service.invoice.service.InvInvlistGoodsService;
import com.yqbsoft.laser.service.invoice.service.InvInvlistService;
import com.yqbsoft.laser.service.invoice.service.InvInvrateService;
import com.yqbsoft.laser.service.invoice.service.InvInvsendService;
import com.yqbsoft.laser.service.invoice.service.InvUserinvService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvInvlistServiceImpl
extends BaseServiceImpl
implements InvInvlistService {
    private static final String SYS_CODE = "inv.InvInvlistServiceImpl";
    private InvInvlistMapper invInvlistMapper;
    private InvInvsendService invInvsendService;
    private InvInvlistGoodsService invInvlistGoodsService;
    private InvUserinvService invUserinvService;
    private InvChannelsendService invChannelsendService;
    private InvInvrateService invInvrateService;
    private InvChannelsendBaseService invChannelsendBaseService;
    private static String INF = "INT";

    public void setInvInvlistMapper(InvInvlistMapper invInvlistMapper) {
        this.invInvlistMapper = invInvlistMapper;
    }

    public InvInvrateService getInvInvrateService() {
        return this.invInvrateService;
    }

    public void setInvInvrateService(InvInvrateService invInvrateService) {
        this.invInvrateService = invInvrateService;
    }

    public void setInvChannelsendService(InvChannelsendService invChannelsendService) {
        this.invChannelsendService = invChannelsendService;
    }

    public InvUserinvService getInvUserinvService() {
        return this.invUserinvService;
    }

    public void setInvUserinvService(InvUserinvService invUserinvService) {
        this.invUserinvService = invUserinvService;
    }

    public InvInvlistGoodsService getInvInvlistGoodsService() {
        return this.invInvlistGoodsService;
    }

    public void setInvInvlistGoodsService(InvInvlistGoodsService invInvlistGoodsService) {
        this.invInvlistGoodsService = invInvlistGoodsService;
    }

    public InvInvsendService getInvInvsendService() {
        return this.invInvsendService;
    }

    public void setInvInvsendService(InvInvsendService invInvsendService) {
        this.invInvsendService = invInvsendService;
    }

    public InvChannelsendBaseService getInvChannelsendBaseService() {
        if (null == this.invChannelsendBaseService) {
            this.invChannelsendBaseService = (InvChannelsendBaseService)ApplicationContextUtil.getService((String)"invChannelsendBaseService");
        }
        return this.invChannelsendBaseService;
    }

    private Date getSysDate() {
        try {
            return this.invInvlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInvlist(InvInvlistDomain invInvlistDomain) {
        if (null == invInvlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)invInvlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInvlistDefault(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return;
        }
        if (null == invInvlist.getDataState()) {
            invInvlist.setDataState(0);
        }
        if (null == invInvlist.getGmtCreate()) {
            invInvlist.setGmtCreate(this.getSysDate());
        }
        invInvlist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)invInvlist.getInvlistCode())) {
            invInvlist.setInvlistCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)invInvlist.getInvlistBatchcode())) {
            invInvlist.setInvlistBatchcode(invInvlist.getInvlistCode());
        }
    }

    private int getInvlistMaxCode() {
        int code = 0;
        try {
            return this.invInvlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getInvlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInvlistUpdataDefault(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return;
        }
        invInvlist.setGmtModified(this.getSysDate());
    }

    private void saveInvlistModel(InvInvlist invInvlist) throws ApiException {
        if (null == invInvlist) {
            return;
        }
        try {
            this.invInvlistMapper.insert(invInvlist);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.saveInvlistModel.ex", (Throwable)e);
        }
    }

    private void saveInvlistBatchModel(List<InvInvlist> invInvlistList) throws ApiException {
        if (null == invInvlistList || invInvlistList.isEmpty()) {
            return;
        }
        try {
            this.invInvlistMapper.insertBatch(invInvlistList);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.saveInvlistBatchModel.ex", (Throwable)e);
        }
    }

    private InvInvlist getInvlistModelById(Integer invlistId) {
        if (null == invlistId) {
            return null;
        }
        try {
            return this.invInvlistMapper.selectByPrimaryKey(invlistId);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getInvlistModelById", (Throwable)e);
            return null;
        }
    }

    private InvInvlist getInvlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.invInvlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.getInvlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInvlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.delInvlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.delInvlistModelByCode.num");
        }
    }

    private void deleteInvlistModel(Integer invlistId) throws ApiException {
        if (null == invlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.deleteByPrimaryKey(invlistId);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.deleteInvlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.deleteInvlistModel.num");
        }
    }

    private void updateInvlistModel(InvInvlist invInvlist) throws ApiException {
        if (null == invInvlist) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateByPrimaryKey(invInvlist);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlistModel.num");
        }
    }

    private void updateRatecodeByCode(InvInvlist invInvlist) throws ApiException {
        if (null == invInvlist) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateRatecodeByCode(invInvlist);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlistModel.num");
        }
    }

    private void updateStateInvlistModel(Integer invlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == invlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invlistId", invlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModel.null");
        }
    }

    private void updateStateInvlistModelByCode(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)invlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateInvlistModelByCode.null");
        }
    }

    private void updateStateInvlistModelByBatchcode(String tenantCode, String invlistBatchcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)invlistBatchcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistBatchcode", invlistBatchcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvlistMapper.updateStateByBatchcode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateByBatchcode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateStateByBatchcode.null");
        }
    }

    private InvInvlist makeInvlist(InvInvlistDomain invInvlistDomain, InvInvlist invInvlist) {
        if (null == invInvlistDomain) {
            return null;
        }
        if (null == invInvlist) {
            invInvlist = new InvInvlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)invInvlist, (Object)invInvlistDomain);
            return invInvlist;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvlist", (Throwable)e);
            return null;
        }
    }

    private InvInvlistReDomain makeInvInvlistReDomain(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return null;
        }
        InvInvlistReDomain invInvlistReDomain = new InvInvlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)invInvlistReDomain, (Object)invInvlist);
            return invInvlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<InvInvlist> queryInvlistModelPage(Map<String, Object> parammap) {
        try {
            return this.invInvlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.queryInvlistModel", (Throwable)e);
            return null;
        }
    }

    private int countInvlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.invInvlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvlistServiceImpl.countInvlist", (Throwable)e);
        }
        return i;
    }

    private InvInvlist createInvInvlist(InvInvlistDomain invInvlistDomain) {
        String msg = this.checkInvlist(invInvlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvlistServiceImpl.saveInvlist.checkInvlist", msg);
        }
        InvInvlist invInvlist = this.makeInvlist(invInvlistDomain, null);
        this.setInvlistDefault(invInvlist);
        return invInvlist;
    }

    @Override
    public List<InvChannelsend> saveInvlist(InvInvlistDomain invInvlistDomain) throws ApiException {
        InvInvlist invInvlist = this.createInvInvlist(invInvlistDomain);
        this.saveInvlistModel(invInvlist);
        if (ListUtil.isNotEmpty(invInvlistDomain.getInvInvlistGoodsDomainList())) {
            ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
            for (InvInvlistGoodsDomain invInvlistGoodsDomain : invInvlistDomain.getInvInvlistGoodsDomainList()) {
                invInvlistGoodsDomain.setInvlistOpcode(invInvlistDomain.getInvlistOpcode());
                invInvlistGoodsDomain.setInvlistCode(invInvlist.getInvlistCode());
                invInvlistGoodsDomain.setInvlistBatchcode(invInvlist.getInvlistBatchcode());
                invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
            }
            this.invInvlistGoodsService.saveInvlistGoodsBatch(invInvlistGoodsDomainList);
        }
        this.updateContractInvstate(invInvlist, 1, 0);
        if (invInvlist.getUserinvType().equals("1") && !"OcContractInv".equals(invInvlist.getInvlistOptype()) && null != invInvlist.getUserinvType() && invInvlist.getUserinvType().equals("1")) {
            this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 1, 0, null);
        }
        ArrayList<InvInvlist> list = new ArrayList<InvInvlist>();
        list.add(invInvlist);
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public String saveInvlistBatch(List<InvInvlistDomain> invInvlistDomainList) throws ApiException {
        if (null == invInvlistDomainList || invInvlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<InvInvlist> invInvlistList = new ArrayList<InvInvlist>();
        String code = "";
        String batchcode = this.createUUIDString();
        for (InvInvlistDomain invInvlistDomain : invInvlistDomainList) {
            invInvlistDomain.setInvlistBatchcode(batchcode);
            InvInvlist invInvlist = this.createInvInvlist(invInvlistDomain);
            code = invInvlist.getInvlistCode();
            invInvlistList.add(invInvlist);
        }
        this.saveInvlistBatchModel(invInvlistList);
        return code;
    }

    @Override
    public void updateInvlistState(Integer invlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvlistModel(invlistId, dataState, oldDataState, map);
        InvInvlist invInvlist = this.getInvlist(invlistId);
        if (1 == dataState) {
            this.updateContractInvstate(invInvlist, 2, 1);
            this.sendInvInvsendService(invInvlist);
        }
        if (2 == dataState) {
            this.updateContractInvstate(invInvlist, 0, 1);
        }
    }

    @Override
    public void updateInvlistStateByCode(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvlistModelByCode(tenantCode, invlistCode, dataState, oldDataState, map);
        InvInvlist invInvlist = this.getInvlistByCode(tenantCode, invlistCode);
        if (1 == dataState) {
            this.updateContractInvstate(invInvlist, 2, null);
        }
        if (2 == dataState) {
            this.updateContractInvstate(invInvlist, -1, null);
        }
    }

    public void updateInvlistStateByBatchcode(String tenantCode, String invlistBatchcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvlistModelByBatchcode(tenantCode, invlistBatchcode, dataState, oldDataState, map);
        if (1 == dataState) {
            InvInvlist invInvlist = this.getInvlistByCode(tenantCode, invlistBatchcode);
            this.updateContractInvstate(invInvlist, 2, 1);
        }
    }

    @Override
    public String sendInvlistStateByCode(String tenantCode, String invlistCode, Integer dataState, Integer oldDataState) throws ApiException {
        String msg = "success";
        try {
            this.updateInvlistStateByBatchcode(tenantCode, invlistCode, dataState, oldDataState, null);
        }
        catch (Exception e) {
            msg = "error";
        }
        return msg;
    }

    private void updateContractInvstate(InvInvlist invInvlist, Integer dataState, Integer oldDataState) {
        if (null == invInvlist) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateContractInvstate.invInvlist");
        }
        if (StringUtils.isBlank((String)invInvlist.getInvlistOpcode())) {
            return;
        }
        String listOptype = invInvlist.getInvlistOptype();
        if (StringUtils.isBlank((String)listOptype)) {
            listOptype = "OcContract";
        }
        if ("OcContractInv".equals(listOptype)) {
            return;
        }
        if ("OcContract".equals(listOptype)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("contractBillcode", invInvlist.getInvlistOpcode());
            paramMap.put("tenantCode", invInvlist.getTenantCode());
            paramMap.put("dataState", dataState);
            paramMap.put("oldDataState", oldDataState);
            this.internalInvoke("oc.contract.updateContractInvstate", paramMap);
        } else {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sendgoodsCode", invInvlist.getInvlistOpcode());
            paramMap.put("tenantCode", invInvlist.getTenantCode());
            paramMap.put("dataState", dataState);
            paramMap.put("oldDataState", oldDataState);
            this.internalInvoke("sg.sendgoods.updatesendSendgoodsInvstate", paramMap);
        }
    }

    @Override
    public void updateInvlist(InvInvlistDomain invInvlistDomain) throws ApiException {
        String msg = this.checkInvlist(invInvlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlist.checkInvlist", msg);
        }
        InvInvlist oldInvInvlist = this.getInvlistModelById(invInvlistDomain.getInvlistId());
        if (null == oldInvInvlist) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        InvInvlist invInvlist = this.makeInvlist(invInvlistDomain, oldInvInvlist);
        if (StringUtils.isNotBlank((String)invInvlistDomain.getMemo())) {
            invInvlist.setMemo(invInvlistDomain.getMemo());
        }
        this.setInvlistUpdataDefault(invInvlist);
        this.updateInvlistModel(invInvlist);
    }

    @Override
    public void updateInvlistRatecode(InvInvlistDomain invInvlistDomain, String dataState, String gmtModified) throws ApiException {
        String msg = this.checkInvlist(invInvlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlist.checkInvlist", msg);
        }
        InvInvlist oldInvInvlist = this.getInvlistByCode(invInvlistDomain.getTenantCode(), invInvlistDomain.getInvlistCode());
        if (null == oldInvInvlist) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        InvInvlist invInvlist = this.makeInvlist(invInvlistDomain, oldInvInvlist);
        if (StringUtils.isNotBlank((String)dataState)) {
            invInvlist.setDataState(Integer.valueOf(dataState));
        }
        if (StringUtils.isNotBlank((String)gmtModified)) {
            invInvlist.setGmtModified(DateUtils.getDateToString((String)gmtModified, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        this.updateRatecodeByCode(invInvlist);
    }

    @Override
    public InvInvlist getInvlist(Integer invlistId) {
        return this.getInvlistModelById(invlistId);
    }

    @Override
    public void deleteInvlist(Integer invlistId) throws ApiException {
        this.deleteInvlistModel(invlistId);
    }

    @Override
    public QueryResult<InvInvlist> queryInvlistPage(Map<String, Object> map) {
        List<InvInvlist> invInvlistList = this.queryInvlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInvlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(invInvlistList);
        return queryResult;
    }

    @Override
    public InvInvlist getInvlistByCode(String tenantCode, String invlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        return this.getInvlistModelByCode(map);
    }

    @Override
    public void deleteInvlistByCode(String tenantCode, String invlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        this.delInvlistModelByCode(map);
    }

    public void sendInvInvsendService(InvInvlist invInvlist) {
        if (null == invInvlist) {
            return;
        }
        InvInvsendDomain invInvsendDomain = new InvInvsendDomain();
        invInvsendDomain.setInvlistCode(invInvlist.getInvlistCode());
        invInvsendDomain.setTenantCode(invInvlist.getTenantCode());
        this.invInvsendService.sendInvsend(invInvsendDomain);
    }

    @Override
    public void updateInvByCodeMemo(String tenantCode, String invlistCode, String memo) throws ApiException {
        if (StringUtils.isBlank((String)invlistCode) || null == memo) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invlistCode", invlistCode);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.invInvlistMapper.updateInvByCodeMemo(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvByCodeMemo.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvlistServiceImpl.updateInvByCodeMemo.null");
        }
    }

    @Override
    public String sendRedInvoice(OcRefundDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            this.logger.error("inv.InvInvlistServiceImpl.saveRedInvoice.ocRefundDomain.null");
            return "error";
        }
        InvInvlistDomain invInvlistDomain = new InvInvlistDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invlistOpcode", ocRefundDomain.getContractBillcode());
        map.put("dataState", 3);
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        QueryResult<InvInvlist> invInvlistQueryResult = this.queryInvlistPage(map);
        if (null == invInvlistQueryResult || ListUtil.isEmpty((Collection)invInvlistQueryResult.getList())) {
            this.logger.error("inv.InvInvlistServiceImpl.sendRedInvoice.invInvlistQueryResult.null", map);
            return "success";
        }
        InvInvlist invInvlist = (InvInvlist)invInvlistQueryResult.getList().get(0);
        try {
            BeanUtils.copyAllPropertys((Object)invInvlistDomain, (Object)invInvlist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        invInvlistDomain.setInvlistType("2");
        invInvlistDomain.setInvlistType("1");
        invInvlistDomain.setUserCode(ocRefundDomain.getMemberBcode());
        invInvlistDomain.setUserName(ocRefundDomain.getMemberBname());
        invInvlistDomain.setInvlistOptype("OcContract");
        invInvlistDomain.setInvlistOpamt(ocRefundDomain.getRefundMoney());
        invInvlistDomain.setTenantCode(ocRefundDomain.getTenantCode());
        invInvlistDomain.setInvlistOpcode(ocRefundDomain.getContractBillcode());
        invInvlistDomain.setInvlistOcode2(ocRefundDomain.getRefundCode());
        invInvlistDomain.setInvInvlistGoodsDomainList(this.makeReInvInvlistGoods(ocRefundDomain));
        InvUserinv invUserinvDomain = this.invUserinvService.getUserinvByCode(ocRefundDomain.getTenantCode(), ocRefundDomain.getMemberBcode());
        if (null == invUserinvDomain) {
            this.logger.error("inv.InvInvlistServiceImpl.saveRedInvoice.invUserinvDomain", (Object)"invUserinvDomain is null");
            return "error";
        }
        return "success";
    }

    @Override
    public String sendBlueInvoice(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("inv.InvInvlistServiceImpl.saveBlueInvoice.ocContractDomain", (Object)"param is null");
            return null;
        }
        InvInvlistDomain invInvlistDomain = new InvInvlistDomain();
        if (StringUtils.isBlank((String)ocContractDomain.getContractInvoice())) {
            return "success";
        }
        InvUserinv invUserinv = this.invUserinvService.getUserinvByCode(ocContractDomain.getTenantCode(), ocContractDomain.getContractInvoice());
        if (null == invUserinv) {
            this.logger.error("inv.InvInvlistServiceImpl.invUserinvDomain", (Object)"param is null");
            return null;
        }
        this.makeInvInvlistDomain(invInvlistDomain, invUserinv);
        if ("2".equals(invUserinv.getUserinvSort())) {
            invInvlistDomain.setUserinvMember(invUserinv.getUserinvUname());
        } else {
            invInvlistDomain.setUserinvMember(invUserinv.getUserinvMember());
        }
        invInvlistDomain.setInvlistType("1");
        invInvlistDomain.setUserCode(ocContractDomain.getMemberBcode());
        invInvlistDomain.setUserName(ocContractDomain.getMemberBname());
        invInvlistDomain.setInvlistOptype("OcContract");
        invInvlistDomain.setInvlistOpamt(ocContractDomain.getDataBmoney());
        invInvlistDomain.setTenantCode(ocContractDomain.getTenantCode());
        invInvlistDomain.setInvlistOpcode(ocContractDomain.getContractBillcode());
        invInvlistDomain.setInvInvlistGoodsDomainList(this.makeInvInvlistGoods(ocContractDomain));
        this.getInvChannelsendBaseService().saveInvlist(invInvlistDomain);
        return "success";
    }

    @Override
    public String sendBlueInvoiceByInv(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getOcContractSettlList())) {
            this.logger.error("inv.InvInvlistServiceImpl.saveBlueInvoice.ocContractDomain", (Object)"param is null");
            return "error";
        }
        OcContractSettlDomain contractSettlDomain = null;
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            if (!StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) || !INF.equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            contractSettlDomain = ocContractSettlDomain;
        }
        if (null == contractSettlDomain || null == contractSettlDomain.getContractSettlPmoney()) {
            this.logger.error("inv.InvInvlistServiceImpl.saveBlueInvoice.contractSettlDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            return "error";
        }
        if (null == contractSettlDomain.getContractSettlRmoney()) {
            contractSettlDomain.setContractSettlRmoney(BigDecimal.ZERO);
        }
        InvInvlistDomain invInvlistDomain = new InvInvlistDomain();
        invInvlistDomain.setUserinvType("1");
        invInvlistDomain.setInvlistType("1");
        invInvlistDomain.setMemberCode(ocContractDomain.getMemberGcode());
        invInvlistDomain.setMemberName(ocContractDomain.getMemberGname());
        invInvlistDomain.setUserCode(ocContractDomain.getMemberCode());
        invInvlistDomain.setUserName(ocContractDomain.getMemberName());
        invInvlistDomain.setInvlistOptype("OcContractInv");
        invInvlistDomain.setInvlistOpamt(contractSettlDomain.getContractSettlPmoney().subtract(contractSettlDomain.getContractSettlRmoney()));
        invInvlistDomain.setTenantCode(ocContractDomain.getTenantCode());
        invInvlistDomain.setInvlistOpcode(ocContractDomain.getContractBillcode());
        invInvlistDomain.setInvInvlistGoodsDomainList(this.makeInvlistGoodsByINT(ocContractDomain));
        this.getInvChannelsendBaseService().saveInvlist(invInvlistDomain);
        return "success";
    }

    @Override
    public String sendGetDlInv(String tenantCode) throws ApiException {
        String api = "cmc.asinvoice.getInvoice";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        String json = (String)this.getInternalRouter().inInvoke(api, map);
        return json;
    }

    @Override
    public String updateStateByInvlist(InvInvlist invInvlist) throws ApiException {
        if (null == invInvlist || StringUtils.isBlank((String)invInvlist.getInvlistCode()) || StringUtils.isBlank((String)invInvlist.getTenantCode())) {
            this.logger.error("inv.InvInvlistServiceImpl.updateStateByInvlist.invInvlist", (Object)"invInvlist is null");
            return "error";
        }
        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 5, invInvlist.getDataState(), null);
        return "success";
    }

    private void makeInvInvlistDomain(InvInvlistDomain invInvlistDomain, InvUserinv invUserinv) {
        try {
            BeanUtils.copyAllPropertys((Object)invInvlistDomain, (Object)invUserinv);
        }
        catch (Exception exception) {
            // empty catch block
        }
        invInvlistDomain.setInvlistRatecode(invUserinv.getUserinvNo());
    }

    private List<InvInvlistGoodsDomain> makeInvInvlistSgGoods(OcContractDomain ocContractDomain) {
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invrateOpcode", "all");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        QueryResult<InvInvrate> invInvrateQueryResult = this.invInvrateService.queryInvratePage(map);
        if (null == invInvrateQueryResult || ListUtil.isEmpty((Collection)invInvrateQueryResult.getList())) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.invInvrateQueryResult.null", map);
            return null;
        }
        return invInvlistGoodsDomainList;
    }

    private List<InvInvlistGoodsDomain> makeInvInvlistGoods(OcContractDomain ocContractDomain) {
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return invInvlistGoodsDomainList;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invrateOpcode", "all");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        QueryResult<InvInvrate> invInvrateQueryResult = this.invInvrateService.queryInvratePage(map);
        if (null == invInvrateQueryResult || ListUtil.isEmpty((Collection)invInvrateQueryResult.getList())) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.invInvrateQueryResult.null", map);
            return null;
        }
        InvInvrate invInvrate = (InvInvrate)invInvrateQueryResult.getList().get(0);
        String taxRate = invInvrate.getInvrateRate().divide(new BigDecimal(100)).setScale(2, 4).toString();
        String contractBillcode = ocContractDomain.getContractBillcode();
        String tenantCode = ocContractDomain.getTenantCode();
        List<SgSendgoodsGoods> sgSendgoodsGoods = this.querySendgoodsGoodsPage(tenantCode, contractBillcode);
        if (ListUtil.isEmpty(sgSendgoodsGoods)) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.sgSendgoodsGoods.null", (Object)(contractBillcode + "========" + tenantCode));
            return null;
        }
        for (SgSendgoodsGoods sgOccontractGoods : sgSendgoodsGoods) {
            if (sgOccontractGoods.getPricesetNprice().compareTo(BigDecimal.ZERO) == 0 || sgOccontractGoods.getContractGoodsGtype().equals("1")) continue;
            InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)sgOccontractGoods);
                invInvlistGoodsDomain.setInvlistOpcode(ocContractDomain.getContractBillcode());
                RsSkuDomain skuByCode = this.getSkuByCode(sgOccontractGoods.getTenantCode(), sgOccontractGoods.getSkuCode());
                if (null == skuByCode || StringUtils.isBlank((String)skuByCode.getGinfoCode())) {
                    this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.skuByCode.null", (Object)(sgOccontractGoods.getTenantCode() + "=======" + sgOccontractGoods.getSkuCode()));
                    invInvlistGoodsDomain.setGoodsProperty1(invInvrate.getInvrateMeno());
                } else {
                    invInvlistGoodsDomain.setGoodsProperty1(skuByCode.getGinfoCode());
                }
                invInvlistGoodsDomain.setGoodsProperty2(taxRate);
                invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.e", (Throwable)e);
            }
        }
        return invInvlistGoodsDomainList;
    }

    private List<InvInvlistGoodsDomain> makeReInvInvlistGoods(OcRefundDomain ocRefundDomain) {
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return invInvlistGoodsDomainList;
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)ocRefundGoodsDomain);
                invInvlistGoodsDomain.setInvlistOpcode(ocRefundGoodsDomain.getRefundCode());
                invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.e", (Throwable)e);
            }
        }
        return invInvlistGoodsDomainList;
    }

    private List<InvInvlistGoodsDomain> makeInvlistGoodsByINT(OcContractDomain ocContractDomain) {
        ArrayList<InvInvlistGoodsDomain> invInvlistGoodsDomainList = new ArrayList<InvInvlistGoodsDomain>();
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return invInvlistGoodsDomainList;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invrateOpcode", "all");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        QueryResult<InvInvrate> invInvrateQueryResult = this.invInvrateService.queryInvratePage(map);
        if (null == invInvrateQueryResult || ListUtil.isEmpty((Collection)invInvrateQueryResult.getList())) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.invInvrateQueryResult.null", map);
            return null;
        }
        InvInvrate invInvrate = (InvInvrate)invInvrateQueryResult.getList().get(0);
        String taxRate = invInvrate.getInvrateRate().divide(new BigDecimal(100)).setScale(2, 4).toString();
        String contractBillcode = ocContractDomain.getContractBillcode();
        String tenantCode = ocContractDomain.getTenantCode();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.goodsList.null", (Object)(contractBillcode + "========" + tenantCode));
            return null;
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (ocContractGoodsDomain.getContractGoodsGtype().equals("1")) continue;
            InvInvlistGoodsDomain invInvlistGoodsDomain = new InvInvlistGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)invInvlistGoodsDomain, (Object)ocContractGoodsDomain);
                invInvlistGoodsDomain.setInvlistOpcode(ocContractDomain.getContractBillcode());
                invInvlistGoodsDomain.setGoodsProperty1(invInvrate.getInvrateMeno());
                invInvlistGoodsDomain.setGoodsProperty2(taxRate);
                invInvlistGoodsDomainList.add(invInvlistGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("inv.InvInvlistServiceImpl.makeInvInvlistGoods.e", (Throwable)e);
            }
        }
        return invInvlistGoodsDomainList;
    }

    private List<InvChannelsend> buidPmChannelsend(List<InvInvlist> invInvlistList, String dri) {
        if (ListUtil.isEmpty(invInvlistList)) {
            return null;
        }
        ArrayList<InvChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<InvChannelsendDomain> disChannelsendDomainList = new ArrayList<InvChannelsendDomain>();
        for (InvInvlist invInvlist : invInvlistList) {
            InvChannelsendDomain tkChannelsendDomain = new InvChannelsendDomain();
            tkChannelsendDomain.setChannelsendOpcode(invInvlist.getInvlistCode());
            tkChannelsendDomain.setChannelsendType("invInvlist");
            tkChannelsendDomain.setChannelsendDir(dri);
            tkChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
            tkChannelsendDomain.setTenantCode(invInvlist.getTenantCode());
            disChannelsendDomainList.add(tkChannelsendDomain);
        }
        pmChannelsendList = this.invChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    public List<SgOccontractGoods> queryOccontractGoodsPage(String tenantCode, String contractBillcode) {
        String api = "sg.sgOccontract.queryOccontractGoodsPage";
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke(api, parameter);
        SupQueryResult invQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List sgOccontractGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)invQueryResult.getList()), SgOccontractGoods.class);
        if (ListUtil.isEmpty((Collection)sgOccontractGoodsList)) {
            this.logger.error("inv.InvInvlistServiceImpl.queryOccontractGoodsPage.sgOccontractGoodsList.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            return null;
        }
        return sgOccontractGoodsList;
    }

    public List<SgSendgoodsGoods> querySendgoodsGoodsPage(String tenantCode, String contractBillcode) {
        String api = "sg.sendgoods.querySendgoodsGoodsPage";
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke(api, parameter);
        SupQueryResult sgSendgoodsGoodsSupQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List sgOccontractGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsGoodsSupQueryResult.getList()), SgSendgoodsGoods.class);
        if (ListUtil.isEmpty((Collection)sgOccontractGoodsList)) {
            this.logger.error("inv.InvInvlistServiceImpl.querySendgoodsGoodsPage.sgOccontractGoodsList.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            return null;
        }
        return sgOccontractGoodsList;
    }

    public List<SgSendgoodsGoods> querygoodsGoodsPage(String tenantCode, String contractBillcode) {
        String api = "sg.sendgoods.querySendgoodsGoodsPage";
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke(api, parameter);
        SupQueryResult sgSendgoodsGoodsSupQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List sgOccontractGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsGoodsSupQueryResult.getList()), SgSendgoodsGoods.class);
        if (ListUtil.isEmpty((Collection)sgOccontractGoodsList)) {
            this.logger.error("inv.InvInvlistServiceImpl.querySendgoodsGoodsPage.sgOccontractGoodsList.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            return null;
        }
        return sgOccontractGoodsList;
    }

    public RsSkuDomain getSkuByCode(String tenantCode, String skuCode) {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> skuMap = new HashMap<String, String>();
        sendMap.put("skuCode", skuCode);
        sendMap.put("tenantCode", tenantCode);
        skuMap.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        String rssku = this.internalInvoke("rs.sku.getSkuByCode", skuMap);
        RsSkuDomain rsSkuReDomain = (RsSkuDomain)JsonUtil.buildNormalBinder().getJsonToObject(rssku, RsSkuDomain.class);
        return rsSkuReDomain;
    }

    @Override
    public void updateInvlistBatch(List<InvInvlistDomain> invInvlistDomainList, Integer dataState, Integer oldDataState) throws ApiException {
        if (ListUtil.isEmpty(invInvlistDomainList)) {
            return;
        }
        for (InvInvlistDomain invInvlistDomain : invInvlistDomainList) {
            this.updateInvlist(invInvlistDomain);
            this.updateInvlistStateByCode(invInvlistDomain.getTenantCode(), invInvlistDomain.getInvlistCode(), dataState, oldDataState, null);
        }
    }
}

