/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.schedule;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.job.model.JobSchedule;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeErrorCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleJobEntity;
import com.yqbsoft.laser.service.job.schedule.ScheduleManager;
import com.yqbsoft.laser.service.job.service.ScheduleService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.Map;

public class BaseExecuteServiceImpl
extends BaseServiceImpl {
    protected final SupperLogUtil logger = new SupperLogUtil(((Object)((Object)this)).getClass());
    public static final String SYS_CODE = "job.JOB.BaseExecuteServiceImpl";
    private ScheduleService scheduleService;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduleService getScheduleService() {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.scheduleService) {
                this.scheduleService = (ScheduleService)SpringApplicationContextUtil.getBean((String)"scheduleService");
            }
        }
        return this.scheduleService;
    }

    public void setScheduleService(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    public void exceptionUpdateScheduleMsg(ScheduleJobEntity scheduleJobEntity, String msg) {
        try {
            msg = this.parseMsg(msg);
            String jobId = scheduleJobEntity.getJobId();
            String jobGroupId = scheduleJobEntity.getJobGroup();
            if (scheduleJobEntity.getJobStopCount() <= 0) {
                this.updateScheduleMsg(jobId, msg);
                return;
            }
            Integer ecount = ScheduleExeErrorCache.getInstance().getErrorJobMap().get(jobId);
            if (ecount == null) {
                ecount = 1;
            } else {
                Integer n = ecount;
                Integer n2 = ecount = Integer.valueOf(ecount + 1);
            }
            if (ecount >= scheduleJobEntity.getJobStopCount()) {
                ScheduleManager.disableSchedule(jobId, jobGroupId);
                this.updateScheduleMsg(jobId, msg);
                ScheduleExeErrorCache.getInstance().getErrorJobMap().remove(jobId);
            } else {
                ScheduleExeErrorCache.getInstance().put(jobId, ecount);
            }
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Throwable)e);
        }
    }

    private String parseMsg(String msg) {
        Map errorMap;
        if (!StringUtils.isMapJson((String)msg)) {
            return msg;
        }
        Map msgMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(msg, String.class, Object.class);
        if (MapUtil.isNotEmpty((Map)msgMap) && MapUtil.isNotEmpty((Map)(errorMap = (Map)msgMap.get("error_response")))) {
            if (errorMap.get("subCode") != null && StringUtils.isNotBlank((String)((String)errorMap.get("subCode")).toString())) {
                msg = (String)errorMap.get("subMsg");
            } else if (errorMap.get("errorCode") != null && StringUtils.isNotBlank((String)((String)errorMap.get("errorCode")).toString())) {
                msg = (String)errorMap.get("msg");
            }
        }
        return msg;
    }

    public void updateScheduleMsg(String jobId, String msg) {
        JobSchedule jobSchedule = this.getScheduleService().getSchedule(Integer.valueOf(jobId.split("@")[0]));
        jobSchedule.setGmtModified(new Date());
        if (null != msg && msg.length() > 250) {
            msg = msg.substring(0, 249);
        }
        jobSchedule.setScheduleMsg(msg);
        this.getScheduleService().updateSchedule(jobSchedule);
    }

    public Map<String, String> getAppKeyCache() {
        return DisUtil.getMapAll((String)"EcoreAppmanage-line");
    }
}

