/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.job.dao.JobScheduleMapper;
import com.yqbsoft.laser.service.job.domain.JobHostnameDomain;
import com.yqbsoft.laser.service.job.domain.JobScheduleDomainBean;
import com.yqbsoft.laser.service.job.model.JobHostname;
import com.yqbsoft.laser.service.job.model.JobSchedule;
import com.yqbsoft.laser.service.job.schedule.PointUtil;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeSuccessCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleJobEntity;
import com.yqbsoft.laser.service.job.schedule.ScheduleManager;
import com.yqbsoft.laser.service.job.service.JobHostnameService;
import com.yqbsoft.laser.service.job.service.ScheduleService;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.router.ApiProperty;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ScheduleServiceImpl
extends BaseServiceImpl
implements ScheduleService {
    public static final String SYS_CODE = "job.JOB.ScheduleServiceImpl";
    private JobScheduleMapper jobScheduleMapper;
    public JobHostnameService jobHostnameService;
    private static String APPMANAGE_KEY = "Appmanage-key-line";
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";
    private static String cachejar = "AmAppwar-jar-war";

    public JobScheduleMapper getJobScheduleMapper() {
        return this.jobScheduleMapper;
    }

    public void setJobScheduleMapper(JobScheduleMapper jobScheduleMapper) {
        this.jobScheduleMapper = jobScheduleMapper;
    }

    public void setJobHostnameService(JobHostnameService jobHostnameService) {
        this.jobHostnameService = jobHostnameService;
    }

    @Override
    public void saveSchedule(JobSchedule jobSchedule) throws ApiException {
        String msg = this.check(jobSchedule);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.saveSchedule.null", msg);
        }
        this.setDefault(jobSchedule);
        this.saveScheduleMode(jobSchedule);
        if (jobSchedule.getScheduleType().equals("1")) {
            JobHostnameDomain job = new JobHostnameDomain();
            job.setScheduleName(jobSchedule.getScheduleName());
            try {
                job.setHostnameName(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            job.setTenantCode(jobSchedule.getTenantCode());
            this.jobHostnameService.saveJobHostname(job);
        }
    }

    private String check(JobSchedule jobSchedule) {
        if (null == jobSchedule) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)jobSchedule.getScheduleName())) {
            msg = msg + "scheduleName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(JobSchedule jobSchedule) {
        if (null == jobSchedule) {
            return;
        }
        if (null == jobSchedule.getDataState()) {
            jobSchedule.setDataState(0);
        }
        if (null == jobSchedule.getGmtCreate()) {
            jobSchedule.setGmtCreate(this.getSysDate());
        }
        if (jobSchedule.getScheduleGroup() != null && jobSchedule.getScheduleGroup().length() == 0) {
            jobSchedule.setScheduleGroup(null);
        }
    }

    private void saveScheduleMode(JobSchedule jobSchedule) throws ApiException {
        if (null == jobSchedule) {
            return;
        }
        try {
            this.jobScheduleMapper.insert(jobSchedule);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.saveScheduleMode.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.jobScheduleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("job.JOB.ScheduleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private List<JobSchedule> querySchedule(Map<String, Object> parammap) {
        try {
            return this.jobScheduleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("job.JOB.ScheduleServiceImpl.querySchedule", (Throwable)e);
            return null;
        }
    }

    private boolean checkDev() {
        String path = "appres.path";
        ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"laser", (String)path, (String)"");
        if (null != resourceBundle) {
            try {
                String flag = resourceBundle.getString("dev");
                if (StringUtils.isNotBlank((String)flag) && "true".equals(flag)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public List<JobSchedule> queryOpenSchedule() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        if (this.checkDev()) {
            List<String> wareIdList = Arrays.asList("0,1".split("\\,"));
            parammap.put("scheduleLevelStr", wareIdList);
        }
        parammap.put("order", true);
        parammap.put("orderStr", "SCHEDULE_LEVEL asc");
        parammap.put("appmanageIcode", ServletMain.getAppName());
        List<JobSchedule> jobScheduleList = this.querySchedule(parammap);
        return jobScheduleList;
    }

    @Override
    public List<JobSchedule> queryCloseSchedule() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<JobSchedule> jobScheduleList = this.queryScheduleMode(parammap);
        return jobScheduleList;
    }

    private Map<String, String> getAppKeyCache() {
        return DisUtil.getRemotMapAll((String)"EcoreAppmanage-line");
    }

    private void delCache(JobSchedule jobSchedule, String scheduleTappkeyUUID, boolean flag) {
        if (null == jobSchedule || StringUtils.isBlank((String)scheduleTappkeyUUID)) {
            return;
        }
        Map<String, ScheduleJobEntity> jobMap = ScheduleExeCache.getInstance().getJobMap();
        if (null == jobMap || jobMap.isEmpty()) {
            return;
        }
        ArrayList<String> mapdel = new ArrayList<String>();
        for (String jobId : jobMap.keySet()) {
            boolean deleteFlag = false;
            String[] jobids = jobId.split("\\@");
            String jobstr = jobids[0] + "@" + jobids[1];
            if (jobids.length < 3) {
                deleteFlag = true;
            } else if (flag) {
                if (jobstr.equals(jobSchedule.getScheduleId() + "@" + jobSchedule.getScheduleName()) && !scheduleTappkeyUUID.equals(jobids[2])) {
                    deleteFlag = true;
                }
            } else if (jobstr.equals(jobSchedule.getScheduleId() + "@" + jobSchedule.getScheduleName())) {
                deleteFlag = true;
            }
            if (!deleteFlag) continue;
            ScheduleManager.disableSchedule(jobId, jobMap.get(jobId).getJobGroup());
            mapdel.add(jobId);
        }
        if (null != mapdel && !mapdel.isEmpty()) {
            for (String string : mapdel) {
                jobMap.remove(string);
            }
        }
    }

    private void makeFlag(List<JobSchedule> openJobScheduleList, Map<String, String> appKey) {
        if (null == openJobScheduleList || openJobScheduleList.isEmpty()) {
            return;
        }
        if (null == appKey || appKey.isEmpty()) {
            this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.noapp", (Object)"");
            return;
        }
        Map<String, String> successJobMap = ScheduleExeSuccessCache.getInstance().getSuccessJobMap();
        if (null == successJobMap || successJobMap.isEmpty()) {
            return;
        }
        String scheduleTappkeyUUID = "";
        String nowScheduleTappkeyUUID = "";
        String jobName = "";
        for (JobSchedule jobSchedule : openJobScheduleList) {
            this.getAppKey(jobSchedule);
            this.makeIcode(jobSchedule);
            jobName = jobSchedule.getScheduleName();
            Set<String> pointAppKeys = PointUtil.getPointAppKeys(jobSchedule.getScheduleTicode(), jobSchedule.getScheduleTappkey());
            this.logger.info("job.JOB.ScheduleServiceImpl.queryJobInit.pointAppKeys", (Object)(jobSchedule.getScheduleTicode() + "=" + jobSchedule.getScheduleTappkey() + "=" + pointAppKeys.toString()));
            for (String pointAppKey : pointAppKeys) {
                jobSchedule.setScheduleTappkey(pointAppKey);
                String successKey = TokenUtil.genToken((Object[])new Object[]{jobName, pointAppKey});
                scheduleTappkeyUUID = successJobMap.get(successKey);
                nowScheduleTappkeyUUID = appKey.get(pointAppKey);
                this.logger.info("job.JOB.ScheduleServiceImpl.queryJobInit.jobName", (Object)(jobName + "=" + jobSchedule.getScheduleTicode() + "=" + jobSchedule.getScheduleTappkey() + "=" + pointAppKey));
                ScheduleExeSuccessCache.getInstance().putJobName(jobName, this.getScheduleJobEntity(jobSchedule, pointAppKey, nowScheduleTappkeyUUID));
                if (StringUtils.isBlank((String)nowScheduleTappkeyUUID) || !nowScheduleTappkeyUUID.equals(scheduleTappkeyUUID)) {
                    successJobMap.remove(successKey);
                    this.makeNextJob(jobName, appKey, successJobMap, openJobScheduleList);
                }
                this.delCache(jobSchedule, nowScheduleTappkeyUUID, true);
            }
        }
    }

    private void makeNextJob(String scheduleName, Map<String, String> appKey, Map<String, String> successJobMap, List<JobSchedule> openJobScheduleList) {
        if (null == openJobScheduleList || openJobScheduleList.isEmpty()) {
            return;
        }
        if (null == successJobMap || successJobMap.isEmpty()) {
            return;
        }
        if (null == appKey || appKey.isEmpty()) {
            this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.noapp", (Object)"");
            return;
        }
        String nowScheduleTappkeyUUID = "";
        String jobName = "";
        String scheduleExjobId = "";
        String[] exjobS = null;
        for (JobSchedule jobSchedule : openJobScheduleList) {
            scheduleExjobId = jobSchedule.getScheduleExjobId();
            if (StringUtils.isBlank((String)scheduleExjobId) || null == (exjobS = scheduleExjobId.split(","))) continue;
            boolean flag = false;
            for (String string : exjobS) {
                if (!string.equals(scheduleName)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            jobName = jobSchedule.getScheduleName();
            Set<String> pointAppKeys = PointUtil.getPointAppKeys(jobSchedule.getScheduleTicode(), jobSchedule.getScheduleTappkey());
            for (String pointAppKey : pointAppKeys) {
                String successKey = TokenUtil.genToken((Object[])new Object[]{jobName, pointAppKey});
                successJobMap.remove(successKey);
                this.delCache(jobSchedule, nowScheduleTappkeyUUID, false);
                this.makeNextJob(jobName, appKey, successJobMap, openJobScheduleList);
            }
        }
    }

    private void makeIcode(JobSchedule jobSchedule) {
        String version;
        if (null == jobSchedule) {
            return;
        }
        String param = jobSchedule.getScheduleParam();
        if (StringUtils.isBlank((String)param)) {
            return;
        }
        JsonUtil.buildNormalBinder();
        Map map = JsonUtil.getJsonToMap((String)param);
        if (null == map || map.isEmpty()) {
            return;
        }
        String apiCode = (String)map.get("method");
        String apiKey = TokenUtil.genToken((Object[])new Object[]{apiCode, version = (String)map.get("version")});
        ApiProperty apiProperty = LocalCache.getApiProperty((String)apiKey);
        if (null != apiProperty) {
            jobSchedule.setAppmanageIcode(apiProperty.getAppmanageIcode());
        }
    }

    private String getNowJobKey(JobSchedule jobSchedule) {
        if (null == jobSchedule) {
            return null;
        }
        String appmanagerKey = ServletMain.getAppKey();
        JobHostname jobhostname = (JobHostname)DisUtil.getMapJson((String)"JobHostname-list", (String)(jobSchedule.getScheduleName() + "-" + appmanagerKey + "-" + jobSchedule.getTenantCode()), JobHostname.class);
        String jobkey = "";
        if (null != jobhostname && !StringUtils.isBlank((String)jobhostname.getHostnameName())) {
            jobkey = jobhostname.getHostnameName();
        }
        if (StringUtils.isNotBlank((String)jobkey) && PointUtil.isAppOnline(jobkey)) {
            return jobkey;
        }
        String cacheKey = "job_mainkey";
        jobkey = DisUtil.getRemot((String)cacheKey);
        if (StringUtils.isNotBlank((String)jobkey) && PointUtil.isAppOnline(jobkey)) {
            return jobkey;
        }
        DisUtil.set((String)cacheKey, (String)appmanagerKey);
        jobkey = DisUtil.getRemot((String)cacheKey);
        if (StringUtils.isNotBlank((String)jobkey) && PointUtil.isAppOnline(jobkey)) {
            return jobkey;
        }
        this.logger.error("job.JOB.ScheduleServiceImpl.getNowJobKey.appmanagerKey-jobkey", (Object)(jobkey + "=" + appmanagerKey));
        return "";
    }

    public List<RegeditBean> getPointAppKeys(String appmanageIcode) {
        if (StringUtils.isBlank((String)appmanageIcode)) {
            return null;
        }
        Map appkeyMap = DisUtil.getRemotMapAll((String)APPMANAGE_KEY);
        if (null == appkeyMap || appkeyMap.isEmpty()) {
            this.logger.error("job.JOB.ScheduleServiceImpl.getPointAppKeys.appkeyMap", (Object)appmanageIcode);
            return null;
        }
        ArrayList<RegeditBean> list = new ArrayList<RegeditBean>();
        for (String key : appkeyMap.keySet()) {
            RegeditBean regeditBean;
            if (!appmanageIcode.equals(appkeyMap.get(key)) || (regeditBean = ScheduleServiceImpl.getRegeditBean(key)) == null) continue;
            list.add(regeditBean);
        }
        return list;
    }

    public static RegeditBean getRegeditBean(String appmanageAppkey) {
        String js = DisUtil.getRemotMap((String)VFOAPPMANAGE_LINEINFO, (String)appmanageAppkey);
        if (StringUtils.isBlank((String)js)) {
            return null;
        }
        RegeditBean regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(js, RegeditBean.class);
        return regeditBean;
    }

    private String getAppKey(JobSchedule jobSchedule) {
        ApiProperty apiProperty;
        if (null == jobSchedule) {
            return "";
        }
        String apiKey = jobSchedule.getScheduleApicode();
        if (StringUtils.isBlank((String)apiKey)) {
            return "";
        }
        if (apiKey.indexOf("-") < 0) {
            apiKey = apiKey + "-1.0";
        }
        if (null == (apiProperty = LocalCache.getApiProperty((String)apiKey))) {
            this.logger.error("job.JOB.ScheduleServiceImpl.getAppKey.apiProperty:", (Object)apiKey);
            return "";
        }
        String appICode = apiProperty.getAppmanageIcode();
        if (StringUtils.isBlank((String)appICode)) {
            this.logger.error("job.JOB.ScheduleServiceImpl.getAppKey.appICode:", (Object)apiKey);
            return "";
        }
        String warIcode = DisUtil.getMap((String)cachejar, (String)(appICode + "-" + "00000000"));
        if (StringUtils.isBlank((String)warIcode)) {
            this.logger.error("job.JOB.ScheduleServiceImpl.getAppKey.warIcode:", (Object)apiKey);
            return "";
        }
        List<RegeditBean> list = this.getPointAppKeys(warIcode);
        if (ListUtil.isEmpty(list)) {
            this.logger.error("job.JOB.ScheduleServiceImpl.getAppKey.appPropList:", (Object)warIcode);
            return "";
        }
        jobSchedule.setScheduleTappkey(list.get(0).getAppkey());
        jobSchedule.setScheduleTicode(list.get(0).getAppIcode());
        return list.get(0).getAppkey();
    }

    @Override
    public synchronized void queryJobInit() {
        try {
            Map<String, ScheduleJobEntity> jobMap;
            Map<String, String> appKey = this.getAppKeyCache();
            if (null == appKey || appKey.isEmpty()) {
                this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.noapp", (Object)"");
                return;
            }
            List<JobSchedule> openJobScheduleList = this.queryOpenSchedule();
            if (null == openJobScheduleList || openJobScheduleList.isEmpty()) {
                return;
            }
            this.makeFlag(openJobScheduleList, appKey);
            String scheduleTappkeyUUID = "";
            String jobtokey = "";
            for (JobSchedule jobSchedule : openJobScheduleList) {
                this.makeIcode(jobSchedule);
                jobtokey = this.getAppKey(jobSchedule);
                if (StringUtils.isBlank((String)jobtokey)) {
                    jobtokey = jobSchedule.getScheduleTappkey();
                }
                Set<String> pointAppKeys = PointUtil.getPointAppKeys(jobSchedule.getScheduleTicode(), jobtokey);
                if ("0".equals(jobSchedule.getScheduleType())) {
                    for (String pointAppKey : pointAppKeys) {
                        jobSchedule.setScheduleTappkey(pointAppKey);
                        scheduleTappkeyUUID = appKey.get(pointAppKey);
                        if (StringUtils.isNotBlank((String)scheduleTappkeyUUID)) {
                            ScheduleManager.enableCronSchedule(this.getScheduleJobEntity(jobSchedule, pointAppKey, scheduleTappkeyUUID));
                            continue;
                        }
                        this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.noapp1:", (Object)(jobtokey + "=" + jobSchedule.getScheduleApicode()));
                    }
                    continue;
                }
                if (!"1".equals(jobSchedule.getScheduleType()) || this.checkDev()) continue;
                String jobkey = this.getNowJobKey(jobSchedule);
                String appmanagerKey = ServletMain.getAppKey();
                if (!appmanagerKey.equals(jobkey)) {
                    this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.appmanagerKey-jobkey", (Object)(jobtokey + "=" + appmanagerKey));
                    ScheduleManager.disableSchedule(jobSchedule.getScheduleId().toString(), jobSchedule.getScheduleGroup());
                    continue;
                }
                String tappkey = jobtokey;
                if (StringUtils.isBlank((String)tappkey) && StringUtils.isNotBlank((String)jobSchedule.getScheduleTappkey()) && !jobSchedule.getScheduleTappkey().equals(jobSchedule.getScheduleTicode())) {
                    tappkey = jobSchedule.getScheduleTappkey();
                } else {
                    if (null != pointAppKeys && !pointAppKeys.isEmpty()) {
                        tappkey = (String)pointAppKeys.toArray()[0];
                    }
                    if (StringUtils.isBlank((String)tappkey)) {
                        tappkey = jobSchedule.getScheduleTappkey();
                    }
                }
                scheduleTappkeyUUID = appKey.get(tappkey);
                if (StringUtils.isNotBlank((String)scheduleTappkeyUUID)) {
                    ScheduleManager.enableCronSchedule(this.getScheduleJobEntity(jobSchedule, tappkey, scheduleTappkeyUUID));
                    continue;
                }
                this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.noapp2:", (Object)(jobtokey + "==" + tappkey + "=" + jobSchedule.getScheduleApicode()));
            }
            List<JobSchedule> closeJobScheduleList = this.queryCloseSchedule();
            if (closeJobScheduleList != null && !closeJobScheduleList.isEmpty()) {
                for (JobSchedule jobSchedule : closeJobScheduleList) {
                    this.getAppKey(jobSchedule);
                    ScheduleManager.disableSchedule(jobSchedule.getScheduleId().toString(), jobSchedule.getScheduleGroup());
                }
            }
            if ((jobMap = ScheduleExeCache.getInstance().getJobMap()) != null && !jobMap.isEmpty()) {
                ArrayList<String> mapdel = new ArrayList<String>();
                for (String jobId : jobMap.keySet()) {
                    boolean deleteFlag = true;
                    if (CollectionUtils.isNotEmpty(openJobScheduleList)) {
                        block6: for (JobSchedule jobSchedule : openJobScheduleList) {
                            this.getAppKey(jobSchedule);
                            Set<String> pointAppKeys = PointUtil.getPointAppKeys(jobSchedule.getScheduleTicode(), jobSchedule.getScheduleTappkey());
                            for (String pointAppKey : pointAppKeys) {
                                scheduleTappkeyUUID = appKey.get(pointAppKey);
                                if (StringUtils.isBlank((String)scheduleTappkeyUUID)) {
                                    scheduleTappkeyUUID = "";
                                }
                                if (!jobId.equals(jobSchedule.getScheduleId() + "@" + jobSchedule.getScheduleName() + "@" + scheduleTappkeyUUID)) continue;
                                deleteFlag = false;
                                continue block6;
                            }
                        }
                    }
                    if (!deleteFlag) continue;
                    ScheduleManager.disableSchedule(jobId, jobMap.get(jobId).getJobGroup());
                    mapdel.add(jobId);
                }
                if (null != mapdel && !mapdel.isEmpty()) {
                    for (String string : mapdel) {
                        jobMap.remove(string);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("job.JOB.ScheduleServiceImpl.queryJobInit.e:", (Throwable)e);
        }
    }

    private ScheduleJobEntity getScheduleJobEntity(JobSchedule jobSchedule, String scheduleTappkey, String scheduleTappkeyUUID) {
        if (jobSchedule == null) {
            return null;
        }
        ScheduleJobEntity scheduleJobEntity = new ScheduleJobEntity();
        scheduleJobEntity.setStateFull("1".equals(jobSchedule.getScheduleSync()));
        scheduleJobEntity.setJobId(jobSchedule.getScheduleId().toString());
        scheduleJobEntity.setJobGroup(jobSchedule.getScheduleGroup());
        if (StringUtils.isBlank((String)scheduleJobEntity.getJobGroup())) {
            scheduleJobEntity.setJobGroup("def");
        }
        scheduleJobEntity.setCronExpression(jobSchedule.getScheduleExp());
        scheduleJobEntity.setJobName(jobSchedule.getScheduleName());
        scheduleJobEntity.setJobType(jobSchedule.getScheduleType());
        scheduleJobEntity.setAppmanageIcode(jobSchedule.getAppmanageIcode());
        scheduleJobEntity.setScheduleTicode(jobSchedule.getScheduleTicode());
        scheduleJobEntity.setScheduleTappkey(scheduleTappkey);
        scheduleJobEntity.setScheduleTappkeyUUID(scheduleTappkeyUUID);
        if (StringUtils.isNotBlank((String)jobSchedule.getScheduleJobclass())) {
            try {
                scheduleJobEntity.setServiceClass(Class.forName(jobSchedule.getScheduleJobclass()));
            }
            catch (Exception e) {
                this.logger.error("job.JOB.ScheduleServiceImpl.getScheduleJobEntity.classnotfound", (Throwable)e);
            }
        }
        scheduleJobEntity.put("url", RegeditUtil.replaceUrl((String)scheduleTappkey, (String)jobSchedule.getScheduleUrl()));
        scheduleJobEntity.put("param", jobSchedule.getScheduleParam());
        scheduleJobEntity.put("type", jobSchedule.getScheduleMethod());
        scheduleJobEntity.setJobStopCount(jobSchedule.getScheduleStopnum() == null ? 0 : jobSchedule.getScheduleStopnum());
        scheduleJobEntity.setExJobIds(StringUtils.isBlank((String)jobSchedule.getScheduleExjobId()) ? null : jobSchedule.getScheduleExjobId().split(","));
        scheduleJobEntity.setScheduleService(this);
        return scheduleJobEntity;
    }

    @Override
    public JobSchedule getSchedule(Integer scheduleId) {
        JobSchedule jobSchedule = null;
        jobSchedule = this.jobScheduleMapper.selectByPrimaryKey(scheduleId);
        return jobSchedule;
    }

    @Override
    public void updateSchedule(JobSchedule jobSchedule) {
        this.jobScheduleMapper.updateByPrimaryKey(jobSchedule);
    }

    @Override
    public QueryResult<JobSchedule> querySchedulePage(Map<String, Object> map) {
        List<JobSchedule> JobScheduleList = this.queryScheduleMode(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSchedule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(JobScheduleList);
        return queryResult;
    }

    private List<JobSchedule> queryScheduleMode(Map<String, Object> parammap) {
        try {
            return this.jobScheduleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("job.JOB.ScheduleServiceImpl.queryScheduleMode", (Throwable)e);
            return null;
        }
    }

    private int countSchedule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.jobScheduleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("job.JOB.ScheduleServiceImpl.countSchedule", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteSchedule(Integer scheduleId) {
        this.jobScheduleMapper.deleteByPrimaryKey(scheduleId);
    }

    @Override
    public void updateScheduleState(Integer scheduleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateScheduleMode(scheduleId, dataState, oldDataState);
    }

    private void updateStateScheduleMode(Integer scheduleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == scheduleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduleId", scheduleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.jobScheduleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateStateScheduleMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateStateScheduleMode.null");
        }
    }

    private void updateStateScheduleModeByTappkey(String scheduleTappkey, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == scheduleTappkey || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduleTappkey", scheduleTappkey);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.jobScheduleMapper.updateStateByTappkey(map);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateStateScheduleModeByTappkey.ex");
        }
        if (i < 0) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateStateScheduleModeByTappkey.null");
        }
    }

    public void updateStateScheduleModeByTicode(String scheduleTicode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == scheduleTicode || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduleTicode", scheduleTicode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.jobScheduleMapper.updateStateByTappkey(map);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateStateScheduleModeByTicode.ex");
        }
        if (i < 0) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateStateScheduleModeByTicode.null");
        }
    }

    @Override
    public void updateScheduleById(JobScheduleDomainBean jobScheduleDomainBean) throws ApiException {
        JobSchedule jobSchedule = this.getSchedule(jobScheduleDomainBean.getScheduleId());
        if (jobSchedule == null) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateSchedule.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(jobSchedule = this.makeModel(jobSchedule, jobScheduleDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateSchedule.null", msg);
        }
        this.setDefault(jobSchedule);
        this.updateScheduleModel(jobSchedule);
    }

    private void updateScheduleModel(JobSchedule jobSchedule) throws ApiException {
        if (null == jobSchedule) {
            return;
        }
        try {
            this.jobScheduleMapper.updateByPrimaryKey(jobSchedule);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.ScheduleServiceImpl.updateScheduleModel.ex");
        }
    }

    private JobSchedule makeModel(JobSchedule jobSchedule, JobScheduleDomainBean jobScheduleDomainBean) {
        if (jobScheduleDomainBean == null) {
            return null;
        }
        if (jobSchedule == null) {
            jobSchedule = new JobSchedule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)jobSchedule, (Object)jobScheduleDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jobSchedule;
    }

    @Override
    public void updateScheduleOpenByTappkey(String scheduleTappkey) throws ApiException {
        this.updateStateScheduleModeByTappkey(scheduleTappkey, 1, 0);
    }

    @Override
    public void updateScheduleCloseByTappkey(String scheduleTappkey) throws ApiException {
        this.updateStateScheduleModeByTappkey(scheduleTappkey, 0, 1);
    }

    @Override
    public List<ScheduleJobEntity> getScheduleInfo() throws ApiException {
        Map<String, ScheduleJobEntity> jobMap = ScheduleExeCache.getInstance().getJobMap();
        ArrayList<ScheduleJobEntity> l = new ArrayList<ScheduleJobEntity>();
        for (String key : jobMap.keySet()) {
            ScheduleJobEntity scheduleJobEntity = jobMap.get(key);
            ScheduleJobEntity entity = new ScheduleJobEntity();
            try {
                BeanUtils.copyAllPropertys((Object)entity, (Object)scheduleJobEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            entity.setJobId(entity.getJobId().split("@")[0]);
            entity.setScheduleService(null);
            l.add(entity);
        }
        if (l.size() > 0) {
            return l;
        }
        return null;
    }
}

