/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.job.dao.JobHostnameMapper;
import com.yqbsoft.laser.service.job.domain.JobHostnameDomain;
import com.yqbsoft.laser.service.job.model.JobHostname;
import com.yqbsoft.laser.service.job.service.JobHostnameService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class JobHostnameServiceImpl
extends BaseServiceImpl
implements JobHostnameService {
    public static final String SYS_CODE = "job.JOB.JobHostnameServiceImpl";
    @Autowired
    JobHostnameMapper jobHostnameMapper;

    private Date getSysDate() {
        try {
            return this.jobHostnameMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("job.JOB.JobHostnameServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkJobHostname(JobHostnameDomain jobHostnameDomain) {
        if (null == jobHostnameDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setJobHostnameDefault(JobHostname jobHostname) {
        if (null == jobHostname) {
            return;
        }
        if (null == jobHostname.getDataState()) {
            jobHostname.setDataState(1);
        }
        if (null == jobHostname.getGmtCreate()) {
            jobHostname.setGmtCreate(this.getSysDate());
        }
        jobHostname.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)jobHostname.getHostnameName())) {
            jobHostname.setHostnameName(this.createUUIDString());
        }
    }

    private int getJobHostnameMaxCode() {
        int code = 0;
        try {
            return this.jobHostnameMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("job.JOB.JobHostnameServiceImpl.getJobHostnameMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setJobHostnameUpdataDefault(JobHostname jobHostname) {
        if (null == jobHostname) {
            return;
        }
        jobHostname.setGmtModified(this.getSysDate());
    }

    private void saveJobHostnameModel(JobHostname jobHostname) throws ApiException {
        if (null == jobHostname) {
            return;
        }
        try {
            this.jobHostnameMapper.insert(jobHostname);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.saveJobHostnameModel.ex", (Throwable)e);
        }
    }

    private JobHostname getJobHostnameModelById(Integer hostnameId) {
        if (null == hostnameId) {
            return null;
        }
        try {
            return this.jobHostnameMapper.selectByPrimaryKey(hostnameId);
        }
        catch (Exception e) {
            this.logger.error("job.JOB.JobHostnameServiceImpl.getJobHostnameModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteJobHostnameModel(Integer hostnameId) throws ApiException {
        if (null == hostnameId) {
            return;
        }
        int i = 0;
        try {
            i = this.jobHostnameMapper.deleteByPrimaryKey(hostnameId);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.deleteJobHostnameModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.deleteJobHostnameModel.num");
        }
    }

    private void updateJobHostnameModel(JobHostname jobHostname) throws ApiException {
        if (null == jobHostname) {
            return;
        }
        try {
            this.jobHostnameMapper.updateByPrimaryKeySelective(jobHostname);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.updateJobHostnameModel.ex", (Throwable)e);
        }
    }

    private void updateStateJobHostnameModel(Integer hostnameId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == hostnameId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hostnameId", hostnameId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.jobHostnameMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.updateStateJobHostnameModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.updateStateJobHostnameModel.null");
        }
    }

    private JobHostname makeJobHostname(JobHostnameDomain jobHostnameDomain, JobHostname jobHostname) {
        if (null == jobHostnameDomain) {
            return null;
        }
        if (null == jobHostname) {
            jobHostname = new JobHostname();
        }
        try {
            BeanUtils.copyAllPropertys((Object)jobHostname, (Object)jobHostnameDomain);
            return jobHostname;
        }
        catch (Exception e) {
            this.logger.error("job.JOB.JobHostnameServiceImpl.makeJobHostname", (Throwable)e);
            return null;
        }
    }

    private List<JobHostname> queryJobHostnameModelPage(Map<String, Object> parammap) {
        try {
            return this.jobHostnameMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("job.JOB.JobHostnameServiceImpl.queryJobHostnameModel", (Throwable)e);
            return null;
        }
    }

    private int countJobHostname(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.jobHostnameMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("job.JOB.JobHostnameServiceImpl.countJobHostname", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveJobHostname(JobHostnameDomain jobHostnameDomain) throws ApiException {
        String msg = this.checkJobHostname(jobHostnameDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.saveJobHostname.checkJobHostname", msg);
        }
        JobHostname jobHostname = this.makeJobHostname(jobHostnameDomain, null);
        this.setJobHostnameDefault(jobHostname);
        this.saveJobHostnameModel(jobHostname);
        this.loadJobhostName();
    }

    @Override
    public void updateJobHostnameState(Integer hostnameId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateJobHostnameModel(hostnameId, dataState, oldDataState);
    }

    @Override
    public void updateJobHostname(JobHostnameDomain jobHostnameDomain) throws ApiException {
        String msg = this.checkJobHostname(jobHostnameDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.updateJobHostname.checkJobHostname", msg);
        }
        JobHostname oldJobHostname = this.getJobHostnameModelById(jobHostnameDomain.getHostnameId());
        if (null == oldJobHostname) {
            throw new ApiException("job.JOB.JobHostnameServiceImpl.updateJobHostname.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        JobHostname jobHostname = this.makeJobHostname(jobHostnameDomain, oldJobHostname);
        this.setJobHostnameUpdataDefault(jobHostname);
        this.updateJobHostnameModel(jobHostname);
    }

    @Override
    public JobHostname getJobHostname(Integer hostnameId) {
        return this.getJobHostnameModelById(hostnameId);
    }

    @Override
    public void deleteJobHostname(Integer hostnameId) throws ApiException {
        this.deleteJobHostnameModel(hostnameId);
    }

    @Override
    public QueryResult<JobHostname> queryJobHostnamePage(Map<String, Object> map) {
        List<JobHostname> jobHostnameList = this.queryJobHostnameModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countJobHostname(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(jobHostnameList);
        return queryResult;
    }

    @Override
    public void loadJobhostName() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<JobHostname> jobHostnameList = this.queryJobHostnameModelPage(parammap);
        String key = "JobHostname-list";
        if (null == jobHostnameList || jobHostnameList.isEmpty()) {
            DisUtil.del((String)key);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            for (JobHostname job : jobHostnameList) {
                map.put(job.getScheduleName() + "-" + job.getHostnameName() + "-" + job.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)job));
            }
            DisUtil.setMap((String)key, map);
        }
    }
}

