/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExpMapper;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExpallMapper;
import com.yqbsoft.laser.service.logistics.dao.WlFreightTemMapper;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpReDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpallDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightTemDomain;
import com.yqbsoft.laser.service.logistics.model.WlFreightExp;
import com.yqbsoft.laser.service.logistics.model.WlFreightExpall;
import com.yqbsoft.laser.service.logistics.model.WlFreightTem;
import com.yqbsoft.laser.service.logistics.service.WlFreightTemService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlFreightTemServiceImpl
extends BaseServiceImpl
implements WlFreightTemService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlFreightTemServiceImpl";
    private WlFreightTemMapper wlFreightTemMapper;
    private WlFreightExpMapper wlFreightExpMapper;
    private WlFreightExpallMapper wlFreightExpallMapper;

    public void setWlFreightTemMapper(WlFreightTemMapper wlFreightTemMapper) {
        this.wlFreightTemMapper = wlFreightTemMapper;
    }

    public void setWlFreightExpMapper(WlFreightExpMapper wlFreightExpMapper) {
        this.wlFreightExpMapper = wlFreightExpMapper;
    }

    public void setWlFreightExpallMapper(WlFreightExpallMapper wlFreightExpallMapper) {
        this.wlFreightExpallMapper = wlFreightExpallMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlFreightTemMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFreightTem(WlFreightTemDomain wlFreightTemDomain) {
        if (null == wlFreightTemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFreightTemDefault(WlFreightTem wlFreightTem) {
        if (null == wlFreightTem) {
            return;
        }
        if (null == wlFreightTem.getDataState()) {
            wlFreightTem.setDataState(0);
        }
        if (null == wlFreightTem.getGmtCreate()) {
            wlFreightTem.setGmtCreate(this.getSysDate());
        }
        wlFreightTem.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlFreightTem.getFreightTemCode())) {
            wlFreightTem.setFreightTemCode(this.createUUIDString());
        }
    }

    private int getFreightTemMaxCode() {
        int code = 0;
        try {
            return this.wlFreightTemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightTemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightTemUpdataDefault(WlFreightTem wlFreightTem) {
        if (null == wlFreightTem) {
            return;
        }
        wlFreightTem.setGmtModified(this.getSysDate());
    }

    private void saveFreightTemModel(WlFreightTem wlFreightTem) throws ApiException {
        if (null == wlFreightTem) {
            return;
        }
        try {
            this.wlFreightTemMapper.insert(wlFreightTem);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightTemModel.ex", (Throwable)e);
        }
    }

    private WlFreightTem getFreightTemModelById(Integer freightTemId) {
        if (null == freightTemId) {
            return null;
        }
        try {
            return this.wlFreightTemMapper.selectByPrimaryKey(freightTemId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightTemModelById", (Throwable)e);
            return null;
        }
    }

    public WlFreightTem getFreightTemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightTemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightTemModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFreightTemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightTemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightTemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightTemModelByCode.num");
        }
    }

    private void deleteFreightTemModel(Integer freightTemId) throws ApiException {
        if (null == freightTemId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightTemMapper.deleteByPrimaryKey(freightTemId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightTemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightTemModel.num");
        }
    }

    private void updateFreightTemModel(WlFreightTem wlFreightTem) throws ApiException {
        if (null == wlFreightTem) {
            return;
        }
        try {
            this.wlFreightTemMapper.updateByPrimaryKeySelective(wlFreightTem);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightTemModel.ex", (Throwable)e);
        }
    }

    private void updateStateFreightTemModel(Integer freightTemId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == freightTemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightTemId", freightTemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlFreightTemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightTemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightTemModel.null");
        }
    }

    private WlFreightTem makeFreightTem(WlFreightTemDomain wlFreightTemDomain, WlFreightTem wlFreightTem) {
        if (null == wlFreightTemDomain) {
            return null;
        }
        if (null == wlFreightTem) {
            wlFreightTem = new WlFreightTem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightTem, (Object)wlFreightTemDomain);
            return wlFreightTem;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightTem", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightTem> queryFreightTemModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightTemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightTemModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightTem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightTemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.countFreightTem", (Throwable)e);
        }
        return i;
    }

    private String checkFreightExp(WlFreightExpDomain wlFreightExpDomain) {
        if (null == wlFreightExpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExpDomain.getMemberCode())) {
            msg = msg + "memberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpDomain.getMemberName())) {
            msg = msg + "memberName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpDomain.getFreightExpPayer())) {
            msg = msg + "freightExpPayer\u4e3a\u7a7a;";
        } else if ("member".equals(wlFreightExpDomain.getFreightExpPayer())) {
            if (StringUtils.isBlank((String)wlFreightExpDomain.getExpressCode())) {
                msg = msg + "expressCode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)wlFreightExpDomain.getFreightExpValuation())) {
                msg = msg + "freightExpValuation\u4e3a\u7a7a;";
            }
        }
        if (StringUtils.isBlank((String)wlFreightExpDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExpDefault(WlFreightExp wlFreightExp) {
        if (null == wlFreightExp) {
            return;
        }
        if (null == wlFreightExp.getDataState()) {
            wlFreightExp.setDataState(0);
        }
        if (null == wlFreightExp.getGmtCreate()) {
            wlFreightExp.setGmtCreate(this.getSysDate());
        }
        wlFreightExp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlFreightExp.getFreightExpCode())) {
            wlFreightExp.setFreightExpCode(this.createUUIDString());
        }
    }

    private int getFreightExpMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExpUpdataDefault(WlFreightExp wlFreightExp) {
        if (null == wlFreightExp) {
            return;
        }
        wlFreightExp.setGmtModified(this.getSysDate());
    }

    private void saveFreightExpModel(WlFreightExp wlFreightExp) throws ApiException {
        if (null == wlFreightExp) {
            return;
        }
        try {
            this.wlFreightExpMapper.insert(wlFreightExp);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExpModel.ex", (Throwable)e);
        }
    }

    private WlFreightExp getFreightExpModelById(Integer freightExpId) {
        if (null == freightExpId) {
            return null;
        }
        try {
            return this.wlFreightExpMapper.selectByPrimaryKey(freightExpId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpModelById", (Throwable)e);
            return null;
        }
    }

    private WlFreightExp getFreightExpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFreightExpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpModelByCode.num");
        }
    }

    private void deleteFreightExpModel(Integer freightExpId) throws ApiException {
        if (null == freightExpId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpMapper.deleteByPrimaryKey(freightExpId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpModel.num");
        }
    }

    private void updateFreightExpModel(WlFreightExp wlFreightExp) throws ApiException {
        if (null == wlFreightExp) {
            return;
        }
        try {
            this.wlFreightExpMapper.updateByPrimaryKeySelective(wlFreightExp);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpModel.ex", (Throwable)e);
        }
    }

    private void updateStateFreightExpModel(Integer freightExpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == freightExpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExpId", freightExpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlFreightExpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpModel.null");
        }
    }

    private WlFreightExp makeFreightExp(WlFreightExpDomain wlFreightExpDomain, WlFreightExp wlFreightExp) {
        if (null == wlFreightExpDomain) {
            return null;
        }
        if (null == wlFreightExp) {
            wlFreightExp = new WlFreightExp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExp, (Object)wlFreightExpDomain);
            return wlFreightExp;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightExp", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExp> queryFreightExpModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpModel", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExpReDomain> queryFreightExpReDomainList(Map<String, Object> parammap) {
        List<WlFreightExp> freightExpallList = this.queryFreightExpModelPage(parammap);
        ArrayList<WlFreightExpReDomain> freightExpReDomainList = new ArrayList<WlFreightExpReDomain>();
        if (ListUtil.isEmpty(freightExpallList)) {
            return freightExpReDomainList;
        }
        for (WlFreightExp wlFreightExp : freightExpallList) {
            WlFreightExpReDomain freightExpReDomain = new WlFreightExpReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)freightExpReDomain, (Object)wlFreightExp);
                freightExpReDomain.setFreightExpallList(this.queryFreightExpallListByExpCode(wlFreightExp.getFreightExpCode()));
                freightExpReDomainList.add(freightExpReDomain);
            }
            catch (Exception e) {
                this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpReDomainList.ex", (Throwable)e);
                return null;
            }
        }
        return freightExpReDomainList;
    }

    private int countFreightExp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.countFreightExp", (Throwable)e);
        }
        return i;
    }

    private String checkFreightExpall(WlFreightExpallDomain wlFreightExpallDomain) {
        if (null == wlFreightExpallDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpCode())) {
            msg = msg + "freightExpCode\u4e3a\u7a7a;";
        }
        if (wlFreightExpallDomain.getFreightExpallPostage() == null) {
            msg = msg + "freightExpallPostage\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpallPlus())) {
            msg = msg + "freightExpallPlus\u4e3a\u7a7a;";
        }
        if (wlFreightExpallDomain.getFreightExpallPostageplus() == null) {
            msg = msg + "freightExpallPostageplus\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpallDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExpallDefault(WlFreightExpall wlFreightExpall) {
        if (null == wlFreightExpall) {
            return;
        }
        if (null == wlFreightExpall.getDataState()) {
            wlFreightExpall.setDataState(0);
        }
        if (null == wlFreightExpall.getGmtCreate()) {
            wlFreightExpall.setGmtCreate(this.getSysDate());
        }
        wlFreightExpall.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlFreightExpall.getFreightExpallCode())) {
            wlFreightExpall.setFreightExpallCode(this.createUUIDString());
        }
    }

    private List<WlFreightExpallDomain> queryFreightExpallListByExpCode(String freightExpCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("freightExpCode", freightExpCode);
        parammap.put("order", true);
        parammap.put("orderStr", "FREIGHT_EXPALL_DEFAULT");
        List<WlFreightExpall> freightExpallList = this.queryFreightExpallModelPage(parammap);
        ArrayList<WlFreightExpallDomain> expallDomainList = new ArrayList<WlFreightExpallDomain>();
        if (ListUtil.isEmpty(freightExpallList)) {
            return expallDomainList;
        }
        try {
            for (WlFreightExpall wlFreightExpall : freightExpallList) {
                WlFreightExpallDomain expallDomain = new WlFreightExpallDomain();
                BeanUtils.copyAllPropertys((Object)expallDomain, (Object)wlFreightExpall);
                expallDomainList.add(expallDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpallListByExpCode.ex", (Throwable)e);
            return null;
        }
        return expallDomainList;
    }

    private List<WlFreightExpReDomain> getFreightExpModelByMemberCode(String memberCode, String tenantCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberCode", memberCode);
        params.put("tenantCode", tenantCode);
        ArrayList<WlFreightExpReDomain> freightExpReDomainList = new ArrayList<WlFreightExpReDomain>();
        List<WlFreightExp> freightExpList = this.queryFreightExpModelPage(params);
        if (ListUtil.isEmpty(freightExpList)) {
            return freightExpReDomainList;
        }
        try {
            for (WlFreightExp wlFreightExp : freightExpList) {
                WlFreightExpReDomain freightExpReDomain = new WlFreightExpReDomain();
                BeanUtils.copyAllPropertys((Object)freightExpReDomain, (Object)wlFreightExp);
                freightExpReDomain.setFreightExpallList(this.queryFreightExpallListByExpCode(wlFreightExp.getFreightExpCode()));
                freightExpReDomainList.add(freightExpReDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightModelByMemberCode.ex", (Throwable)e);
            return null;
        }
        return freightExpReDomainList;
    }

    private int getFreightExpallMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExpallMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpallMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExpallUpdataDefault(WlFreightExpall wlFreightExpall) {
        if (null == wlFreightExpall) {
            return;
        }
        wlFreightExpall.setGmtModified(this.getSysDate());
    }

    private void saveFreightExpallModel(WlFreightExpall wlFreightExpall) throws ApiException {
        if (null == wlFreightExpall) {
            return;
        }
        try {
            this.wlFreightExpallMapper.insert(wlFreightExpall);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExpallModel.ex", (Throwable)e);
        }
    }

    private WlFreightExpall getFreightExpallModelById(Integer freightExpallId) {
        if (null == freightExpallId) {
            return null;
        }
        try {
            return this.wlFreightExpallMapper.selectByPrimaryKey(freightExpallId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpallModelById", (Throwable)e);
            return null;
        }
    }

    public WlFreightExpall getFreightExpallModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExpallMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpallModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFreightExpallModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpallModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpallModelByCode.num");
        }
    }

    private void deleteFreightExpallModel(Integer freightExpallId) throws ApiException {
        if (null == freightExpallId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.deleteByPrimaryKey(freightExpallId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpallModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpallModel.num");
        }
    }

    private void updateFreightExpallModel(WlFreightExpall wlFreightExpall) throws ApiException {
        if (null == wlFreightExpall) {
            return;
        }
        try {
            this.wlFreightExpallMapper.updateByPrimaryKeySelective(wlFreightExpall);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpallModel.ex", (Throwable)e);
        }
    }

    private void updateStateFreightExpallModel(Integer freightExpallId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == freightExpallId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExpallId", freightExpallId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpallModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpallModel.null");
        }
    }

    private WlFreightExpall makeFreightExpall(WlFreightExpallDomain wlFreightExpallDomain, WlFreightExpall wlFreightExpall) {
        if (null == wlFreightExpallDomain) {
            return null;
        }
        if (null == wlFreightExpall) {
            wlFreightExpall = new WlFreightExpall();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpall, (Object)wlFreightExpallDomain);
            return wlFreightExpall;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightExpall", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExpall> queryFreightExpallModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExpallMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpallModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightExpall(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.countFreightExpall", (Throwable)e);
        }
        return i;
    }

    private void saveFreightExpallBarthModel(List<WlFreightExpallDomain> freightExpallDomainList, WlFreightExp freightExp) {
        if (freightExpallDomainList == null || freightExpallDomainList.isEmpty()) {
            return;
        }
        if (freightExp == null || "shop".equals(freightExp.getFreightExpPayer())) {
            return;
        }
        for (WlFreightExpallDomain wlFreightExpallDomain : freightExpallDomainList) {
            wlFreightExpallDomain.setFreightExpCode(freightExp.getFreightExpCode());
            wlFreightExpallDomain.setAppmanageIcode(freightExp.getAppmanageIcode());
            wlFreightExpallDomain.setTenantCode(freightExp.getTenantCode());
            this.saveFreightExpall(wlFreightExpallDomain);
        }
    }

    @Override
    public String saveFreightTem(WlFreightTemDomain wlFreightTemDomain) throws ApiException {
        String msg = this.checkFreightTem(wlFreightTemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightTem.checkFreightTem", msg);
        }
        WlFreightTem wlFreightTem = this.makeFreightTem(wlFreightTemDomain, null);
        this.setFreightTemDefault(wlFreightTem);
        this.saveFreightTemModel(wlFreightTem);
        return wlFreightTem.getFreightTemCode();
    }

    @Override
    public void updateFreightTemState(Integer freightTemId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFreightTemModel(freightTemId, dataState, oldDataState);
    }

    @Override
    public void updateFreightTem(WlFreightTemDomain wlFreightTemDomain) throws ApiException {
        String msg = this.checkFreightTem(wlFreightTemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightTem.checkFreightTem", msg);
        }
        WlFreightTem oldWlFreightTem = this.getFreightTemModelById(wlFreightTemDomain.getFreightTemId());
        if (null == oldWlFreightTem) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightTem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightTem wlFreightTem = this.makeFreightTem(wlFreightTemDomain, oldWlFreightTem);
        this.setFreightTemUpdataDefault(wlFreightTem);
        this.updateFreightTemModel(wlFreightTem);
    }

    @Override
    public WlFreightTem getFreightTem(Integer freightTemId) {
        return this.getFreightTemModelById(freightTemId);
    }

    @Override
    public void deleteFreightTem(Integer freightTemId) throws ApiException {
        this.deleteFreightTemModel(freightTemId);
    }

    @Override
    public QueryResult<WlFreightTem> queryFreightTemPage(Map<String, Object> map) {
        List<WlFreightTem> wlFreightTemList = this.queryFreightTemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightTem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightTemList);
        return queryResult;
    }

    @Override
    public WlFreightTem getFreightTemByCode(Map<String, Object> map) {
        return this.getFreightTemModelByCode(map);
    }

    @Override
    public void delFreightTemByCode(Map<String, Object> map) throws ApiException {
        this.delFreightTemModelByCode(map);
    }

    @Override
    public String saveFreightExp(WlFreightExpDomain wlFreightExpDomain) throws ApiException {
        String msg = this.checkFreightExp(wlFreightExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExp.checkFreightExp", msg);
        }
        WlFreightExp wlFreightExp = this.makeFreightExp(wlFreightExpDomain, null);
        this.setFreightExpDefault(wlFreightExp);
        this.saveFreightExpModel(wlFreightExp);
        this.saveFreightExpallBarthModel(wlFreightExpDomain.getFreightExpallList(), wlFreightExp);
        return wlFreightExp.getFreightExpCode();
    }

    @Override
    public void updateFreightExpState(Integer freightExpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFreightExpModel(freightExpId, dataState, oldDataState);
    }

    @Override
    public void updateFreightExp(WlFreightExpDomain wlFreightExpDomain) throws ApiException {
        String msg = this.checkFreightExp(wlFreightExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExp.checkFreightExp", msg);
        }
        WlFreightExp oldWlFreightExp = this.getFreightExpModelById(wlFreightExpDomain.getFreightExpId());
        if (null == oldWlFreightExp) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExp wlFreightExp = this.makeFreightExp(wlFreightExpDomain, oldWlFreightExp);
        this.setFreightExpUpdataDefault(wlFreightExp);
        this.updateFreightExpModel(wlFreightExp);
    }

    @Override
    public WlFreightExp getFreightExp(Integer freightExpId) {
        return this.getFreightExpModelById(freightExpId);
    }

    @Override
    public void deleteFreightExp(Integer freightExpId) throws ApiException {
        this.deleteFreightExpModel(freightExpId);
    }

    @Override
    public QueryResult<WlFreightExpReDomain> queryFreightExpPage(Map<String, Object> map) {
        int count = this.countFreightExp(map);
        List<WlFreightExpReDomain> wlFreightExpList = count > 0 ? this.queryFreightExpReDomainList(map) : new ArrayList<WlFreightExpReDomain>();
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExpList);
        return queryResult;
    }

    private WlFreightExpReDomain makeFreightExpReDomain(WlFreightExp wlFreightExp) {
        if (wlFreightExp == null) {
            return null;
        }
        WlFreightExpReDomain wlFreightExpReDomain = new WlFreightExpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpReDomain, (Object)wlFreightExp);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightExpReDomain.ex", (Throwable)e);
            return null;
        }
        wlFreightExpReDomain.setFreightExpallList(this.queryFreightExpallListByExpCode(wlFreightExp.getFreightExpCode()));
        return wlFreightExpReDomain;
    }

    @Override
    public WlFreightExpReDomain getFreightExpByCode(Map<String, Object> map) {
        return this.makeFreightExpReDomain(this.getFreightExpModelByCode(map));
    }

    @Override
    public void delFreightExpByCode(Map<String, Object> map) throws ApiException {
        this.delFreightExpModelByCode(map);
    }

    @Override
    public List<WlFreightExpReDomain> getFreightExpByMemberCode(String memberCode, String tenantCode) {
        return this.getFreightExpModelByMemberCode(memberCode, tenantCode);
    }

    @Override
    public String saveFreightExpall(WlFreightExpallDomain wlFreightExpallDomain) throws ApiException {
        String msg = this.checkFreightExpall(wlFreightExpallDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExpall.checkFreightExpall", msg);
        }
        WlFreightExpall wlFreightExpall = this.makeFreightExpall(wlFreightExpallDomain, null);
        this.setFreightExpallDefault(wlFreightExpall);
        this.saveFreightExpallModel(wlFreightExpall);
        return wlFreightExpall.getFreightExpallCode();
    }

    @Override
    public void updateFreightExpallState(Integer freightExpallId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFreightExpallModel(freightExpallId, dataState, oldDataState);
    }

    @Override
    public void updateFreightExpall(WlFreightExpallDomain wlFreightExpallDomain) throws ApiException {
        String msg = this.checkFreightExpall(wlFreightExpallDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpall.checkFreightExpall", msg);
        }
        WlFreightExpall oldWlFreightExpall = this.getFreightExpallModelById(wlFreightExpallDomain.getFreightExpallId());
        if (null == oldWlFreightExpall) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpall.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExpall wlFreightExpall = this.makeFreightExpall(wlFreightExpallDomain, oldWlFreightExpall);
        this.setFreightExpallUpdataDefault(wlFreightExpall);
        this.updateFreightExpallModel(wlFreightExpall);
    }

    @Override
    public WlFreightExpall getFreightExpall(Integer freightExpallId) {
        return this.getFreightExpallModelById(freightExpallId);
    }

    @Override
    public void deleteFreightExpall(Integer freightExpallId) throws ApiException {
        this.deleteFreightExpallModel(freightExpallId);
    }

    @Override
    public QueryResult<WlFreightExpall> queryFreightExpallPage(Map<String, Object> map) {
        List<WlFreightExpall> wlFreightExpallList = this.queryFreightExpallModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExpall(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExpallList);
        return queryResult;
    }

    @Override
    public WlFreightExpall getFreightExpallByCode(Map<String, Object> map) {
        return this.getFreightExpallModelByCode(map);
    }

    @Override
    public void delFreightExpallByCode(Map<String, Object> map) throws ApiException {
        this.delFreightExpallModelByCode(map);
    }

    @Override
    public BigDecimal getFreightFare(Map<String, Object> map) {
        BigDecimal buynums;
        WlFreightExpReDomain wlFreightExp;
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.map.null", "map is null");
        }
        String freightExpCode = (String)map.get("freightExpCode");
        String areaCode = (String)map.get("areaCode");
        Object quantityMap = map.get("quantity");
        Object weightMap = map.get("weight");
        String tenantCode = (String)map.get("tenantCode");
        BigDecimal DEFAULT_FARE = BigDecimal.ZERO;
        if (StringUtils.isBlank((String)areaCode)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.areaCode.null", "\u6536\u8d27\u5730\u5740\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((String)freightExpCode)) {
            this.logger.info("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.freightExpCode.null", (Object)"freightExpCode is null");
            return DEFAULT_FARE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("freightExpCode", freightExpCode);
        if (tenantCode == null) {
            params.put("tenantCode", tenantCode);
        }
        if ((wlFreightExp = this.getFreightExpByCode(params)) == null) {
            this.logger.info(SYS_CODE, (Object)("\u672a\u5339\u914d\u5230\u7269\u6d41\u6a21\u677f   code=" + freightExpCode));
            return DEFAULT_FARE;
        }
        if ("shop".equals(wlFreightExp.getFreightExpPayer())) {
            return BigDecimal.ZERO;
        }
        WlFreightExpallDomain expall = null;
        WlFreightExpallDomain defaultExpall = null;
        for (WlFreightExpallDomain wlFreightExpallDomain : wlFreightExp.getFreightExpallList()) {
            if (wlFreightExpallDomain.getFreightExpallArea().contains(areaCode)) {
                expall = wlFreightExpallDomain;
                break;
            }
            if (!wlFreightExpallDomain.getFreightExpallDefault().booleanValue()) continue;
            defaultExpall = wlFreightExpallDomain;
        }
        if (expall == null) {
            expall = defaultExpall;
        }
        if (expall == null) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.expall.no", (Object)("\u7269\u6d41\u6a21\u677f\u914d\u7f6e\u6709\u8bef" + wlFreightExp.getFreightExpCode()));
            return DEFAULT_FARE;
        }
        if ("quantity".equals(wlFreightExp.getFreightExpValuation())) {
            if (quantityMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.quantity.null", "\u672a\u83b7\u53d6\u5230\u6570\u91cf\u4fe1\u606f");
            }
            buynums = new BigDecimal(quantityMap.toString());
        } else if ("g".equals(wlFreightExp.getFreightExpValuation())) {
            if (weightMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.weight.null", "\u672a\u83b7\u53d6\u5230\u91cd\u91cf\u4fe1\u606f");
            }
            buynums = new BigDecimal(weightMap.toString());
        } else {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.null", (Object)("\u8fd0\u8d39\u6a21\u677f\u8ba1\u91cf\u672a\u5339\u914d\u6210\u529f" + wlFreightExp.getFreightExpValuation()));
            return DEFAULT_FARE;
        }
        if (buynums.compareTo(BigDecimal.ZERO) < 1) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.no", "\u6570\u91cf/\u91cd\u91cf\u6709\u8bef" + buynums);
        }
        BigDecimal fare = expall.getFreightExpallPostage();
        BigDecimal vstart = new BigDecimal(expall.getFreightExpallStart());
        if (vstart.compareTo(buynums) < 0) {
            BigDecimal numu = buynums.subtract(vstart).divide(new BigDecimal(expall.getFreightExpallPlus()), 0, RoundingMode.CEILING);
            fare = fare.add(numu.multiply(expall.getFreightExpallPostageplus()));
        }
        return fare;
    }
}

