/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.kdniao.api;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.logistics.kdniao.api.KdniaoUtil;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoCommodity;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoWaybill;
import com.yqbsoft.laser.service.logistics.kdniao.bean.Kdniaopeople;
import com.yqbsoft.laser.service.logistics.model.WlTrace;
import com.yqbsoft.laser.service.logistics.service.WlTraceService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class KdniaoInterfaceAPI
extends BaseServiceImpl {
    @Autowired
    WlTraceService wlTraceService;
    public static final String SYS_CODE = "wl.LOGISTICS.KdniaoInterfaceAPI";
    private String url = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-wl-kdniaoUrl");
    private String ReqURL = this.url + "/Ebusiness/EbusinessOrderHandle.aspx";
    private String OrderReqURL = this.url + "/api/dist";
    private String OnlineReqURL = this.url + "/api/Eorderservice";

    public String getOrderTracesByJson(String expNo, String tenantCode) throws ApiException {
        String msg = this.checkMsg("null", expNo, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("wl.LOGISTICS.KdniaoInterfaceAPI.getOrderTracesByJson", msg);
        }
        String requestData = "{'LogisticCode':'" + expNo + "'}";
        Map<String, String> params = KdniaoUtil.makeDefaultMap(requestData, tenantCode);
        params.put("RequestType", "2002");
        String result = KdniaoUtil.sendPost(this.ReqURL, params);
        return result;
    }

    public String getOrderTracesByJson(String expCode, String expNo, String tenantCode) throws ApiException {
        String msg = this.checkMsg(expCode, expNo, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("wl.LOGISTICS.KdniaoInterfaceAPI.getOrderTracesByJson", msg);
        }
        String requestData = "{'ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "'}";
        Map<String, String> params = KdniaoUtil.makeDefaultMap(requestData, tenantCode);
        if (params == null) {
            return null;
        }
        params.put("RequestType", "1002");
        String result = KdniaoUtil.sendPost(this.ReqURL, params);
        return result;
    }

    public String orderTracesSubByJson(String expCode, String expNo, String tenantCode) throws ApiException {
        String msg = this.checkMsg(expCode, expNo, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("wl.LOGISTICS.KdniaoInterfaceAPI.orderTracesSubByJson", msg);
        }
        String requestData = "{'ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "'}";
        Map<String, String> params = KdniaoUtil.makeDefaultMap(requestData, tenantCode);
        params.put("RequestType", "1008");
        String result = KdniaoUtil.sendPost(this.OrderReqURL, params);
        return result;
    }

    public String getOrderTracesByJsonWithCharge(String expCode, String expNo, String tenantCode) throws ApiException {
        String requestData;
        String msg = this.checkMsg(expCode, expNo, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("wl.LOGISTICS.KdniaoInterfaceAPI.getOrderTracesByJsonWithCharge", msg);
        }
        if ("SF".equals(expCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expressCode", expCode);
            map.put("traceBillno", expNo);
            WlTrace wlTrace = this.wlTraceService.getTraceByCode(map);
            String mobile = wlTrace.getTraceRMobile();
            mobile = mobile.substring(mobile.length() - 4);
            requestData = "{'ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "','CustomerName':'" + mobile + "'}";
        } else {
            requestData = "{'ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "'}";
        }
        Map<String, String> params = KdniaoUtil.makeDefaultMap(requestData, tenantCode);
        params.put("RequestType", "8001");
        String result = KdniaoUtil.sendPost(this.ReqURL, params);
        return result;
    }

    public String orderTracesSubByJsonWithCharge(String expCode, String expNo, String tenantCode) throws ApiException {
        String requestData;
        String msg = this.checkMsg(expCode, expNo, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("wl.LOGISTICS.KdniaoInterfaceAPI.orderTracesSubByJsonWithCharge", msg);
        }
        if ("SF".equals(expCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expressCode", expCode);
            map.put("traceBillno", expNo);
            WlTrace wlTrace = this.wlTraceService.getTraceByCode(map);
            String mobile = wlTrace.getTraceRMobile();
            mobile = mobile.substring(mobile.length() - 4);
            requestData = "{'ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "','CustomerName':'" + mobile + "'}";
        } else {
            requestData = "{'ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "'}";
        }
        Map<String, String> params = KdniaoUtil.makeDefaultMap(requestData, tenantCode);
        params.put("RequestType", "8008");
        String result = KdniaoUtil.sendPost(this.OrderReqURL, params);
        return result;
    }

    public String orderOnlineByJson(KdniaoWaybill kdniaoWaybill, String tenantCode) throws ApiException {
        String msg = this.checkWaybill(kdniaoWaybill, tenantCode);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new ApiException("wl.LOGISTICS.KdniaoInterfaceAPI.orderOnlineByJson", msg);
        }
        String requestData = JsonUtil.buildNormalBinder().toJson((Object)kdniaoWaybill);
        Map<String, String> params = KdniaoUtil.makeDefaultMap(requestData, tenantCode);
        params.put("RequestType", "1007");
        String result = KdniaoUtil.sendPost(this.OnlineReqURL, params);
        return result;
    }

    private String checkWaybill(KdniaoWaybill kdniaoWaybill, String tenantCode) {
        List<KdniaoCommodity> goodsList;
        Kdniaopeople sender;
        Kdniaopeople receiver;
        String msg = "";
        if (kdniaoWaybill == null) {
            return "\u53c2\u6570\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)tenantCode)) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a!";
        }
        if (kdniaoWaybill.getPayType() == null) {
            msg = msg + "\u90ae\u8d39\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)kdniaoWaybill.getOrderCode())) {
            kdniaoWaybill.setOrderCode(this.createUUIDString());
        }
        if (StringUtil.isBlank((String)kdniaoWaybill.getShipperCode())) {
            msg = msg + "\u5feb\u9012\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a!";
        }
        if ((receiver = kdniaoWaybill.getReceiver()) == null) {
            msg = msg + "\u6536\u4ef6\u4eba\u5bf9\u8c61\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getName())) {
            msg = msg + "\u6536\u4ef6\u4eba\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getTel()) && StringUtil.isBlank((String)receiver.getMobile())) {
            msg = msg + "\u6536\u4ef6\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getProvinceName())) {
            msg = msg + "\u6536\u4ef6\u7701\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getCityName())) {
            msg = msg + "\u6536\u4ef6\u5e02\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getAddress())) {
            msg = msg + "\u6536\u4ef6\u4eba\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a!";
        }
        if ((sender = kdniaoWaybill.getSender()) == null) {
            msg = msg + "\u53d1\u4ef6\u4eba\u4fe1\u606f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getName())) {
            msg = msg + "\u53d1\u4ef6\u4eba\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getTel()) && StringUtil.isBlank((String)receiver.getMobile())) {
            msg = msg + "\u53d1\u4ef6\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getProvinceName())) {
            msg = msg + "\u53d1\u4ef6\u7701\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getCityName())) {
            msg = msg + "\u53d1\u4ef6\u5e02\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)receiver.getAddress())) {
            msg = msg + "\u53d1\u4ef6\u4eba\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)kdniaoWaybill.getExpType())) {
            kdniaoWaybill.setExpType("1");
        }
        if ((goodsList = kdniaoWaybill.getCommodity()) == null || goodsList.isEmpty()) {
            msg = msg + "\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a";
        } else {
            for (KdniaoCommodity kdniaoCommodity : goodsList) {
                if (!StringUtil.isBlank((String)kdniaoCommodity.getGoodsName())) continue;
                msg = msg + "\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a!";
                break;
            }
        }
        return msg;
    }

    private String checkMsg(String expCode, String expNo, String tenantCode) {
        String msg = "";
        if (StringUtils.isBlank((CharSequence)expNo)) {
            msg = msg + "\u8fd0\u5355\u53f7\u4e3a\u7a7a!";
        }
        if (StringUtils.isBlank((CharSequence)expCode)) {
            msg = msg + "\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u4e3a\u7a7a!";
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a!";
        }
        return msg;
    }
}

