/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.LogisticsConstants;
import com.yqbsoft.laser.service.logistics.dao.WlExporgApiMapper;
import com.yqbsoft.laser.service.logistics.dao.WlExporgConfigMapper;
import com.yqbsoft.laser.service.logistics.dao.WlExporgExpMapper;
import com.yqbsoft.laser.service.logistics.dao.WlExporgMapper;
import com.yqbsoft.laser.service.logistics.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.logistics.domain.SgSendgoods;
import com.yqbsoft.laser.service.logistics.domain.WlExporgApiDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgApiReDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgConfigDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgConfigReDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgExpDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgExpReDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExporgReDomain;
import com.yqbsoft.laser.service.logistics.model.WlExporg;
import com.yqbsoft.laser.service.logistics.model.WlExporgApi;
import com.yqbsoft.laser.service.logistics.model.WlExporgConfig;
import com.yqbsoft.laser.service.logistics.model.WlExporgExp;
import com.yqbsoft.laser.service.logistics.service.WlExporgService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class WlExporgServiceImpl
extends BaseServiceImpl
implements WlExporgService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlExporgServiceImpl";
    private WlExporgMapper wlExporgMapper;
    private WlExporgConfigMapper wlExporgConfigMapper;
    private WlExporgExpMapper wlExporgExpMapper;
    private WlExporgApiMapper wlExporgApiMapper;

    public void setWlExporgMapper(WlExporgMapper wlExporgMapper) {
        this.wlExporgMapper = wlExporgMapper;
    }

    public void setWlExporgConfigMapper(WlExporgConfigMapper wlExporgConfigMapper) {
        this.wlExporgConfigMapper = wlExporgConfigMapper;
    }

    public void setWlExporgExpMapper(WlExporgExpMapper wlExporgExpMapper) {
        this.wlExporgExpMapper = wlExporgExpMapper;
    }

    public void setWlExporgApiMapper(WlExporgApiMapper wlExporgApiMapper) {
        this.wlExporgApiMapper = wlExporgApiMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlExporgMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkExporg(WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlExporgDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setExporgDefault(WlExporg wlExporg) {
        if (null == wlExporg) {
            return;
        }
        if (null == wlExporg.getDataState()) {
            wlExporg.setDataState(0);
        }
        if (null == wlExporg.getGmtCreate()) {
            wlExporg.setGmtCreate(this.getSysDate());
        }
        wlExporg.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlExporg.getExporgCode())) {
            wlExporg.setExporgCode(this.createUUIDString());
        }
    }

    private int getExporgMaxCode() {
        int code = 0;
        try {
            return this.wlExporgMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExporgUpdataDefault(WlExporg wlExporg) {
        if (null == wlExporg) {
            return;
        }
        wlExporg.setGmtModified(this.getSysDate());
    }

    private void saveExporgModel(WlExporg wlExporg) throws ApiException {
        if (null == wlExporg) {
            return;
        }
        try {
            this.wlExporgMapper.insert(wlExporg);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgModel.ex", (Throwable)e);
        }
    }

    private void saveExporgBatchModel(List<WlExporg> wlExporgList) throws ApiException {
        if (null == wlExporgList || wlExporgList.isEmpty()) {
            return;
        }
        try {
            this.wlExporgMapper.insertBatch(wlExporgList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgBatchModel.ex", (Throwable)e);
        }
    }

    private WlExporg getExporgModelById(Integer exporgId) {
        if (null == exporgId) {
            return null;
        }
        try {
            return this.wlExporgMapper.selectByPrimaryKey(exporgId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgModelById", (Throwable)e);
            return null;
        }
    }

    private WlExporg getExporgModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlExporgMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delExporgModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgModelByCode.num");
        }
    }

    private void deleteExporgModel(Integer exporgId) throws ApiException {
        if (null == exporgId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgMapper.deleteByPrimaryKey(exporgId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgModel.num");
        }
    }

    private void updateExporgModel(WlExporg wlExporg) throws ApiException {
        if (null == wlExporg) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgMapper.updateByPrimaryKeySelective(wlExporg);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgModel.num");
        }
    }

    private void updateStateExporgModel(Integer exporgId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == exporgId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exporgId", exporgId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgModel.null");
        }
    }

    private void updateStateExporgModelByCode(String tenantCode, String exporgCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)exporgCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgCode", exporgCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgModelByCode.null");
        }
    }

    private WlExporg makeExporg(WlExporgDomain wlExporgDomain, WlExporg wlExporg) {
        if (null == wlExporgDomain) {
            return null;
        }
        if (null == wlExporg) {
            wlExporg = new WlExporg();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlExporg, (Object)wlExporgDomain);
            return wlExporg;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeExporg", (Throwable)e);
            return null;
        }
    }

    private WlExporgReDomain makeWlExporgReDomain(WlExporg wlExporg) {
        if (null == wlExporg) {
            return null;
        }
        WlExporgReDomain wlExporgReDomain = new WlExporgReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgReDomain, (Object)wlExporg);
            return wlExporgReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeWlExporgReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlExporg> queryExporgModelPage(Map<String, Object> parammap) {
        try {
            return this.wlExporgMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExporgModel", (Throwable)e);
            return null;
        }
    }

    private int countExporg(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlExporgMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.countExporg", (Throwable)e);
        }
        return i;
    }

    private WlExporg createWlExporg(WlExporgDomain wlExporgDomain) {
        String msg = this.checkExporg(wlExporgDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporg.checkExporg", msg);
        }
        WlExporg wlExporg = this.makeExporg(wlExporgDomain, null);
        this.setExporgDefault(wlExporg);
        return wlExporg;
    }

    private String checkExporgConfig(WlExporgConfigDomain wlExporgConfigDomain) {
        if (null == wlExporgConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlExporgConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setExporgConfigDefault(WlExporgConfig wlExporgConfig) {
        if (null == wlExporgConfig) {
            return;
        }
        if (null == wlExporgConfig.getDataState()) {
            wlExporgConfig.setDataState(0);
        }
        if (null == wlExporgConfig.getGmtCreate()) {
            wlExporgConfig.setGmtCreate(this.getSysDate());
        }
        wlExporgConfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlExporgConfig.getExporgConfigCode())) {
            wlExporgConfig.setExporgConfigCode(this.createUUIDString());
        }
    }

    private int getExporgConfigMaxCode() {
        int code = 0;
        try {
            return this.wlExporgConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExporgConfigUpdataDefault(WlExporgConfig wlExporgConfig) {
        if (null == wlExporgConfig) {
            return;
        }
        wlExporgConfig.setGmtModified(this.getSysDate());
    }

    private void saveExporgConfigModel(WlExporgConfig wlExporgConfig) throws ApiException {
        if (null == wlExporgConfig) {
            return;
        }
        try {
            this.wlExporgConfigMapper.insert(wlExporgConfig);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgConfigModel.ex", (Throwable)e);
        }
    }

    private void saveExporgConfigBatchModel(List<WlExporgConfig> wlExporgConfigList) throws ApiException {
        if (null == wlExporgConfigList || wlExporgConfigList.isEmpty()) {
            return;
        }
        try {
            this.wlExporgConfigMapper.insertBatch(wlExporgConfigList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgConfigBatchModel.ex", (Throwable)e);
        }
    }

    private WlExporgConfig getExporgConfigModelById(Integer exporgConfigId) {
        if (null == exporgConfigId) {
            return null;
        }
        try {
            return this.wlExporgConfigMapper.selectByPrimaryKey(exporgConfigId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgConfigModelById", (Throwable)e);
            return null;
        }
    }

    private WlExporgConfig getExporgConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlExporgConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delExporgConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgConfigModelByCode.num");
        }
    }

    private void deleteExporgConfigModel(Integer exporgConfigId) throws ApiException {
        if (null == exporgConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgConfigMapper.deleteByPrimaryKey(exporgConfigId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgConfigModel.num");
        }
    }

    private void updateExporgConfigModel(WlExporgConfig wlExporgConfig) throws ApiException {
        if (null == wlExporgConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgConfigMapper.updateByPrimaryKeySelective(wlExporgConfig);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgConfigModel.num");
        }
    }

    private void updateStateExporgConfigModel(Integer exporgConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == exporgConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exporgConfigId", exporgConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgConfigModel.null");
        }
    }

    private void updateStateExporgConfigModelByCode(String tenantCode, String exporgConfigCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)exporgConfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgConfigCode", exporgConfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgConfigModelByCode.null");
        }
    }

    private WlExporgConfig makeExporgConfig(WlExporgConfigDomain wlExporgConfigDomain, WlExporgConfig wlExporgConfig) {
        if (null == wlExporgConfigDomain) {
            return null;
        }
        if (null == wlExporgConfig) {
            wlExporgConfig = new WlExporgConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgConfig, (Object)wlExporgConfigDomain);
            return wlExporgConfig;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeExporgConfig", (Throwable)e);
            return null;
        }
    }

    private WlExporgConfigReDomain makeWlExporgConfigReDomain(WlExporgConfig wlExporgConfig) {
        if (null == wlExporgConfig) {
            return null;
        }
        WlExporgConfigReDomain wlExporgConfigReDomain = new WlExporgConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgConfigReDomain, (Object)wlExporgConfig);
            return wlExporgConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeWlExporgConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlExporgConfig> queryExporgConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.wlExporgConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExporgConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countExporgConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlExporgConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.countExporgConfig", (Throwable)e);
        }
        return i;
    }

    private WlExporgConfig createWlExporgConfig(WlExporgConfigDomain wlExporgConfigDomain) {
        String msg = this.checkExporgConfig(wlExporgConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgConfig.checkExporgConfig", msg);
        }
        WlExporgConfig wlExporgConfig = this.makeExporgConfig(wlExporgConfigDomain, null);
        this.setExporgConfigDefault(wlExporgConfig);
        return wlExporgConfig;
    }

    private String checkExporgExp(WlExporgExpDomain wlExporgExpDomain) {
        if (null == wlExporgExpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlExporgExpDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setExporgExpDefault(WlExporgExp wlExporgExp) {
        if (null == wlExporgExp) {
            return;
        }
        if (null == wlExporgExp.getDataState()) {
            wlExporgExp.setDataState(0);
        }
        if (null == wlExporgExp.getGmtCreate()) {
            wlExporgExp.setGmtCreate(this.getSysDate());
        }
        wlExporgExp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlExporgExp.getExporgExpCode())) {
            wlExporgExp.setExporgExpCode(this.createUUIDString());
        }
    }

    private int getExporgExpMaxCode() {
        int code = 0;
        try {
            return this.wlExporgExpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgExpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExporgExpUpdataDefault(WlExporgExp wlExporgExp) {
        if (null == wlExporgExp) {
            return;
        }
        wlExporgExp.setGmtModified(this.getSysDate());
    }

    private void saveExporgExpModel(WlExporgExp wlExporgExp) throws ApiException {
        if (null == wlExporgExp) {
            return;
        }
        try {
            this.wlExporgExpMapper.insert(wlExporgExp);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgExpModel.ex", (Throwable)e);
        }
    }

    private void saveExporgExpBatchModel(List<WlExporgExp> wlExporgExpList) throws ApiException {
        if (null == wlExporgExpList || wlExporgExpList.isEmpty()) {
            return;
        }
        try {
            this.wlExporgExpMapper.insertBatch(wlExporgExpList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgExpBatchModel.ex", (Throwable)e);
        }
    }

    private WlExporgExp getExporgExpModelById(Integer exporgExpId) {
        if (null == exporgExpId) {
            return null;
        }
        try {
            return this.wlExporgExpMapper.selectByPrimaryKey(exporgExpId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgExpModelById", (Throwable)e);
            return null;
        }
    }

    private WlExporgExp getExporgExpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlExporgExpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgExpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delExporgExpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgExpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgExpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgExpModelByCode.num");
        }
    }

    private void deleteExporgExpModel(Integer exporgExpId) throws ApiException {
        if (null == exporgExpId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgExpMapper.deleteByPrimaryKey(exporgExpId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgExpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgExpModel.num");
        }
    }

    private void updateExporgExpModel(WlExporgExp wlExporgExp) throws ApiException {
        if (null == wlExporgExp) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgExpMapper.updateByPrimaryKeySelective(wlExporgExp);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgExpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgExpModel.num");
        }
    }

    private void updateStateExporgExpModel(Integer exporgExpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == exporgExpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exporgExpId", exporgExpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgExpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgExpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgExpModel.null");
        }
    }

    private void updateStateExporgExpModelByCode(String tenantCode, String exporgExpCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)exporgExpCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgExpCode", exporgExpCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgExpMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgExpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgExpModelByCode.null");
        }
    }

    private WlExporgExp makeExporgExp(WlExporgExpDomain wlExporgExpDomain, WlExporgExp wlExporgExp) {
        if (null == wlExporgExpDomain) {
            return null;
        }
        if (null == wlExporgExp) {
            wlExporgExp = new WlExporgExp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgExp, (Object)wlExporgExpDomain);
            return wlExporgExp;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeExporgExp", (Throwable)e);
            return null;
        }
    }

    private WlExporgExpReDomain makeWlExporgExpReDomain(WlExporgExp wlExporgExp) {
        if (null == wlExporgExp) {
            return null;
        }
        WlExporgExpReDomain wlExporgExpReDomain = new WlExporgExpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgExpReDomain, (Object)wlExporgExp);
            return wlExporgExpReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeWlExporgExpReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlExporgExp> queryExporgExpModelPage(Map<String, Object> parammap) {
        try {
            return this.wlExporgExpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExporgExpModel", (Throwable)e);
            return null;
        }
    }

    private int countExporgExp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlExporgExpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.countExporgExp", (Throwable)e);
        }
        return i;
    }

    private WlExporgExp createWlExporgExp(WlExporgExpDomain wlExporgExpDomain) {
        String msg = this.checkExporgExp(wlExporgExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgExp.checkExporgExp", msg);
        }
        WlExporgExp wlExporgExp = this.makeExporgExp(wlExporgExpDomain, null);
        this.setExporgExpDefault(wlExporgExp);
        return wlExporgExp;
    }

    private String checkExporgApi(WlExporgApiDomain wlExporgApiDomain) {
        if (null == wlExporgApiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlExporgApiDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setExporgApiDefault(WlExporgApi wlExporgApi) {
        if (null == wlExporgApi) {
            return;
        }
        if (null == wlExporgApi.getDataState()) {
            wlExporgApi.setDataState(0);
        }
        if (null == wlExporgApi.getGmtCreate()) {
            wlExporgApi.setGmtCreate(this.getSysDate());
        }
        wlExporgApi.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlExporgApi.getExporgApiCode())) {
            wlExporgApi.setExporgApiCode(this.createUUIDString());
        }
    }

    private int getExporgApiMaxCode() {
        int code = 0;
        try {
            return this.wlExporgApiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgApiMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExporgApiUpdataDefault(WlExporgApi wlExporgApi) {
        if (null == wlExporgApi) {
            return;
        }
        wlExporgApi.setGmtModified(this.getSysDate());
    }

    private void saveExporgApiModel(WlExporgApi wlExporgApi) throws ApiException {
        if (null == wlExporgApi) {
            return;
        }
        try {
            this.wlExporgApiMapper.insert(wlExporgApi);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgApiModel.ex", (Throwable)e);
        }
    }

    private void saveExporgApiBatchModel(List<WlExporgApi> wlExporgApiList) throws ApiException {
        if (null == wlExporgApiList || wlExporgApiList.isEmpty()) {
            return;
        }
        try {
            this.wlExporgApiMapper.insertBatch(wlExporgApiList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgApiBatchModel.ex", (Throwable)e);
        }
    }

    private WlExporgApi getExporgApiModelById(Integer exporgApiId) {
        if (null == exporgApiId) {
            return null;
        }
        try {
            return this.wlExporgApiMapper.selectByPrimaryKey(exporgApiId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgApiModelById", (Throwable)e);
            return null;
        }
    }

    private WlExporgApi getExporgApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlExporgApiMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.getExporgApiModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delExporgApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgApiMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgApiModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.delExporgApiModelByCode.num");
        }
    }

    private void deleteExporgApiModel(Integer exporgApiId) throws ApiException {
        if (null == exporgApiId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgApiMapper.deleteByPrimaryKey(exporgApiId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.deleteExporgApiModel.num");
        }
    }

    private void updateExporgApiModel(WlExporgApi wlExporgApi) throws ApiException {
        if (null == wlExporgApi) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExporgApiMapper.updateByPrimaryKeySelective(wlExporgApi);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgApiModel.num");
        }
    }

    private void updateStateExporgApiModel(Integer exporgApiId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == exporgApiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exporgApiId", exporgApiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgApiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgApiModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgApiModel.null");
        }
    }

    private void updateStateExporgApiModelByCode(String tenantCode, String exporgApiCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)exporgApiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgApiCode", exporgApiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExporgApiMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgApiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateStateExporgApiModelByCode.null");
        }
    }

    private WlExporgApi makeExporgApi(WlExporgApiDomain wlExporgApiDomain, WlExporgApi wlExporgApi) {
        if (null == wlExporgApiDomain) {
            return null;
        }
        if (null == wlExporgApi) {
            wlExporgApi = new WlExporgApi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgApi, (Object)wlExporgApiDomain);
            return wlExporgApi;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeExporgApi", (Throwable)e);
            return null;
        }
    }

    private WlExporgApiReDomain makeWlExporgApiReDomain(WlExporgApi wlExporgApi) {
        if (null == wlExporgApi) {
            return null;
        }
        WlExporgApiReDomain wlExporgApiReDomain = new WlExporgApiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgApiReDomain, (Object)wlExporgApi);
            return wlExporgApiReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeWlExporgApiReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlExporgApi> queryExporgApiModelPage(Map<String, Object> parammap) {
        try {
            return this.wlExporgApiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExporgApiModel", (Throwable)e);
            return null;
        }
    }

    private int countExporgApi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlExporgApiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.countExporgApi", (Throwable)e);
        }
        return i;
    }

    private WlExporgApi createWlExporgApi(WlExporgApiDomain wlExporgApiDomain) {
        String msg = this.checkExporgApi(wlExporgApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.saveExporgApi.checkExporgApi", msg);
        }
        WlExporgApi wlExporgApi = this.makeExporgApi(wlExporgApiDomain, null);
        this.setExporgApiDefault(wlExporgApi);
        return wlExporgApi;
    }

    @Override
    public String saveExporg(WlExporgDomain wlExporgDomain) throws ApiException {
        WlExporg wlExporg = this.createWlExporg(wlExporgDomain);
        this.saveExporgModel(wlExporg);
        return wlExporg.getExporgCode();
    }

    @Override
    public String saveExporgBatch(List<WlExporgDomain> wlExporgDomainList) throws ApiException {
        if (null == wlExporgDomainList || wlExporgDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlExporg> wlExporgList = new ArrayList<WlExporg>();
        String code = "";
        for (WlExporgDomain wlExporgDomain : wlExporgDomainList) {
            WlExporg wlExporg = this.createWlExporg(wlExporgDomain);
            code = wlExporg.getExporgCode();
            wlExporgList.add(wlExporg);
        }
        this.saveExporgBatchModel(wlExporgList);
        return code;
    }

    @Override
    public void updateExporgState(Integer exporgId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgModel(exporgId, dataState, oldDataState);
    }

    @Override
    public void updateExporgStateByCode(String tenantCode, String exporgCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgModelByCode(tenantCode, exporgCode, dataState, oldDataState);
    }

    @Override
    public void updateExporg(WlExporgDomain wlExporgDomain) throws ApiException {
        String msg = this.checkExporg(wlExporgDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporg.checkExporg", msg);
        }
        WlExporg oldWlExporg = this.getExporgModelById(wlExporgDomain.getExporgId());
        if (null == oldWlExporg) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporg.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlExporg wlExporg = this.makeExporg(wlExporgDomain, oldWlExporg);
        this.setExporgUpdataDefault(wlExporg);
        this.updateExporgModel(wlExporg);
    }

    @Override
    public WlExporg getExporg(Integer exporgId) {
        return this.getExporgModelById(exporgId);
    }

    @Override
    public void deleteExporg(Integer exporgId) throws ApiException {
        this.deleteExporgModel(exporgId);
    }

    @Override
    public QueryResult<WlExporg> queryExporgPage(Map<String, Object> map) {
        List<WlExporg> wlExporgList = this.queryExporgModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExporg(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlExporgList);
        return queryResult;
    }

    @Override
    public WlExporg getExporgByCode(String tenantCode, String exporgCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgCode", exporgCode);
        return this.getExporgModelByCode(map);
    }

    @Override
    public void deleteExporgByCode(String tenantCode, String exporgCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgCode", exporgCode);
        this.delExporgModelByCode(map);
    }

    @Override
    public String saveExporgConfig(WlExporgConfigDomain wlExporgConfigDomain) throws ApiException {
        WlExporgConfig wlExporgConfig = this.createWlExporgConfig(wlExporgConfigDomain);
        this.saveExporgConfigModel(wlExporgConfig);
        return wlExporgConfig.getExporgConfigCode();
    }

    @Override
    public String saveExporgConfigBatch(List<WlExporgConfigDomain> wlExporgConfigDomainList) throws ApiException {
        if (null == wlExporgConfigDomainList || wlExporgConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlExporgConfig> wlExporgConfigList = new ArrayList<WlExporgConfig>();
        String code = "";
        for (WlExporgConfigDomain wlExporgConfigDomain : wlExporgConfigDomainList) {
            WlExporgConfig wlExporgConfig = this.createWlExporgConfig(wlExporgConfigDomain);
            code = wlExporgConfig.getExporgConfigCode();
            wlExporgConfigList.add(wlExporgConfig);
        }
        this.saveExporgConfigBatchModel(wlExporgConfigList);
        return code;
    }

    @Override
    public void updateExporgConfigState(Integer exporgConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgConfigModel(exporgConfigId, dataState, oldDataState);
    }

    @Override
    public void updateExporgConfigStateByCode(String tenantCode, String exporgConfigCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgConfigModelByCode(tenantCode, exporgConfigCode, dataState, oldDataState);
    }

    @Override
    public void updateExporgConfig(WlExporgConfigDomain wlExporgConfigDomain) throws ApiException {
        String msg = this.checkExporgConfig(wlExporgConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgConfig.checkExporgConfig", msg);
        }
        WlExporgConfig oldWlExporgConfig = this.getExporgConfigModelById(wlExporgConfigDomain.getExporgConfigId());
        if (null == oldWlExporgConfig) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlExporgConfig wlExporgConfig = this.makeExporgConfig(wlExporgConfigDomain, oldWlExporgConfig);
        this.setExporgConfigUpdataDefault(wlExporgConfig);
        this.updateExporgConfigModel(wlExporgConfig);
    }

    @Override
    public WlExporgConfig getExporgConfig(Integer exporgConfigId) {
        return this.getExporgConfigModelById(exporgConfigId);
    }

    @Override
    public void deleteExporgConfig(Integer exporgConfigId) throws ApiException {
        this.deleteExporgConfigModel(exporgConfigId);
    }

    @Override
    public QueryResult<WlExporgConfig> queryExporgConfigPage(Map<String, Object> map) {
        List<WlExporgConfig> wlExporgConfigList = this.queryExporgConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExporgConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlExporgConfigList);
        return queryResult;
    }

    @Override
    public WlExporgConfig getExporgConfigByCode(String tenantCode, String exporgConfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgConfigCode", exporgConfigCode);
        return this.getExporgConfigModelByCode(map);
    }

    @Override
    public void deleteExporgConfigByCode(String tenantCode, String exporgConfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgConfigCode", exporgConfigCode);
        this.delExporgConfigModelByCode(map);
    }

    @Override
    public String saveExporgExp(WlExporgExpDomain wlExporgExpDomain) throws ApiException {
        WlExporgExp wlExporgExp = this.createWlExporgExp(wlExporgExpDomain);
        this.saveExporgExpModel(wlExporgExp);
        return wlExporgExp.getExporgExpCode();
    }

    @Override
    public String saveExporgExpBatch(List<WlExporgExpDomain> wlExporgExpDomainList) throws ApiException {
        if (null == wlExporgExpDomainList || wlExporgExpDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlExporgExp> wlExporgExpList = new ArrayList<WlExporgExp>();
        String code = "";
        for (WlExporgExpDomain wlExporgExpDomain : wlExporgExpDomainList) {
            WlExporgExp wlExporgExp = this.createWlExporgExp(wlExporgExpDomain);
            code = wlExporgExp.getExporgExpCode();
            wlExporgExpList.add(wlExporgExp);
        }
        this.saveExporgExpBatchModel(wlExporgExpList);
        return code;
    }

    @Override
    public void updateExporgExpState(Integer exporgExpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgExpModel(exporgExpId, dataState, oldDataState);
    }

    @Override
    public void updateExporgExpStateByCode(String tenantCode, String exporgExpCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgExpModelByCode(tenantCode, exporgExpCode, dataState, oldDataState);
    }

    @Override
    public void updateExporgExp(WlExporgExpDomain wlExporgExpDomain) throws ApiException {
        String msg = this.checkExporgExp(wlExporgExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgExp.checkExporgExp", msg);
        }
        WlExporgExp oldWlExporgExp = this.getExporgExpModelById(wlExporgExpDomain.getExporgExpId());
        if (null == oldWlExporgExp) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgExp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlExporgExp wlExporgExp = this.makeExporgExp(wlExporgExpDomain, oldWlExporgExp);
        this.setExporgExpUpdataDefault(wlExporgExp);
        this.updateExporgExpModel(wlExporgExp);
    }

    @Override
    public WlExporgExp getExporgExp(Integer exporgExpId) {
        return this.getExporgExpModelById(exporgExpId);
    }

    @Override
    public void deleteExporgExp(Integer exporgExpId) throws ApiException {
        this.deleteExporgExpModel(exporgExpId);
    }

    @Override
    public QueryResult<WlExporgExp> queryExporgExpPage(Map<String, Object> map) {
        List<WlExporgExp> wlExporgExpList = this.queryExporgExpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExporgExp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlExporgExpList);
        return queryResult;
    }

    @Override
    public WlExporgExp getExporgExpByCode(String tenantCode, String exporgExpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgExpCode", exporgExpCode);
        return this.getExporgExpModelByCode(map);
    }

    @Override
    public void deleteExporgExpByCode(String tenantCode, String exporgExpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgExpCode", exporgExpCode);
        this.delExporgExpModelByCode(map);
    }

    @Override
    public String saveExporgApi(WlExporgApiDomain wlExporgApiDomain) throws ApiException {
        WlExporgApi wlExporgApi = this.createWlExporgApi(wlExporgApiDomain);
        this.saveExporgApiModel(wlExporgApi);
        return wlExporgApi.getExporgApiCode();
    }

    @Override
    public String saveExporgApiBatch(List<WlExporgApiDomain> wlExporgApiDomainList) throws ApiException {
        if (null == wlExporgApiDomainList || wlExporgApiDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlExporgApi> wlExporgApiList = new ArrayList<WlExporgApi>();
        String code = "";
        for (WlExporgApiDomain wlExporgApiDomain : wlExporgApiDomainList) {
            WlExporgApi wlExporgApi = this.createWlExporgApi(wlExporgApiDomain);
            code = wlExporgApi.getExporgApiCode();
            wlExporgApiList.add(wlExporgApi);
        }
        this.saveExporgApiBatchModel(wlExporgApiList);
        return code;
    }

    @Override
    public void updateExporgApiState(Integer exporgApiId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgApiModel(exporgApiId, dataState, oldDataState);
    }

    @Override
    public void updateExporgApiStateByCode(String tenantCode, String exporgApiCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExporgApiModelByCode(tenantCode, exporgApiCode, dataState, oldDataState);
    }

    @Override
    public void updateExporgApi(WlExporgApiDomain wlExporgApiDomain) throws ApiException {
        String msg = this.checkExporgApi(wlExporgApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgApi.checkExporgApi", msg);
        }
        WlExporgApi oldWlExporgApi = this.getExporgApiModelById(wlExporgApiDomain.getExporgApiId());
        if (null == oldWlExporgApi) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.updateExporgApi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlExporgApi wlExporgApi = this.makeExporgApi(wlExporgApiDomain, oldWlExporgApi);
        this.setExporgApiUpdataDefault(wlExporgApi);
        this.updateExporgApiModel(wlExporgApi);
    }

    @Override
    public WlExporgApi getExporgApi(Integer exporgApiId) {
        return this.getExporgApiModelById(exporgApiId);
    }

    @Override
    public void deleteExporgApi(Integer exporgApiId) throws ApiException {
        this.deleteExporgApiModel(exporgApiId);
    }

    @Override
    public QueryResult<WlExporgApi> queryExporgApiPage(Map<String, Object> map) {
        List<WlExporgApi> wlExporgApiList = this.queryExporgApiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExporgApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlExporgApiList);
        return queryResult;
    }

    @Override
    public WlExporgApi getExporgApiByCode(String tenantCode, String exporgApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgApiCode", exporgApiCode);
        return this.getExporgApiModelByCode(map);
    }

    @Override
    public void deleteExporgApiByCode(String tenantCode, String exporgApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exporgApiCode", exporgApiCode);
        this.delExporgApiModelByCode(map);
    }

    @Override
    public void loadExporg() {
        this.logger.info("wl.LOGISTICS.WlExporgServiceImpl.loadExporg.start", (Object)"=======\u8c03\u5ea6start=======");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<WlExporg> wlExporgList = this.queryExporgModelPage(parammap);
        String cachekey = "WlExporg-all";
        String mpkey = "WlExporg-mp";
        if (null == wlExporgList || wlExporgList.isEmpty()) {
            DisUtil.del((String)mpkey);
            DisUtil.del((String)cachekey);
            this.logger.info("wl.LOGISTICS.WlExporgServiceImpl.loadExporg.del.end", (Object)"=======\u8c03\u5ea6del-end=======");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, List<String>> mapmp = new HashMap<String, List<String>>();
        String mapkey = "";
        for (WlExporg wlExporg : wlExporgList) {
            mapkey = wlExporg.getExporgCode() + "-" + wlExporg.getTenantCode();
            WlExporgReDomain wlExporgReDomain = this.makeWlExporgDomain(wlExporg, mapmp);
            map.put(mapkey, JsonUtil.buildNormalBinder().toJson((Object)wlExporgReDomain));
        }
        HashMap<String, String> macachepmp = new HashMap<String, String>();
        for (String key : mapmp.keySet()) {
            macachepmp.put(key, JsonUtil.buildNormalBinder().toJson(mapmp.get(key)));
        }
        DisUtil.setMapVer((String)mpkey, macachepmp);
        DisUtil.setMapVer((String)cachekey, map);
        this.logger.info("wl.LOGISTICS.WlExporgServiceImpl.loadExporg.end", (Object)"=======\u8c03\u5ea6end=======");
    }

    private WlExporgReDomain makeWlExporgDomain(WlExporg wlExporg, Map<String, List<String>> mapmp) {
        if (null == wlExporg || null == mapmp) {
            return null;
        }
        WlExporgReDomain wlExporgReDomain = new WlExporgReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExporgReDomain, (Object)wlExporg);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeWlExporgDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("exporgCode", wlExporg.getExporgCode());
        parammap.put("tenantCode", wlExporg.getTenantCode());
        wlExporgReDomain.setApiMap(this.makeApi(parammap));
        wlExporgReDomain.setConfigMap(this.makeConfig(parammap));
        wlExporgReDomain.setExpMap(this.makeExp(parammap));
        return wlExporgReDomain;
    }

    private Map<String, WlExporgExp> makeExp(Map<String, Object> parammap) {
        List<WlExporgExp> list = this.queryExporgExpModelPage(parammap);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeExp.parammap", parammap);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, WlExporgExp> expMap = new HashMap<String, WlExporgExp>();
        for (WlExporgExp wlExporgExp : list) {
            expMap.put(wlExporgExp.getExpressCode(), wlExporgExp);
        }
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.makeExp.expMap", expMap);
        return expMap;
    }

    private Map<String, WlExporgConfig> makeConfig(Map<String, Object> parammap) {
        List<WlExporgConfig> list = this.queryExporgConfigModelPage(parammap);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, WlExporgConfig> configMap = new HashMap<String, WlExporgConfig>();
        for (WlExporgConfig wlExporgConfig : list) {
            configMap.put(wlExporgConfig.getExporgConfigKey(), wlExporgConfig);
        }
        return configMap;
    }

    private Map<String, WlExporgApi> makeApi(Map<String, Object> parammap) {
        List<WlExporgApi> list = this.queryExporgApiModelPage(parammap);
        if (null == list || list.isEmpty()) {
            return null;
        }
        HashMap<String, WlExporgApi> apiMap = new HashMap<String, WlExporgApi>();
        for (WlExporgApi wlExporgApi : list) {
            apiMap.put(wlExporgApi.getExporgApiApitype(), wlExporgApi);
        }
        return apiMap;
    }

    @Override
    public String queryExpInfo(String expressCode, String traceCode, String tenantCode) throws ApiException {
        return this.queryExpInfoByPhone(expressCode, traceCode, tenantCode, null);
    }

    @Override
    public String queryExpInfoByPhone(String expressCode, String traceCode, String tenantCode, String phone) throws ApiException {
        WlExporgReDomain wlExporg;
        Map<String, WlExporgExp> expMap;
        String cachekey = "WlExporg-all";
        String keyDomain = "WlExpress-domain";
        String domainkey = expressCode + "-" + tenantCode;
        String apiCode = DisUtil.getRemotMap((String)keyDomain, (String)domainkey);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExpInfo.apiCode", (Object)apiCode);
        if (StringUtils.isBlank((String)apiCode)) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.apiCode", (Object)apiCode);
            return "\u5f53\u524d\u5feb\u9012\u4ee3\u7801\u4e0d\u5b58\u5728";
        }
        Map map = DisUtil.getRemotMapAll((String)cachekey);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExpInfo.map", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
        String key = apiCode + "-" + tenantCode;
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExpInfo.key", (Object)key);
        String sfd = (String)map.get(key);
        if (StringUtils.isBlank((String)sfd)) {
            key = apiCode + "-" + "00000000";
            sfd = (String)map.get(key);
        }
        if (null == (expMap = (wlExporg = (WlExporgReDomain)JsonUtil.buildNormalBinder().getJsonToObject(sfd, WlExporgReDomain.class)).getExpMap()) || expMap.isEmpty()) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.expMap", (Object)(apiCode + ":" + key));
            return null;
        }
        WlExporgExp wlExporgExp = expMap.get(expressCode);
        if (null == wlExporgExp) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.null", "\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u9519\u8bef");
        }
        String exporgExpCode = wlExporgExp.getExporgExpMpcode();
        if (StringUtils.isBlank((String)exporgExpCode)) {
            exporgExpCode = wlExporgExp.getExporgExpCode();
        }
        Map<String, WlExporgConfig> configMap = wlExporg.getConfigMap();
        WlExporgConfig idConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_EBUSINESSID);
        String idVaule = idConfig.getExporgConfigVaule();
        Map<String, WlExporgApi> apiMap = wlExporg.getApiMap();
        WlExporgApi wlExporgApi = apiMap.get(LogisticsConstants.EXPORG_API_APITYPE_QUERY);
        String exporgApiApicode = wlExporgApi.getExporgApiApicode();
        WlExporgConfig AppKeyConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_APPKEY);
        String appKeyVaule = AppKeyConfig.getExporgConfigVaule();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String expressinfo = "";
        paramMap.put("expCode", exporgExpCode);
        paramMap.put("expNo", traceCode);
        paramMap.put("EBusinessID", idVaule);
        paramMap.put("AppKey", appKeyVaule);
        if (exporgApiApicode.equals("kuaidi100.kuaidi100.adapter.queryExpressInfo")) {
            HashedMap pas = new HashedMap();
            HashedMap parMap = new HashedMap();
            parMap.put("com", exporgExpCode);
            parMap.put("num", traceCode);
            if (StringUtils.isNotBlank((String)phone)) {
                parMap.put("phone", phone);
            }
            String param = JsonUtil.buildNonDefaultBinder().toJson((Object)parMap);
            String sign = param + appKeyVaule + idVaule;
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.sign", (Object)sign);
            pas.put("customer", idVaule);
            pas.put("sign", MD5Util.generate32md5((String)sign).toUpperCase());
            pas.put("param", param);
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.pas", (Object)JsonUtil.buildNormalBinder().toJson((Object)pas));
            try {
                expressinfo = WebUtils.doPost((String)"https://poll.kuaidi100.com/poll/query.do", (Map)pas, (int)1000, (int)10000);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return expressinfo;
        }
        expressinfo = (String)this.getInternalRouter().inInvoke(exporgApiApicode, "1.0", "0", paramMap);
        return expressinfo;
    }

    @Override
    public String queryExpInfoByPhoneToMap(String expressCode, String traceCode, String tenantCode, String phone, String fromArrdess, String toArrdess) throws ApiException {
        WlExporgReDomain wlExporg;
        Map<String, WlExporgExp> expMap;
        String cachekey = "WlExporg-all";
        String keyDomain = "WlExpress-domain";
        String domainkey = expressCode + "-" + tenantCode;
        String apiCode = DisUtil.getRemotMap((String)keyDomain, (String)domainkey);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExpInfo.apiCode", (Object)apiCode);
        if (StringUtils.isBlank((String)apiCode)) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.apiCode", (Object)apiCode);
            return "\u5f53\u524d\u5feb\u9012\u4ee3\u7801\u4e0d\u5b58\u5728";
        }
        Map map = DisUtil.getRemotMapAll((String)cachekey);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExpInfo.map", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
        String key = apiCode + "-" + tenantCode;
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.queryExpInfo.key", (Object)key);
        String sfd = (String)map.get(key);
        if (StringUtils.isBlank((String)sfd)) {
            key = apiCode + "-" + "00000000";
            sfd = (String)map.get(key);
        }
        if (null == (expMap = (wlExporg = (WlExporgReDomain)JsonUtil.buildNormalBinder().getJsonToObject(sfd, WlExporgReDomain.class)).getExpMap()) || expMap.isEmpty()) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.expMap", (Object)(apiCode + ":" + key));
            return null;
        }
        WlExporgExp wlExporgExp = expMap.get(expressCode);
        if (null == wlExporgExp) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.null", "\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u9519\u8bef");
        }
        String exporgExpCode = wlExporgExp.getExporgExpMpcode();
        if (StringUtils.isBlank((String)exporgExpCode)) {
            exporgExpCode = wlExporgExp.getExporgExpCode();
        }
        Map<String, WlExporgConfig> configMap = wlExporg.getConfigMap();
        WlExporgConfig idConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_EBUSINESSID);
        String idVaule = idConfig.getExporgConfigVaule();
        Map<String, WlExporgApi> apiMap = wlExporg.getApiMap();
        WlExporgApi wlExporgApi = apiMap.get(LogisticsConstants.EXPORG_API_APITYPE_QUERY);
        String exporgApiApicode = wlExporgApi.getExporgApiApicode();
        WlExporgConfig AppKeyConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_APPKEY);
        String appKeyVaule = AppKeyConfig.getExporgConfigVaule();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String expressinfo = "";
        paramMap.put("expCode", exporgExpCode);
        paramMap.put("expNo", traceCode);
        paramMap.put("EBusinessID", idVaule);
        paramMap.put("AppKey", appKeyVaule);
        if (exporgApiApicode.equals("kuaidi100.kuaidi100.adapter.queryExpressInfo")) {
            HashedMap pas = new HashedMap();
            HashedMap parMap = new HashedMap();
            parMap.put("com", exporgExpCode);
            parMap.put("num", traceCode);
            parMap.put("from", fromArrdess);
            parMap.put("to", toArrdess);
            if (StringUtils.isNotBlank((String)phone)) {
                parMap.put("phone", phone);
            }
            String param = JsonUtil.buildNonDefaultBinder().toJson((Object)parMap);
            String sign = param + appKeyVaule + idVaule;
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.sign", (Object)sign);
            pas.put("customer", idVaule);
            pas.put("sign", MD5Util.generate32md5((String)sign).toUpperCase());
            pas.put("param", param);
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.insertExpInfo.pas", (Object)JsonUtil.buildNormalBinder().toJson((Object)pas));
            try {
                expressinfo = WebUtils.doPost((String)"https://poll.kuaidi100.com/poll/maptrack.do", (Map)pas, (int)1000, (int)10000);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return expressinfo;
        }
        expressinfo = (String)this.getInternalRouter().inInvoke(exporgApiApicode, "1.0", "0", paramMap);
        return expressinfo;
    }

    @Override
    public String subscriptionlogisticsInfo(String expressCode, String traceCode, String tenantCode, String phone) throws ApiException {
        WlExporgReDomain wlExporg;
        Map<String, WlExporgExp> expMap;
        String cachekey = "WlExporg-all";
        String keyDomain = "WlExpress-domain";
        String domainkey = expressCode + "-" + tenantCode;
        String apiCode = DisUtil.getRemotMap((String)keyDomain, (String)domainkey);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.apiCode", (Object)apiCode);
        if (StringUtils.isBlank((String)apiCode)) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.apiCode", (Object)apiCode);
            return "\u5f53\u524d\u5feb\u9012\u4ee3\u7801\u4e0d\u5b58\u5728";
        }
        Map map = DisUtil.getRemotMapAll((String)cachekey);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.map", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
        String key = apiCode + "-" + tenantCode;
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.key", (Object)key);
        String sfd = (String)map.get(key);
        if (StringUtils.isBlank((String)sfd)) {
            key = apiCode + "-" + "00000000";
            sfd = (String)map.get(key);
        }
        if (null == (expMap = (wlExporg = (WlExporgReDomain)JsonUtil.buildNormalBinder().getJsonToObject(sfd, WlExporgReDomain.class)).getExpMap()) || expMap.isEmpty()) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.expMap", (Object)(apiCode + ":" + key));
            return null;
        }
        WlExporgExp wlExporgExp = expMap.get(expressCode);
        if (null == wlExporgExp) {
            throw new ApiException("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.null", "\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u9519\u8bef");
        }
        String exporgExpCode = wlExporgExp.getExporgExpMpcode();
        if (StringUtils.isBlank((String)exporgExpCode)) {
            exporgExpCode = wlExporgExp.getExporgExpCode();
        }
        Map<String, WlExporgConfig> configMap = wlExporg.getConfigMap();
        WlExporgConfig idConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_EBUSINESSID);
        String idVaule = idConfig.getExporgConfigVaule();
        Map<String, WlExporgApi> apiMap = wlExporg.getApiMap();
        WlExporgApi wlExporgApi = apiMap.get(LogisticsConstants.EXPORG_API_APITYPE_QUERY);
        String exporgApiApicode = wlExporgApi.getExporgApiApicode();
        WlExporgConfig AppKeyConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_APPKEY);
        String appKeyVaule = AppKeyConfig.getExporgConfigVaule();
        WlExporgConfig callbackurlConfig = configMap.get(LogisticsConstants.EXPORG_CONFIG_KEY_CALLBACKURL);
        String callbackurl = callbackurlConfig.getExporgConfigVaule();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String expressinfo = "";
        paramMap.put("expCode", exporgExpCode);
        paramMap.put("expNo", traceCode);
        paramMap.put("EBusinessID", idVaule);
        paramMap.put("AppKey", appKeyVaule);
        if ("kuaidi100.kuaidi100.adapter.queryExpressInfo".equals(exporgApiApicode)) {
            HashedMap pas = new HashedMap();
            HashedMap parMap = new HashedMap();
            HashedMap parameterMap = new HashedMap();
            parMap.put("company", exporgExpCode);
            parMap.put("number", traceCode);
            parMap.put("key", appKeyVaule);
            if (StringUtils.isNotBlank((String)phone)) {
                parameterMap.put("phone", phone);
            }
            parameterMap.put("callbackurl", callbackurl);
            parameterMap.put("resultv2", "4");
            parMap.put("parameters", parameterMap);
            String param = JsonUtil.buildNormalBinder().toJson((Object)parMap);
            pas.put("param", param);
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.pas", (Object)JsonUtil.buildNormalBinder().toJson((Object)pas));
            try {
                expressinfo = WebUtils.doPost((String)"https://poll.kuaidi100.com/poll", (Map)pas, (int)1000, (int)10000);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.expressinfo", (Object)expressinfo);
            return expressinfo;
        }
        expressinfo = (String)this.getInternalRouter().inInvoke(exporgApiApicode, "1.0", "0", paramMap);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.subscriptionlogisticsInfo.expressinfo", (Object)expressinfo);
        return expressinfo;
    }

    @Override
    public String receivelogisticsInfo(String sign, String param, String tenantCode) throws ApiException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)param)) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.receivelogisticsInfo \u53c2\u6570\u4e3a\u7a7a", (Object)param);
            resultMap.put("result", false);
            resultMap.put("returnCode", "500");
            resultMap.put("message", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)param);
        JSONObject lastResult = jsonObject.getJSONObject("lastResult");
        String state = lastResult.getString("state");
        if (!("1".equals(state) || "0".equals(state) || "5".equals(state) || "3".equals(state))) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.receivelogisticsInfo \u4e0d\u63a8\u9001", (Object)state);
            return this.makeResultJson(resultMap);
        }
        JSONArray dataList = lastResult.getJSONArray("data");
        JSONObject data = (JSONObject)dataList.get(0);
        String nu = lastResult.getString("nu");
        String com = lastResult.getString("com");
        String context = data.getString("context");
        String status = data.getString("status");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> pmap1 = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("packageMode", com);
        paramMap.put("packageBillno", nu);
        pmap1.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String sendGoodsStr = (String)BaseAuth.internalRouter.inInvoke("sg.sendgoods.querySendgoodsPage", "1.0", "0", pmap1);
        QueryResult sendGoodsQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(sendGoodsStr, QueryResult.class);
        if (sendGoodsQuery == null) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.receivelogisticsInfo.sendGoodsQuery is null", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return this.makeResultJson(resultMap);
        }
        List sendGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)sendGoodsQuery.getList()), SgSendgoods.class);
        if (ListUtil.isEmpty((Collection)sendGoodsList)) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.receivelogisticsInfo.sendGoodsList is null", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            return this.makeResultJson(resultMap);
        }
        SgSendgoods sgSendgoods = (SgSendgoods)sendGoodsList.get(0);
        this.sendWxMns(nu, state, status, sgSendgoods);
        return this.makeResultJson(resultMap);
    }

    private String makeResultJson(Map<String, Object> resultMap) {
        resultMap.put("result", true);
        resultMap.put("returnCode", "200");
        resultMap.put("message", "\u6210\u529f");
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    private void sendWxMns(String nu, String state, String status, SgSendgoods sgSendgoods) {
        if (StringUtils.isBlank((String)nu) || StringUtils.isBlank((String)state) || StringUtils.isBlank((String)status) || sgSendgoods == null) {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.sendWxMns.param is null", (Object)(nu + "-" + state + "-" + status + "-" + sgSendgoods));
            return;
        }
        String packageName = sgSendgoods.getPackageName();
        String contractBillcode = sgSendgoods.getContractBillcode();
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        String p = "";
        if ("02333".equals(sgSendgoods.getAppmanageIcode())) {
            p = "1";
        } else if ("032".equals(sgSendgoods.getAppmanageIcode())) {
            p = "0";
        } else {
            this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.sendWxMns.\u4e0d\u662f\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u4e0d\u901a\u77e5", (Object)sgSendgoods.getAppmanageIcode());
            return;
        }
        mnsMnslistDomainBean.setMnslistBustype("wl" + p + "0" + state);
        mnsMnslistDomainBean.setMnslistBusname("\u7269\u6d41\u4fe1\u606f");
        mnsMnslistDomainBean.setMemberCode(sgSendgoods.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(sgSendgoods.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(sgSendgoods.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("proappCode", sgSendgoods.getAppmanageIcode());
        listReceiver.put("code", sgSendgoods.getMemberBcode());
        listReceiver.put("name", sgSendgoods.getMemberBname());
        listReceiver.put("number", nu);
        listReceiver.put("comName", packageName);
        listReceiver.put("orderCode", contractBillcode);
        listReceiver.put("status", status);
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.sendWxMns.mnsMnslistDomainBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        HashMap<String, String> paramsend = new HashMap<String, String>();
        paramsend.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        String s = this.internalInvoke("mns.ser.sendMnslist", paramsend);
        this.logger.error("wl.LOGISTICS.WlExporgServiceImpl.sendWxMns.s", (Object)JsonUtil.buildNormalBinder().toJson((Object)s));
    }
}

