/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.memberprice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.memberprice.MpMpriceConstants;
import com.yqbsoft.laser.service.memberprice.dao.MpMpriceConfMapper;
import com.yqbsoft.laser.service.memberprice.dao.MpMpriceMapper;
import com.yqbsoft.laser.service.memberprice.dao.MpMpriceMemMapper;
import com.yqbsoft.laser.service.memberprice.domain.MpMpriceConfDomain;
import com.yqbsoft.laser.service.memberprice.domain.MpMpriceConfReDomain;
import com.yqbsoft.laser.service.memberprice.domain.MpMpriceDomain;
import com.yqbsoft.laser.service.memberprice.domain.MpMpriceMemDomain;
import com.yqbsoft.laser.service.memberprice.domain.MpMpriceMemReDomain;
import com.yqbsoft.laser.service.memberprice.domain.MpMpriceReDomain;
import com.yqbsoft.laser.service.memberprice.model.MpMprice;
import com.yqbsoft.laser.service.memberprice.model.MpMpriceConf;
import com.yqbsoft.laser.service.memberprice.model.MpMpriceMem;
import com.yqbsoft.laser.service.memberprice.service.MpMpriceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MpMpriceServiceImpl
extends BaseServiceImpl
implements MpMpriceService {
    private static final String SYS_CODE = "mpr.MpMpriceServiceImpl";
    private MpMpriceMapper mpMpriceMapper;
    private MpMpriceMemMapper mpMpriceMemMapper;
    private MpMpriceConfMapper mpMpriceConfMapper;
    private String cachekey = "ChannelCode-TenantCode";

    public void setMpMpriceMapper(MpMpriceMapper mpMpriceMapper) {
        this.mpMpriceMapper = mpMpriceMapper;
    }

    public void setMpMpriceMemMapper(MpMpriceMemMapper mpMpriceMemMapper) {
        this.mpMpriceMemMapper = mpMpriceMemMapper;
    }

    public void setMpMpriceConfMapper(MpMpriceConfMapper mpMpriceConfMapper) {
        this.mpMpriceConfMapper = mpMpriceConfMapper;
    }

    private Date getSysDate() {
        try {
            return this.mpMpriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMpMprice(MpMpriceDomain mpMpriceDomain) {
        if (null == mpMpriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMpriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMpMpriceDefault(MpMprice mpMprice) {
        if (null == mpMprice) {
            return;
        }
        if (null == mpMprice.getDataState()) {
            mpMprice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == mpMprice.getGmtCreate()) {
            mpMprice.setGmtCreate(date);
        }
        mpMprice.setGmtModified(date);
        if (StringUtils.isBlank((String)mpMprice.getMpriceCode())) {
            mpMprice.setMpriceCode(this.getNo(null, "MpMprice", "mpMprice", mpMprice.getTenantCode()));
        }
    }

    private int getMpMpriceMaxCode() {
        int code = 0;
        try {
            return this.mpMpriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMpMpriceUpdataDefault(MpMprice mpMprice) {
        if (null == mpMprice) {
            return;
        }
        mpMprice.setGmtModified(this.getSysDate());
    }

    private void saveMpMpriceModel(MpMprice mpMprice) throws ApiException {
        if (null == mpMprice) {
            return;
        }
        try {
            this.mpMpriceMapper.insert(mpMprice);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceModel.ex", (Throwable)e);
        }
    }

    private void saveMpMpriceBatchModel(List<MpMprice> mpMpriceList) throws ApiException {
        if (null == mpMpriceList || mpMpriceList.isEmpty()) {
            return;
        }
        try {
            this.mpMpriceMapper.insertBatch(mpMpriceList);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceBatchModel.ex", (Throwable)e);
        }
    }

    private MpMprice getMpMpriceModelById(Integer mpriceId) {
        if (null == mpriceId) {
            return null;
        }
        try {
            return this.mpMpriceMapper.selectByPrimaryKey(mpriceId);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceModelById", (Throwable)e);
            return null;
        }
    }

    private MpMprice getMpMpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mpMpriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMpMpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.delMpMpriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.delMpMpriceModelByCode.num");
        }
    }

    private void deleteMpMpriceModel(Integer mpriceId) throws ApiException {
        if (null == mpriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceMapper.deleteByPrimaryKey(mpriceId);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.deleteMpMpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.deleteMpMpriceModel.num");
        }
    }

    private void updateMpMpriceModel(MpMprice mpMprice) throws ApiException {
        if (null == mpMprice) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceMapper.updateByPrimaryKey(mpMprice);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceModel.num");
        }
    }

    private void updateStateMpMpriceModel(Integer mpriceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mpriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mpriceId", mpriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mpMpriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceModel.null");
        }
    }

    private void updateStateMpMpriceModelByCode(String tenantCode, String mpriceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mpriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceCode", mpriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mpMpriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceModelByCode.null");
        }
    }

    private MpMprice makeMpMprice(MpMpriceDomain mpMpriceDomain, MpMprice mpMprice) {
        if (null == mpMpriceDomain) {
            return null;
        }
        if (null == mpMprice) {
            mpMprice = new MpMprice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMprice, (Object)mpMpriceDomain);
            return mpMprice;
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.makeMpMprice", (Throwable)e);
            return null;
        }
    }

    private MpMpriceReDomain makeMpMpriceReDomain(MpMprice mpMprice) {
        if (null == mpMprice) {
            return null;
        }
        MpMpriceReDomain mpMpriceReDomain = new MpMpriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceReDomain, (Object)mpMprice);
            return mpMpriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.makeMpMpriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MpMprice> queryMpMpriceModelPage(Map<String, Object> parammap) {
        try {
            return this.mpMpriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.queryMpMpriceModel", (Throwable)e);
            return null;
        }
    }

    private int countMpMprice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMpriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.countMpMprice", (Throwable)e);
        }
        return i;
    }

    private MpMprice createMpMprice(MpMpriceDomain mpMpriceDomain) {
        String msg = this.checkMpMprice(mpMpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMprice.checkMpMprice", msg);
        }
        MpMprice mpMprice = this.makeMpMprice(mpMpriceDomain, null);
        this.setMpMpriceDefault(mpMprice);
        return mpMprice;
    }

    private String checkMpMpriceMem(MpMpriceMemDomain mpMpriceMemDomain) {
        if (null == mpMpriceMemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMpriceMemDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMpMpriceMemDefault(MpMpriceMem mpMpriceMem) {
        if (null == mpMpriceMem) {
            return;
        }
        if (null == mpMpriceMem.getDataState()) {
            mpMpriceMem.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == mpMpriceMem.getGmtCreate()) {
            mpMpriceMem.setGmtCreate(date);
        }
        mpMpriceMem.setGmtModified(date);
        if (StringUtils.isBlank((String)mpMpriceMem.getMpriceMemCode())) {
            mpMpriceMem.setMpriceMemCode(this.getNo(null, "MpMpriceMem", "mpMpriceMem", mpMpriceMem.getTenantCode()));
        }
    }

    private int getMpMpriceMemMaxCode() {
        int code = 0;
        try {
            return this.mpMpriceMemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceMemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMpMpriceMemUpdataDefault(MpMpriceMem mpMpriceMem) {
        if (null == mpMpriceMem) {
            return;
        }
        mpMpriceMem.setGmtModified(this.getSysDate());
    }

    private void saveMpMpriceMemModel(MpMpriceMem mpMpriceMem) throws ApiException {
        if (null == mpMpriceMem) {
            return;
        }
        try {
            this.mpMpriceMemMapper.insert(mpMpriceMem);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceMemModel.ex", (Throwable)e);
        }
    }

    private void saveMpMpriceMemBatchModel(List<MpMpriceMem> mpMpriceMemList) throws ApiException {
        if (null == mpMpriceMemList || mpMpriceMemList.isEmpty()) {
            return;
        }
        try {
            this.mpMpriceMemMapper.insertBatch(mpMpriceMemList);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceMemBatchModel.ex", (Throwable)e);
        }
    }

    private MpMpriceMem getMpMpriceMemModelById(Integer mpriceMemId) {
        if (null == mpriceMemId) {
            return null;
        }
        try {
            return this.mpMpriceMemMapper.selectByPrimaryKey(mpriceMemId);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceMemModelById", (Throwable)e);
            return null;
        }
    }

    private MpMpriceMem getMpMpriceMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mpMpriceMemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceMemModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMpMpriceMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceMemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.delMpMpriceMemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.delMpMpriceMemModelByCode.num");
        }
    }

    private void deleteMpMpriceMemModel(Integer mpriceMemId) throws ApiException {
        if (null == mpriceMemId) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceMemMapper.deleteByPrimaryKey(mpriceMemId);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.deleteMpMpriceMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.deleteMpMpriceMemModel.num");
        }
    }

    private void updateMpMpriceMemModel(MpMpriceMem mpMpriceMem) throws ApiException {
        if (null == mpMpriceMem) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceMemMapper.updateByPrimaryKey(mpMpriceMem);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceMemModel.num");
        }
    }

    private void updateStateMpMpriceMemModel(Integer mpriceMemId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mpriceMemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mpriceMemId", mpriceMemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mpMpriceMemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceMemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceMemModel.null");
        }
    }

    private void updateStateMpMpriceMemModelByCode(String tenantCode, String mpriceMemCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mpriceMemCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceMemCode", mpriceMemCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mpMpriceMemMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceMemModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceMemModelByCode.null");
        }
    }

    private MpMpriceMem makeMpMpriceMem(MpMpriceMemDomain mpMpriceMemDomain, MpMpriceMem mpMpriceMem) {
        if (null == mpMpriceMemDomain) {
            return null;
        }
        if (null == mpMpriceMem) {
            mpMpriceMem = new MpMpriceMem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceMem, (Object)mpMpriceMemDomain);
            return mpMpriceMem;
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.makeMpMpriceMem", (Throwable)e);
            return null;
        }
    }

    private MpMpriceMemReDomain makeMpMpriceMemReDomain(MpMpriceMem mpMpriceMem) {
        if (null == mpMpriceMem) {
            return null;
        }
        MpMpriceMemReDomain mpMpriceMemReDomain = new MpMpriceMemReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceMemReDomain, (Object)mpMpriceMem);
            return mpMpriceMemReDomain;
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.makeMpMpriceMemReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MpMpriceMem> queryMpMpriceMemModelPage(Map<String, Object> parammap) {
        try {
            return this.mpMpriceMemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.queryMpMpriceMemModel", (Throwable)e);
            return null;
        }
    }

    private int countMpMpriceMem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMpriceMemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.countMpMpriceMem", (Throwable)e);
        }
        return i;
    }

    private MpMpriceMem createMpMpriceMem(MpMpriceMemDomain mpMpriceMemDomain) {
        String msg = this.checkMpMpriceMem(mpMpriceMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceMem.checkMpMpriceMem", msg);
        }
        MpMpriceMem mpMpriceMem = this.makeMpMpriceMem(mpMpriceMemDomain, null);
        this.setMpMpriceMemDefault(mpMpriceMem);
        return mpMpriceMem;
    }

    private String checkMpMpriceConf(MpMpriceConfDomain mpMpriceConfDomain) {
        if (null == mpMpriceConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMpriceConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMpMpriceConfDefault(MpMpriceConf mpMpriceConf) {
        if (null == mpMpriceConf) {
            return;
        }
        if (null == mpMpriceConf.getDataState()) {
            mpMpriceConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == mpMpriceConf.getGmtCreate()) {
            mpMpriceConf.setGmtCreate(date);
        }
        mpMpriceConf.setGmtModified(date);
        if (StringUtils.isBlank((String)mpMpriceConf.getMpriceConfCode())) {
            mpMpriceConf.setMpriceConfCode(this.getNo(null, "MpMpriceConf", "mpMpriceConf", mpMpriceConf.getTenantCode()));
        }
    }

    private int getMpMpriceConfMaxCode() {
        int code = 0;
        try {
            return this.mpMpriceConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMpMpriceConfUpdataDefault(MpMpriceConf mpMpriceConf) {
        if (null == mpMpriceConf) {
            return;
        }
        mpMpriceConf.setGmtModified(this.getSysDate());
    }

    private void saveMpMpriceConfModel(MpMpriceConf mpMpriceConf) throws ApiException {
        if (null == mpMpriceConf) {
            return;
        }
        try {
            this.mpMpriceConfMapper.insert(mpMpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceConfModel.ex", (Throwable)e);
        }
    }

    private void saveMpMpriceConfBatchModel(List<MpMpriceConf> mpMpriceConfList) throws ApiException {
        if (null == mpMpriceConfList || mpMpriceConfList.isEmpty()) {
            return;
        }
        try {
            this.mpMpriceConfMapper.insertBatch(mpMpriceConfList);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceConfBatchModel.ex", (Throwable)e);
        }
    }

    private MpMpriceConf getMpMpriceConfModelById(Integer mpriceConfId) {
        if (null == mpriceConfId) {
            return null;
        }
        try {
            return this.mpMpriceConfMapper.selectByPrimaryKey(mpriceConfId);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceConfModelById", (Throwable)e);
            return null;
        }
    }

    private MpMpriceConf getMpMpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mpMpriceConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.getMpMpriceConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMpMpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.delMpMpriceConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.delMpMpriceConfModelByCode.num");
        }
    }

    private void deleteMpMpriceConfModel(Integer mpriceConfId) throws ApiException {
        if (null == mpriceConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceConfMapper.deleteByPrimaryKey(mpriceConfId);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.deleteMpMpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.deleteMpMpriceConfModel.num");
        }
    }

    private void updateMpMpriceConfModel(MpMpriceConf mpMpriceConf) throws ApiException {
        if (null == mpMpriceConf) {
            return;
        }
        int i = 0;
        try {
            i = this.mpMpriceConfMapper.updateByPrimaryKey(mpMpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceConfModel.num");
        }
    }

    private void updateStateMpMpriceConfModel(Integer mpriceConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mpriceConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mpriceConfId", mpriceConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mpMpriceConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceConfModel.null");
        }
    }

    private void updateStateMpMpriceConfModelByCode(String tenantCode, String mpriceConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mpriceConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceConfCode", mpriceConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mpMpriceConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateStateMpMpriceConfModelByCode.null");
        }
    }

    private MpMpriceConf makeMpMpriceConf(MpMpriceConfDomain mpMpriceConfDomain, MpMpriceConf mpMpriceConf) {
        if (null == mpMpriceConfDomain) {
            return null;
        }
        if (null == mpMpriceConf) {
            mpMpriceConf = new MpMpriceConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceConf, (Object)mpMpriceConfDomain);
            return mpMpriceConf;
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.makeMpMpriceConf", (Throwable)e);
            return null;
        }
    }

    private MpMpriceConfReDomain makeMpMpriceConfReDomain(MpMpriceConf mpMpriceConf) {
        if (null == mpMpriceConf) {
            return null;
        }
        MpMpriceConfReDomain mpMpriceConfReDomain = new MpMpriceConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceConfReDomain, (Object)mpMpriceConf);
            return mpMpriceConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.makeMpMpriceConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MpMpriceConf> queryMpMpriceConfModelPage(Map<String, Object> parammap) {
        try {
            return this.mpMpriceConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.queryMpMpriceConfModel", (Throwable)e);
            return null;
        }
    }

    private List<MpMpriceMemDomain> makeMemDomain(List<MpMpriceMem> mpMpriceMemList) {
        if (ListUtil.isEmpty(mpMpriceMemList)) {
            return null;
        }
        ArrayList<MpMpriceMemDomain> mpMpriceMemDomainList = new ArrayList<MpMpriceMemDomain>();
        for (MpMpriceMem mpMpriceMem : mpMpriceMemList) {
            MpMpriceMemDomain mpMpriceMemDomain = this.makeMemDomain(mpMpriceMem);
            if (null == mpMpriceMemDomain) continue;
            mpMpriceMemDomainList.add(mpMpriceMemDomain);
        }
        return mpMpriceMemDomainList;
    }

    private MpMpriceMemDomain makeMemDomain(MpMpriceMem mpMpriceMem) {
        if (null == mpMpriceMem) {
            return null;
        }
        MpMpriceMemDomain mpMpriceMemDomain = new MpMpriceMemDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceMemDomain, (Object)mpMpriceMem);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMpriceMemDomain;
    }

    private List<MpMpriceConfDomain> makeConfDomain(List<MpMpriceConf> mpMpriceConfList) {
        if (ListUtil.isEmpty(mpMpriceConfList)) {
            return null;
        }
        ArrayList<MpMpriceConfDomain> mpMpriceConfDomainList = new ArrayList<MpMpriceConfDomain>();
        for (MpMpriceConf mpMpriceConf : mpMpriceConfList) {
            MpMpriceConfDomain mpMpriceConfDomain = this.makeConfDomain(mpMpriceConf);
            if (null == mpMpriceConfDomain) continue;
            mpMpriceConfDomainList.add(mpMpriceConfDomain);
        }
        return mpMpriceConfDomainList;
    }

    private MpMpriceConfDomain makeConfDomain(MpMpriceConf mpMpriceConf) {
        if (null == mpMpriceConf) {
            return null;
        }
        MpMpriceConfDomain mpMpriceConfDomain = new MpMpriceConfDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceConfDomain, (Object)mpMpriceConf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMpriceConfDomain;
    }

    private int countMpMpriceConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMpriceConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mpr.MpMpriceServiceImpl.countMpMpriceConf", (Throwable)e);
        }
        return i;
    }

    private MpMpriceConf createMpMpriceConf(MpMpriceConfDomain mpMpriceConfDomain) {
        String msg = this.checkMpMpriceConf(mpMpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mpr.MpMpriceServiceImpl.saveMpMpriceConf.checkMpMpriceConf", msg);
        }
        MpMpriceConf mpMpriceConf = this.makeMpMpriceConf(mpMpriceConfDomain, null);
        this.setMpMpriceConfDefault(mpMpriceConf);
        return mpMpriceConf;
    }

    @Override
    public String saveMpMprice(MpMpriceDomain mpMpriceDomain) throws ApiException {
        MpMprice mpMprice = this.createMpMprice(mpMpriceDomain);
        if (null == mpMprice.getMpriceId()) {
            this.saveMpMpriceModel(mpMprice);
        }
        if (ListUtil.isNotEmpty(mpMpriceDomain.getMpMpriceConfDomainList())) {
            this.saveMpriceConfListDomain(mpMpriceDomain.getMpMpriceConfDomainList(), mpMprice);
        }
        if (ListUtil.isNotEmpty(mpMpriceDomain.getMpMpriceMemDomainList())) {
            this.saveMpriceMemListDomain(mpMpriceDomain.getMpMpriceMemDomainList(), mpMprice);
        }
        if (MpMpriceConstants.dataState_start.intValue() == mpMprice.getDataState().intValue()) {
            this.updateMpriceCache(mpMprice);
        }
        return mpMprice.getMpriceCode();
    }

    private void saveMpriceConfListDomain(List<MpMpriceConfDomain> mpMpriceConfDomainList, MpMprice mpMprice) {
        if (ListUtil.isEmpty(mpMpriceConfDomainList) || null == mpMprice) {
            return;
        }
        for (MpMpriceConfDomain mpMpriceConfDomain : mpMpriceConfDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)mpMpriceConfDomain, (Object)mpMprice);
            }
            catch (Exception exception) {}
        }
        this.saveMpMpriceConfBatch(mpMpriceConfDomainList);
    }

    private void saveMpriceMemListDomain(List<MpMpriceMemDomain> mpMpriceMemDomainList, MpMprice mpMprice) {
        if (ListUtil.isEmpty(mpMpriceMemDomainList) || null == mpMprice) {
            return;
        }
        for (MpMpriceMemDomain mpMpriceMemDomain : mpMpriceMemDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)mpMpriceMemDomain, (Object)mpMprice);
            }
            catch (Exception exception) {}
        }
        this.saveMpMpriceMemBatch(mpMpriceMemDomainList);
    }

    @Override
    public String saveMpMpriceBatch(List<MpMpriceDomain> mpMpriceDomainList) throws ApiException {
        if (null == mpMpriceDomainList || mpMpriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MpMprice> mpMpriceList = new ArrayList<MpMprice>();
        String code = "";
        for (MpMpriceDomain mpMpriceDomain : mpMpriceDomainList) {
            MpMprice mpMprice = this.createMpMprice(mpMpriceDomain);
            code = mpMprice.getMpriceCode();
            mpMpriceList.add(mpMprice);
        }
        this.saveMpMpriceBatchModel(mpMpriceList);
        return code;
    }

    @Override
    public void updateMpMpriceState(Integer mpriceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == mpriceId) {
            return;
        }
        MpMprice mpMprice = this.getMpMprice(mpriceId);
        this.updateStateMpMpriceModel(mpriceId, dataState, oldDataState, map);
        if (MpMpriceConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteMpriceCache(mpMprice);
        } else if (MpMpriceConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateMpriceCache(mpMprice);
        }
    }

    @Override
    public void updateMpMpriceStateByCode(String tenantCode, String mpriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)mpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        MpMprice mpMprice = this.getMpMpriceByCode(tenantCode, mpriceCode);
        this.updateStateMpMpriceModelByCode(tenantCode, mpriceCode, dataState, oldDataState, map);
        if (MpMpriceConstants.dataState_start.intValue() != dataState.intValue()) {
            this.deleteMpriceCache(mpMprice);
        } else if (MpMpriceConstants.dataState_start.intValue() == dataState.intValue()) {
            this.updateMpriceCache(mpMprice);
        }
    }

    @Override
    public void updateMpMprice(MpMpriceDomain mpMpriceDomain) throws ApiException {
        String msg = this.checkMpMprice(mpMpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMprice.checkMpMprice", msg);
        }
        MpMprice oldMpMprice = this.getMpMpriceModelById(mpMpriceDomain.getMpriceId());
        if (null == oldMpMprice) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MpMprice mpMprice = this.makeMpMprice(mpMpriceDomain, oldMpMprice);
        this.setMpMpriceUpdataDefault(mpMprice);
        this.updateMpMpriceModel(mpMprice);
    }

    @Override
    public MpMprice getMpMprice(Integer mpriceId) {
        if (null == mpriceId) {
            return null;
        }
        return this.getMpMpriceModelById(mpriceId);
    }

    @Override
    public void deleteMpMprice(Integer mpriceId) throws ApiException {
        if (null == mpriceId) {
            return;
        }
        this.deleteMpMpriceModel(mpriceId);
    }

    @Override
    public QueryResult<MpMprice> queryMpMpricePage(Map<String, Object> map) {
        List<MpMprice> mpMpriceList = this.queryMpMpriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMpMprice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mpMpriceList);
        return queryResult;
    }

    @Override
    public MpMprice getMpMpriceByCode(String tenantCode, String mpriceCode) throws ApiException {
        if (StringUtils.isBlank((String)mpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceCode", mpriceCode);
        return this.getMpMpriceModelByCode(map);
    }

    @Override
    public void deleteMpMpriceByCode(String tenantCode, String mpriceCode) throws ApiException {
        if (StringUtils.isBlank((String)mpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceCode", mpriceCode);
        this.delMpMpriceModelByCode(map);
    }

    @Override
    public String saveMpMpriceMem(MpMpriceMemDomain mpMpriceMemDomain) throws ApiException {
        MpMpriceMem mpMpriceMem = this.createMpMpriceMem(mpMpriceMemDomain);
        this.saveMpMpriceMemModel(mpMpriceMem);
        return mpMpriceMem.getMpriceMemCode();
    }

    @Override
    public String saveMpMpriceMemBatch(List<MpMpriceMemDomain> mpMpriceMemDomainList) throws ApiException {
        if (null == mpMpriceMemDomainList || mpMpriceMemDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MpMpriceMem> mpMpriceMemList = new ArrayList<MpMpriceMem>();
        String code = "";
        for (MpMpriceMemDomain mpMpriceMemDomain : mpMpriceMemDomainList) {
            MpMpriceMem mpMpriceMem = this.createMpMpriceMem(mpMpriceMemDomain);
            code = mpMpriceMem.getMpriceMemCode();
            mpMpriceMemList.add(mpMpriceMem);
        }
        this.saveMpMpriceMemBatchModel(mpMpriceMemList);
        return code;
    }

    @Override
    public void updateMpMpriceMemState(Integer mpriceMemId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == mpriceMemId) {
            return;
        }
        this.updateStateMpMpriceMemModel(mpriceMemId, dataState, oldDataState, map);
    }

    @Override
    public void updateMpMpriceMemStateByCode(String tenantCode, String mpriceMemCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)mpriceMemCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMpMpriceMemModelByCode(tenantCode, mpriceMemCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMpMpriceMem(MpMpriceMemDomain mpMpriceMemDomain) throws ApiException {
        String msg = this.checkMpMpriceMem(mpMpriceMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceMem.checkMpMpriceMem", msg);
        }
        MpMpriceMem oldMpMpriceMem = this.getMpMpriceMemModelById(mpMpriceMemDomain.getMpriceMemId());
        if (null == oldMpMpriceMem) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceMem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MpMpriceMem mpMpriceMem = this.makeMpMpriceMem(mpMpriceMemDomain, oldMpMpriceMem);
        this.setMpMpriceMemUpdataDefault(mpMpriceMem);
        this.updateMpMpriceMemModel(mpMpriceMem);
    }

    @Override
    public MpMpriceMem getMpMpriceMem(Integer mpriceMemId) {
        if (null == mpriceMemId) {
            return null;
        }
        return this.getMpMpriceMemModelById(mpriceMemId);
    }

    @Override
    public void deleteMpMpriceMem(Integer mpriceMemId) throws ApiException {
        if (null == mpriceMemId) {
            return;
        }
        this.deleteMpMpriceMemModel(mpriceMemId);
    }

    @Override
    public QueryResult<MpMpriceMem> queryMpMpriceMemPage(Map<String, Object> map) {
        List<MpMpriceMem> mpMpriceMemList = this.queryMpMpriceMemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMpMpriceMem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mpMpriceMemList);
        return queryResult;
    }

    @Override
    public MpMpriceMem getMpMpriceMemByCode(String tenantCode, String mpriceMemCode) throws ApiException {
        if (StringUtils.isBlank((String)mpriceMemCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceMemCode", mpriceMemCode);
        return this.getMpMpriceMemModelByCode(map);
    }

    @Override
    public void deleteMpMpriceMemByCode(String tenantCode, String mpriceMemCode) throws ApiException {
        if (StringUtils.isBlank((String)mpriceMemCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceMemCode", mpriceMemCode);
        this.delMpMpriceMemModelByCode(map);
    }

    @Override
    public String saveMpMpriceConf(MpMpriceConfDomain mpMpriceConfDomain) throws ApiException {
        MpMpriceConf mpMpriceConf = this.createMpMpriceConf(mpMpriceConfDomain);
        this.saveMpMpriceConfModel(mpMpriceConf);
        return mpMpriceConf.getMpriceConfCode();
    }

    @Override
    public String saveMpMpriceConfBatch(List<MpMpriceConfDomain> mpMpriceConfDomainList) throws ApiException {
        if (null == mpMpriceConfDomainList || mpMpriceConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MpMpriceConf> mpMpriceConfList = new ArrayList<MpMpriceConf>();
        String code = "";
        for (MpMpriceConfDomain mpMpriceConfDomain : mpMpriceConfDomainList) {
            MpMpriceConf mpMpriceConf = this.createMpMpriceConf(mpMpriceConfDomain);
            code = mpMpriceConf.getMpriceConfCode();
            mpMpriceConfList.add(mpMpriceConf);
        }
        this.saveMpMpriceConfBatchModel(mpMpriceConfList);
        return code;
    }

    @Override
    public void updateMpMpriceConfState(Integer mpriceConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == mpriceConfId) {
            return;
        }
        this.updateStateMpMpriceConfModel(mpriceConfId, dataState, oldDataState, map);
    }

    @Override
    public void updateMpMpriceConfStateByCode(String tenantCode, String mpriceConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)mpriceConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMpMpriceConfModelByCode(tenantCode, mpriceConfCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMpMpriceConf(MpMpriceConfDomain mpMpriceConfDomain) throws ApiException {
        String msg = this.checkMpMpriceConf(mpMpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceConf.checkMpMpriceConf", msg);
        }
        MpMpriceConf oldMpMpriceConf = this.getMpMpriceConfModelById(mpMpriceConfDomain.getMpriceConfId());
        if (null == oldMpMpriceConf) {
            throw new ApiException("mpr.MpMpriceServiceImpl.updateMpMpriceConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MpMpriceConf mpMpriceConf = this.makeMpMpriceConf(mpMpriceConfDomain, oldMpMpriceConf);
        this.setMpMpriceConfUpdataDefault(mpMpriceConf);
        this.updateMpMpriceConfModel(mpMpriceConf);
    }

    @Override
    public MpMpriceConf getMpMpriceConf(Integer mpriceConfId) {
        if (null == mpriceConfId) {
            return null;
        }
        return this.getMpMpriceConfModelById(mpriceConfId);
    }

    @Override
    public void deleteMpMpriceConf(Integer mpriceConfId) throws ApiException {
        if (null == mpriceConfId) {
            return;
        }
        this.deleteMpMpriceConfModel(mpriceConfId);
    }

    @Override
    public QueryResult<MpMpriceConf> queryMpMpriceConfPage(Map<String, Object> map) {
        List<MpMpriceConf> mpMpriceConfList = this.queryMpMpriceConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMpMpriceConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mpMpriceConfList);
        return queryResult;
    }

    @Override
    public MpMpriceConf getMpMpriceConfByCode(String tenantCode, String mpriceConfCode) throws ApiException {
        if (StringUtils.isBlank((String)mpriceConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceConfCode", mpriceConfCode);
        return this.getMpMpriceConfModelByCode(map);
    }

    @Override
    public void deleteMpMpriceConfByCode(String tenantCode, String mpriceConfCode) throws ApiException {
        if (StringUtils.isBlank((String)mpriceConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mpriceConfCode", mpriceConfCode);
        this.delMpMpriceConfModelByCode(map);
    }

    @Override
    public void queryMpriceLoadCache() {
        this.logger.info("MpMpriceService.queryMpriceLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", MpMpriceConstants.dataState_start);
        List<MpMprice> mpriceList = this.queryMpMpriceModelPage(parammap);
        if (null == mpriceList || mpriceList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("MpMpriceService.queryMpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<MpMpriceDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<MpMpriceDomain>>();
        for (MpMprice mpMprice : mpriceList) {
            if (StringUtils.isBlank((String)mpMprice.getChannelCode())) {
                mpMprice.setChannelCode("all");
            }
            MpMpriceDomain mpMpriceDomain = this.makeMprDpriceDomain(null, mpMprice);
            confparammap.put("mpriceCode", mpMprice.getMpriceCode());
            confparammap.put("tenantCode", mpMprice.getTenantCode());
            List<MpMpriceConf> upcachelist = this.queryMpMpriceConfModelPage(confparammap);
            mpMpriceDomain.setMpMpriceConfDomainList(this.makeConfDomain(upcachelist));
            List<MpMpriceMem> mpMpriceMemList = this.queryMpMpriceMemModelPage(confparammap);
            mpMpriceDomain.setMpMpriceMemDomainList(this.makeMemDomain(mpMpriceMemList));
            ArrayList<MpMpriceDomain> mlist = (ArrayList<MpMpriceDomain>)ddListMap.get(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode());
            if (null == mlist) {
                mlist = new ArrayList<MpMpriceDomain>();
                ddListMap.put(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode(), mlist);
            }
            mlist.add(mpMpriceDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.mprDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("MpMpriceService.queryMpriceLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public void deleteMpMpriceConfByIds(List<Integer> mpriceConfIds) {
        if (ListUtil.isEmpty(mpriceConfIds)) {
            return;
        }
        for (Integer mpriceConfid : mpriceConfIds) {
            this.deleteMpMpriceConf(mpriceConfid);
        }
    }

    @Override
    public void deleteMpMpriceMemByIds(List<Integer> mpriceMemIds) {
        if (ListUtil.isEmpty(mpriceMemIds)) {
            return;
        }
        for (Integer mpriceMemid : mpriceMemIds) {
            this.deleteMpMpriceMem(mpriceMemid);
        }
    }

    private void deleteMpriceCache(MpMprice mpMprice) {
        String json;
        if (null == mpMprice) {
            return;
        }
        if (StringUtils.isBlank((String)mpMprice.getChannelCode())) {
            mpMprice.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode()))))) {
            return;
        }
        List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, MpMpriceDomain.class);
        ArrayList<MpMpriceDomain> mlist2 = new ArrayList<MpMpriceDomain>();
        if (ListUtil.isNotEmpty((Collection)mlist)) {
            for (MpMpriceDomain mpMpriceDomain2 : mlist) {
                if (mpMpriceDomain2.getMpriceCode().equals(mpMprice.getMpriceCode())) continue;
                mlist2.add(mpMpriceDomain2);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.mprDomainsort(mlist2)));
    }

    private void updateMpriceCache(MpMprice mpMprice) {
        if (null == mpMprice) {
            return;
        }
        MpMpriceDomain mpMpriceDomain = this.makeMprDpriceDomain(null, mpMprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("mpriceCode", mpMprice.getMpriceCode());
        confparammap.put("tenantCode", mpMprice.getTenantCode());
        List<MpMpriceConf> upcachelist = this.queryMpMpriceConfModelPage(confparammap);
        mpMpriceDomain.setMpMpriceConfDomainList(this.makeConfDomain(upcachelist));
        List<MpMpriceMem> mpMpriceMems = this.queryMpMpriceMemModelPage(confparammap);
        mpMpriceDomain.setMpMpriceMemDomainList(this.makeMemDomain(mpMpriceMems));
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<MpMpriceDomain> mlist = new ArrayList<MpMpriceDomain>();
            mlist.add(mpMpriceDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.mprDomainsort(mlist)));
        } else {
            List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, MpMpriceDomain.class);
            ArrayList<MpMpriceDomain> mprlist = new ArrayList<MpMpriceDomain>();
            if (ListUtil.isNotEmpty((Collection)mlist)) {
                boolean flag = false;
                for (MpMpriceDomain mpMpriceDomain2 : mlist) {
                    if (mpMpriceDomain2.getMpriceCode().equals(mpMprice.getMpriceCode())) {
                        flag = true;
                        mprlist.add(mpMpriceDomain);
                        continue;
                    }
                    mprlist.add(mpMpriceDomain2);
                }
                if (!flag) {
                    mprlist.add(mpMpriceDomain);
                }
            } else {
                mprlist.add(mpMpriceDomain);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(mpMprice.getChannelCode() + "-" + mpMprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.mprDomainsort(mprlist)));
        }
    }

    private List<MpMpriceDomain> mprDomainsort(List<MpMpriceDomain> mlist) {
        if (ListUtil.isEmpty(mlist)) {
            return null;
        }
        Collections.sort(mlist, new Comparator<MpMpriceDomain>(){

            @Override
            public int compare(MpMpriceDomain arg0, MpMpriceDomain arg1) {
                if (arg0.getMpriceWeight() > arg1.getMpriceWeight()) {
                    return 1;
                }
                if (arg0.getMpriceWeight() < arg1.getMpriceWeight()) {
                    return -1;
                }
                return arg0.getMpriceWeight().compareTo(arg0.getMpriceWeight());
            }
        });
        return mlist;
    }

    private MpMpriceDomain makeMprDpriceDomain(MpMpriceDomain mpMpriceDomain, MpMprice mpMprice) {
        if (null == mpMprice) {
            return null;
        }
        if (null == mpMpriceDomain) {
            mpMpriceDomain = new MpMpriceDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMpriceDomain, (Object)mpMprice);
            return mpMpriceDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

