/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.service.MnsSendPhoneService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class MnsSendPhoneServiceImpl
extends BaseServiceImpl
implements MnsSendPhoneService {
    public static final String SYS_CODE = "mns.MNS.MnsSendPhoneServiceImpl";

    @Override
    public void saveSendMsg(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        if ("0001".equals(mnsconfig.getMnschannelCode())) {
            this.sendShortMesBatch(mnsList, mnsconfig);
        } else if ("0002".equals(mnsconfig.getMnschannelCode())) {
            this.sendMsgChuanlan(mnsList, mnsconfig);
        } else if ("0004".equals(mnsconfig.getMnschannelCode())) {
            this.sendMsgAliDaYu(mnsList, mnsconfig);
        } else {
            this.sendMsg(mnsList, mnsconfig);
        }
    }

    private void sendMsgChuanlan(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        String key = "00000000-msg-clParams";
        String params = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        if (StringUtils.isEmpty((String)params)) {
            this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.key-->\u3010" + key + "\u3011.error", (Object)"\u77ed\u4fe1\u6e20\u9053\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        Map paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(params, String.class, Object.class);
        if (paramMap == null) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            List receiverList;
            Map mapExp;
            String context = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)context)) continue;
            paramMap.put("msg", context);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null || (receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class)) == null || receiverList.isEmpty()) continue;
            String phoneNos = "";
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                phoneNos = StringUtils.isBlank((String)phoneNos) ? telphone : phoneNos + "," + telphone;
            }
            if (StringUtils.isBlank((String)phoneNos)) continue;
            this.logger.debug("mns.MNS.MnsSendPhoneServiceImpl.sendMsgChuanlan", (Object)("\u624b\u673a\u53f7-->" + phoneNos));
            paramMap.put("mobile", phoneNos);
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", paramMap);
        }
    }

    private void sendMsg(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (Map<String, String> map : mnsList) {
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            paramMap.put("mnsconfig", JsonUtil.buildNormalBinder().toJson((Object)mnsconfig));
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", paramMap);
        }
    }

    private void sendMsgAliDaYu(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (Map<String, String> map : mnsList) {
            Map mapExp;
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null) continue;
            Map randomParamMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap((String)mapExp.get("paramMap"), String.class, String.class);
            String randomCode = (String)randomParamMap.get("random");
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            if (receiverList == null || receiverList.isEmpty()) continue;
            String phoneNos = "";
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                phoneNos = StringUtils.isBlank((String)phoneNos) ? telphone : phoneNos + "," + telphone;
            }
            if (StringUtils.isBlank((String)phoneNos)) continue;
            this.logger.info("mns.MNS.MnsSendPhoneServiceImpl.sendMsgAliDaYu", (Object)(" \u624b\u673a\u53f7-->" + phoneNos));
            paramMap.put("accessKeyId", mnsconfig.getMnstemplateName());
            paramMap.put("accessKeySecret", mnsconfig.getMnstemplateCode());
            paramMap.put("content", mnsconfig.getMnstemplateContent());
            paramMap.put("randomCode", randomCode);
            paramMap.put("signName", mnsconfig.getMemo());
            paramMap.put("phone", phoneNos);
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", paramMap);
        }
    }

    private void sendShortMesBatch(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            Map mapExp;
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            String apikey = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(mnsconfig.getTenantCode() + "-mns-" + "phoneApiKey"));
            if (StringUtils.isEmpty((String)apikey)) continue;
            sendMap.put("apikey", apikey);
            String context = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)context)) continue;
            sendMap.put("text", context);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null) continue;
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                this.logger.debug("mns.MNS.MnsSendPhoneServiceImpl_sendShortMesBatch", (Object)("\u624b\u673a\u53f7-->" + telphone));
                sendMap.put("mobile", telphone);
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
            }
        }
    }
}

