/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.MnsConstants;
import com.yqbsoft.laser.service.mns.dao.MnsMnslistMapper;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.mns.model.MnsMnschannel;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.model.MnsMnslist;
import com.yqbsoft.laser.service.mns.send.SendPollThread;
import com.yqbsoft.laser.service.mns.send.SendPutThread;
import com.yqbsoft.laser.service.mns.send.SendService;
import com.yqbsoft.laser.service.mns.service.MnsSendPhoneService;
import com.yqbsoft.laser.service.mns.service.MnsblistService;
import com.yqbsoft.laser.service.mns.service.MnschannelService;
import com.yqbsoft.laser.service.mns.service.MnsconfigService;
import com.yqbsoft.laser.service.mns.service.MnslistService;
import com.yqbsoft.laser.service.mns.service.MnstemplateService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class MnslistServiceImpl
extends BaseServiceImpl
implements MnslistService {
    public static final String SYS_CODE = "mns.MNS.MnslistServiceImpl";
    private static SendService sendService;
    private static Object lock;
    private MnsMnslistMapper mnsMnslistMapper;
    private MnstemplateService mnstemplateService;
    private MnschannelService mnschannelService;
    private MnsconfigService mnsconfigService;
    private MnsSendPhoneService mnsSendPhoneService;
    private MnsblistService mnsblistService;

    private static String getContent(Map<String, Object> map, String mnsContent) {
        try {
            StringWriter writer = MnslistServiceImpl.getTemplateContent(map, mnsContent);
            return writer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static StringWriter getTemplateContent(Map<String, Object> map, String content) throws IOException, TemplateException {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(VfinOpenConstants.FREEMAKER_STR_KEY, content);
        cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        cfg.setDefaultEncoding("UTF-8");
        Template template = cfg.getTemplate(VfinOpenConstants.FREEMAKER_STR_KEY);
        StringWriter writer = new StringWriter();
        template.process(map, (Writer)writer);
        return writer;
    }

    public void setMnsSendPhoneService(MnsSendPhoneService mnsSendPhoneService) {
        this.mnsSendPhoneService = mnsSendPhoneService;
    }

    public void setMnschannelService(MnschannelService mnschannelService) {
        this.mnschannelService = mnschannelService;
    }

    public void setMnsblistService(MnsblistService mnsblistService) {
        this.mnsblistService = mnsblistService;
    }

    public void setMnstemplateService(MnstemplateService mnstemplateService) {
        this.mnstemplateService = mnstemplateService;
    }

    public void setMnsconfigService(MnsconfigService mnsconfigService) {
        this.mnsconfigService = mnsconfigService;
    }

    public void setMnsMnslistMapper(MnsMnslistMapper mnsMnslistMapper) {
        this.mnsMnslistMapper = mnsMnslistMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsMnslistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private String checkBusinessMnslist(Map<String, Object> map) {
        if (null == map) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("businessType")))) {
            msg = msg + "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMnslistDefault(MnsMnslist mnsMnslist) {
        if (null == mnsMnslist) {
            return;
        }
        if (null == mnsMnslist.getDataState()) {
            mnsMnslist.setDataState(0);
        }
        if (null == mnsMnslist.getGmtCreate()) {
            mnsMnslist.setGmtCreate(this.getSysDate());
        }
        if (null == mnsMnslist.getMnslistSource()) {
            mnsMnslist.setMnslistSource(0);
        }
        if (StringUtils.isBlank((String)mnsMnslist.getMnslistCode())) {
            int code = this.getMaxCode();
            mnsMnslist.setMnslistCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            Integer i = this.mnsMnslistMapper.getMaxCode();
            if (null == i) {
                i = 0;
            }
            return i;
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMnslistUpdataDefault(MnsMnslist mnsMnslist) {
        if (null == mnsMnslist) {
            return;
        }
        mnsMnslist.setGmtModified(this.getSysDate());
    }

    private void saveMnslistModel(MnsMnslist mnsMnslist) throws ApiException {
        if (null == mnsMnslist) {
            return;
        }
        try {
            this.mnsMnslistMapper.insert(mnsMnslist);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnslistModel.ex");
        }
    }

    private MnsMnslist getMnslistModelById(Integer mnslistId) {
        if (null == mnslistId) {
            return null;
        }
        try {
            return this.mnsMnslistMapper.selectByPrimaryKey(mnslistId);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getMnslistModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMnslistModel(Integer mnslistId) throws ApiException {
        if (null == mnslistId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnslistMapper.deleteByPrimaryKey(mnslistId);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModel.ex");
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModel.num");
        }
    }

    private void deleteMnslistModelByCode(String mnslistCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)mnslistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistCode", mnslistCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.mnsMnslistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModelByCode.ex", ((Object)map).toString());
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModelByCode.num", i + "=" + ((Object)map).toString());
        }
    }

    private void updateMnslistModel(MnsMnslist mnsMnslist) throws ApiException {
        if (null == mnsMnslist) {
            return;
        }
        try {
            this.mnsMnslistMapper.updateByPrimaryKeyWithBLOBs(mnsMnslist);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslistModel.ex");
        }
    }

    private void updateStateMnslistModel(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mnslistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistId", mnslistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mnsMnslistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.null");
        }
    }

    private void updateStateMnslistModelSend(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mnslistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistId", mnslistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("mnslistSenddate", this.getSysDate());
        int i = 0;
        try {
            i = this.mnsMnslistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.null");
        }
    }

    private MnsMnslist makeMnslist(MnsMnslistDomainBean mnsMnslistDomainBean, MnsMnslist mnsMnslist) {
        if (null == mnsMnslistDomainBean) {
            return null;
        }
        if (null == mnsMnslist) {
            mnsMnslist = new MnsMnslist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnslist, (Object)mnsMnslistDomainBean);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnslist", (Throwable)e);
        }
        return mnsMnslist;
    }

    private MnsMnslist makeBusinessMnslist(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        MnsMnslist mnsMnslist = new MnsMnslist();
        try {
            String sendSys = (String)map.get("sendSys");
            mnsMnslist.setMnslistBustype((String)map.get("businessType"));
            mnsMnslist.setMnslistSubject((String)map.get("theme"));
            HashMap<String, String> expMap = new HashMap<String, String>();
            expMap.put("businessType", (String)map.get("businessType"));
            expMap.put("sender", (String)map.get("sender"));
            expMap.put("receiverList", (String)map.get("receiverList"));
            expMap.put("paramMap", (String)map.get("paramMap"));
            if (StringUtils.isNotBlank((String)sendSys)) {
                HashMap<String, String> mapSender = new HashMap<String, String>();
                mapSender.put("code", "sys");
                mapSender.put("name", "sys");
                map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
                ArrayList listReceiver = new ArrayList();
                HashMap<String, String> mapReceiver = new HashMap<String, String>();
                mapReceiver.put("code", "");
                mapReceiver.put("name", "sys");
                String email = DisUtil.getMap((String)"PosCstSysParam-list", (String)"OPEN_EMAIL_SERVER-01-00");
                if (StringUtils.isBlank((String)email)) {
                    this.logger.info(SYS_CODE, (Object)"sys email is null");
                    return null;
                }
                mapReceiver.put("email", email);
                mapReceiver.put("telphone", "");
                listReceiver.add(mapReceiver);
                map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
                expMap.put("sender", (String)map.get("sender"));
                expMap.put("receiverList", (String)map.get("receiverList"));
            }
            mnsMnslist.setMnslistSource(0);
            mnsMnslist.setMnslistExp(JsonUtil.buildNormalBinder().toJson(expMap));
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.makeBusinessMnslist", (Throwable)e);
        }
        return mnsMnslist;
    }

    private List<MnsMnslist> queryMnslistModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsMnslistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.queryMnslistModel", (Throwable)e);
            return null;
        }
    }

    private List<MnsMnslist> queryMnslistModel(Map<String, Object> parammap) {
        try {
            return this.mnsMnslistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.queryMnslistModel", (Throwable)e);
            return null;
        }
    }

    private int countMnslist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsMnslistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.countMnslist", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        String msg = this.checkMnslist(mnsMnslistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnslist.checkMnslist", msg);
        }
        MnsMnslist mnsMnslist = this.makeMnslist(mnsMnslistDomainBean, null);
        this.setMnslistDefault(mnsMnslist);
        this.saveMnslistModel(mnsMnslist);
        mnsMnslistDomainBean.setMnslistId(mnsMnslist.getMnslistId());
        mnsMnslistDomainBean.setMnslistCode(mnsMnslist.getMnslistCode());
    }

    @Override
    public void saveSendMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        this.saveMnslist(mnsMnslistDomainBean);
        this.getSendService().putQueue(mnsMnslistDomainBean);
    }

    @Override
    public void saveBusinessMnslist(Map<String, Object> map) throws ApiException {
        String msg = this.checkBusinessMnslist(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveBusinessMnslist.checkMnslist", msg);
        }
        MnsMnslist mnsMnslist = this.makeBusinessMnslist(map);
        this.setMnslistDefault(mnsMnslist);
        this.saveMnslistModel(mnsMnslist);
    }

    @Override
    public void saveMnslistBatch(List<MnsMnslistDomainBean> list) throws ApiException {
        if (null != list && list.size() > 0) {
            for (MnsMnslistDomainBean mnsMnslist : list) {
                this.saveMnslist(mnsMnslist);
            }
        }
    }

    @Override
    public void updateMnslistState(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMnslistModel(mnslistId, dataState, oldDataState);
    }

    @Override
    public void updateMnslistStateSend(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMnslistModelSend(mnslistId, dataState, oldDataState);
    }

    @Override
    public void updateMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        String msg = this.checkMnslist(mnsMnslistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslist.checkMnslist", msg);
        }
        MnsMnslist oldMnsMnslist = this.getMnslistModelById(mnsMnslistDomainBean.getMnslistId());
        if (null == oldMnsMnslist) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnslist mnsMnslist = this.makeMnslist(mnsMnslistDomainBean, oldMnsMnslist);
        this.setMnslistUpdataDefault(mnsMnslist);
        this.updateMnslistModel(mnsMnslist);
    }

    @Override
    public MnsMnslist getMnslist(Integer mnslistId) {
        return this.getMnslistModelById(mnslistId);
    }

    @Override
    public void deleteMnslist(Integer mnslistId) throws ApiException {
        this.deleteMnslistModel(mnslistId);
    }

    @Override
    public QueryResult<MnsMnslist> queryMnslistPage(Map<String, Object> map) {
        List<MnsMnslist> mnsMnslistList = this.queryMnslistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMnslist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsMnslistList);
        return queryResult;
    }

    @Override
    public List<MnsMnslist> queryMnslist(Map<String, Object> map) {
        List<MnsMnslist> mnsMnslistList = this.queryMnslistModel(map);
        return mnsMnslistList;
    }

    @Override
    public void saveMnslistByNotContent(MnsMnslistDomainBean mnsMnslistDomainBean, Map<String, Object> map, String mnstemplateCode, boolean sendflag) throws ApiException {
        if (null != mnstemplateCode) {
            String content = this.mnstemplateService.getMnstemplateContent(mnstemplateCode, map);
            if (mnsMnslistDomainBean != null) {
                mnsMnslistDomainBean.setMnslistContent(content);
            }
        }
        this.saveMnslist(mnsMnslistDomainBean);
        if (mnsMnslistDomainBean.getMnslistId() != null && sendflag) {
            this.updateMnslistState(mnsMnslistDomainBean.getMnslistId(), MnsConstants.DATA_STATE_SUCCESS, null);
            this.sendMns(mnsMnslistDomainBean);
        }
    }

    private MnsMnsblistDomainBean makeMnsMnsblistDomainBean(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return null;
        }
        MnsMnsblistDomainBean mnsMnsblistDomainBean = new MnsMnsblistDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsblistDomainBean, (Object)mnsMnslistDomainBean);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBean", (Throwable)e);
        }
        return mnsMnsblistDomainBean;
    }

    private void getMnstemplateProperty(MnsMnsconfig mnsconfig, Map<String, String> paramMap) {
        Map mnstemplateProperty = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnsconfig.getMnstemplateProperty(), String.class, String.class);
        if (MapUtil.isNotEmpty((Map)mnstemplateProperty)) {
            for (String key : mnstemplateProperty.keySet()) {
                paramMap.put(key, (String)mnstemplateProperty.get(key));
            }
        }
    }

    private List<Map<String, String>> getManualmsgList(MnsMnslistDomainBean mnsMnslistDomain, MnsMnsconfig mnsconfig) {
        String manualmsgSubject = StringUtils.isEmpty((String)mnsMnslistDomain.getMnslistSubject()) ? mnsconfig.getMnstemplateDes() : mnsMnslistDomain.getMnslistSubject();
        String manualmsgContent = mnsconfig.getMnstemplateContent();
        String mnslistExp = mnsMnslistDomain.getMnslistExp();
        if (mnslistExp == null) {
            return null;
        }
        Map mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class);
        if (mapExp == null) {
            return null;
        }
        List auserList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
        Map paramMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap((String)mapExp.get("paramMap"), String.class, String.class);
        this.getMnstemplateProperty(mnsconfig, paramMap);
        mapExp.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson((Object)paramMap));
        mapExp.put("mnsMsgType", String.valueOf(mnsconfig.getMnsMsgType()));
        ArrayList<Map<String, String>> mnsList = new ArrayList<Map<String, String>>();
        String mnslistBusType = mnsMnslistDomain.getMnslistBustype();
        String mnslistBusName = mnsMnslistDomain.getMnslistBusname();
        Integer mnschannelType = mnsconfig.getMnschannelType();
        String appmanageIcode = mnsconfig.getAppmanageIcode();
        Integer hasInstantPush = mnsconfig.getHasInstantPush();
        Integer validDay = mnsconfig.getValidDay();
        String tenantCode = mnsMnslistDomain.getTenantCode();
        if (hasInstantPush == null) {
            hasInstantPush = 0;
        }
        String allcontent = "";
        mnsMnslistDomain.setMnslistSubject(manualmsgSubject);
        for (int i = 0; i < auserList.size(); ++i) {
            HashMap<String, String> imsgMap;
            Map mapAuser = (Map)auserList.get(i);
            HashMap<String, Object> amap = new HashMap<String, Object>();
            String manualmsgContentNew = this.getMnsContent(amap, mapAuser, paramMap, manualmsgContent);
            allcontent = allcontent + (null == manualmsgContentNew ? "" : manualmsgContentNew);
            String auserCode = (String)mapAuser.get("code");
            String auserName = (String)mapAuser.get("name");
            String callValidateUrl = mnsconfig.getCallValidateUrl();
            String code = (String)paramMap.get("code");
            HashMap<String, String> callMap = new HashMap<String, String>();
            String url = "";
            if (!StringUtils.isEmpty((String)callValidateUrl) && !StringUtils.isEmpty((String)code)) {
                callMap.putAll(paramMap);
                callMap.put("callValidateUrl", callValidateUrl);
                callMap.put("tenantCode", tenantCode);
                callMap.put("acceptCode", auserCode);
                callMap.put("mnschannelType", String.valueOf(mnschannelType));
                url = JsonUtil.buildNonDefaultBinder().toJson(callMap);
            }
            if (null != mnschannelType && mnschannelType == 3) {
                imsgMap = new HashMap<String, String>();
                imsgMap.put("imsgSubject", manualmsgSubject);
                imsgMap.put("imsgContent", manualmsgContentNew);
                imsgMap.put("imsgType", "0");
                imsgMap.put("imsgSuserCode", "sys");
                imsgMap.put("imsgSuserName", "sys");
                imsgMap.put("imsgAuserCode", auserCode);
                imsgMap.put("imsgAuserName", auserName);
                imsgMap.put("tenantCode", tenantCode);
                imsgMap.put("mnschannelType", String.valueOf(mnschannelType));
                mnsList.add(imsgMap);
                continue;
            }
            if (null != mnschannelType && mnschannelType == 2) {
                imsgMap = new HashMap();
                imsgMap.put("pushmsgSubject", manualmsgSubject);
                imsgMap.put("pushmsgContent", manualmsgContentNew);
                imsgMap.put("pushmsgType", (String)mapExp.get("pushmsgType"));
                imsgMap.put("pushmsgJpushType", (String)mapExp.get("pushmsgJpushType"));
                imsgMap.put("pushmsgSuserCode", this.imsgSenders(mapExp)[0]);
                imsgMap.put("pushmsgSuserName", this.imsgSenders(mapExp)[1]);
                imsgMap.put("pushmsgAuserCode", auserCode);
                imsgMap.put("pushmsgAuserName", auserName);
                imsgMap.put("pushmsgSenddate", (String)mapExp.get("pushmsgSenddate"));
                imsgMap.put("pushmsgExp", JsonUtil.buildNonDefaultBinder().toJson((Object)mapExp));
                imsgMap.put("tenantCode", tenantCode);
                imsgMap.put("hasInstantPush", hasInstantPush.toString());
                imsgMap.put("mnsMsgType", String.valueOf(mnsconfig.getMnsMsgType()));
                imsgMap.put("appmanageIcode", appmanageIcode);
                imsgMap.put("callValidateUrl", url);
                imsgMap.put("mnschannelType", String.valueOf(mnschannelType));
                if (validDay != null) {
                    imsgMap.put("validDay", validDay.toString());
                }
                mnsList.add(imsgMap);
                continue;
            }
            HashMap<String, String> mnsMap = new HashMap<String, String>();
            mnsMap.put("mnschannelType", String.valueOf(mnschannelType));
            mnsMap.put("mnslistSubject", manualmsgSubject);
            mnsMap.put("mnslistContent", manualmsgContentNew);
            mnsMap.put("mnslistSource", "0");
            mnsMap.put("mnslistBusType", mnslistBusType);
            mnsMap.put("mnslistBusName", mnslistBusName);
            mnsMap.put("mnslistActiveid", mnsMnslistDomain.getMnslistActiveid());
            mnsMap.put("tenantCode", tenantCode);
            mapExp.remove("receiverList");
            ArrayList listReceiver = new ArrayList();
            HashMap<String, String> mapReceiver = new HashMap<String, String>();
            mapReceiver.put("code", auserCode);
            mapReceiver.put("name", auserName);
            mapReceiver.put("telphone", (String)mapAuser.get("telphone"));
            mapReceiver.put("email", (String)mapAuser.get("email"));
            listReceiver.add(mapReceiver);
            mapExp.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
            mnsMap.put("mnslistExp", JsonUtil.buildNonDefaultBinder().toJson((Object)mapExp));
            mnsList.add(mnsMap);
        }
        mnsMnslistDomain.setMnslistContent(allcontent);
        return mnsList;
    }

    private String[] imsgSenders(Map<String, String> mapExp) {
        String[] imsgSenders = new String[]{"sys", "sys"};
        if (StringUtils.isBlank((String)mapExp.get("imsgSuserCode")) || StringUtils.isBlank((String)mapExp.get("imsgSuserName"))) {
            Map senderMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mapExp.get("sender"), String.class, String.class);
            if (MapUtil.isNotEmpty((Map)senderMap)) {
                imsgSenders[0] = (String)senderMap.get("code");
                imsgSenders[1] = (String)senderMap.get("name");
            }
        } else {
            imsgSenders[0] = mapExp.get("imsgSuserCode");
            imsgSenders[1] = mapExp.get("imsgSuserName");
        }
        return imsgSenders;
    }

    private String getMnsContent(Map<String, Object> amap, Map<String, String> mapAuser, Map<String, String> paramMap, String manualmsgContent) {
        if (MapUtil.isNotEmpty(paramMap)) {
            for (String key : paramMap.keySet()) {
                amap.put(key, paramMap.get(key));
            }
        }
        if (MapUtil.isNotEmpty(mapAuser)) {
            for (String key : mapAuser.keySet()) {
                amap.put(key, mapAuser.get(key));
            }
        }
        return MnslistServiceImpl.getContent(amap, manualmsgContent);
    }

    @Override
    public void autoSendMsg() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", MnsConstants.DATA_STATE_WAITSEND);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<MnsMnslist> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getSendService().getPage());
                result = this.queryMnslistPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getSendService().addPutPool(new SendPutThread(this.getSendService(), result.getRows()));
                    if (result.getRows().size() == this.getSendService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    private List<MnsMnsconfig> getMnsconfig(String busType, String tenantCode, boolean exeFlag) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.put("mnsconfigBusType", busType);
        map.put("dataState", "1");
        map.put("tenantCode", tenantCode);
        QueryResult<MnsMnsconfig> mnsconfigResult = this.mnsconfigService.queryMnsconfigPage(map);
        List mnsMnsconfigList = null;
        if (null != mnsconfigResult) {
            mnsMnsconfigList = mnsconfigResult.getList();
            if (CollectionUtils.isEmpty((Collection)mnsMnsconfigList) && exeFlag) {
                for (MnsMnsconfig mnsMnsconfig : mnsMnsconfigList) {
                    mnsMnsconfig.setMnsMnstemplate(this.mnstemplateService.getMnstemplate(mnsMnsconfig.getMnstemplateCode(), "00000000"));
                }
                exeFlag = false;
                if (!"00000000".equals(tenantCode)) {
                    return this.getMnsconfig(busType, "00000000", exeFlag);
                }
                return null;
            }
            return mnsMnsconfigList;
        }
        if (!"00000000".equals(tenantCode)) {
            return this.getMnsconfig(busType, "00000000", exeFlag);
        }
        return null;
    }

    @Override
    public void saveSend(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        this.updateMnslistStateSend(mnsMnslistDomainBean.getMnslistId(), MnsConstants.DATA_STATE_SUCCESS, null);
        this.sendMns(mnsMnslistDomainBean);
    }

    @Override
    public void sendMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return;
        }
        this.saveMnslist(mnsMnslistDomainBean);
        this.getSendService().putQueue(mnsMnslistDomainBean);
    }

    private void sendMns(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return;
        }
        String busType = mnsMnslistDomainBean.getMnslistBustype();
        boolean exeFlag = true;
        List<MnsMnsconfig> mnsMnsconfigList = this.getMnsconfig(busType, mnsMnslistDomainBean.getTenantCode(), exeFlag);
        if (CollectionUtils.isEmpty(mnsMnsconfigList)) {
            this.logger.error("mns.MNS.MnslistServiceImpl_sendMnslist", (Object)("\u672a\u627e\u5230\u63a8\u9001\u914d\u7f6e\u4fe1\u606f mnsconfig->busType=" + busType + ",tenantCode=" + mnsMnslistDomainBean.getTenantCode()));
            return;
        }
        Map paramMap = null;
        if (StringUtils.isNotBlank((String)mnsMnslistDomainBean.getMnslistExp())) {
            paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(mnsMnslistDomainBean.getMnslistExp(), String.class, String.class);
        }
        if (MapUtil.isEmpty(paramMap)) {
            this.logger.error("mns.MNS.MnslistServiceImpl_sendMnslist.paramMap");
            return;
        }
        for (MnsMnsconfig mnsconfig : mnsMnsconfigList) {
            this.sendMns(mnsMnslistDomainBean, paramMap, mnsconfig);
        }
    }

    private void sendMns(MnsMnslistDomainBean mnsMnslistDomainBean, Map<String, String> paramMap, MnsMnsconfig mnsconfig) {
        if (null == mnsMnslistDomainBean || null == paramMap || null == mnsconfig) {
            return;
        }
        paramMap.put("mnslistSubject", null == mnsMnslistDomainBean.getMnslistSubject() ? mnsconfig.getMnstemplateDes() : mnsMnslistDomainBean.getMnslistSubject());
        paramMap.put("mnslistContent", mnsconfig.getMnstemplateContent());
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        Integer mnschannelType = mnsconfig.getMnschannelType();
        if (null == mnschannelType) {
            this.logger.error("mns.MNS.MnslistServiceImplsendMns.mnschannelType");
            return;
        }
        List<Map<String, String>> mnsList = this.getManualmsgList(mnsMnslistDomainBean, mnsconfig);
        if (CollectionUtils.isEmpty(mnsList)) {
            this.logger.error("mns.MNS.MnslistServiceImplsendMns.mnsList");
            return;
        }
        if (MnsConstants.MNSLIST_TYPE_INNERMES.equals(mnschannelType)) {
            for (Map<String, String> imsgMap : mnsList) {
                sendMap.put("map", JsonUtil.buildNormalBinder().toJson(imsgMap));
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
            }
        } else if (MnsConstants.MNSLIST_TYPE_APP.equals(mnschannelType)) {
            for (Map<String, String> pushmsgMap : mnsList) {
                sendMap.put("imsgPushmsgDomain", JsonUtil.buildNormalBinder().toJson(pushmsgMap));
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
            }
        } else if (MnsConstants.MNSLIST_TYPE_SHORTMES.equals(mnschannelType)) {
            this.mnsSendPhoneService.saveSendMsg(mnsList, mnsconfig);
        } else if (MnsConstants.MNSLIST_TYPE_EMAIL.equals(mnschannelType)) {
            this.sendEmailBatch(mnsList, mnsconfig);
        }
        this.saveBatchMnslist(mnsMnslistDomainBean, mnsconfig, "1");
    }

    private void sendShortMesBatch(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            Map mapExp;
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            String apikey = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(mnsconfig.getTenantCode() + "-mns-phoneApiKey"));
            if (StringUtils.isEmpty((String)apikey)) continue;
            sendMap.put("apikey", apikey);
            String context = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)context)) continue;
            sendMap.put("text", context);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null) continue;
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                sendMap.put("mobile", telphone);
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
            }
        }
    }

    private void sendEmailBatch(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            String mnslistSubject = map.get("mnslistSubject");
            if (StringUtils.isEmpty((String)mnslistSubject)) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mnslistSubject");
                continue;
            }
            paramMap.put("mnslistSubject", mnslistSubject);
            String mnslistContent = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)mnslistContent)) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mnslistContent");
                continue;
            }
            paramMap.put("mnslistContent", mnslistContent);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mnslistExp");
                continue;
            }
            Map mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class);
            if (mapExp == null) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mapExp");
                continue;
            }
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            ArrayList<String> listMns = new ArrayList<String>();
            for (Map receiverMap : receiverList) {
                String email = (String)receiverMap.get("email");
                if (StringUtils.isEmpty((String)email)) {
                    this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.email");
                    continue;
                }
                listMns.add(email);
            }
            if (CollectionUtils.isEmpty(listMns)) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.listMns");
                continue;
            }
            paramMap.put("to", JsonUtil.buildNormalBinder().toJson(listMns));
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
        }
    }

    private void saveBatchMnslist(MnsMnslistDomainBean mnsMnslistDomainBean, MnsMnsconfig mnsconfig, String flag) {
        if (null == mnsMnslistDomainBean || null == mnsconfig) {
            return;
        }
        MnsMnslistDomainBean mnsMnslist = new MnsMnslistDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnslist, (Object)mnsMnslistDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mnsMnslist.setMnschannelType(mnsconfig.getMnschannelType());
        mnsMnslist.setMnslistSubject(mnsMnslistDomainBean.getMnslistSubject());
        mnsMnslist.setMnslistContent(mnsMnslistDomainBean.getMnslistContent());
        mnsMnslist.setMnslistSource(mnsMnslistDomainBean.getMnslistSource());
        mnsMnslist.setMnslistBustype(mnsMnslistDomainBean.getMnslistBustype());
        mnsMnslist.setMnslistBusname(mnsMnslistDomainBean.getMnslistBusname());
        mnsMnslist.setMnslistActiveid(mnsMnslistDomainBean.getMnslistActiveid());
        mnsMnslist.setMnslistExp(mnsMnslistDomainBean.getMnslistExp());
        mnsMnslist.setMnschannelCode(mnsconfig.getMnschannelCode());
        mnsMnslist.setMnschannelName(mnsconfig.getMnschannelName());
        if (StringUtils.isNotBlank((String)flag) && "1".equals(flag)) {
            this.mnsblistService.saveMnsblist(this.makeMnsMnsblistDomainBean(mnsMnslist));
            this.deleteMnslistModelByCode(mnsMnslistDomainBean.getMnslistCode(), mnsMnslistDomainBean.getTenantCode());
        }
    }

    @Override
    public void saveMnslistByCode(String mnschannelCode, String mnstemplateCode, Map<String, Object> map, boolean sendflag) throws ApiException {
        MnsMnslistDomainBean mnslistDomainBean = new MnsMnslistDomainBean();
        mnslistDomainBean.setMnslistExp(JsonUtil.buildNormalBinder().toJson(map));
        mnslistDomainBean.setMnslistSubject(map.get("mnslistSubject").toString());
        mnslistDomainBean.setMnslistBustype(map.get("mnslistBusType").toString());
        Map mnschannel = this.getQueryParamMap("mnschannelCode", new Object[]{mnschannelCode});
        QueryResult<MnsMnschannel> qr = this.mnschannelService.queryMnschannelPage(mnschannel);
        if (ListUtil.isEmpty((Collection)qr.getList())) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnslistByCode.mnsMnschannel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnschannel mnsMnschannel = (MnsMnschannel)qr.getList().get(0);
        if (map.get("tenantCode") != null) {
            mnsMnschannel.setTenantCode((String)map.get("tenantCode"));
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnslistDomainBean, (Object)mnsMnschannel);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.saveMnslistByCode.mnsMnschannel.null", (Object)"\u6570\u636e\u8f6c\u6362\u4e3aDomian\u9519\u8bef");
        }
        this.saveMnslistByNotContent(mnslistDomainBean, map, mnstemplateCode, sendflag);
    }

    @Override
    public List<Map<String, Object>> queryNumByTenantCode(Map<String, Object> map) {
        return this.queryNumByTenantCodeModel(map);
    }

    private List<Map<String, Object>> queryNumByTenantCodeModel(Map<String, Object> map) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((MnslistService)SpringApplicationContextUtil.getBean((String)"mnslistService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    static {
        lock = new Object();
    }
}

