/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.dao.MnsMnsfeeChannelMapper;
import com.yqbsoft.laser.service.mns.dao.MnsMnsfeeMapper;
import com.yqbsoft.laser.service.mns.domain.MnsMnsfeeChannelDomain;
import com.yqbsoft.laser.service.mns.domain.MnsMnsfeeChannelReDomain;
import com.yqbsoft.laser.service.mns.domain.MnsMnsfeeDomain;
import com.yqbsoft.laser.service.mns.domain.MnsMnsfeeReDomain;
import com.yqbsoft.laser.service.mns.model.MnsMnsfee;
import com.yqbsoft.laser.service.mns.model.MnsMnsfeeChannel;
import com.yqbsoft.laser.service.mns.service.MnsMnsfeeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class MnsMnsfeeServiceImpl
extends BaseServiceImpl
implements MnsMnsfeeService {
    private static final String SYS_CODE = "MnsMnsfeeServiceImpl";
    private MnsMnsfeeMapper mnsMnsfeeMapper;
    private MnsMnsfeeChannelMapper mnsMnsfeeChannelMapper;
    String cache = "Mnsfee-mnschannelCode";

    public void setMnsMnsfeeMapper(MnsMnsfeeMapper mnsMnsfeeMapper) {
        this.mnsMnsfeeMapper = mnsMnsfeeMapper;
    }

    public void setMnsMnsfeeChannelMapper(MnsMnsfeeChannelMapper mnsMnsfeeChannelMapper) {
        this.mnsMnsfeeChannelMapper = mnsMnsfeeChannelMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsMnsfeeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMnsfee(MnsMnsfeeDomain mnsMnsfeeDomain) {
        if (null == mnsMnsfeeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mnsMnsfeeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMnsfeeDefault(MnsMnsfee mnsMnsfee) {
        if (null == mnsMnsfee) {
            return;
        }
        if (null == mnsMnsfee.getDataState()) {
            mnsMnsfee.setDataState(0);
        }
        if (null == mnsMnsfee.getGmtCreate()) {
            mnsMnsfee.setGmtCreate(this.getSysDate());
        }
        mnsMnsfee.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mnsMnsfee.getMnsfeeCode())) {
            mnsMnsfee.setMnsfeeCode(this.getNo(null, "MnsMnsfee", "mnsMnsfee", mnsMnsfee.getTenantCode()));
        }
    }

    private int getMnsfeeMaxCode() {
        int code = 0;
        try {
            return this.mnsMnsfeeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getMnsfeeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMnsfeeUpdataDefault(MnsMnsfee mnsMnsfee) {
        if (null == mnsMnsfee) {
            return;
        }
        mnsMnsfee.setGmtModified(this.getSysDate());
    }

    private void saveMnsfeeModel(MnsMnsfee mnsMnsfee) throws ApiException {
        if (null == mnsMnsfee) {
            return;
        }
        try {
            this.mnsMnsfeeMapper.insert(mnsMnsfee);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.saveMnsfeeModel.ex", (Throwable)e);
        }
    }

    private void saveMnsfeeBatchModel(List<MnsMnsfee> mnsMnsfeeList) throws ApiException {
        if (null == mnsMnsfeeList || mnsMnsfeeList.isEmpty()) {
            return;
        }
        try {
            this.mnsMnsfeeMapper.insertBatch(mnsMnsfeeList);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.saveMnsfeeBatchModel.ex", (Throwable)e);
        }
    }

    private MnsMnsfee getMnsfeeModelById(Integer mnsfeeId) {
        if (null == mnsfeeId) {
            return null;
        }
        try {
            return this.mnsMnsfeeMapper.selectByPrimaryKey(mnsfeeId);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getMnsfeeModelById", (Throwable)e);
            return null;
        }
    }

    private MnsMnsfee getMnsfeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mnsMnsfeeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getMnsfeeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMnsfeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.delMnsfeeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("MnsMnsfeeServiceImpl.delMnsfeeModelByCode.num");
        }
    }

    private void deleteMnsfeeModel(Integer mnsfeeId) throws ApiException {
        if (null == mnsfeeId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeMapper.deleteByPrimaryKey(mnsfeeId);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.deleteMnsfeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("MnsMnsfeeServiceImpl.deleteMnsfeeModel.num");
        }
    }

    private void updateMnsfeeModel(MnsMnsfee mnsMnsfee) throws ApiException {
        if (null == mnsMnsfee) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeMapper.updateByPrimaryKey(mnsMnsfee);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfeeModel.num");
        }
    }

    private void updateStateMnsfeeModel(Integer mnsfeeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mnsfeeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnsfeeId", mnsfeeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeModel.null");
        }
    }

    private void updateStateMnsfeeModelByCode(String tenantCode, String mnsfeeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mnsfeeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsfeeCode", mnsfeeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeModelByCode.null");
        }
    }

    private MnsMnsfee makeMnsfee(MnsMnsfeeDomain mnsMnsfeeDomain, MnsMnsfee mnsMnsfee) {
        if (null == mnsMnsfeeDomain) {
            return null;
        }
        if (null == mnsMnsfee) {
            mnsMnsfee = new MnsMnsfee();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsfee, (Object)mnsMnsfeeDomain);
            return mnsMnsfee;
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.makeMnsfee", (Throwable)e);
            return null;
        }
    }

    private MnsMnsfeeReDomain makeMnsMnsfeeReDomain(MnsMnsfee mnsMnsfee) {
        if (null == mnsMnsfee) {
            return null;
        }
        MnsMnsfeeReDomain mnsMnsfeeReDomain = new MnsMnsfeeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsfeeReDomain, (Object)mnsMnsfee);
            return mnsMnsfeeReDomain;
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.makeMnsMnsfeeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MnsMnsfee> queryMnsfeeModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsMnsfeeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.queryMnsfeeModel", (Throwable)e);
            return null;
        }
    }

    private int countMnsfee(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsMnsfeeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.countMnsfee", (Throwable)e);
        }
        return i;
    }

    private MnsMnsfee createMnsMnsfee(MnsMnsfeeDomain mnsMnsfeeDomain) {
        String msg = this.checkMnsfee(mnsMnsfeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("MnsMnsfeeServiceImpl.saveMnsfee.checkMnsfee", msg);
        }
        MnsMnsfee mnsMnsfee = this.makeMnsfee(mnsMnsfeeDomain, null);
        this.setMnsfeeDefault(mnsMnsfee);
        return mnsMnsfee;
    }

    private String checkMnsfeeChannel(MnsMnsfeeChannelDomain mnsMnsfeeChannelDomain) {
        if (null == mnsMnsfeeChannelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mnsMnsfeeChannelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMnsfeeChannelDefault(MnsMnsfeeChannel mnsMnsfeeChannel) {
        if (null == mnsMnsfeeChannel) {
            return;
        }
        if (null == mnsMnsfeeChannel.getDataState()) {
            mnsMnsfeeChannel.setDataState(0);
        }
        if (null == mnsMnsfeeChannel.getGmtCreate()) {
            mnsMnsfeeChannel.setGmtCreate(this.getSysDate());
        }
        mnsMnsfeeChannel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mnsMnsfeeChannel.getMnsfeeChannelCode())) {
            mnsMnsfeeChannel.setMnsfeeChannelCode(this.getNo(null, "MnsMnsfeeChannel", "mnsMnsfeeChannel", mnsMnsfeeChannel.getTenantCode()));
        }
    }

    private int getMnsfeeChannelMaxCode() {
        int code = 0;
        try {
            return this.mnsMnsfeeChannelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getMnsfeeChannelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMnsfeeChannelUpdataDefault(MnsMnsfeeChannel mnsMnsfeeChannel) {
        if (null == mnsMnsfeeChannel) {
            return;
        }
        mnsMnsfeeChannel.setGmtModified(this.getSysDate());
    }

    private void saveMnsfeeChannelModel(MnsMnsfeeChannel mnsMnsfeeChannel) throws ApiException {
        if (null == mnsMnsfeeChannel) {
            return;
        }
        try {
            this.mnsMnsfeeChannelMapper.insert(mnsMnsfeeChannel);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.saveMnsfeeChannelModel.ex", (Throwable)e);
        }
    }

    private void saveMnsfeeChannelBatchModel(List<MnsMnsfeeChannel> mnsMnsfeeChannelList) throws ApiException {
        if (null == mnsMnsfeeChannelList || mnsMnsfeeChannelList.isEmpty()) {
            return;
        }
        try {
            this.mnsMnsfeeChannelMapper.insertBatch(mnsMnsfeeChannelList);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.saveMnsfeeChannelBatchModel.ex", (Throwable)e);
        }
    }

    private MnsMnsfeeChannel getMnsfeeChannelModelById(Integer mnsfeeChannelId) {
        if (null == mnsfeeChannelId) {
            return null;
        }
        try {
            return this.mnsMnsfeeChannelMapper.selectByPrimaryKey(mnsfeeChannelId);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getMnsfeeChannelModelById", (Throwable)e);
            return null;
        }
    }

    private MnsMnsfeeChannel getMnsfeeChannelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mnsMnsfeeChannelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.getMnsfeeChannelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMnsfeeChannelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeChannelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.delMnsfeeChannelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("MnsMnsfeeServiceImpl.delMnsfeeChannelModelByCode.num");
        }
    }

    private void deleteMnsfeeChannelModel(Integer mnsfeeChannelId) throws ApiException {
        if (null == mnsfeeChannelId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeChannelMapper.deleteByPrimaryKey(mnsfeeChannelId);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.deleteMnsfeeChannelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("MnsMnsfeeServiceImpl.deleteMnsfeeChannelModel.num");
        }
    }

    private void updateMnsfeeChannelModel(MnsMnsfeeChannel mnsMnsfeeChannel) throws ApiException {
        if (null == mnsMnsfeeChannel) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeChannelMapper.updateByPrimaryKey(mnsMnsfeeChannel);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfeeChannelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfeeChannelModel.num");
        }
    }

    private void updateStateMnsfeeChannelModel(Integer mnsfeeChannelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mnsfeeChannelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnsfeeChannelId", mnsfeeChannelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeChannelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeChannelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeChannelModel.null");
        }
    }

    private void updateStateMnsfeeChannelModelByCode(String tenantCode, String mnsfeeChannelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mnsfeeChannelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsfeeChannelCode", mnsfeeChannelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsMnsfeeChannelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeChannelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateStateMnsfeeChannelModelByCode.null");
        }
    }

    private MnsMnsfeeChannel makeMnsfeeChannel(MnsMnsfeeChannelDomain mnsMnsfeeChannelDomain, MnsMnsfeeChannel mnsMnsfeeChannel) {
        if (null == mnsMnsfeeChannelDomain) {
            return null;
        }
        if (null == mnsMnsfeeChannel) {
            mnsMnsfeeChannel = new MnsMnsfeeChannel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsfeeChannel, (Object)mnsMnsfeeChannelDomain);
            return mnsMnsfeeChannel;
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.makeMnsfeeChannel", (Throwable)e);
            return null;
        }
    }

    private MnsMnsfeeChannelReDomain makeMnsMnsfeeChannelReDomain(MnsMnsfeeChannel mnsMnsfeeChannel) {
        if (null == mnsMnsfeeChannel) {
            return null;
        }
        MnsMnsfeeChannelReDomain mnsMnsfeeChannelReDomain = new MnsMnsfeeChannelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsfeeChannelReDomain, (Object)mnsMnsfeeChannel);
            return mnsMnsfeeChannelReDomain;
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.makeMnsMnsfeeChannelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MnsMnsfeeChannel> queryMnsfeeChannelModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsMnsfeeChannelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.queryMnsfeeChannelModel", (Throwable)e);
            return null;
        }
    }

    private int countMnsfeeChannel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsMnsfeeChannelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("MnsMnsfeeServiceImpl.countMnsfeeChannel", (Throwable)e);
        }
        return i;
    }

    private MnsMnsfeeChannel createMnsMnsfeeChannel(MnsMnsfeeChannelDomain mnsMnsfeeChannelDomain) {
        String msg = this.checkMnsfeeChannel(mnsMnsfeeChannelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("MnsMnsfeeServiceImpl.saveMnsfeeChannel.checkMnsfeeChannel", msg);
        }
        MnsMnsfeeChannel mnsMnsfeeChannel = this.makeMnsfeeChannel(mnsMnsfeeChannelDomain, null);
        this.setMnsfeeChannelDefault(mnsMnsfeeChannel);
        return mnsMnsfeeChannel;
    }

    @Override
    public String saveMnsfee(MnsMnsfeeDomain mnsMnsfeeDomain) throws ApiException {
        MnsMnsfee mnsMnsfee = this.createMnsMnsfee(mnsMnsfeeDomain);
        this.saveMnsfeeModel(mnsMnsfee);
        return mnsMnsfee.getMnsfeeCode();
    }

    @Override
    public String saveMnsfeeBatch(List<MnsMnsfeeDomain> mnsMnsfeeDomainList) throws ApiException {
        if (null == mnsMnsfeeDomainList || mnsMnsfeeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MnsMnsfee> mnsMnsfeeList = new ArrayList<MnsMnsfee>();
        String code = "";
        for (MnsMnsfeeDomain mnsMnsfeeDomain : mnsMnsfeeDomainList) {
            MnsMnsfee mnsMnsfee = this.createMnsMnsfee(mnsMnsfeeDomain);
            code = mnsMnsfee.getMnsfeeCode();
            mnsMnsfeeList.add(mnsMnsfee);
        }
        this.saveMnsfeeBatchModel(mnsMnsfeeList);
        return code;
    }

    @Override
    public void updateMnsfeeState(Integer mnsfeeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateMnsfeeModel(mnsfeeId, dataState, oldDataState, map);
    }

    @Override
    public void updateMnsfeeStateByCode(String tenantCode, String mnsfeeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateMnsfeeModelByCode(tenantCode, mnsfeeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMnsfee(MnsMnsfeeDomain mnsMnsfeeDomain) throws ApiException {
        String msg = this.checkMnsfee(mnsMnsfeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfee.checkMnsfee", msg);
        }
        MnsMnsfee oldMnsMnsfee = this.getMnsfeeModelById(mnsMnsfeeDomain.getMnsfeeId());
        if (null == oldMnsMnsfee) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfee.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnsfee mnsMnsfee = this.makeMnsfee(mnsMnsfeeDomain, oldMnsMnsfee);
        this.setMnsfeeUpdataDefault(mnsMnsfee);
        this.updateMnsfeeModel(mnsMnsfee);
    }

    @Override
    public MnsMnsfee getMnsfee(Integer mnsfeeId) {
        return this.getMnsfeeModelById(mnsfeeId);
    }

    @Override
    public void deleteMnsfee(Integer mnsfeeId) throws ApiException {
        this.deleteMnsfeeModel(mnsfeeId);
    }

    @Override
    public QueryResult<MnsMnsfee> queryMnsfeePage(Map<String, Object> map) {
        List<MnsMnsfee> mnsMnsfeeList = this.queryMnsfeeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMnsfee(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsMnsfeeList);
        return queryResult;
    }

    @Override
    public MnsMnsfee getMnsfeeByCode(String tenantCode, String mnsfeeCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsfeeCode", mnsfeeCode);
        return this.getMnsfeeModelByCode(map);
    }

    @Override
    public void deleteMnsfeeByCode(String tenantCode, String mnsfeeCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsfeeCode", mnsfeeCode);
        this.delMnsfeeModelByCode(map);
    }

    @Override
    public String saveMnsfeeChannel(MnsMnsfeeChannelDomain mnsMnsfeeChannelDomain) throws ApiException {
        MnsMnsfeeChannel mnsMnsfeeChannel = this.createMnsMnsfeeChannel(mnsMnsfeeChannelDomain);
        this.saveMnsfeeChannelModel(mnsMnsfeeChannel);
        return mnsMnsfeeChannel.getMnsfeeChannelCode();
    }

    @Override
    public String saveMnsfeeChannelBatch(List<MnsMnsfeeChannelDomain> mnsMnsfeeChannelDomainList) throws ApiException {
        if (null == mnsMnsfeeChannelDomainList || mnsMnsfeeChannelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MnsMnsfeeChannel> mnsMnsfeeChannelList = new ArrayList<MnsMnsfeeChannel>();
        String code = "";
        for (MnsMnsfeeChannelDomain mnsMnsfeeChannelDomain : mnsMnsfeeChannelDomainList) {
            MnsMnsfeeChannel mnsMnsfeeChannel = this.createMnsMnsfeeChannel(mnsMnsfeeChannelDomain);
            code = mnsMnsfeeChannel.getMnsfeeChannelCode();
            mnsMnsfeeChannelList.add(mnsMnsfeeChannel);
        }
        this.saveMnsfeeChannelBatchModel(mnsMnsfeeChannelList);
        return code;
    }

    @Override
    public void updateMnsfeeChannelState(Integer mnsfeeChannelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateMnsfeeChannelModel(mnsfeeChannelId, dataState, oldDataState, map);
    }

    @Override
    public void updateMnsfeeChannelStateByCode(String tenantCode, String mnsfeeChannelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateMnsfeeChannelModelByCode(tenantCode, mnsfeeChannelCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMnsfeeChannel(MnsMnsfeeChannelDomain mnsMnsfeeChannelDomain) throws ApiException {
        String msg = this.checkMnsfeeChannel(mnsMnsfeeChannelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfeeChannel.checkMnsfeeChannel", msg);
        }
        MnsMnsfeeChannel oldMnsMnsfeeChannel = this.getMnsfeeChannelModelById(mnsMnsfeeChannelDomain.getMnsfeeChannelId());
        if (null == oldMnsMnsfeeChannel) {
            throw new ApiException("MnsMnsfeeServiceImpl.updateMnsfeeChannel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnsfeeChannel mnsMnsfeeChannel = this.makeMnsfeeChannel(mnsMnsfeeChannelDomain, oldMnsMnsfeeChannel);
        this.setMnsfeeChannelUpdataDefault(mnsMnsfeeChannel);
        this.updateMnsfeeChannelModel(mnsMnsfeeChannel);
    }

    @Override
    public MnsMnsfeeChannel getMnsfeeChannel(Integer mnsfeeChannelId) {
        return this.getMnsfeeChannelModelById(mnsfeeChannelId);
    }

    @Override
    public void deleteMnsfeeChannel(Integer mnsfeeChannelId) throws ApiException {
        this.deleteMnsfeeChannelModel(mnsfeeChannelId);
    }

    @Override
    public QueryResult<MnsMnsfeeChannel> queryMnsfeeChannelPage(Map<String, Object> map) {
        List<MnsMnsfeeChannel> mnsMnsfeeChannelList = this.queryMnsfeeChannelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMnsfeeChannel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsMnsfeeChannelList);
        return queryResult;
    }

    @Override
    public MnsMnsfeeChannel getMnsfeeChannelByCode(String tenantCode, String mnsfeeChannelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsfeeChannelCode", mnsfeeChannelCode);
        return this.getMnsfeeChannelModelByCode(map);
    }

    @Override
    public void deleteMnsfeeChannelByCode(String tenantCode, String mnsfeeChannelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsfeeChannelCode", mnsfeeChannelCode);
        this.delMnsfeeChannelModelByCode(map);
    }

    @Override
    public void queryMnsfeeCache() {
        this.info("MnsMnsfeeServiceImpl.queryMnsfeeCache.start", "=======queryMnsfeeCache\u8c03\u5ea6start=======");
        List<MnsMnsfee> mnsMnsfeeList = this.queryMnsfeeModelPage(null);
        if (CollectionUtils.isEmpty(mnsMnsfeeList)) {
            DisUtil.delVer((String)this.cache);
            this.info("MnsMnsfeeServiceImpl.queryMnsfeeCache.null", "=======queryMnsfeeCache\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        for (MnsMnsfee mnsMnsfee : mnsMnsfeeList) {
            parammap.put("tenantCode", mnsMnsfee.getTenantCode());
            parammap.put("mnsfeeCode", mnsMnsfee.getMnsfeeCode());
            List<MnsMnsfeeChannel> mnsMnsfeeChannelList = this.queryMnsfeeChannelModelPage(parammap);
            if (ListUtil.isNotEmpty(mnsMnsfeeChannelList)) {
                for (MnsMnsfeeChannel mnsMnsfeeChannel : mnsMnsfeeChannelList) {
                    map.put(mnsMnsfeeChannel.getMnschannelCode() + "-" + mnsMnsfee.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsfee));
                }
                continue;
            }
            map.put("all-" + mnsMnsfee.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsfee));
        }
        DisUtil.setMap((String)this.cache, map);
        this.info("MnsMnsfeeServiceImpl.queryMnsfeeCache.end", "=======queryMnsfeeCache\u8c03\u5ea6end=======");
    }
}

