/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.freemarker.FreemarkerUtil;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistReDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnsmemlistDomain;
import com.yqbsoft.laser.service.mns.domain.UmUserDomain;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.model.MnsMnsfee;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistPollThread;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistService;
import com.yqbsoft.laser.service.mns.service.MnsMnsmemlistService;
import com.yqbsoft.laser.service.mns.service.MnsSendPhoneService;
import com.yqbsoft.laser.service.mns.service.MnsblistService;
import com.yqbsoft.laser.service.mns.service.MnslistService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class MnsSendPhoneServiceImpl
extends BaseServiceImpl
implements MnsSendPhoneService {
    public static final String SYS_CODE = "mns.MNS.MnsSendPhoneServiceImpl";
    private MnsMnsmemlistService mnsMnsmemlistService;
    private static SendMnsBlistService sendMnsBlistService;
    private static Object lock;
    private MnsblistService mnsblistService;

    public void setMnsblistService(MnsblistService mnsblistService) {
        this.mnsblistService = mnsblistService;
    }

    public void setMnsMnsmemlistService(MnsMnsmemlistService mnsMnsmemlistService) {
        this.mnsMnsmemlistService = mnsMnsmemlistService;
    }

    @Override
    public List<MnsMnsblistDomainBean> saveSendMsg(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return null;
        }
        if ("0001".equals(mnsconfig.getMnschannelCode())) {
            return this.sendMsgAliDaYu(mnsList, mnsconfig);
        }
        if ("0002".equals(mnsconfig.getMnschannelCode())) {
            return this.sendMsgAliDaYu(mnsList, mnsconfig);
        }
        if ("0004".equals(mnsconfig.getMnschannelCode())) {
            return this.sendMsgAliDaYu(mnsList, mnsconfig);
        }
        if ("0005".equals(mnsconfig.getMnschannelCode())) {
            return this.sendMsgAliDaYu(mnsList, mnsconfig);
        }
        if ("0006".equals(mnsconfig.getMnschannelCode())) {
            this.sendMsgWechat(mnsList, mnsconfig);
        } else {
            this.sendMsg(mnsList, mnsconfig);
        }
        return null;
    }

    private void sendMsgChuanlan(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        String key = "00000000-msg-clParams";
        String params = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        if (StringUtils.isEmpty((String)params)) {
            this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.key-->\u3010" + key + "\u3011.error", (Object)"\u77ed\u4fe1\u6e20\u9053\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        Map paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(params, String.class, Object.class);
        if (paramMap == null) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            List receiverList;
            Map mapExp;
            String context = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)context)) continue;
            paramMap.put("msg", context);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null || (receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class)) == null || receiverList.isEmpty()) continue;
            String phoneNos = "";
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                phoneNos = StringUtils.isBlank((String)phoneNos) ? telphone : phoneNos + "," + telphone;
            }
            if (StringUtils.isBlank((String)phoneNos)) continue;
            this.logger.debug("mns.MNS.MnsSendPhoneServiceImpl.sendMsgChuanlan", (Object)("\u624b\u673a\u53f7-->" + phoneNos));
            paramMap.put("mobile", phoneNos);
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", paramMap);
        }
    }

    private void sendMsg(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (Map<String, String> map : mnsList) {
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            paramMap.put("mnsconfig", JsonUtil.buildNormalBinder().toJson((Object)mnsconfig));
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", paramMap);
        }
    }

    private List<MnsMnsblistDomainBean> sendMsgAliDaYu(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return null;
        }
        ArrayList<MnsMnsblistDomainBean> list = new ArrayList<MnsMnsblistDomainBean>();
        for (Map<String, String> map : mnsList) {
            Map mapExp;
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null) continue;
            Map randomParamMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap((String)mapExp.get("paramMap"), String.class, String.class);
            String code = map.get("mnslistCode");
            String dataTenant = map.get("dataTenant");
            String tenantCode = map.get("tenantCode");
            String memberCode = map.get("memberCode");
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            if (receiverList == null || receiverList.isEmpty()) continue;
            String phoneNos = "";
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                phoneNos = StringUtils.isBlank((String)phoneNos) ? telphone : phoneNos + "," + telphone;
            }
            if (StringUtils.isBlank((String)phoneNos)) continue;
            String patam = this.getContent(mnsconfig.getMnsMnstemplate().getMnstemplateContent(), randomParamMap);
            int res = (int)this.getSize(mnsconfig.getMnsMnstemplate().getMnstemplateKey() + patam);
            if (!this.saveList(dataTenant, mnsconfig, res)) {
                throw new ApiException("mns.MNS.MnsSendPhoneServiceImpl.sendMsgAliDaYu.saveList");
            }
            MnsMnsblistReDomainBean mnsMnsblistDomainBean = new MnsMnsblistReDomainBean();
            mnsMnsblistDomainBean.setMnslistPhone(phoneNos);
            mnsMnsblistDomainBean.setMnslistSubject(map.get("mnslistSubject"));
            mnsMnsblistDomainBean.setMnslistState("1");
            mnsMnsblistDomainBean.setMnslistNum(res);
            mnsMnsblistDomainBean.setDataState(0);
            mnsMnsblistDomainBean.setMnslistCode(code);
            mnsMnsblistDomainBean.setMnschannelCode(mnsconfig.getMnschannelCode());
            mnsMnsblistDomainBean.setMnschannelName(mnsconfig.getMnschannelName());
            mnsMnsblistDomainBean.setAppapiCode(mnsconfig.getAppapiCode());
            mnsMnsblistDomainBean.setAppapiVersion(mnsconfig.getAppapiVersion());
            mnsMnsblistDomainBean.setMnslistContent(patam);
            mnsMnsblistDomainBean.setMnslistExp(mnslistExp);
            mnsMnsblistDomainBean.setDataTenant(dataTenant);
            mnsMnsblistDomainBean.setTenantCode(tenantCode);
            mnsMnsblistDomainBean.setMnslistBustype(mnsconfig.getMnsconfigBustype());
            mnsMnsblistDomainBean.setMnslistBusname(mnsconfig.getMnsconfigBusname());
            mnsMnsblistDomainBean.setMnslistSource(0);
            mnsMnsblistDomainBean.setMemberCode(memberCode);
            this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
            list.add(mnsMnsblistDomainBean);
        }
        return list;
    }

    private void sendMsgWechat(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (null == mnsconfig || null == mnsconfig.getMnsMnstemplate() || null == mnsconfig.getMnsMnstemplate().getMnstemplateContent()) {
            this.logger.info("mns.MNS.MnsSendPhoneServiceImpl.sendMsgWechat", (Object)(mnsList.toString() + "|" + JsonUtil.buildNormalBinder().toJson((Object)mnsconfig)));
            return;
        }
        String mnstemplateContent = mnsconfig.getMnsMnstemplate().getMnstemplateContent();
        for (Map<String, String> map : mnsList) {
            List auserList;
            Map paramMap;
            String mnslistExp = map.get("mnslistExp");
            String tenantCode = map.get("tenantCode");
            if (mnslistExp == null || null == tenantCode || MapUtil.isEmpty((Map)(paramMap = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(mnslistExp, String.class, String.class))) || null == paramMap.get("receiverList") || ListUtil.isEmpty((Collection)(auserList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)paramMap.get("receiverList"), Map.class)))) continue;
            for (Map marapusermap : auserList) {
                UmUserDomain umUserDomain = this.getUmUserByPcode(tenantCode, (String)marapusermap.get("code"));
                if (null == umUserDomain || StringUtils.isBlank((String)umUserDomain.getUserOpenid())) continue;
                marapusermap.put("openId", umUserDomain.getUserOpenid());
                String template_id = mnsconfig.getMnsMnstemplate().getMnstemplateOcode();
                marapusermap.put("template_id", template_id);
                String sendJson = FreemarkerUtil.returnTranslateByString((Object)marapusermap, (String)mnstemplateContent);
                Map requestMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(sendJson, String.class, Object.class);
                HashMap<String, String> invokeMap = new HashMap<String, String>();
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("tenantCode", map.get("tenantCode"));
                invokeMap.put("fchannelCode", "wechatmini");
                invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(param));
                String access_Token = this.internalInvoke("cmc.channelToken.getToken", invokeMap);
                if (StringUtils.isBlank((String)access_Token)) {
                    this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.invokeMap", (Object)((Object)invokeMap).toString());
                    return;
                }
                this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.sendMsgWechat.access_Token", (Object)access_Token);
                String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=ACCESS_TOKEN";
                requestUrl = requestUrl.replace("ACCESS_TOKEN", access_Token);
                String result = "";
                try {
                    result = WebUtils.doPostJson((String)requestUrl, (Map)requestMap, (int)100000, (int)100000);
                    if (StringUtils.isBlank((String)result)) {
                        this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.sendMsgWechat", (Object)(result + "+(result\u4e3a\u7a7a)"));
                    }
                    this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.result", (Object)result);
                    this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.result", (Object)requestMap.toString());
                }
                catch (IOException e) {
                    this.logger.error("mns.MNS.MnsSendPhoneServiceImpl.sendMsgWechat", (Object)result, (Throwable)e);
                }
            }
        }
    }

    protected UmUserDomain getUmUserByPcode(String tenantCode, String userPcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userPcode)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("userPhone", userPcode);
        String umUserJson = (String)this.getInternalRouter().inInvoke("um.user.getUserByPcode", map);
        return (UmUserDomain)JsonUtil.buildNormalBinder().getJsonToObject(umUserJson, UmUserDomain.class);
    }

    private boolean saveList(String dataTenant, MnsMnsconfig mnsconfig, int res) {
        String falg;
        if (null == mnsconfig) {
            return false;
        }
        MnsMnsfee mnsMnsfee = (MnsMnsfee)DisUtil.getMapJson((String)"Mnsfee-mnschannelCode", (String)(mnsconfig.getMnschannelCode() + "-0-" + mnsconfig.getTenantCode()), MnsMnsfee.class);
        if (null == mnsMnsfee) {
            mnsMnsfee = (MnsMnsfee)DisUtil.getMapJson((String)"Mnsfee-mnschannelCode", (String)("all-0-" + mnsconfig.getTenantCode()), MnsMnsfee.class);
        }
        if (null == mnsMnsfee) {
            return true;
        }
        MnsMnsmemlistDomain mnsMnsmemlist = new MnsMnsmemlistDomain();
        mnsMnsmemlist.setMnsmemlistType("1");
        mnsMnsmemlist.setMnschannelType(0);
        mnsMnsmemlist.setMnsmemlistState(0);
        mnsMnsmemlist.setMnsfeeType(mnsMnsfee.getMnsfeeType());
        mnsMnsmemlist.setMnsfeeCyc(mnsMnsfee.getMnsfeeCyc());
        mnsMnsmemlist.setMnsfeeName(mnsMnsfee.getMnsfeeName());
        mnsMnsmemlist.setMnsfeeCode(mnsMnsfee.getMnsfeeCode());
        mnsMnsmemlist.setMnsmemfeeDes(mnsMnsfee.getMnsfeeDes());
        mnsMnsmemlist.setMnsfeePrice(mnsMnsfee.getMnsfeePrice());
        mnsMnsmemlist.setMnsmemlistNum(res);
        mnsMnsmemlist.setMemberCode(mnsconfig.getMnsMnstemplate().getMemberCode());
        mnsMnsmemlist.setMemberName(mnsconfig.getMnsMnstemplate().getMemberName());
        mnsMnsmemlist.setUserCode(mnsconfig.getMnsMnstemplate().getUserCode());
        mnsMnsmemlist.setUserName(mnsconfig.getMnsMnstemplate().getUserName());
        mnsMnsmemlist.setDataTenant(dataTenant);
        mnsMnsmemlist.setDataTenantname(mnsconfig.getMnsMnstemplate().getDataTenantname());
        mnsMnsmemlist.setTenantCode(mnsconfig.getMnsMnstemplate().getTenantCode());
        mnsMnsmemlist.setMemberCode(mnsconfig.getMemberCode());
        if (StringUtils.isNotBlank((String)mnsconfig.getMemberCode()) && "error".equals(falg = this.mnsMnsmemlistService.saveMnsmemlist(mnsMnsmemlist))) {
            throw new ApiException("mns.MNS.MnsSendPhoneServiceImpl.saveList.falg", "\u4f59\u989d\u4e0d\u8db3\uff0c\u53d1\u9001\u77ed\u4fe1\u5931\u8d25");
        }
        return true;
    }

    private double getSize(String temp) {
        double res = 1.0;
        double zong = temp.length();
        double one = zong - 70.0;
        if (one <= 0.0) {
            return res;
        }
        double aa = one / 67.0;
        double ss = Math.floor(aa);
        if (aa > ss) {
            res = res + ss + 1.0;
        }
        return res;
    }

    private String getContent(String template, Map<String, String> map) {
        String temp = template;
        for (String key : map.keySet()) {
            temp = temp.replace("${" + key + "}", map.get(key));
        }
        return temp;
    }

    private void sendShortMesBatch(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            Map mapExp;
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            String apikey = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(mnsconfig.getTenantCode() + "-mns-" + "phoneApiKey"));
            if (StringUtils.isEmpty((String)apikey)) continue;
            sendMap.put("apikey", apikey);
            String context = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)context)) continue;
            sendMap.put("text", context);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null) continue;
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                this.logger.debug("mns.MNS.MnsSendPhoneServiceImpl_sendShortMesBatch", (Object)("\u624b\u673a\u53f7-->" + telphone));
                sendMap.put("mobile", telphone);
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendMnsBlistService getsendMnsBlistService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendMnsBlistService) {
                sendMnsBlistService = new SendMnsBlistService((MnslistService)SpringApplicationContextUtil.getBean((String)"mnslistService"));
                for (int i = 0; i < 20; ++i) {
                    sendMnsBlistService.addPollPool(new SendMnsBlistPollThread(sendMnsBlistService));
                }
            }
            return sendMnsBlistService;
        }
    }

    static {
        lock = new Object();
    }
}

