/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.mns.domain.OcContractReDomain;
import com.yqbsoft.laser.service.mns.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.mns.domain.UmUserinfo;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistPollThread;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistPutThread;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistService;
import com.yqbsoft.laser.service.mns.send.SendPollThread;
import com.yqbsoft.laser.service.mns.send.SendService;
import com.yqbsoft.laser.service.mns.service.MnsService;
import com.yqbsoft.laser.service.mns.service.MnslistService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MnsServiceImpl
extends BaseServiceImpl
implements MnsService {
    public static final String SYS_CODE = "mns.MNS.MnsServiceImpl";
    private static SendService sendService;
    private static SendMnsBlistService sendMnsBlistService;
    private static Object lock;
    private MnslistService mnslistService;

    public void setMnslistService(MnslistService mnslistService) {
        this.mnslistService = mnslistService;
    }

    @Override
    public void sendMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        this.mnslistService.saveMnslist(mnsMnslistDomainBean);
        this.getSendService().putQueue(mnsMnslistDomainBean);
    }

    @Override
    public void sendMnsBlist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        List<MnsMnsblistDomainBean> relist = this.mnslistService.saveSend(mnsMnslistDomainBean);
        if (ListUtil.isNotEmpty(relist)) {
            this.getsendMnsBlistService().addPutPool(new SendMnsBlistPutThread(this.getsendMnsBlistService(), relist));
        }
    }

    @Override
    public void saveSendPlus(String TemplateParam, String phoneNumbers, String businessType, String app_id, String tenantCode) throws ApiException {
        this.mnslistService.saveSendPlus(TemplateParam, phoneNumbers, businessType, app_id, tenantCode);
    }

    @Override
    public String sendOrderDomain(OcContractReDomain ocContractDomain) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.sendOrderDomain", (Object)"=====================================\u8ba2\u5355\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528=====================================");
        if (null == ocContractDomain) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendOrderDomain", (Object)("ocContractReDomain->" + ocContractDomain));
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("oc" + ocContractDomain.getContractType() + ocContractDomain.getDataState());
        mnsMnslistDomainBean.setMnslistBusname("\u8ba2\u5355\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(ocContractDomain.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(ocContractDomain.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(ocContractDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", ocContractDomain.getMemberBcode());
        listReceiver.put("name", ocContractDomain.getMemberBname());
        listReceiver.put("ocContractDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)ocContractDomain));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendUserDomain(UmUserinfo umUserinfo) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.sendUserDomain", (Object)"=====================================\u7528\u6237\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528=====================================");
        if (null == umUserinfo) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendUserDomain", (Object)("umUserinfo->" + umUserinfo));
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("um" + umUserinfo.getUserinfoType() + umUserinfo.getDataState());
        mnsMnslistDomainBean.setMnslistBusname("\u7528\u6237\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(umUserinfo.getUserCode());
        mnsMnslistDomainBean.setDataTenant(umUserinfo.getTenantCode());
        String params = JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfo);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(umUserinfo.getTenantCode());
        this.logger.error("mns.MNS.MnsServiceImpl.sendUserDomain", (Object)("=====================================" + mnsMnslistDomainBean.getMnslistBustype() + "====================================="));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendRefundDomain(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)"=====================================\u9000\u8d27\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528=====================================");
        if (null == ocRefundDomain) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("ocRefundDomain->" + ocRefundDomain));
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("re" + ocRefundDomain.getContractType());
        mnsMnslistDomainBean.setMnslistBusname("\u9000\u8d27\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(ocRefundDomain.getMemberCode());
        mnsMnslistDomainBean.setDataTenant(ocRefundDomain.getTenantCode());
        String params = JsonUtil.buildNonEmptyBinder().toJson((Object)ocRefundDomain);
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("=====================================params->" + params + "====================================="));
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(ocRefundDomain.getTenantCode());
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("=====================================" + mnsMnslistDomainBean.getMnslistBustype() + "====================================="));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendOrderMnslist(String contractBillcode, String busType, String memberBcode, String tenantCode) throws ApiException {
        HashMap<String, String> contentMap;
        ArrayList receiverList;
        MnsMnslistDomainBean mnsMnslistDomainBean;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("userinfoCode", memberBcode);
        queryMap.put("tenantCode", tenantCode);
        String result = null;
        try {
            result = this.internalInvoke("um.user.getUserinfoByCode", queryMap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsServiceImplsendOrderMnslist.map", queryMap);
            return "error";
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(result, UmUserinfo.class);
        if (null != umUserinfo) {
            mnsMnslistDomainBean = new MnsMnslistDomainBean();
            mnsMnslistDomainBean.setMnslistBustype(busType);
            mnsMnslistDomainBean.setMnslistBusname("\u90ae\u7bb1\u53d1\u9001\u4fe1\u606f");
            mnsMnslistDomainBean.setMemberCode(umUserinfo.getUserinfoCode());
            mnsMnslistDomainBean.setDataTenant(tenantCode);
            receiverList = new ArrayList();
            HashMap<String, String> mape = new HashMap<String, String>();
            mape.put("email", umUserinfo.getUserinfoEmail());
            mape.put("name", umUserinfo.getUserinfoCompname());
            receiverList.add(mape);
            contentMap = new HashMap<String, String>();
            contentMap.put("email", umUserinfo.getUserinfoEmail());
            contentMap.put("userinfoCompname", umUserinfo.getUserinfoCompname());
            if (StringUtils.isNotBlank((String)contractBillcode)) {
                contentMap.put("contractBillcode", contractBillcode);
            }
        } else {
            return "error";
        }
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(contentMap));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        String params = JsonUtil.buildNonDefaultBinder().toJson(expMap);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(tenantCode);
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendMnsBlistService getsendMnsBlistService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendMnsBlistService) {
                sendMnsBlistService = new SendMnsBlistService((MnslistService)SpringApplicationContextUtil.getBean((String)"mnslistService"));
                for (int i = 0; i < 20; ++i) {
                    sendMnsBlistService.addPollPool(new SendMnsBlistPollThread(sendMnsBlistService));
                }
            }
            return sendMnsBlistService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((MnsService)SpringApplicationContextUtil.getBean((String)"mnsService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    static {
        lock = new Object();
    }
}

