/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.dao.MnsAcceptSettingMapper;
import com.yqbsoft.laser.service.mns.domain.MnsAcceptSettingDomainBean;
import com.yqbsoft.laser.service.mns.model.MnsAcceptSetting;
import com.yqbsoft.laser.service.mns.service.MnsAcceptSettingService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MnsAcceptSettingServiceImpl
extends BaseServiceImpl
implements MnsAcceptSettingService {
    public static final String SYS_CODE = "mns.MNS.MnsAcceptSettingServiceImpl";
    private MnsAcceptSettingMapper mnsAcceptSettingMapper;

    public void setMnsAcceptSettingMapper(MnsAcceptSettingMapper mnsAcceptSettingMapper) {
        this.mnsAcceptSettingMapper = mnsAcceptSettingMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsAcceptSettingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAcceptSetting(MnsAcceptSettingDomainBean mnsAcceptSettingDomainBean) {
        if (null == mnsAcceptSettingDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAcceptSettingDefault(MnsAcceptSetting mnsAcceptSetting) {
        if (null == mnsAcceptSetting) {
            return;
        }
        if (null == mnsAcceptSetting.getDataState()) {
            mnsAcceptSetting.setDataState(0);
        }
        if (null == mnsAcceptSetting.getGmtCreate()) {
            mnsAcceptSetting.setGmtCreate(this.getSysDate());
        }
        mnsAcceptSetting.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mnsAcceptSetting.getAcceptSettingCode())) {
            mnsAcceptSetting.setAcceptSettingCode(this.createUUIDString());
        }
    }

    private int getAcceptSettingMaxCode() {
        int code = 0;
        try {
            return this.mnsAcceptSettingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.getAcceptSettingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAcceptSettingUpdataDefault(MnsAcceptSetting mnsAcceptSetting) {
        if (null == mnsAcceptSetting) {
            return;
        }
        mnsAcceptSetting.setGmtModified(this.getSysDate());
    }

    private void saveAcceptSettingModel(MnsAcceptSetting mnsAcceptSetting) throws ApiException {
        if (null == mnsAcceptSetting) {
            return;
        }
        try {
            this.mnsAcceptSettingMapper.insert(mnsAcceptSetting);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.saveAcceptSettingModel.ex", (Throwable)e);
        }
    }

    private MnsAcceptSetting getAcceptSettingModelById(Integer acceptSettingId) {
        if (null == acceptSettingId) {
            return null;
        }
        try {
            return this.mnsAcceptSettingMapper.selectByPrimaryKey(acceptSettingId);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.getAcceptSettingModelById", (Throwable)e);
            return null;
        }
    }

    public MnsAcceptSetting getAcceptSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mnsAcceptSettingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.getAcceptSettingModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAcceptSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsAcceptSettingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.delAcceptSettingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.delAcceptSettingModelByCode.num");
        }
    }

    private void deleteAcceptSettingModel(Integer acceptSettingId) throws ApiException {
        if (null == acceptSettingId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsAcceptSettingMapper.deleteByPrimaryKey(acceptSettingId);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.deleteAcceptSettingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.deleteAcceptSettingModel.num");
        }
    }

    private void updateAcceptSettingModel(MnsAcceptSetting mnsAcceptSetting) throws ApiException {
        if (null == mnsAcceptSetting) {
            return;
        }
        try {
            this.mnsAcceptSettingMapper.updateByPrimaryKeySelective(mnsAcceptSetting);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.updateAcceptSettingModel.ex", (Throwable)e);
        }
    }

    private void updateStateAcceptSettingModel(Integer acceptSettingId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == acceptSettingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acceptSettingId", acceptSettingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mnsAcceptSettingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.updateStateAcceptSettingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.updateStateAcceptSettingModel.null");
        }
    }

    private MnsAcceptSetting makeAcceptSetting(MnsAcceptSettingDomainBean mnsAcceptSettingDomainBean, MnsAcceptSetting mnsAcceptSetting) {
        if (null == mnsAcceptSettingDomainBean) {
            return null;
        }
        if (null == mnsAcceptSetting) {
            mnsAcceptSetting = new MnsAcceptSetting();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsAcceptSetting, (Object)mnsAcceptSettingDomainBean);
            return mnsAcceptSetting;
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.makeAcceptSetting", (Throwable)e);
            return null;
        }
    }

    private List<MnsAcceptSetting> queryAcceptSettingModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsAcceptSettingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.queryAcceptSettingModel", (Throwable)e);
            return null;
        }
    }

    private int countAcceptSetting(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsAcceptSettingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.countAcceptSetting", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveAcceptSetting(MnsAcceptSettingDomainBean mnsAcceptSettingDomainBean) throws ApiException {
        String msg = this.checkAcceptSetting(mnsAcceptSettingDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.saveAcceptSetting.checkAcceptSetting", msg);
        }
        MnsAcceptSetting mnsAcceptSetting = this.makeAcceptSetting(mnsAcceptSettingDomainBean, null);
        this.setAcceptSettingDefault(mnsAcceptSetting);
        this.saveAcceptSettingModel(mnsAcceptSetting);
        return mnsAcceptSetting.getAcceptSettingCode();
    }

    @Override
    public void updateAcceptSettingState(Integer acceptSettingId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAcceptSettingModel(acceptSettingId, dataState, oldDataState);
    }

    @Override
    public void updateAcceptSetting(MnsAcceptSettingDomainBean mnsAcceptSettingDomainBean) throws ApiException {
        String msg = this.checkAcceptSetting(mnsAcceptSettingDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.updateAcceptSetting.checkAcceptSetting", msg);
        }
        MnsAcceptSetting oldMnsAcceptSetting = this.getAcceptSettingModelById(mnsAcceptSettingDomainBean.getAcceptSettingId());
        if (null == oldMnsAcceptSetting) {
            throw new ApiException("mns.MNS.MnsAcceptSettingServiceImpl.updateAcceptSetting.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsAcceptSetting mnsAcceptSetting = this.makeAcceptSetting(mnsAcceptSettingDomainBean, oldMnsAcceptSetting);
        this.setAcceptSettingUpdataDefault(mnsAcceptSetting);
        this.updateAcceptSettingModel(mnsAcceptSetting);
    }

    @Override
    public MnsAcceptSetting getAcceptSetting(Integer acceptSettingId) {
        return this.getAcceptSettingModelById(acceptSettingId);
    }

    @Override
    public void deleteAcceptSetting(Integer acceptSettingId) throws ApiException {
        this.deleteAcceptSettingModel(acceptSettingId);
    }

    @Override
    public QueryResult<MnsAcceptSetting> queryAcceptSettingPage(Map<String, Object> map) {
        List<MnsAcceptSetting> mnsAcceptSettingList = this.queryAcceptSettingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAcceptSetting(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsAcceptSettingList);
        return queryResult;
    }

    @Override
    public MnsAcceptSetting getAcceptSettingByCode(Map<String, Object> map) {
        return this.getAcceptSettingModelByCode(map);
    }

    @Override
    public void delAcceptSettingByCode(Map<String, Object> map) throws ApiException {
        this.delAcceptSettingModelByCode(map);
    }

    @Override
    public MnsAcceptSetting getAcceptSettingByATMCode(String acceptCode, String tenantCode, String mnsconfigBustype) {
        if (StringUtils.isNotBlankLoop((String[])new String[]{acceptCode, tenantCode, mnsconfigBustype})) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("acceptCode", acceptCode);
            map.put("tenantCode", tenantCode);
            map.put("mnsconfigBustype", mnsconfigBustype);
            MnsAcceptSetting acceptSetting = this.getAcceptSettingByATMCodeModel(map);
            if (acceptSetting != null) {
                return acceptSetting;
            }
        }
        return null;
    }

    private MnsAcceptSetting getAcceptSettingByATMCodeModel(Map<String, Object> map) {
        try {
            return this.mnsAcceptSettingMapper.getAcceptSettingByATMCode(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsAcceptSettingServiceImpl.getAcceptSettingByATMCodeModel", (Throwable)e);
            return null;
        }
    }
}

