/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.dao.MnsMnssignMapper;
import com.yqbsoft.laser.service.mns.domain.MnsMnssignDomain;
import com.yqbsoft.laser.service.mns.domain.MnsMnssignReDomain;
import com.yqbsoft.laser.service.mns.model.MnsMnssign;
import com.yqbsoft.laser.service.mns.service.MnsMnssignService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MnsMnssignServiceImpl
extends BaseServiceImpl
implements MnsMnssignService {
    private static final String SYS_CODE = ".MnsMnssignServiceImpl";
    private MnsMnssignMapper mnsMnssignMapper;

    public void setMnsMnssignMapper(MnsMnssignMapper mnsMnssignMapper) {
        this.mnsMnssignMapper = mnsMnssignMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsMnssignMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMnssign(MnsMnssignDomain mnsMnssignDomain) {
        if (null == mnsMnssignDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mnsMnssignDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMnssignDefault(MnsMnssign mnsMnssign) {
        if (null == mnsMnssign) {
            return;
        }
        if (null == mnsMnssign.getDataState()) {
            mnsMnssign.setDataState(0);
        }
        if (null == mnsMnssign.getGmtCreate()) {
            mnsMnssign.setGmtCreate(this.getSysDate());
        }
        mnsMnssign.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mnsMnssign.getMnssignCode())) {
            mnsMnssign.setMnssignCode(this.getNo(null, "MnsMnssign", "mnsMnssign", mnsMnssign.getTenantCode()));
        }
    }

    private int getMnssignMaxCode() {
        int code = 0;
        try {
            return this.mnsMnssignMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.getMnssignMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMnssignUpdataDefault(MnsMnssign mnsMnssign) {
        if (null == mnsMnssign) {
            return;
        }
        mnsMnssign.setGmtModified(this.getSysDate());
    }

    private void saveMnssignModel(MnsMnssign mnsMnssign) throws ApiException {
        if (null == mnsMnssign) {
            return;
        }
        try {
            this.mnsMnssignMapper.insert(mnsMnssign);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.saveMnssignModel.ex", (Throwable)e);
        }
    }

    private void saveMnssignBatchModel(List<MnsMnssign> mnsMnssignList) throws ApiException {
        if (null == mnsMnssignList || mnsMnssignList.isEmpty()) {
            return;
        }
        try {
            this.mnsMnssignMapper.insertBatch(mnsMnssignList);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.saveMnssignBatchModel.ex", (Throwable)e);
        }
    }

    private MnsMnssign getMnssignModelById(Integer mnssignId) {
        if (null == mnssignId) {
            return null;
        }
        try {
            return this.mnsMnssignMapper.selectByPrimaryKey(mnssignId);
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.getMnssignModelById", (Throwable)e);
            return null;
        }
    }

    private MnsMnssign getMnssignModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mnsMnssignMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.getMnssignModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMnssignModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnssignMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.delMnssignModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(".MnsMnssignServiceImpl.delMnssignModelByCode.num");
        }
    }

    private void deleteMnssignModel(Integer mnssignId) throws ApiException {
        if (null == mnssignId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnssignMapper.deleteByPrimaryKey(mnssignId);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.deleteMnssignModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(".MnsMnssignServiceImpl.deleteMnssignModel.num");
        }
    }

    private void updateMnssignModel(MnsMnssign mnsMnssign) throws ApiException {
        if (null == mnsMnssign) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnssignMapper.updateByPrimaryKey(mnsMnssign);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.updateMnssignModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(".MnsMnssignServiceImpl.updateMnssignModel.num");
        }
    }

    private void updateStateMnssignModel(Integer mnssignId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == mnssignId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnssignId", mnssignId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsMnssignMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.updateStateMnssignModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(".MnsMnssignServiceImpl.updateStateMnssignModel.null");
        }
    }

    private void updateStateMnssignModelByCode(String tenantCode, String mnssignCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)mnssignCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnssignCode", mnssignCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsMnssignMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(".MnsMnssignServiceImpl.updateStateMnssignModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(".MnsMnssignServiceImpl.updateStateMnssignModelByCode.null");
        }
    }

    private MnsMnssign makeMnssign(MnsMnssignDomain mnsMnssignDomain, MnsMnssign mnsMnssign) {
        if (null == mnsMnssignDomain) {
            return null;
        }
        if (null == mnsMnssign) {
            mnsMnssign = new MnsMnssign();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnssign, (Object)mnsMnssignDomain);
            return mnsMnssign;
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.makeMnssign", (Throwable)e);
            return null;
        }
    }

    private MnsMnssignReDomain makeMnsMnssignReDomain(MnsMnssign mnsMnssign) {
        if (null == mnsMnssign) {
            return null;
        }
        MnsMnssignReDomain mnsMnssignReDomain = new MnsMnssignReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnssignReDomain, (Object)mnsMnssign);
            return mnsMnssignReDomain;
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.makeMnsMnssignReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MnsMnssign> queryMnssignModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsMnssignMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.queryMnssignModel", (Throwable)e);
            return null;
        }
    }

    private int countMnssign(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsMnssignMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(".MnsMnssignServiceImpl.countMnssign", (Throwable)e);
        }
        return i;
    }

    private MnsMnssign createMnsMnssign(MnsMnssignDomain mnsMnssignDomain) {
        String msg = this.checkMnssign(mnsMnssignDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(".MnsMnssignServiceImpl.saveMnssign.checkMnssign", msg);
        }
        MnsMnssign mnsMnssign = this.makeMnssign(mnsMnssignDomain, null);
        this.setMnssignDefault(mnsMnssign);
        return mnsMnssign;
    }

    @Override
    public String saveMnssign(MnsMnssignDomain mnsMnssignDomain) throws ApiException {
        MnsMnssign mnsMnssign = this.createMnsMnssign(mnsMnssignDomain);
        this.saveMnssignModel(mnsMnssign);
        return mnsMnssign.getMnssignCode();
    }

    @Override
    public String saveMnssignBatch(List<MnsMnssignDomain> mnsMnssignDomainList) throws ApiException {
        if (null == mnsMnssignDomainList || mnsMnssignDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MnsMnssign> mnsMnssignList = new ArrayList<MnsMnssign>();
        String code = "";
        for (MnsMnssignDomain mnsMnssignDomain : mnsMnssignDomainList) {
            MnsMnssign mnsMnssign = this.createMnsMnssign(mnsMnssignDomain);
            code = mnsMnssign.getMnssignCode();
            mnsMnssignList.add(mnsMnssign);
        }
        this.saveMnssignBatchModel(mnsMnssignList);
        return code;
    }

    @Override
    public void updateMnssignState(Integer mnssignId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateMnssignModel(mnssignId, dataState, oldDataState, map);
    }

    @Override
    public void updateMnssignStateByCode(String tenantCode, String mnssignCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateMnssignModelByCode(tenantCode, mnssignCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMnssign(MnsMnssignDomain mnsMnssignDomain) throws ApiException {
        String msg = this.checkMnssign(mnsMnssignDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(".MnsMnssignServiceImpl.updateMnssign.checkMnssign", msg);
        }
        MnsMnssign oldMnsMnssign = this.getMnssignModelById(mnsMnssignDomain.getMnssignId());
        if (null == oldMnsMnssign) {
            throw new ApiException(".MnsMnssignServiceImpl.updateMnssign.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnssign mnsMnssign = this.makeMnssign(mnsMnssignDomain, oldMnsMnssign);
        this.setMnssignUpdataDefault(mnsMnssign);
        this.updateMnssignModel(mnsMnssign);
    }

    @Override
    public MnsMnssign getMnssign(Integer mnssignId) {
        return this.getMnssignModelById(mnssignId);
    }

    @Override
    public void deleteMnssign(Integer mnssignId) throws ApiException {
        this.deleteMnssignModel(mnssignId);
    }

    @Override
    public QueryResult<MnsMnssign> queryMnssignPage(Map<String, Object> map) {
        List<MnsMnssign> mnsMnssignList = this.queryMnssignModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMnssign(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsMnssignList);
        return queryResult;
    }

    @Override
    public MnsMnssign getMnssignByCode(String tenantCode, String mnssignCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnssignCode", mnssignCode);
        return this.getMnssignModelByCode(map);
    }

    @Override
    public void deleteMnssignByCode(String tenantCode, String mnssignCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnssignCode", mnssignCode);
        this.delMnssignModelByCode(map);
    }
}

