/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.model.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.model.dao.MrOptionValueMapper;
import com.yqbsoft.laser.service.model.domain.MrOptionValueDomain;
import com.yqbsoft.laser.service.model.model.MrOptionValue;
import com.yqbsoft.laser.service.model.service.OptionValueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionValueServiceImpl
extends BaseServiceImpl
implements OptionValueService {
    public static final String SYS_CODE = "mr.MODEL.OptionValueServiceImpl";
    private MrOptionValueMapper mrOptionValueMapper;

    public void setMrOptionValueMapper(MrOptionValueMapper mrOptionValueMapper) {
        this.mrOptionValueMapper = mrOptionValueMapper;
    }

    private Date getSysDate() {
        try {
            return this.mrOptionValueMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionValueServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOptionValue(MrOptionValueDomain mrOptionValueDomain) {
        if (null == mrOptionValueDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setOptionValueDefault(MrOptionValue mrOptionValue) {
        if (null == mrOptionValue) {
            return;
        }
        if (null == mrOptionValue.getDataState()) {
            mrOptionValue.setDataState(0);
        }
        if (null == mrOptionValue.getGmtCreate()) {
            mrOptionValue.setGmtCreate(this.getSysDate());
        }
        mrOptionValue.setGmtModified(this.getSysDate());
        int code = this.getMaxCode();
        mrOptionValue.setOptionValueCode(this.makeMaxCode8(++code));
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mrOptionValueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionValueServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOptionValueUpdataDefault(MrOptionValue mrOptionValue) {
        if (null == mrOptionValue) {
            return;
        }
        mrOptionValue.setGmtModified(this.getSysDate());
    }

    private void saveOptionValueModel(MrOptionValue mrOptionValue) throws ApiException {
        if (null == mrOptionValue) {
            return;
        }
        try {
            this.mrOptionValueMapper.insert(mrOptionValue);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.saveOptionValueModel.ex", (Throwable)e);
        }
    }

    private MrOptionValue getOptionValueModelById(Integer optionValueId) {
        if (null == optionValueId) {
            return null;
        }
        try {
            return this.mrOptionValueMapper.selectByPrimaryKey(optionValueId);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionValueServiceImpl.getOptionValueModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteOptionValueModel(Integer optionValueId) throws ApiException {
        if (null == optionValueId) {
            return;
        }
        int i = 0;
        try {
            i = this.mrOptionValueMapper.deleteByPrimaryKey(optionValueId);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.deleteOptionValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.deleteOptionValueModel.num");
        }
    }

    private void updateOptionValueModel(MrOptionValue mrOptionValue) throws ApiException {
        if (null == mrOptionValue) {
            return;
        }
        try {
            this.mrOptionValueMapper.updateByPrimaryKeySelective(mrOptionValue);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.updateOptionValueModel.ex", (Throwable)e);
        }
    }

    private void updateStateOptionValueModel(Integer optionValueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == optionValueId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("optionValueId", optionValueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mrOptionValueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.updateStateOptionValueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.updateStateOptionValueModel.null");
        }
    }

    private MrOptionValue makeOptionValue(MrOptionValueDomain mrOptionValueDomain, MrOptionValue mrOptionValue) {
        if (null == mrOptionValueDomain) {
            return null;
        }
        if (null == mrOptionValue) {
            mrOptionValue = new MrOptionValue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mrOptionValue, (Object)mrOptionValueDomain);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionValueServiceImpl.makeOptionValue", (Throwable)e);
        }
        return mrOptionValue;
    }

    private List<MrOptionValue> queryOptionValueModelPage(Map<String, Object> parammap) {
        try {
            return this.mrOptionValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionValueServiceImpl.queryOptionValueModel", (Throwable)e);
            return null;
        }
    }

    private int countOptionValue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mrOptionValueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.OptionValueServiceImpl.countOptionValue", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveOptionValue(MrOptionValueDomain mrOptionValueDomain) throws ApiException {
        String msg = this.checkOptionValue(mrOptionValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.saveOptionValue.checkOptionValue", msg);
        }
        MrOptionValue mrOptionValue = this.makeOptionValue(mrOptionValueDomain, null);
        this.setOptionValueDefault(mrOptionValue);
        this.saveOptionValueModel(mrOptionValue);
    }

    @Override
    public void updateOptionValueState(Integer optionValueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOptionValueModel(optionValueId, dataState, oldDataState);
    }

    @Override
    public void updateOptionValue(MrOptionValueDomain mrOptionValueDomain) throws ApiException {
        String msg = this.checkOptionValue(mrOptionValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.updateOptionValue.checkOptionValue", msg);
        }
        MrOptionValue oldMrOptionValue = this.getOptionValueModelById(mrOptionValueDomain.getOptionValueId());
        if (null == oldMrOptionValue) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.updateOptionValue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MrOptionValue mrOptionValue = this.makeOptionValue(mrOptionValueDomain, oldMrOptionValue);
        this.setOptionValueUpdataDefault(mrOptionValue);
        this.updateOptionValueModel(mrOptionValue);
    }

    @Override
    public MrOptionValue getOptionValue(Integer optionValueId) {
        return this.getOptionValueModelById(optionValueId);
    }

    @Override
    public void deleteOptionValue(Integer optionValueId) throws ApiException {
        this.deleteOptionValueModel(optionValueId);
    }

    @Override
    public QueryResult<MrOptionValue> queryOptionValuePage(Map<String, Object> map) {
        List<MrOptionValue> mrOptionValueList = this.queryOptionValueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOptionValue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mrOptionValueList);
        return queryResult;
    }

    @Override
    public void saveOptionValueList(List<MrOptionValueDomain> mrOptionValueDomainList) throws ApiException {
        if (ListUtil.isEmpty(mrOptionValueDomainList)) {
            return;
        }
        for (MrOptionValueDomain mrOptionValueDomain : mrOptionValueDomainList) {
            this.saveOptionValue(mrOptionValueDomain);
        }
    }

    @Override
    public void deleteOptionValueByCode(String appmanageIcode, String productCode) throws ApiException {
        this.deleteOptionValueModelByCode(appmanageIcode, productCode);
    }

    private void deleteOptionValueModelByCode(String appmanageIcode, String productCode) {
        if (StringUtils.isBlank((String)appmanageIcode) || StringUtils.isBlank((String)productCode)) {
            return;
        }
        try {
            this.mrOptionValueMapper.deleteByCode(appmanageIcode, productCode);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.OptionValueServiceImpl.deleteOptionValueModelByCode.ex", (Throwable)e);
        }
    }
}

