/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.model.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.model.dao.MrProductMapper;
import com.yqbsoft.laser.service.model.domain.MrProductDomain;
import com.yqbsoft.laser.service.model.model.MrAppmodelValue;
import com.yqbsoft.laser.service.model.model.MrOptionValue;
import com.yqbsoft.laser.service.model.model.MrProduct;
import com.yqbsoft.laser.service.model.service.AppmodelValueService;
import com.yqbsoft.laser.service.model.service.OptionValueService;
import com.yqbsoft.laser.service.model.service.ProductService;
import com.yqbsoft.laser.service.suppercore.router.ApiProperty;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProductServiceImpl
extends BaseServiceImpl
implements ProductService {
    public static final String SYS_CODE = "mr.MODEL.ProductServiceImpl";
    private MrProductMapper mrProductMapper;
    private AppmodelValueService appmodelValueService;
    private OptionValueService optionValueService;

    public void setAppmodelValueService(AppmodelValueService appmodelValueService) {
        this.appmodelValueService = appmodelValueService;
    }

    public void setMrProductMapper(MrProductMapper mrProductMapper) {
        this.mrProductMapper = mrProductMapper;
    }

    public void setOptionValueService(OptionValueService optionValueService) {
        this.optionValueService = optionValueService;
    }

    private Date getSysDate() {
        try {
            return this.mrProductMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.ProductServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProduct(MrProductDomain mrProductDomain) {
        if (null == mrProductDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProductDefault(MrProduct mrProduct) {
        if (null == mrProduct) {
            return;
        }
        if (null == mrProduct.getDataState()) {
            mrProduct.setDataState(0);
        }
        if (null == mrProduct.getGmtCreate()) {
            mrProduct.setGmtCreate(this.getSysDate());
        }
        mrProduct.setGmtModified(this.getSysDate());
        int code = this.getMaxCode();
        mrProduct.setProductCode(this.makeMaxCode8(++code));
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mrProductMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.ProductServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProductUpdataDefault(MrProduct mrProduct) {
        if (null == mrProduct) {
            return;
        }
        mrProduct.setGmtModified(this.getSysDate());
    }

    private void saveProductModel(MrProduct mrProduct) throws ApiException {
        if (null == mrProduct) {
            return;
        }
        try {
            this.mrProductMapper.insert(mrProduct);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.saveProductModel.ex", (Throwable)e);
        }
    }

    private MrProduct getProductModelById(Integer productId) {
        if (null == productId) {
            return null;
        }
        try {
            return this.mrProductMapper.selectByPrimaryKey(productId);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.ProductServiceImpl.getProductModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteProductModel(Integer productId) throws ApiException {
        if (null == productId) {
            return;
        }
        int i = 0;
        try {
            i = this.mrProductMapper.deleteByPrimaryKey(productId);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.deleteProductModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.deleteProductModel.num");
        }
    }

    private void updateProductModel(MrProduct mrProduct) throws ApiException {
        if (null == mrProduct) {
            return;
        }
        try {
            this.mrProductMapper.updateByPrimaryKeySelective(mrProduct);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.updateProductModel.ex", (Throwable)e);
        }
    }

    private void updateStateProductModel(Integer productId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == productId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productId", productId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mrProductMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.updateStateProductModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.updateStateProductModel.null");
        }
    }

    private MrProduct makeProduct(MrProductDomain mrProductDomain, MrProduct mrProduct) {
        if (null == mrProductDomain) {
            return null;
        }
        if (null == mrProduct) {
            mrProduct = new MrProduct();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mrProduct, (Object)mrProductDomain);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.ProductServiceImpl.makeProduct", (Throwable)e);
        }
        return mrProduct;
    }

    private List<MrProduct> queryProductModelPage(Map<String, Object> parammap) {
        try {
            return this.mrProductMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.ProductServiceImpl.queryProductModel", (Throwable)e);
            return null;
        }
    }

    private int countProduct(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mrProductMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.ProductServiceImpl.countProduct", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveProduct(MrProductDomain mrProductDomain) throws ApiException {
        String msg = this.checkProduct(mrProductDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.saveProduct.checkProduct", msg);
        }
        MrProduct mrProduct = this.makeProduct(mrProductDomain, null);
        this.setProductDefault(mrProduct);
        this.saveProductModel(mrProduct);
        return mrProduct.getProductCode();
    }

    @Override
    public void updateProductState(Integer productId, Integer dataState, Integer oldDataState) throws ApiException {
        QueryResult<MrOptionValue> queryResult1;
        MrProduct mrProduct = this.getProduct(productId);
        this.updateStateProductModel(productId, dataState, oldDataState);
        QueryResult<MrAppmodelValue> queryResult = this.appmodelValueService.queryAppmodelValuePage(this.getQueryParamMap("productCode", new Object[]{mrProduct.getProductCode()}));
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            for (MrAppmodelValue mrAppmodelValue : queryResult.getList()) {
                this.appmodelValueService.updateAppmodelValueState(mrAppmodelValue.getAppmodelValueId(), dataState, oldDataState);
            }
        }
        if ((queryResult1 = this.optionValueService.queryOptionValuePage(this.getQueryParamMap("productCode", new Object[]{mrProduct.getProductCode()}))) != null && ListUtil.isNotEmpty((Collection)queryResult1.getList())) {
            for (MrOptionValue mrOptionValue : queryResult1.getList()) {
                this.optionValueService.updateOptionValueState(mrOptionValue.getOptionValueId(), dataState, oldDataState);
            }
        }
    }

    @Override
    public void updateProduct(MrProductDomain mrProductDomain) throws ApiException {
        String msg = this.checkProduct(mrProductDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.updateProduct.checkProduct", msg);
        }
        MrProduct oldMrProduct = this.getProductModelById(mrProductDomain.getProductId());
        if (null == oldMrProduct) {
            throw new ApiException("mr.MODEL.ProductServiceImpl.updateProduct.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MrProduct mrProduct = this.makeProduct(mrProductDomain, oldMrProduct);
        this.setProductUpdataDefault(mrProduct);
        this.updateProductModel(mrProduct);
        this.appmodelValueService.deleteAppmodelValueByCode(mrProduct.getAppmanageIcode(), mrProduct.getProductCode());
        this.optionValueService.deleteOptionValueByCode(mrProduct.getAppmanageIcode(), mrProduct.getProductCode());
    }

    @Override
    public MrProduct getProduct(Integer productId) {
        return this.getProductModelById(productId);
    }

    @Override
    public void deleteProduct(Integer productId) throws ApiException {
        MrProduct mrProduct = this.getProduct(productId);
        this.appmodelValueService.deleteAppmodelValueByCode(mrProduct.getAppmanageIcode(), mrProduct.getProductCode());
        this.optionValueService.deleteOptionValueByCode(mrProduct.getAppmanageIcode(), mrProduct.getProductCode());
        this.deleteProductModel(productId);
    }

    @Override
    public QueryResult<MrProduct> queryProductPage(Map<String, Object> map) {
        List<MrProduct> mrProductList = this.queryProductModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProduct(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mrProductList);
        return queryResult;
    }

    @Override
    public Boolean getProductExist(String appapiCode, String userCode, String getType) {
        boolean result;
        block7: {
            block6: {
                result = false;
                if (!"1".equals(getType)) break block6;
                QueryResult<MrAppmodelValue> qr = this.appmodelValueService.queryAppmodelValuePage(this.getQueryParamMap("paramValue", new Object[]{userCode}));
                if (qr == null || !ListUtil.isNotEmpty((Collection)qr.getList())) break block7;
                result = true;
                break block7;
            }
            if ("0".equals(getType)) {
                ApiProperty apiProperty = (ApiProperty)LocalCache.getApiMap().get(appapiCode);
                if (apiProperty == null) {
                    return false;
                }
                String appKey = apiProperty.getAppmanageIcode();
                List list = (List)LocalCache.getAppManagerMap().get(appKey);
                if (ListUtil.isEmpty((Collection)list)) {
                    return false;
                }
                AppProperty appProperty = (AppProperty)list.get(0);
                String appmanageApptype = appProperty.getAppmanageApptype();
                QueryResult<MrAppmodelValue> qr = this.appmodelValueService.queryAppmodelValuePage(this.getQueryParamMap("appmanageApptype,paramValue", new Object[]{appmanageApptype, userCode}));
                if (qr == null || ListUtil.isEmpty((Collection)qr.getList())) {
                    return false;
                }
                HashMap<String, String> productUserCode = new HashMap<String, String>();
                for (MrAppmodelValue mrAppmodelValue : qr.getList()) {
                    productUserCode.put(mrAppmodelValue.getProductCode(), userCode);
                }
                for (String key : productUserCode.keySet()) {
                    QueryResult<MrAppmodelValue> appQR = this.appmodelValueService.queryAppmodelValuePage(this.getQueryParamMap("productCode,paramValue", new Object[]{key, appKey}));
                    if (appQR == null || !ListUtil.isNotEmpty((Collection)appQR.getList())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}

