/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.model.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.model.dao.MrPropertyValueMapper;
import com.yqbsoft.laser.service.model.domain.MrPropertyValueDomain;
import com.yqbsoft.laser.service.model.model.MrPropertyValue;
import com.yqbsoft.laser.service.model.service.PropertyValueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyValueServiceImpl
extends BaseServiceImpl
implements PropertyValueService {
    public static final String SYS_CODE = "mr.MODEL.PropertyValueServiceImpl";
    private MrPropertyValueMapper mrPropertyValueMapper;

    public void setMrPropertyValueMapper(MrPropertyValueMapper mrPropertyValueMapper) {
        this.mrPropertyValueMapper = mrPropertyValueMapper;
    }

    private Date getSysDate() {
        try {
            return this.mrPropertyValueMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyValueServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPropertyValue(MrPropertyValueDomain mrPropertyValueDomain) {
        if (null == mrPropertyValueDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPropertyValueDefault(MrPropertyValue mrPropertyValue) {
        if (null == mrPropertyValue) {
            return;
        }
        if (null == mrPropertyValue.getDataState()) {
            mrPropertyValue.setDataState(0);
        }
        if (null == mrPropertyValue.getGmtCreate()) {
            mrPropertyValue.setGmtCreate(this.getSysDate());
        }
        mrPropertyValue.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mrPropertyValueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyValueServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPropertyValueUpdataDefault(MrPropertyValue mrPropertyValue) {
        if (null == mrPropertyValue) {
            return;
        }
        mrPropertyValue.setGmtModified(this.getSysDate());
    }

    private void savePropertyValueModel(MrPropertyValue mrPropertyValue) throws ApiException {
        if (null == mrPropertyValue) {
            return;
        }
        try {
            this.mrPropertyValueMapper.insert(mrPropertyValue);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.savePropertyValueModel.ex", (Throwable)e);
        }
    }

    private MrPropertyValue getPropertyValueModelById(Integer propertyValueId) {
        if (null == propertyValueId) {
            return null;
        }
        try {
            return this.mrPropertyValueMapper.selectByPrimaryKey(propertyValueId);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyValueServiceImpl.getPropertyValueModelById", (Throwable)e);
            return null;
        }
    }

    private void deletePropertyValueModel(Integer propertyValueId) throws ApiException {
        if (null == propertyValueId) {
            return;
        }
        int i = 0;
        try {
            i = this.mrPropertyValueMapper.deleteByPrimaryKey(propertyValueId);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.deletePropertyValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.deletePropertyValueModel.num");
        }
    }

    private void updatePropertyValueModel(MrPropertyValue mrPropertyValue) throws ApiException {
        if (null == mrPropertyValue) {
            return;
        }
        try {
            this.mrPropertyValueMapper.updateByPrimaryKeySelective(mrPropertyValue);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.updatePropertyValueModel.ex", (Throwable)e);
        }
    }

    private void updateStatePropertyValueModel(Integer propertyValueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == propertyValueId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertyValueId", propertyValueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mrPropertyValueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.updateStatePropertyValueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.updateStatePropertyValueModel.null");
        }
    }

    private MrPropertyValue makePropertyValue(MrPropertyValueDomain mrPropertyValueDomain, MrPropertyValue mrPropertyValue) {
        if (null == mrPropertyValueDomain) {
            return null;
        }
        if (null == mrPropertyValue) {
            mrPropertyValue = new MrPropertyValue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mrPropertyValue, (Object)mrPropertyValueDomain);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyValueServiceImpl.makePropertyValue", (Throwable)e);
        }
        return mrPropertyValue;
    }

    private List<MrPropertyValue> queryPropertyValueModelPage(Map<String, Object> parammap) {
        try {
            return this.mrPropertyValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyValueServiceImpl.queryPropertyValueModel", (Throwable)e);
            return null;
        }
    }

    private int countPropertyValue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mrPropertyValueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mr.MODEL.PropertyValueServiceImpl.countPropertyValue", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePropertyValue(MrPropertyValueDomain mrPropertyValueDomain) throws ApiException {
        String msg = this.checkPropertyValue(mrPropertyValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.savePropertyValue.checkPropertyValue", msg);
        }
        MrPropertyValue mrPropertyValue = this.makePropertyValue(mrPropertyValueDomain, null);
        this.setPropertyValueDefault(mrPropertyValue);
        this.savePropertyValueModel(mrPropertyValue);
    }

    @Override
    public void updatePropertyValueState(Integer propertyValueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePropertyValueModel(propertyValueId, dataState, oldDataState);
    }

    @Override
    public void updatePropertyValue(MrPropertyValueDomain mrPropertyValueDomain) throws ApiException {
        String msg = this.checkPropertyValue(mrPropertyValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.updatePropertyValue.checkPropertyValue", msg);
        }
        MrPropertyValue oldMrPropertyValue = this.getPropertyValueModelById(mrPropertyValueDomain.getPropertyValueId());
        if (null == oldMrPropertyValue) {
            throw new ApiException("mr.MODEL.PropertyValueServiceImpl.updatePropertyValue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MrPropertyValue mrPropertyValue = this.makePropertyValue(mrPropertyValueDomain, oldMrPropertyValue);
        this.setPropertyValueUpdataDefault(mrPropertyValue);
        this.updatePropertyValueModel(mrPropertyValue);
    }

    @Override
    public MrPropertyValue getPropertyValue(Integer propertyValueId) {
        return this.getPropertyValueModelById(propertyValueId);
    }

    @Override
    public void deletePropertyValue(Integer propertyValueId) throws ApiException {
        this.deletePropertyValueModel(propertyValueId);
    }

    @Override
    public QueryResult<MrPropertyValue> queryPropertyValuePage(Map<String, Object> map) {
        List<MrPropertyValue> mrPropertyValueList = this.queryPropertyValueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPropertyValue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mrPropertyValueList);
        return queryResult;
    }
}

