/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mpermis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mpermis.dao.MpMroleMapper;
import com.yqbsoft.laser.service.mpermis.domain.MpMroleDomainBean;
import com.yqbsoft.laser.service.mpermis.model.MpMrole;
import com.yqbsoft.laser.service.mpermis.service.MroleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MroleServiceImpl
extends BaseServiceImpl
implements MroleService {
    public static final String SYS_CODE = "mp.MPERMIS.MroleServiceImpl";
    private MpMroleMapper mpMroleMapper;

    public MpMroleMapper getMpMroleMapper() {
        return this.mpMroleMapper;
    }

    public void setMpMroleMapper(MpMroleMapper mpMroleMapper) {
        this.mpMroleMapper = mpMroleMapper;
    }

    @Override
    public void saveMrole(MpMroleDomainBean mpMroleDomainBean) throws ApiException {
        MpMrole mpMrole = new MpMrole();
        String msg = this.check(mpMrole = this.makeModel(mpMrole, mpMroleDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.saveMrole.check", msg);
        }
        this.setInsertDefaultValue(mpMrole);
        this.insertMrole(mpMrole);
    }

    private MpMrole makeModel(MpMrole mpMrole, MpMroleDomainBean mpMroleDomainBean) {
        if (mpMroleDomainBean == null) {
            return null;
        }
        if (mpMrole == null) {
            mpMrole = new MpMrole();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMrole, (Object)mpMroleDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMrole;
    }

    private String check(MpMrole mpMrole) {
        if (null == mpMrole) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMrole.getRoleName())) {
            msg = msg + "RoleName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsertDefaultValue(MpMrole mpMrole) {
        if (null == mpMrole) {
            return;
        }
        if (null == mpMrole.getDataState()) {
            mpMrole.setDataState(0);
        }
        if (null == mpMrole.getGmtCreate()) {
            mpMrole.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)mpMrole.getRoleCode())) {
            int code = this.getMaxCode();
            mpMrole.setRoleCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mpMroleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MroleServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private Date getSysDate() {
        try {
            return this.mpMroleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MroleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void insertMrole(MpMrole mpMrole) throws ApiException {
        try {
            this.mpMroleMapper.insert(mpMrole);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.insertMrole", "", (Throwable)e);
        }
    }

    private List<MpMrole> queryMrole(Map<String, Object> parammap) {
        try {
            return this.mpMroleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MpMrole getMrole(Integer mroleId) {
        return this.mpMroleMapper.selectByPrimaryKey(mroleId);
    }

    @Override
    public void updateMrole(MpMroleDomainBean mpMroleDomainBean) throws ApiException {
        MpMrole mpMrole = this.getMrole(mpMroleDomainBean.getRoleId());
        if (mpMrole == null) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.mpMrole.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mpMrole = this.makeModel(mpMrole, mpMroleDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.updateMrole.check", msg);
        }
        this.setUpdateDefaultValue(mpMrole);
        this.updateMqService(mpMrole);
    }

    private void setUpdateDefaultValue(MpMrole mpMrole) {
        if (null == mpMrole) {
            return;
        }
        if (null == mpMrole.getDataState()) {
            mpMrole.setDataState(0);
        }
        if (null == mpMrole.getGmtModified()) {
            mpMrole.setGmtModified(this.getSysDate());
        }
    }

    private void updateMqService(MpMrole mpMrole) throws ApiException {
        try {
            this.mpMroleMapper.updateByPrimaryKey(mpMrole);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.updateMqService", "", (Throwable)e);
        }
    }

    @Override
    public QueryResult<MpMrole> queryMpMroleList(Map<String, Object> map) {
        List<MpMrole> MpMroleList = this.queryMrole(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMroleList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(MpMroleList);
        return queryResult;
    }

    @Override
    public List<MpMrole> queryMpMroleInfo(Map<String, Object> map) {
        List<MpMrole> MpMroleList = this.queryMrole(map);
        return MpMroleList;
    }

    private int countMroleList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMroleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MroleServiceImpl.countMroleList", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteMrole(Integer mroleId) {
        this.mpMroleMapper.deleteByPrimaryKey(mroleId);
    }

    @Override
    public void updateMroleState(Integer roleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMrole(roleId, dataState, oldDataState);
    }

    private void updateStateMrole(Integer roleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == roleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleId", roleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mpMroleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.updateStateMqserver.ex");
        }
        if (i <= 0) {
            throw new ApiException("mp.MPERMIS.MroleServiceImpl.updateStateMqserver.null");
        }
    }
}

