/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mpermis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mpermis.dao.MpMmenuMapper;
import com.yqbsoft.laser.service.mpermis.domain.MpMmenuDomainBean;
import com.yqbsoft.laser.service.mpermis.model.MpMmenu;
import com.yqbsoft.laser.service.mpermis.service.MmenuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MmenuServiceImpl
extends BaseServiceImpl
implements MmenuService {
    public static final String SYS_CODE = "mp.MPERMIS.MmenuServiceImpl";
    private MpMmenuMapper mpMmenuMapper;

    public MpMmenuMapper getMpMmenuMapper() {
        return this.mpMmenuMapper;
    }

    public void setMpMmenuMapper(MpMmenuMapper mpMmenuMapper) {
        this.mpMmenuMapper = mpMmenuMapper;
    }

    @Override
    public void saveMmenu(MpMmenu mpMmenu) throws ApiException {
        String msg = this.check(mpMmenu);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MmenuServiceImpl.saveMmenu.null", msg);
        }
        this.setDefault(mpMmenu);
        this.saveMmenuModel(mpMmenu);
    }

    private void saveMmenuModel(MpMmenu mpMmenu) throws ApiException {
        if (mpMmenu == null) {
            return;
        }
        try {
            this.mpMmenuMapper.insert(mpMmenu);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MmenuServiceImpl.saveMmenuModel.ex", (Throwable)e);
        }
    }

    private String check(MpMmenu mpMmenu) {
        if (null == mpMmenu) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMmenu.getMenuName())) {
            msg = msg + "\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private Date getSysDate() {
        try {
            return this.mpMmenuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MmenuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void setDefault(MpMmenu mpMmenu) {
        if (null == mpMmenu) {
            return;
        }
        if (null == mpMmenu.getDataState()) {
            mpMmenu.setDataState(0);
        }
        if (null == mpMmenu.getGmtCreate()) {
            mpMmenu.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)mpMmenu.getMenuCode())) {
            int code = this.getMaxCode();
            mpMmenu.setMenuCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            code = this.mpMmenuMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private List<MpMmenu> queryMmenu(Map<String, Object> parammap) {
        try {
            return this.mpMmenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MpMmenu getMmenu(Integer mmenuId) {
        return this.mpMmenuMapper.selectByPrimaryKey(mmenuId);
    }

    @Override
    public void updateMmenu(MpMmenuDomainBean mpMmenuDomainBean) throws ApiException {
        MpMmenu mpMmenu = this.getMmenu(mpMmenuDomainBean.getMenuId());
        if (mpMmenu == null) {
            throw new ApiException("mp.MPERMIS.MmenuServiceImpl.updateMmenu.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mpMmenu = this.makeModel(mpMmenu, mpMmenuDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MmenuServiceImpl.updateMmenu.null", msg);
        }
        this.setUpDefault(mpMmenu);
        this.updateMmenuModel(mpMmenu);
    }

    private void updateMmenuModel(MpMmenu mpMmenu) throws ApiException {
        if (null == mpMmenu) {
            return;
        }
        try {
            this.mpMmenuMapper.updateByPrimaryKey(mpMmenu);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MmenuServiceImpl.updateMmenuModel.ex", (Throwable)e);
        }
    }

    private void setUpDefault(MpMmenu mpMmenu) {
        if (null == mpMmenu) {
            return;
        }
        mpMmenu.setGmtModified(this.getSysDate());
    }

    private MpMmenu makeModel(MpMmenu mpMmenu, MpMmenuDomainBean mpMmenuDomainBean) {
        if (mpMmenuDomainBean == null) {
            return null;
        }
        if (mpMmenu == null) {
            mpMmenu = new MpMmenu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMmenu, (Object)mpMmenuDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMmenu;
    }

    @Override
    public List<MpMmenu> queryMpMmenu(Map<String, Object> map) {
        return this.queryMmenu(map);
    }

    @Override
    public void deleteMmenu(Integer mmenuId) {
        this.mpMmenuMapper.deleteByPrimaryKey(mmenuId);
    }

    @Override
    public QueryResult<MpMmenu> queryMpMmenuPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        List<MpMmenu> list = this.queryMmenu(map);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.count(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private int count(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMmenuMapper.count(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    @Override
    public List<MpMmenuDomainBean> queryMpMmenuTree(String appmanageIcode, String menuParentCode) {
        ArrayList<MpMmenuDomainBean> mpMmenuDomainBeanList = new ArrayList<MpMmenuDomainBean>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuParentCode", menuParentCode);
        map.put("order", true);
        map.put("menuShow", 0);
        List<MpMmenu> mpMmenuList = this.queryMmenu(map);
        if (mpMmenuList == null || mpMmenuList.isEmpty()) {
            return null;
        }
        for (MpMmenu mpMmenu : mpMmenuList) {
            MpMmenuDomainBean mpMmenuDomainBean = this.getMpMmenuDomain(mpMmenu);
            mpMmenuDomainBean.setChildren(this.queryMpMmenuTree(mpMmenu.getAppmanageIcode(), mpMmenu.getMenuCode()));
            mpMmenuDomainBeanList.add(mpMmenuDomainBean);
        }
        return mpMmenuDomainBeanList;
    }

    private MpMmenuDomainBean getMpMmenuDomain(MpMmenu mpMmenu) {
        MpMmenuDomainBean mpMmenuDomainBean = new MpMmenuDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)mpMmenuDomainBean, (Object)mpMmenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMmenuDomainBean;
    }

    @Override
    public Map<String, String> queryMmenuCodeByUrl(String appmanageIcode, String menuParentCode) {
        List<MpMmenuDomainBean> list = this.queryMpMmenuTree(appmanageIcode, menuParentCode);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, String> menuCodeMap = new HashMap<String, String>();
        for (MpMmenuDomainBean mpMmenuDomainBean : list) {
            this.putMenuCodeMap(mpMmenuDomainBean.getChildren(), menuCodeMap, mpMmenuDomainBean.getMenuCode() + "_" + mpMmenuDomainBean.getMenuAction());
            menuCodeMap.put(mpMmenuDomainBean.getMenuAction(), mpMmenuDomainBean.getMenuCode() + "_" + mpMmenuDomainBean.getMenuAction());
        }
        return menuCodeMap;
    }

    private void putMenuCodeMap(List<MpMmenuDomainBean> list, Map<String, String> menuCodeMap, String parentMenuCode) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MpMmenuDomainBean mpMmenuDomainBean : list) {
            if (mpMmenuDomainBean.getChildren() != null && !mpMmenuDomainBean.getChildren().isEmpty()) {
                this.putMenuCodeMap(mpMmenuDomainBean.getChildren(), menuCodeMap, parentMenuCode);
            }
            if (!StringUtils.isNotBlank((String)mpMmenuDomainBean.getMenuAction())) continue;
            menuCodeMap.put(mpMmenuDomainBean.getMenuAction(), parentMenuCode);
        }
    }
}

