/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mpermis.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mpermis.MpermisConstants;
import com.yqbsoft.laser.service.mpermis.dao.MpMopPermissionMapper;
import com.yqbsoft.laser.service.mpermis.model.MpMopPermission;
import com.yqbsoft.laser.service.mpermis.service.MopPermissionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MopPermissionServiceImpl
extends BaseServiceImpl
implements MopPermissionService {
    public static final String SYS_CODE = "mp.MPERMIS.MopPermissionServiceImpl";
    private MpMopPermissionMapper mpMopPermissionMapper;

    public MpMopPermissionMapper getMpMopPermissionMapper() {
        return this.mpMopPermissionMapper;
    }

    public void setMpMopPermissionMapper(MpMopPermissionMapper mpMopPermissionMapper) {
        this.mpMopPermissionMapper = mpMopPermissionMapper;
    }

    @Override
    public void saveMopPermission(MpMopPermission mpMopPermission) {
        this.mpMopPermissionMapper.insert(mpMopPermission);
    }

    private List<MpMopPermission> queryMopPermission(Map<String, Object> parammap) {
        try {
            return this.mpMopPermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MpMopPermission getMopPermission(Integer mopPermissionId) {
        return this.mpMopPermissionMapper.selectByPrimaryKey(mopPermissionId);
    }

    @Override
    public void updateMopPermission(MpMopPermission mpMopPermission) {
        this.mpMopPermissionMapper.updateByPrimaryKey(mpMopPermission);
    }

    @Override
    public List<MpMopPermission> queryMpMopPermission(Map<String, Object> map) {
        return this.queryMopPermission(map);
    }

    @Override
    public void deleteMopPermission(Integer mopPermissionId) {
        this.mpMopPermissionMapper.deleteByPrimaryKey(mopPermissionId);
    }

    @Override
    public Map<String, String> queryMuserPermission(String appmanageIcode, String roleCode, String userCode) {
        List<MpMopPermission> muserPermisList = null;
        try {
            muserPermisList = this.mpMopPermissionMapper.query(this.getQueryParamMap("opPermissionType,opPermissionCode", new Object[]{MpermisConstants.PERMIS_TYPE_OPER, userCode}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<MpMopPermission> rolePermisList = null;
        if (StringUtils.isNotBlank((String)roleCode)) {
            rolePermisList = this.mpMopPermissionMapper.query(this.getQueryParamMap("opPermissionType,opPermissionCode", new Object[]{MpermisConstants.PERMIS_TYPE_ROLE, roleCode}));
        }
        return this.setMuserPermis(muserPermisList, rolePermisList);
    }

    private Map<String, String> setMuserPermis(List<MpMopPermission> muserPermisList, List<MpMopPermission> rolePermisList) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != muserPermisList && !muserPermisList.isEmpty()) {
            Map<String, MpMopPermission> roleMap = this.getRoleMap(rolePermisList);
            this.setMuserPermission(map, muserPermisList, roleMap);
        }
        if (null != rolePermisList && !rolePermisList.isEmpty()) {
            for (MpMopPermission mod : rolePermisList) {
                if (null == mod.getOpPermissionState()) {
                    mod.setOpPermissionState(MpermisConstants.MUSER_STATE_ROLE);
                }
                if (!MpermisConstants.MUSER_STATE_ON.equals(mod.getOpPermissionState()) || !StringUtils.isBlank((String)((String)map.get(mod.getPermissionCode())))) continue;
                map.put(mod.getAppmanageIcode() + "-" + mod.getMenuCode(), mod.getMenuCode());
            }
        }
        return map;
    }

    private Map<String, MpMopPermission> getRoleMap(List<MpMopPermission> roleList) {
        HashMap<String, MpMopPermission> roleMap = new HashMap<String, MpMopPermission>();
        if (null != roleList && !roleList.isEmpty()) {
            for (MpMopPermission permission : roleList) {
                roleMap.put(permission.getMenuCode(), permission);
            }
        }
        return roleMap;
    }

    private void setMuserPermission(Map<String, String> map, List<MpMopPermission> muserPermisList, Map<String, MpMopPermission> roleMap) {
        MpMopPermission roleMod = null;
        for (MpMopPermission mod : muserPermisList) {
            if (null != roleMap) {
                roleMod = roleMap.get(mod.getPermissionCode());
            }
            if (null == mod.getOpPermissionState()) {
                mod.setOpPermissionState(MpermisConstants.MUSER_STATE_ROLE);
            }
            if (null != roleMod && MpermisConstants.MUSER_STATE_ROLE.equals(mod.getOpPermissionState()) && MpermisConstants.MUSER_STATE_ON.equals(roleMod.getOpPermissionState()) || MpermisConstants.MUSER_STATE_ON.equals(mod.getOpPermissionState())) {
                map.put(mod.getAppmanageIcode() + "-" + mod.getMenuCode(), mod.getMenuCode());
            }
            if (null == roleMod) continue;
            roleMod.setOpPermissionState(mod.getOpPermissionState());
        }
    }

    @Override
    public void saveMopPermission(List<MpMopPermission> mpMopPermissionList) {
        if (mpMopPermissionList == null || mpMopPermissionList.isEmpty()) {
            return;
        }
        for (MpMopPermission mpMopPermission : mpMopPermissionList) {
            this.saveMopPermission(mpMopPermission);
        }
    }

    @Override
    public void updateMopPermission(List<MpMopPermission> mpMopPermissionList) {
        if (mpMopPermissionList == null || mpMopPermissionList.isEmpty()) {
            return;
        }
        for (MpMopPermission mpMopPermission : mpMopPermissionList) {
            this.updateMopPermission(mpMopPermission);
        }
    }

    @Override
    public QueryResult<MpMopPermission> queryMpMopPermissionPage(Map<String, Object> map) {
        List<MpMopPermission> mopPermissionList = this.queryMopPermission(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMopPermission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mopPermissionList);
        return queryResult;
    }

    private int countMopPermission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMopPermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MopPermissionServiceImpl.countMopPermission", (Throwable)e);
        }
        return i;
    }
}

