/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mpermis.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mpermis.dao.MpMpermissionListMapper;
import com.yqbsoft.laser.service.mpermis.dao.MpMpermissionMapper;
import com.yqbsoft.laser.service.mpermis.domain.MpMpermissionDomainBean;
import com.yqbsoft.laser.service.mpermis.domain.MpMpermissionListDomainBean;
import com.yqbsoft.laser.service.mpermis.model.MpMpermission;
import com.yqbsoft.laser.service.mpermis.model.MpMpermissionList;
import com.yqbsoft.laser.service.mpermis.service.MpermissionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MpermissionServiceImpl
extends BaseServiceImpl
implements MpermissionService {
    public static final String SYS_CODE = "mp.MPERMIS.MpermissionServiceImpl";
    private static final String CACHE_KEY = "mpermission-flag";
    private MpMpermissionMapper mpMpermissionMapper;
    private MpMpermissionListMapper mpMpermissionListMapper;

    public MpMpermissionMapper getMpMpermissionMapper() {
        return this.mpMpermissionMapper;
    }

    public void setMpMpermissionMapper(MpMpermissionMapper mpMpermissionMapper) {
        this.mpMpermissionMapper = mpMpermissionMapper;
    }

    public MpMpermissionListMapper getMpMpermissionListMapper() {
        return this.mpMpermissionListMapper;
    }

    public void setMpMpermissionListMapper(MpMpermissionListMapper mpMpermissionListMapper) {
        this.mpMpermissionListMapper = mpMpermissionListMapper;
    }

    @Override
    public MpMpermission saveMpermission(MpMpermissionDomainBean mpMpermissionDomainBean) throws ApiException {
        MpMpermission mpMpermission = this.makeModel(null, mpMpermissionDomainBean);
        String msg = this.check(mpMpermission);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.saveMpermission.null", msg);
        }
        this.setDefault(mpMpermission);
        this.saveMpermissionModel(mpMpermission);
        List<MpMpermissionListDomainBean> mpermisslist = mpMpermissionDomainBean.getMpermisslist();
        if (null == mpermisslist || mpermisslist.isEmpty()) {
            return mpMpermission;
        }
        for (MpMpermissionListDomainBean mpMpermissionListDomainBean : mpermisslist) {
            mpMpermissionListDomainBean.setAppmanageIcode(mpMpermission.getAppmanageIcode());
            mpMpermissionListDomainBean.setPermissionCode(mpMpermission.getPermissionCode());
            if (null == mpMpermissionListDomainBean.getPermissionListType()) {
                mpMpermissionListDomainBean.setPermissionListType(mpMpermission.getPermissionType());
            }
            if (null == mpMpermissionListDomainBean.getPermissionListSort()) {
                mpMpermissionListDomainBean.setPermissionListSort(mpMpermission.getPermissionSort());
            }
            this.saveMpermission(mpMpermissionDomainBean);
        }
        this.setMpermissionFlag();
        return mpMpermission;
    }

    private void setMpermissionFlag() {
        DisUtil.setVer((String)CACHE_KEY, (String)"1");
    }

    private void saveMpermissionModel(MpMpermission mpMpermission) throws ApiException {
        if (null == mpMpermission) {
            return;
        }
        try {
            this.mpMpermissionMapper.insert(mpMpermission);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.saveMpermissionMode.ex", (Throwable)e);
        }
    }

    private String check(MpMpermission mpMpermission) {
        if (null == mpMpermission) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMpermission.getPermissionName())) {
            msg = msg + "\u6743\u9650\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String check(MpMpermissionList mpMpermissionList) {
        if (null == mpMpermissionList) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mpMpermissionList.getPermissionCode())) {
            msg = msg + "\u6743\u9650\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)mpMpermissionList.getPermissionListName())) {
            msg = msg + "\u6743\u9650\u540d\u79f0\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(MpMpermission mpMpermission) {
        if (null == mpMpermission) {
            return;
        }
        if (null == mpMpermission.getDataState()) {
            mpMpermission.setDataState(0);
        }
        if (null == mpMpermission.getGmtCreate()) {
            mpMpermission.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)mpMpermission.getPermissionCode())) {
            int code = this.getMaxCode();
            mpMpermission.setPermissionCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mpMpermissionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MpermissionServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpDefault(MpMpermission mpMpermission) {
        if (null == mpMpermission) {
            return;
        }
        mpMpermission.setGmtModified(this.getSysDate());
    }

    private void setUpDefault(MpMpermissionList mpMpermissionList) {
        if (null == mpMpermissionList) {
            return;
        }
        mpMpermissionList.setGmtModified(this.getSysDate());
    }

    private void setDefault(MpMpermissionList mpMpermissionList) {
        if (null == mpMpermissionList) {
            return;
        }
        if (null == mpMpermissionList.getDataState()) {
            mpMpermissionList.setDataState(0);
        }
        if (null == mpMpermissionList.getGmtCreate()) {
            mpMpermissionList.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)mpMpermissionList.getPermissionListCode())) {
            int code = this.getMaxCodeList();
            mpMpermissionList.setPermissionListCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCodeList() {
        int code = 0;
        try {
            code = this.mpMpermissionListMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private Date getSysDate() {
        try {
            return this.mpMpermissionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MpermissionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private List<MpMpermission> queryMpermission(Map<String, Object> parammap) {
        try {
            return this.mpMpermissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MpMpermission getMpermission(Integer mpermissionId) {
        return this.mpMpermissionMapper.selectByPrimaryKey(mpermissionId);
    }

    @Override
    public void updateMpermission(MpMpermissionDomainBean mpMpermissionDomainBean) throws ApiException {
        MpMpermission mpMpermission = this.getMpermission(mpMpermissionDomainBean.getPermissionId());
        if (mpMpermission == null) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.updateMpermission.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mpMpermission = this.makeModel(mpMpermission, mpMpermissionDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.updateMpermission.null", msg);
        }
        this.setUpDefault(mpMpermission);
        this.updateMpermissionModel(mpMpermission);
        this.setMpermissionFlag();
    }

    private void updateMpermissionModel(MpMpermission mpMpermission) throws ApiException {
        if (null == mpMpermission) {
            return;
        }
        try {
            this.mpMpermissionMapper.updateByPrimaryKey(mpMpermission);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.updateMpermissionModel.ex");
        }
    }

    private void updateMpermissionListModel(MpMpermissionList mpMpermissionList) throws ApiException {
        if (null == mpMpermissionList) {
            return;
        }
        try {
            this.mpMpermissionListMapper.updateByPrimaryKey(mpMpermissionList);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.updateMpermissionListModel.ex");
        }
    }

    private MpMpermission makeModel(MpMpermission mpMpermission, MpMpermissionDomainBean mpMpermissionDomainBean) {
        if (mpMpermissionDomainBean == null) {
            return null;
        }
        if (mpMpermission == null) {
            mpMpermission = new MpMpermission();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMpermission, (Object)mpMpermissionDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMpermission;
    }

    private MpMpermissionList makeModel(MpMpermissionList mpMpermissionList, MpMpermissionListDomainBean mpMpermissionListDomainBean) {
        if (mpMpermissionListDomainBean == null) {
            return null;
        }
        if (mpMpermissionList == null) {
            mpMpermissionList = new MpMpermissionList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mpMpermissionList, (Object)mpMpermissionListDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mpMpermissionList;
    }

    @Override
    public List<MpMpermission> queryMpMpermission(Map<String, Object> map) {
        return this.queryMpermission(map);
    }

    @Override
    public void deleteMpermission(Integer mpermissionId) {
        this.mpMpermissionMapper.deleteByPrimaryKey(mpermissionId);
        this.setMpermissionFlag();
    }

    @Override
    public void saveMpermissionList(MpMpermissionListDomainBean mpMpermissionListDomainBean) throws ApiException {
        MpMpermissionList mpMpermissionList = this.makeModel(null, mpMpermissionListDomainBean);
        String msg = this.check(mpMpermissionList);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.saveMpermissionList.null", msg);
        }
        this.setDefault(mpMpermissionList);
        this.saveMpermissionListModel(mpMpermissionList);
        this.setMpermissionFlag();
    }

    private void saveMpermissionListModel(MpMpermissionList mpMpermissionList) throws ApiException {
        if (null == mpMpermissionList) {
            return;
        }
        try {
            this.mpMpermissionListMapper.insert(mpMpermissionList);
        }
        catch (Exception e) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.saveMpermissionListModel.ex");
        }
    }

    private List<MpMpermissionList> queryMpermissionList(Map<String, Object> parammap) {
        try {
            return this.mpMpermissionListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MpMpermissionList getMpermissionList(Integer mpermissionListId) {
        return this.mpMpermissionListMapper.selectByPrimaryKey(mpermissionListId);
    }

    @Override
    public void updateMpermissionList(MpMpermissionListDomainBean mpMpermissionListDomainBean) throws ApiException {
        MpMpermissionList mpMpermissionList = this.getMpermissionList(mpMpermissionListDomainBean.getPermissionListId());
        if (mpMpermissionList == null) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.updateMpermissionList.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(mpMpermissionList = this.makeModel(mpMpermissionList, mpMpermissionListDomainBean));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mp.MPERMIS.MpermissionServiceImpl.updateMpermissionList.null", msg);
        }
        this.setUpDefault(mpMpermissionList);
        this.updateMpermissionListModel(mpMpermissionList);
        this.setMpermissionFlag();
    }

    @Override
    public List<MpMpermissionList> queryMpMpermissionList(Map<String, Object> map) {
        return this.queryMpermissionList(map);
    }

    @Override
    public void deleteMpermissionList(Integer mpermissionListId) {
        this.mpMpermissionListMapper.deleteByPrimaryKey(mpermissionListId);
        this.setMpermissionFlag();
    }

    @Override
    public QueryResult<MpMpermission> queryMpMpermissionPage(Map<String, Object> map) {
        List<MpMpermission> mpMpermissionList = this.queryMpermission(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMpermission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mpMpermissionList);
        return queryResult;
    }

    private int countMpermission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMpermissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MpermissionServiceImpl.countMpermission", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<MpMpermissionList> queryMpMpermissionListPage(Map<String, Object> map) {
        List<MpMpermissionList> mpMpermissionListList = this.queryMpermissionList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMpermissionList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mpMpermissionListList);
        return queryResult;
    }

    private int countMpermissionList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mpMpermissionListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mp.MPERMIS.MpermissionServiceImpl.countMpermissionList", (Throwable)e);
        }
        return i;
    }
}

