/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.mq.service;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.tool.util.FileUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringBrokerContext;
import org.apache.activemq.xbean.XBeanBrokerFactory;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class VfinXBeanBrokerFactory
extends XBeanBrokerFactory {
    protected final OpenLogUtil logger = new OpenLogUtil(((Object)((Object)this)).getClass());

    public BrokerService createBroker(String uri, String content) throws Exception {
        if (StringUtils.isBlank((String)uri) || StringUtils.isBlank((String)content)) {
            return null;
        }
        BrokerFactory.setStartDefault((boolean)false);
        ApplicationContext context = this.createApplicationContext(uri, content);
        BrokerService broker = null;
        try {
            broker = (BrokerService)context.getBean("broker");
        }
        catch (BeansException e) {
            // empty catch block
        }
        if (broker == null) {
            String name;
            String[] names = context.getBeanNamesForType(BrokerService.class);
            for (int i = 0; i < names.length && (broker = (BrokerService)context.getBean(name = names[i])) == null; ++i) {
            }
        }
        if (broker == null) {
            this.logger.error("The configuration has no BrokerService instance for resource: " + uri);
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + uri);
        }
        SpringBrokerContext springBrokerContext = new SpringBrokerContext();
        springBrokerContext.setApplicationContext(context);
        springBrokerContext.setConfigurationUrl(uri);
        broker.setBrokerContext((BrokerContext)springBrokerContext);
        return broker;
    }

    public ApplicationContext createApplicationContext(String uri, String content) throws Exception {
        if (StringUtils.isBlank((String)uri) || StringUtils.isBlank((String)content)) {
            return null;
        }
        File file = File.createTempFile(uri, ".xml");
        this.logger.debug("createApplicationContext", (Object)("file:" + file.getPath()));
        int i = FileUtil.writeFile((File)file, (String)content, null);
        this.logger.debug("createApplicationContext", (Object)("writeFile:" + i + "===content:" + content));
        FileSystemResource resource = new FileSystemResource(file);
        try {
            return new ResourceXmlApplicationContext((Resource)resource){

                protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
                    reader.setValidating(VfinXBeanBrokerFactory.this.isValidate());
                }
            };
        }
        catch (FatalBeanException errorToLog) {
            this.logger.error("createApplicationContext", (Object)"FatalBeanException", (Throwable)errorToLog);
            throw errorToLog;
        }
    }
}

