/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.mq.web;

import com.yqbsoft.laser.service.esb.mq.domain.ConnetMqQueryBean;
import com.yqbsoft.laser.service.esb.mq.domain.MqQueryBean;
import com.yqbsoft.laser.service.esb.mq.service.MqJmsQueryService;
import com.yqbsoft.laser.service.esb.mq.web.LocalBrokerFacade;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;

public class JmsQueryServiceImpl
implements MqJmsQueryService {
    private static Map<String, LocalBrokerFacade> brokerFacadeMap = new HashMap<String, LocalBrokerFacade>();

    public static Map<String, LocalBrokerFacade> getBrokerFacadeMap() {
        return brokerFacadeMap;
    }

    public static void setBrokerFacadeMap(Map<String, LocalBrokerFacade> brokerFacadeMap) {
        JmsQueryServiceImpl.brokerFacadeMap = brokerFacadeMap;
    }

    @Override
    public List<MqQueryBean> queryQueues(String brokerName) {
        if (StringUtils.isBlank((String)brokerName)) {
            return null;
        }
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap() || null == JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName)) {
            return null;
        }
        ArrayList<MqQueryBean> qblist = null;
        try {
            Collection<QueueViewMBean> qlist = JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName).getQueues();
            if (null == qlist) {
                return null;
            }
            qblist = new ArrayList<MqQueryBean>();
            MqQueryBean mqQueryBean = null;
            for (QueueViewMBean queueViewMBean : qlist) {
                mqQueryBean = new MqQueryBean();
                qblist.add(mqQueryBean);
                mqQueryBean.setName(queueViewMBean.getName());
                mqQueryBean.setConsumerCount(queueViewMBean.getConsumerCount());
                mqQueryBean.setDequeueCount(queueViewMBean.getDequeueCount());
                mqQueryBean.setDispatchCount(queueViewMBean.getDispatchCount());
                mqQueryBean.setEnqueueCount(queueViewMBean.getEnqueueCount());
                mqQueryBean.setExpiredCount(queueViewMBean.getExpiredCount());
                mqQueryBean.setProducerCount(queueViewMBean.getProducerCount());
                mqQueryBean.setQueueSize(queueViewMBean.getQueueSize());
                mqQueryBean.setMemoryLimit(queueViewMBean.getMemoryLimit());
                mqQueryBean.setMemoryPercentUsage(queueViewMBean.getMemoryPercentUsage());
                mqQueryBean.setMemoryUsageByteCount(queueViewMBean.getMemoryUsageByteCount());
                mqQueryBean.setMemoryUsagePortion(queueViewMBean.getMemoryUsagePortion());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qblist;
    }

    @Override
    public List<MqQueryBean> queryTopics(String brokerName) {
        if (StringUtils.isBlank((String)brokerName)) {
            return null;
        }
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap() || null == JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName)) {
            return null;
        }
        ArrayList<MqQueryBean> qblist = null;
        try {
            Collection<TopicViewMBean> qlist = JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName).getTopics();
            if (null == qlist) {
                return null;
            }
            qblist = new ArrayList<MqQueryBean>();
            MqQueryBean queryBean = null;
            for (TopicViewMBean queueViewMBean : qlist) {
                queryBean = new MqQueryBean();
                qblist.add(queryBean);
                queryBean.setName(queueViewMBean.getName());
                queryBean.setConsumerCount(queueViewMBean.getConsumerCount());
                queryBean.setDequeueCount(queueViewMBean.getDequeueCount());
                queryBean.setDispatchCount(queueViewMBean.getDispatchCount());
                queryBean.setEnqueueCount(queueViewMBean.getEnqueueCount());
                queryBean.setExpiredCount(queueViewMBean.getExpiredCount());
                queryBean.setProducerCount(queueViewMBean.getProducerCount());
                queryBean.setQueueSize(queueViewMBean.getQueueSize());
                queryBean.setMemoryLimit(queueViewMBean.getMemoryLimit());
                queryBean.setMemoryPercentUsage(queueViewMBean.getMemoryPercentUsage());
                queryBean.setMemoryUsageByteCount(queueViewMBean.getMemoryUsageByteCount());
                queryBean.setMemoryUsagePortion(queueViewMBean.getMemoryUsagePortion());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qblist;
    }

    @Override
    public List<ConnetMqQueryBean> queryConnections(String brokerName) {
        if (StringUtils.isBlank((String)brokerName)) {
            return null;
        }
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap() || null == JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName)) {
            return null;
        }
        ArrayList<ConnetMqQueryBean> qblist = null;
        try {
            Collection<ConnectionViewMBean> qlist = JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName).getConnections();
            if (null == qlist) {
                return null;
            }
            qblist = new ArrayList<ConnetMqQueryBean>();
            ConnetMqQueryBean connetMqQueryBean = null;
            for (ConnectionViewMBean connectionViewMBean : qlist) {
                connetMqQueryBean = new ConnetMqQueryBean();
                qblist.add(connetMqQueryBean);
                connetMqQueryBean.setActive(connectionViewMBean.isActive());
                connetMqQueryBean.setBlocked(connectionViewMBean.isBlocked());
                connetMqQueryBean.setClientid(connectionViewMBean.getClientId());
                connetMqQueryBean.setConnected(connectionViewMBean.isConnected());
                ArrayList<Map<String, String>> consumersList = new ArrayList<Map<String, String>>();
                connetMqQueryBean.setConsumersList(consumersList);
                for (ObjectName objectName : connectionViewMBean.getConsumers()) {
                    consumersList.add(objectName.getKeyPropertyList());
                }
                connetMqQueryBean.setDispatchQueueSize(connectionViewMBean.getDispatchQueueSize());
                ArrayList<Map<String, String>> producersList = new ArrayList<Map<String, String>>();
                connetMqQueryBean.setProducersList(producersList);
                for (ObjectName objectName : connectionViewMBean.getProducers()) {
                    producersList.add(objectName.getKeyPropertyList());
                }
                connetMqQueryBean.setRemoteAddress(connectionViewMBean.getRemoteAddress());
                connetMqQueryBean.setSlow(connectionViewMBean.isSlow());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qblist;
    }

    @Override
    public Collection<String> queryAllBrokerName() {
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : JmsQueryServiceImpl.getBrokerFacadeMap().keySet()) {
            list.add(key);
        }
        return list;
    }
}

