/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.mq.server;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.jms.MqServerInt;
import com.yqbsoft.laser.service.esb.core.jms.invo.BrokerBean;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.mq.service.VfinXBeanBrokerFactory;
import com.yqbsoft.laser.service.esb.mq.web.JmsQueryServiceImpl;
import com.yqbsoft.laser.service.esb.mq.web.LocalBrokerFacade;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.transport.TransportFactorySupport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.usage.SystemUsage;

public class JmsServer
extends BaseServiceImpl
implements MqServerInt {
    public static final String SYS_CODE = "MQ.JmsServer";
    private static final String defTransportName = "openwire";
    private static final String perAdapterKeyName = "pdbName";
    private static final String perAdapterKeyDire = "pdbDire";
    private static final String perAdapterKeyDs = "pdbDs";
    private static final String TransportKeyName = "name";
    private static final String TransportKeyUrl = "url";
    private static final String perAdapterKeyKahaDB = "kahaDB";
    private static final String perAdapterKeyJdbc = "jdbc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAll() {
        String string = SYS_CODE;
        synchronized (SYS_CODE) {
            String key = "McMqserver-start";
            Map cacheMap = DisUtil.getMapJson((String)key, String.class, String.class);
            if (null == cacheMap || cacheMap.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            String list = (String)cacheMap.get(ServletMain.getAppKey());
            if (StringUtils.isBlank((String)list)) {
                this.logger.info("MQ.JmsServer.startAll.null");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            List beanlist = (List)JsonUtil.buildNormalBinder().getJsonToList(list, BrokerBean.class);
            if (null == beanlist || beanlist.isEmpty()) {
                this.logger.info("MQ.JmsServer.startAll.null1");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            for (BrokerBean brokerBean : beanlist) {
                this.start(brokerBean);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public boolean start(BrokerBean brokerBean) {
        if (null == brokerBean || null == brokerBean.getBrokerName()) {
            return false;
        }
        Map<String, LocalBrokerFacade> map = JmsQueryServiceImpl.getBrokerFacadeMap();
        synchronized (map) {
            if (null != JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerBean.getBrokerName()) && !this.stop(brokerBean.getBrokerName())) {
                return false;
            }
            try {
                brokerBean.setBrokerUrl(RegeditUtil.replaceServiceUrl((String)ServletMain.getAppKey(), (String)brokerBean.getBrokerUrl()));
                BrokerService broker = this.createBroker(brokerBean);
                if (null == broker) {
                    broker = new BrokerService();
                    broker.setBrokerName(brokerBean.getBrokerName());
                    broker.setPersistent(brokerBean.isPersistent());
                    broker.setUseJmx(brokerBean.isUseJmx());
                    this.makeConnector(broker, brokerBean);
                }
                if (brokerBean.getConnectorPort() > 0 && broker.getManagementContext() == null) {
                    ManagementContext managementContext = new ManagementContext();
                    managementContext.setCreateMBeanServer(brokerBean.isCreateMBeanServer());
                    managementContext.setConnectorPort(brokerBean.getConnectorPort());
                    managementContext.setCreateConnector(brokerBean.isCreateConnector());
                    broker.setManagementContext(managementContext);
                }
                Map extParam = brokerBean.getExtParam();
                this.setExtparam(extParam, broker);
                broker.start();
                JmsQueryServiceImpl.getBrokerFacadeMap().put(brokerBean.getBrokerName(), new LocalBrokerFacade(broker));
                this.logger.info("MQ:" + brokerBean.getBrokerUrl() + ":" + brokerBean.getNetworkUrl() + "==\u542f\u52a8\u6210\u529f");
                return true;
            }
            catch (Exception e) {
                throw new ApiException("mq.JmsServer.ex", e.getMessage());
            }
        }
    }

    private BrokerService createBroker(BrokerBean brokerBean) throws Exception {
        if (null == brokerBean || StringUtils.isBlank((String)brokerBean.getBrokerConfig())) {
            return null;
        }
        String uri = brokerBean.getBrokerName();
        VfinXBeanBrokerFactory vfinXBeanBrokerFactory = new VfinXBeanBrokerFactory();
        return vfinXBeanBrokerFactory.createBroker(uri, brokerBean.getBrokerConfig());
    }

    public void makeDB(BrokerService broker, BrokerBean brokerBean) throws Exception {
        if (null == broker || null == brokerBean) {
            return;
        }
        Map pmap = brokerBean.getPersistenceAdapterParam();
        if (null == pmap || pmap.isEmpty()) {
            return;
        }
        String pdbName = (String)pmap.get(perAdapterKeyName);
        if (StringUtils.isBlank((String)pdbName)) {
            return;
        }
        if (pdbName.equals(perAdapterKeyKahaDB)) {
            KahaDBStore kahaDB = new KahaDBStore();
            kahaDB.setDirectory(new File((String)pmap.get(perAdapterKeyDire)));
            broker.setPersistenceAdapter((PersistenceAdapter)kahaDB);
        } else if (pdbName.equals(perAdapterKeyJdbc)) {
            JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
            jdbc.setDataDirectory((String)pmap.get(perAdapterKeyDire));
            jdbc.setDataSource((DataSource)ApplicationContextUtil.getService((String)((String)pmap.get(perAdapterKeyDs))));
        }
    }

    public void makeConnector(BrokerService broker, BrokerBean brokerBean) throws Exception {
        if (null == broker || null == brokerBean) {
            return;
        }
        TransportServer transport = TransportFactorySupport.bind((BrokerService)broker, (URI)new URI(brokerBean.getBrokerUrl()));
        TransportConnector transportConnector = new TransportConnector(transport);
        transportConnector.setName(defTransportName);
        broker.addConnector(transportConnector);
        this.makeTransportConnector(broker, brokerBean.getTransportParam());
        if (StringUtils.isNotBlank((String)brokerBean.getNetworkUrl())) {
            this.makeNetworkConnector(broker, brokerBean.getNetworkParam());
        }
    }

    private void makeTransportConnector(BrokerService broker, Map<String, Map<String, Object>> transportParam) throws Exception {
        if (null == broker || null == transportParam || transportParam.isEmpty()) {
            return;
        }
        Map<String, Object> vmap = null;
        boolean add = false;
        for (String key : transportParam.keySet()) {
            vmap = transportParam.get(key);
            if (null == vmap || vmap.isEmpty()) continue;
            add = false;
            TransportConnector transportConnector = broker.getTransportConnectorByName((String)vmap.get(TransportKeyName));
            if (null == transportConnector) {
                TransportServer transport = TransportFactorySupport.bind((BrokerService)broker, (URI)new URI((String)vmap.get(TransportKeyUrl)));
                transportConnector = new TransportConnector(transport);
                add = true;
            }
            for (String key1 : vmap.keySet()) {
                BeanUtils.forceSetProperty((Object)transportConnector, (String)key1, (Object)vmap.get(key1));
            }
            if (!add) continue;
            broker.addConnector(transportConnector);
        }
    }

    private void makeNetworkConnector(BrokerService broker, Map<String, Map<String, Object>> networkParam) throws Exception {
        if (null == broker || null == networkParam || networkParam.isEmpty()) {
            return;
        }
        Map<String, Object> vmap = null;
        for (String key : networkParam.keySet()) {
            vmap = networkParam.get(key);
            if (null == vmap || vmap.isEmpty()) continue;
            DiscoveryNetworkConnector networkConnector = new DiscoveryNetworkConnector(new URI((String)vmap.get(TransportKeyUrl)));
            for (String key1 : vmap.keySet()) {
                BeanUtils.forceSetProperty((Object)networkConnector, (String)key1, (Object)vmap.get(key1));
            }
            broker.addNetworkConnector((NetworkConnector)networkConnector);
        }
    }

    private void setExtparam(Map<String, String> extParam, BrokerService broker) {
        String jobSchedulerUsage;
        String storeUsageLimit;
        String tempUsageLimit;
        if (null == extParam || extParam.isEmpty() || null == broker) {
            return;
        }
        String memoryUsageLimit = extParam.get("memoryUsageLimit");
        SystemUsage memoryManager = broker.getSystemUsage();
        if (StringUtils.isNotBlank((String)memoryUsageLimit)) {
            memoryManager.getMemoryUsage().setLimit(Long.valueOf(memoryUsageLimit) * 1024L * 1024L);
        }
        if (StringUtils.isNotBlank((String)(tempUsageLimit = extParam.get("tempUsageLimit")))) {
            memoryManager.getTempUsage().setLimit(Long.valueOf(tempUsageLimit) * 1024L * 1024L);
        }
        if (StringUtils.isNotBlank((String)(storeUsageLimit = extParam.get("storeUsageLimit")))) {
            memoryManager.getStoreUsage().setLimit(Long.valueOf(storeUsageLimit) * 1024L * 1024L);
        }
        if (StringUtils.isNotBlank((String)(jobSchedulerUsage = extParam.get("jobSchedulerUsage")))) {
            memoryManager.getStoreUsage().setLimit(Long.valueOf(jobSchedulerUsage) * 1024L * 1024L);
        }
        broker.setSystemUsage(memoryManager);
    }

    public boolean stop(String brokerName) {
        if (null == brokerName) {
            return false;
        }
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName)) {
            return true;
        }
        try {
            JmsQueryServiceImpl.getBrokerFacadeMap().remove(brokerName).getBrokerService().stop();
            return true;
        }
        catch (Exception e) {
            this.logger.info("MQ.JmsServer.stop.ex", (Object)e);
            return false;
        }
    }

    public boolean delAllMessage(String brokerName) {
        if (null == brokerName) {
            return false;
        }
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName)) {
            return true;
        }
        try {
            JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName).getBrokerService().deleteAllMessages();
            return true;
        }
        catch (Exception e) {
            this.logger.info("MQ.JmsServer.delAllMessage.ex", (Object)e);
            return false;
        }
    }

    public boolean isRun(String brokerName) {
        if (null == brokerName) {
            return false;
        }
        if (null == JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName)) {
            return false;
        }
        try {
            return !JmsQueryServiceImpl.getBrokerFacadeMap().get(brokerName).getBroker().isStopped();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] args) {
        JmsServer jmsServer = new JmsServer();
        jmsServer.startAll();
    }
}

