/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthConfigListMapper;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthConfigMapper;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigReDomain;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthConfig;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthConfigList;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthConfigService;
import com.yqbsoft.laser.service.oauthserver.service.impl.OAuthConfigPollThread;
import com.yqbsoft.laser.service.oauthserver.service.impl.OAuthConfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OsOAuthConfigServiceImpl
extends BaseServiceImpl
implements OsOAuthConfigService {
    public static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthConfigServiceImpl";
    private OsOAuthConfigMapper osOAuthConfigMapper;
    private OsOAuthConfigListMapper osOAuthConfigListMapper;
    private static OAuthConfigService oAuthConfigService;
    private static Object obj;

    public void setOsOAuthConfigMapper(OsOAuthConfigMapper osOAuthConfigMapper) {
        this.osOAuthConfigMapper = osOAuthConfigMapper;
    }

    public void setOsOAuthConfigListMapper(OsOAuthConfigListMapper osOAuthConfigListMapper) {
        this.osOAuthConfigListMapper = osOAuthConfigListMapper;
    }

    private Date getSysDate() {
        try {
            return this.osOAuthConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOAuthConfig(OsOAuthConfigDomain osOAuthConfigDomain) {
        if (null == osOAuthConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)osOAuthConfigDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)osOAuthConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOAuthConfigDefault(OsOAuthConfig osOAuthConfig) {
        if (null == osOAuthConfig) {
            return;
        }
        if (null == osOAuthConfig.getDataState()) {
            osOAuthConfig.setDataState(0);
        }
        if (null == osOAuthConfig.getGmtCreate()) {
            osOAuthConfig.setGmtCreate(this.getSysDate());
        }
        osOAuthConfig.setGmtModified(this.getSysDate());
    }

    private int getosOAuthConMaxCode() {
        int code = 0;
        try {
            return this.osOAuthConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOAuthConfigUpdataDefault(OsOAuthConfig osOAuthConfig) {
        if (null == osOAuthConfig) {
            return;
        }
        osOAuthConfig.setGmtModified(this.getSysDate());
    }

    private void saveOAuthConfigModel(OsOAuthConfig osOAuthConfig) throws ApiException {
        if (null == osOAuthConfig) {
            return;
        }
        try {
            this.osOAuthConfigMapper.insert(osOAuthConfig);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.saveOAuthConfigModel.ex", (Throwable)e);
        }
    }

    private OsOAuthConfig getOAuthConfigModelById(Integer oauthConfigId) {
        if (null == oauthConfigId) {
            return null;
        }
        try {
            return this.osOAuthConfigMapper.selectByPrimaryKey(oauthConfigId);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getOAuthConfigModelById", (Throwable)e);
            return null;
        }
    }

    public OsOAuthConfig getOAuthConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.osOAuthConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getOAuthConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delOAuthConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.delOAuthConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.delOAuthConfigModelByCode.num");
        }
    }

    private void deleteOAuthConfigModel(Integer oauthConfigId) throws ApiException {
        if (null == oauthConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthConfigMapper.deleteByPrimaryKey(oauthConfigId);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.deleteOAuthConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.deleteOAuthConfigModel.num");
        }
    }

    private void updateOAuthConfigModel(OsOAuthConfig osOAuthConfig) throws ApiException {
        if (null == osOAuthConfig) {
            return;
        }
        try {
            this.osOAuthConfigMapper.updateByPrimaryKeySelective(osOAuthConfig);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateOAuthConfigModel.ex", (Throwable)e);
        }
    }

    private void updateStateOAuthConfigModel(Integer oauthConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == oauthConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthConfigId", oauthConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.osOAuthConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateStateOAuthConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateStateOAuthConfigModel.null");
        }
    }

    private OsOAuthConfig makeOAuthConfig(OsOAuthConfigDomain osOAuthConfigDomain, OsOAuthConfig osOAuthConfig) {
        if (null == osOAuthConfigDomain) {
            return null;
        }
        if (null == osOAuthConfig) {
            osOAuthConfig = new OsOAuthConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthConfig, (Object)osOAuthConfigDomain);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.makeOAuthConfig", (Throwable)e);
        }
        return osOAuthConfig;
    }

    private OsOAuthConfigReDomain makeOAuthConfigDomain(OsOAuthConfig osOAuthConfig, OsOAuthConfigReDomain osOAuthConfigReDomain) {
        if (null == osOAuthConfig) {
            return null;
        }
        if (null == osOAuthConfigReDomain) {
            osOAuthConfigReDomain = new OsOAuthConfigReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthConfigReDomain, (Object)osOAuthConfig);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.makeOAuthConfigDomain", (Throwable)e);
        }
        return osOAuthConfigReDomain;
    }

    private List<OsOAuthConfig> queryOAuthConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.osOAuthConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.queryOAuthConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countOAuthConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.osOAuthConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.countOAuthConfig", (Throwable)e);
        }
        return i;
    }

    private String checkOAuthConfigList(OsOAuthConfigListDomain osOAuthConfigListDomain) {
        if (null == osOAuthConfigListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)osOAuthConfigListDomain.getOauthConfigCode())) {
            msg = msg + "OauthConfigCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)osOAuthConfigListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOAuthConfigListDefault(OsOAuthConfigList osOAuthConfigList) {
        if (null == osOAuthConfigList) {
            return;
        }
        if (null == osOAuthConfigList.getDataState()) {
            osOAuthConfigList.setDataState(0);
        }
        if (null == osOAuthConfigList.getGmtCreate()) {
            osOAuthConfigList.setGmtCreate(this.getSysDate());
        }
        osOAuthConfigList.setGmtModified(this.getSysDate());
    }

    private int getosOAuthConfigListMaxCode() {
        int code = 0;
        try {
            return this.osOAuthConfigListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOAuthConfigListUpdataDefault(OsOAuthConfigList osOAuthConfigList) {
        if (null == osOAuthConfigList) {
            return;
        }
        osOAuthConfigList.setGmtModified(this.getSysDate());
    }

    private void saveOAuthConfigListModel(OsOAuthConfigList osOAuthConfigList) throws ApiException {
        if (null == osOAuthConfigList) {
            return;
        }
        try {
            this.osOAuthConfigListMapper.insert(osOAuthConfigList);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.saveOAuthConfigListModel.ex", (Throwable)e);
        }
    }

    private OsOAuthConfigList getOAuthConfigListModelById(Integer oauthConfigListId) {
        if (null == oauthConfigListId) {
            return null;
        }
        try {
            return this.osOAuthConfigListMapper.selectByPrimaryKey(oauthConfigListId);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getOAuthConfigListModelById", (Throwable)e);
            return null;
        }
    }

    public OsOAuthConfigList getOAuthConfigListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.osOAuthConfigListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getOAuthConfigListModelByCode", (Throwable)e);
            return null;
        }
    }

    public OsOAuthConfig getOAuthConfigModelByProapp(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.osOAuthConfigMapper.getOAuthConfig(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.getOAuthConfigModelByAppKey", (Throwable)e);
            return null;
        }
    }

    public void delOAuthConfigListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthConfigListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.delOAuthConfigListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.delOAuthConfigListModelByCode.num");
        }
    }

    private void delOAuthConfigListModelByMainCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthConfigListMapper.deleteByMainCode(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.delOAuthConfigListModelByMainCode.ex", (Throwable)e);
        }
        if (-1 == i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.delOAuthConfigListModelByMainCode.num");
        }
    }

    private void deleteOAuthConfigListModel(Integer oauthConfigListId) throws ApiException {
        if (null == oauthConfigListId) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthConfigListMapper.deleteByPrimaryKey(oauthConfigListId);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.deleteOAuthConfigListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.deleteOAuthConfigListModel.num");
        }
    }

    private void updateOAuthConfigListModel(OsOAuthConfigList osOAuthConfigList) throws ApiException {
        if (null == osOAuthConfigList) {
            return;
        }
        try {
            this.osOAuthConfigListMapper.updateByPrimaryKeySelective(osOAuthConfigList);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateOAuthConfigListModel.ex", (Throwable)e);
        }
    }

    private void updateStateOAuthConfigListModel(Integer oauthConfigListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == oauthConfigListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthConfigListId", oauthConfigListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.osOAuthConfigListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateStateOAuthConfigListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateStateOAuthConfigListModel.null");
        }
    }

    private OsOAuthConfigList makeOAuthConfigList(OsOAuthConfigListDomain osOAuthConfigListDomain, OsOAuthConfigList osOAuthConfigList) {
        if (null == osOAuthConfigListDomain) {
            return null;
        }
        if (null == osOAuthConfigList) {
            osOAuthConfigList = new OsOAuthConfigList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthConfigList, (Object)osOAuthConfigListDomain);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.makeOAuthConfigList", (Throwable)e);
        }
        return osOAuthConfigList;
    }

    private OsOAuthConfigListReDomain makeOAuthConfigListDomain(OsOAuthConfigList osOAuthConfigList, OsOAuthConfigListReDomain osOAuthConfigListReDomain) {
        if (null == osOAuthConfigList) {
            return null;
        }
        if (null == osOAuthConfigListReDomain) {
            osOAuthConfigListReDomain = new OsOAuthConfigListReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthConfigListReDomain, (Object)osOAuthConfigList);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.makeOAuthConfigList", (Throwable)e);
        }
        return osOAuthConfigListReDomain;
    }

    private List<OsOAuthConfigList> queryOAuthConfigListModelPage(Map<String, Object> parammap) {
        try {
            return this.osOAuthConfigListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.queryOAuthConfigListModel", (Throwable)e);
            return null;
        }
    }

    private int countOAuthConfigList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.osOAuthConfigListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthConfigServiceImpl.countOAuthConfigList", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveOAuthConfig(OsOAuthConfigDomain osOAuthConfigDomain) throws ApiException {
        String msg = this.checkOAuthConfig(osOAuthConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.saveOAuthConfig.checkOAuthConfig", msg);
        }
        OsOAuthConfig osOAuthConfig = this.makeOAuthConfig(osOAuthConfigDomain, null);
        this.setOAuthConfigDefault(osOAuthConfig);
        this.saveOAuthConfigModel(osOAuthConfig);
    }

    @Override
    public void updateOAuthConfigState(Integer oauthConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOAuthConfigModel(oauthConfigId, dataState, oldDataState);
    }

    @Override
    public void updateOAuthConfig(OsOAuthConfigDomain osOAuthConfigDomain) throws ApiException {
        String msg = this.checkOAuthConfig(osOAuthConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateOAuthConfig.checkOAuthConfig", msg);
        }
        OsOAuthConfig oldOsOAuthConfig = this.getOAuthConfigModelById(osOAuthConfigDomain.getOauthConfigId());
        if (null == oldOsOAuthConfig) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateOAuthConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OsOAuthConfig osOAuthConfig = this.makeOAuthConfig(osOAuthConfigDomain, oldOsOAuthConfig);
        this.setOAuthConfigUpdataDefault(osOAuthConfig);
        this.updateOAuthConfigModel(osOAuthConfig);
    }

    @Override
    public OsOAuthConfig getOAuthConfig(Integer oauthConfigId) {
        return this.getOAuthConfigModelById(oauthConfigId);
    }

    @Override
    public void deleteOAuthConfig(Integer oauthConfigId) throws ApiException {
        OsOAuthConfig osOAuthConfig = this.getOAuthConfigModelById(oauthConfigId);
        if (null == osOAuthConfig) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.deleteOAuthConfig.null", "null");
        }
        this.deleteOAuthConfigModel(oauthConfigId);
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.put("tenantCode", osOAuthConfig.getTenantCode());
        map.put("oauthConfigCode", osOAuthConfig.getOauthConfigCode());
        this.delOAuthConfigListModelByMainCode(map);
    }

    @Override
    public QueryResult<OsOAuthConfig> queryOAuthConfigPage(Map<String, Object> map) {
        List<OsOAuthConfig> osOAuthConfigList = this.queryOAuthConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOAuthConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(osOAuthConfigList);
        return queryResult;
    }

    @Override
    public void saveOAuthConfigList(OsOAuthConfigListDomain osOAuthConfigListDomain) throws ApiException {
        String msg = this.checkOAuthConfigList(osOAuthConfigListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.saveOAuthConfigList.checkOAuthConfigList", msg);
        }
        OsOAuthConfigList osOAuthConfigList = this.makeOAuthConfigList(osOAuthConfigListDomain, null);
        this.setOAuthConfigListDefault(osOAuthConfigList);
        this.saveOAuthConfigListModel(osOAuthConfigList);
    }

    @Override
    public void updateOAuthConfigListState(Integer oauthConfigListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOAuthConfigListModel(oauthConfigListId, dataState, oldDataState);
    }

    @Override
    public void updateOAuthConfigList(OsOAuthConfigListDomain osOAuthConfigListDomain) throws ApiException {
        String msg = this.checkOAuthConfigList(osOAuthConfigListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateOAuthConfigList.checkOAuthConfigList", msg);
        }
        OsOAuthConfigList oldOsOAuthConfigList = this.getOAuthConfigListModelById(osOAuthConfigListDomain.getOauthConfigListId());
        if (null == oldOsOAuthConfigList) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthConfigServiceImpl.updateOAuthConfigList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OsOAuthConfigList osOAuthConfigList = this.makeOAuthConfigList(osOAuthConfigListDomain, oldOsOAuthConfigList);
        this.setOAuthConfigListUpdataDefault(osOAuthConfigList);
        this.updateOAuthConfigListModel(osOAuthConfigList);
    }

    @Override
    public OsOAuthConfigList getOAuthConfigList(Integer oauthConfigListId) {
        return this.getOAuthConfigListModelById(oauthConfigListId);
    }

    @Override
    public void deleteOAuthConfigList(Integer oauthConfigListId) throws ApiException {
        this.deleteOAuthConfigListModel(oauthConfigListId);
    }

    @Override
    public QueryResult<OsOAuthConfigList> queryOAuthConfigListPage(Map<String, Object> map) {
        List<OsOAuthConfigList> osOAuthConfigListList = this.queryOAuthConfigListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOAuthConfigList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(osOAuthConfigListList);
        return queryResult;
    }

    @Override
    public OsOAuthConfigReDomain getOAuthConfigAll(String tenantCode, String proappCode) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("proappCode", proappCode);
        OsOAuthConfig osOAuthConfig = this.getOAuthConfigModelByProapp(map);
        if (null == osOAuthConfig) {
            return null;
        }
        OsOAuthConfigReDomain osOAuthConfigReDomain = this.makeOAuthConfigDomain(osOAuthConfig, null);
        map = new ConcurrentHashMap();
        map.put("tenantCode", tenantCode);
        map.put("oauthConfigCode", osOAuthConfig.getOauthConfigCode());
        List<OsOAuthConfigList> list = this.queryOAuthConfigListModelPage(map);
        if (null == list || list.isEmpty()) {
            return osOAuthConfigReDomain;
        }
        ArrayList<OsOAuthConfigListReDomain> listlist = new ArrayList<OsOAuthConfigListReDomain>();
        for (OsOAuthConfigList osOAuthConfigList : list) {
            listlist.add(this.makeOAuthConfigListDomain(osOAuthConfigList, null));
        }
        osOAuthConfigReDomain.setOsOAuthConfigListReDomainList(listlist);
        return osOAuthConfigReDomain;
    }

    @Override
    public void loadCache() {
        List<OsOAuthConfig> list = this.queryOAuthConfigModelPage(new HashMap<String, Object>());
        if (list == null || list.size() == 0) {
            DisUtil.del((String)"osconfig_key");
            return;
        }
        for (OsOAuthConfig osoa : list) {
            if (!StringUtils.isNotBlank((String)osoa.getAppmanageGroup())) continue;
            DisUtil.setMap((String)"osconfig_key", (String)(osoa.getProappCode() + "-" + osoa.getTenantCode()), (String)osoa.getAppmanageGroup());
        }
    }

    @Override
    public void loadoAuthConfigCache() {
        List<OsOAuthConfig> list = this.queryOAuthConfigModelPage(new HashMap<String, Object>());
        if (list == null || list.size() == 0) {
            DisUtil.del((String)"OsOAuthConfig_Key");
        }
        for (OsOAuthConfig oa : list) {
            String key = oa.getProappCode() + "-" + oa.getTenantCode();
            DisUtil.setMap((String)"OsOAuthConfig_Key", (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)this.getOAuthConfigAll(oa.getTenantCode(), oa.getProappCode())));
        }
    }

    @Override
    public void sendOsOAuthConfigInit(String tenantCode, String proappCode) {
        String manager;
        String inittenantCode = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-tenantCode-tenantCode");
        List<OsOAuthConfig> list = this.queryOAuthConfigModelPage(this.getQueryParamMap("tenantCode,proappCode", new Object[]{inittenantCode, manager = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-manager-manager")}));
        if (null != list && null != list.get(0)) {
            OsOAuthConfig osOAuthConfig = list.get(0);
            osOAuthConfig.setTenantCode(tenantCode);
            osOAuthConfig.setProappCode(proappCode);
            osOAuthConfig.setOauthConfigId(null);
            osOAuthConfig.setOauthConfigCode(this.createUUIDString());
            this.getOAuthConfigService().putQueue(osOAuthConfig);
        }
    }

    @Override
    public void saveOsOAuthConfigInit(OsOAuthConfig osOAuthConfig) {
        this.saveOAuthConfigModel(osOAuthConfig);
        this.loadoAuthConfigCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuthConfigService getOAuthConfigService() {
        Object object = obj;
        synchronized (object) {
            if (null == oAuthConfigService) {
                oAuthConfigService = new OAuthConfigService((OsOAuthConfigService)SpringApplicationContextUtil.getBean((String)"osOAuthConfigService"));
                oAuthConfigService.addPollPool(new OAuthConfigPollThread(oAuthConfigService));
                oAuthConfigService.addPollPool(new OAuthConfigPollThread(oAuthConfigService));
                oAuthConfigService.addPollPool(new OAuthConfigPollThread(oAuthConfigService));
            }
            return oAuthConfigService;
        }
    }

    static {
        obj = new Object();
    }
}

