/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.process;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.token.process.TokenService;
import com.yqbsoft.laser.service.suppercore.sync.AbstractEtcInfoThread;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.Map;

public class TokenPollThread
extends AbstractEtcInfoThread {
    public static final String SYS_CODE = "os.OAUTHSERVER.PatmentPollThread";
    private TokenService tokenService;

    public TokenPollThread(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void run() {
        String cachekey = "OsOauthToken-pro";
        Map map = DisUtil.getMapAll((String)cachekey);
        if (null != map && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String str = (String)map.get(key);
                if (!StringUtils.isNotBlank((String)str)) continue;
                OsOAuthToken osOAuthToken = (OsOAuthToken)JsonUtil.buildNormalBinder().getJsonToObject(str, OsOAuthToken.class);
                Date oauthTokenUpdateTime = osOAuthToken.getOauthTokenUpdateTime();
                Date nowDate = new Date();
                Long sc = (nowDate.getTime() - oauthTokenUpdateTime.getTime()) / 86400000L;
                if (sc - (long)osOAuthToken.getOauthTokenExpireIn().intValue() < 0L) continue;
                this.tokenService.doStart(osOAuthToken);
            }
        }
        try {
            TokenPollThread.sleep((long)5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

