/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.validate;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.token.validate.OAuthTokenValidator;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;

public abstract class AbstractOAuthTokenValidator<T extends OsOAuthToken>
implements OAuthTokenValidator<T> {
    private OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private String SYSCODE = "com.yqbsoft.laser.service.oauthserver.token.validate.AbstractOauthTokenValidator";

    @Override
    public boolean checkAppKey(T token, String appKey) {
        if (token == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkAppKey.token.null");
            return false;
        }
        if (StringUtils.isBlank((String)((OsOAuthToken)token).getOauthTokenAppKey())) {
            this.logger.debug(this.SYSCODE, (Object)".checkUserId.token.OauthTokenAppKey.null");
            return false;
        }
        if (StringUtils.isBlank((String)appKey)) {
            this.logger.debug(this.SYSCODE, (Object)".checkAppKey.appKey.null");
            return false;
        }
        return appKey.equals(((OsOAuthToken)token).getOauthTokenAppKey());
    }

    @Override
    public boolean checkUserId(T token, String uid) {
        if (token == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkUserId.token.null");
            return false;
        }
        if (StringUtils.isBlank((String)((OsOAuthToken)token).getOauthTokenUserAccount())) {
            this.logger.debug(this.SYSCODE, (Object)".checkUserId.token.OauthTokenUserAccount.null");
            return false;
        }
        if (StringUtils.isBlank((String)uid)) {
            this.logger.debug(this.SYSCODE, (Object)".checkUserId.appKey.null");
            return false;
        }
        return uid.equals(((OsOAuthToken)token).getOauthTokenUserAccount());
    }

    @Override
    public boolean checkExpireTime(T token, Date date) {
        if (token == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkExpireTime.token.null");
            return false;
        }
        if (((OsOAuthToken)token).getOauthTokenUpdateTime() == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkExpireTime.token.OauthTokenUpdateTime.null");
            return false;
        }
        if (((OsOAuthToken)token).getOauthTokenExpireIn() == null || ((OsOAuthToken)token).getOauthTokenExpireIn() != null && ((OsOAuthToken)token).getOauthTokenExpireIn() == 0) {
            this.logger.debug(this.SYSCODE, (Object)".checkExpireTime.token.OauthTokenExpireIn.\u6c38\u4e45\u6709\u6548");
            return true;
        }
        if (date == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkExpireTime.date.null");
            return false;
        }
        long time = date.getTime() - ((OsOAuthToken)token).getOauthTokenUpdateTime().getTime();
        this.logger.debug(this.SYSCODE, (Object)("[OauthTokenUpdateTime]:[" + ((OsOAuthToken)token).getOauthTokenUpdateTime().getTime() + "];[time]:[" + time + "];[OauthTokenExpireInTime]:[" + ((OsOAuthToken)token).getOauthTokenExpireIn() + "]"));
        long timeout = (long)(((OsOAuthToken)token).getOauthTokenExpireIn() * 1000) - time;
        this.logger.debug(this.SYSCODE, (Object)(".checkExpireTime.timeout:" + timeout));
        if (timeout > 0L) {
            return true;
        }
        this.logger.debug(this.SYSCODE, (Object)"OauthTokenExpireInTime is too long and timeout < 0");
        return false;
    }

    @Override
    public boolean checkStatus(T token, String status) {
        if (token == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkStatus.token.null");
            return false;
        }
        if (((OsOAuthToken)token).getOauthTokenState() == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkStatus.token.OauthTokenState.null");
            return false;
        }
        if (StringUtils.isBlank((String)status)) {
            this.logger.debug(this.SYSCODE, (Object)".checkStatus.status.null");
            return false;
        }
        return status.equals(String.valueOf(((OsOAuthToken)token).getOauthTokenState()));
    }

    @Override
    public boolean checkOauthTokenRefresh(T token, String oauthTokenRefresh) {
        if (token == null) {
            this.logger.debug(this.SYSCODE, (Object)".checkOauthTokenRefresh.token.null");
            return false;
        }
        if (StringUtils.isBlank((String)((OsOAuthToken)token).getOauthTokenRefreshToken())) {
            this.logger.debug(this.SYSCODE, (Object)".checkOauthTokenRefresh.token.OauthTokenRefreshToken.null");
            return false;
        }
        if (StringUtils.isBlank((String)oauthTokenRefresh)) {
            this.logger.debug(this.SYSCODE, (Object)".checkOauthTokenRefresh.oauthTokenRefresh.null");
            return false;
        }
        return oauthTokenRefresh.equals(((OsOAuthToken)token).getOauthTokenRefreshToken());
    }
}

