/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.process;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.token.process.TokenService;
import com.yqbsoft.laser.service.suppercore.sync.AbstractEtcInfoThread;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.Map;

public class TokenPollThread
extends AbstractEtcInfoThread {
    public static final String SYS_CODE = "os.OAUTHSERVER.PatmentPollThread";
    private TokenService tokenService;

    public TokenPollThread(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    public boolean checkExpireTime(OsOAuthToken token, Date date) {
        if (token == null) {
            return false;
        }
        if (token.getOauthTokenUpdateTime() == null) {
            return false;
        }
        if (token.getOauthTokenExpireIn() == null || token.getOauthTokenExpireIn() != null && token.getOauthTokenExpireIn() == 0) {
            return true;
        }
        if (date == null) {
            return false;
        }
        long time = date.getTime() - token.getOauthTokenUpdateTime().getTime();
        long timeout = (long)(token.getOauthTokenExpireIn() * 1000) - time;
        return timeout > 0L;
    }

    public void run() {
        while (true) {
            try {
                String cachekey = "OsOauthToken-pro";
                Map map = DisUtil.getMapAll((String)cachekey);
                if (null != map && !map.isEmpty()) {
                    for (String key : map.keySet()) {
                        OsOAuthToken osOAuthToken;
                        String str = (String)map.get(key);
                        if (!StringUtils.isNotBlank((String)str) || this.checkExpireTime(osOAuthToken = (OsOAuthToken)JsonUtil.buildNormalBinder().getJsonToObject(str, OsOAuthToken.class), new Date())) continue;
                        this.tokenService.doStart(osOAuthToken);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                TokenPollThread.sleep((long)5000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

