/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.OauthToken;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthTokenHistoryMapper;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthTokenMapper;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthRightsReDomainBean;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthTokenReDomainBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthTokenHistory;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthLoginService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthRightsService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthTokenService;
import com.yqbsoft.laser.service.oauthserver.token.process.TokenPollThread;
import com.yqbsoft.laser.service.oauthserver.token.process.TokenService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OsOAuthTokenServiceImpl
extends BaseServiceImpl
implements OsOAuthTokenService {
    public static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthTokenServiceImpl";
    private OsOAuthTokenMapper osOAuthTokenMapper;
    private OsOAuthTokenHistoryMapper osOAuthTokenHistoryMapper;
    private OsOAuthRightsService oauthRightsService;
    private static TokenService tokenService;
    private static Object lock;

    public OsOAuthTokenHistoryMapper getOsOAuthTokenHistoryMapper() {
        return this.osOAuthTokenHistoryMapper;
    }

    public void setOsOAuthTokenHistoryMapper(OsOAuthTokenHistoryMapper osOAuthTokenHistoryMapper) {
        this.osOAuthTokenHistoryMapper = osOAuthTokenHistoryMapper;
    }

    public void setOsOAuthTokenMapper(OsOAuthTokenMapper osOAuthTokenMapper) {
        this.osOAuthTokenMapper = osOAuthTokenMapper;
    }

    public void setOauthRightsService(OsOAuthRightsService oauthRightsService) {
        this.oauthRightsService = oauthRightsService;
    }

    private Date getSysDate() {
        try {
            return this.osOAuthTokenMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthTokenServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOAuthToken(OsOAuthTokenReDomainBean osOAuthTokenReDomainBean) {
        if (null == osOAuthTokenReDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setOAuthTokenDefault(OsOAuthToken osOAuthToken) {
        if (null == osOAuthToken) {
            return;
        }
        if (null == osOAuthToken.getDataState()) {
            osOAuthToken.setDataState(0);
        }
        if (null == osOAuthToken.getGmtCreate()) {
            osOAuthToken.setGmtCreate(this.getSysDate());
        }
        osOAuthToken.setGmtModified(this.getSysDate());
    }

    private void setOAuthTokenUpdataDefault(OsOAuthToken osOAuthToken) {
        if (null == osOAuthToken) {
            return;
        }
        osOAuthToken.setGmtModified(this.getSysDate());
    }

    private Integer saveOAuthTokenModel(OsOAuthToken osOAuthToken) throws ApiException {
        if (null == osOAuthToken) {
            return null;
        }
        try {
            this.osOAuthTokenMapper.insert(osOAuthToken);
            if (osOAuthToken.getDataState() == 1) {
                this.refreshCache(osOAuthToken, 1);
            }
            return osOAuthToken.getOauthTokenId();
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.saveOAuthTokenModel.ex", (Throwable)e);
        }
    }

    private OsOAuthToken getOAuthTokenModelById(Integer oAuthTokenId) {
        if (null == oAuthTokenId) {
            return null;
        }
        try {
            return this.osOAuthTokenMapper.selectByPrimaryKey(oAuthTokenId);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthTokenServiceImpl.getOAuthTokenModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteOAuthTokenModel(Integer oAuthTokenId) throws ApiException {
        if (null == oAuthTokenId) {
            return;
        }
        int i = 0;
        try {
            OsOAuthToken osOAuthToken = this.getOAuthTokenModelById(oAuthTokenId);
            i = this.osOAuthTokenMapper.deleteByPrimaryKey(oAuthTokenId);
            if (i > 0) {
                this.refreshCache(osOAuthToken, 0);
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.deleteOAuthTokenModel.ex");
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.deleteOAuthTokenModel.num");
        }
    }

    private void updateOAuthTokenModel(OsOAuthToken osOAuthToken) throws ApiException {
        if (null == osOAuthToken) {
            return;
        }
        try {
            this.osOAuthTokenMapper.updateByPrimaryKeySelective(osOAuthToken);
            if (osOAuthToken.getDataState() == 0) {
                this.refreshCache(osOAuthToken, 0);
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.updateOAuthTokenModel.ex");
        }
    }

    private void updateStateOAuthTokenModel(Integer oAuthTokenId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == oAuthTokenId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oAuthTokenId", oAuthTokenId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.osOAuthTokenMapper.updateStateByPrimaryKey(map);
            if (i > 0 && oldDataState != 0 && dataState == 0) {
                this.refreshCache(this.getOAuthToken(oAuthTokenId), 0);
            }
            if (i > 0 && oldDataState == 0 && dataState != 0) {
                this.refreshCache(this.getOAuthToken(oAuthTokenId), 1);
            }
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.updateStateOAuthTokenModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.updateStateOAuthTokenModel.null");
        }
    }

    private OsOAuthToken makeOAuthToken(OsOAuthTokenReDomainBean osOAuthTokenReDomainBean, OsOAuthToken osOAuthToken) {
        if (null == osOAuthTokenReDomainBean) {
            return null;
        }
        if (null == osOAuthToken) {
            osOAuthToken = new OsOAuthToken();
        }
        try {
            BeanUtils.copyAllPropertys((Object)((Object)osOAuthToken), (Object)osOAuthTokenReDomainBean);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthTokenServiceImpl.makeOAuthToken", (Throwable)e);
        }
        return osOAuthToken;
    }

    private List<OsOAuthToken> queryOAuthTokenModelPage(Map<String, Object> parammap) {
        try {
            return this.osOAuthTokenMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthTokenServiceImpl.queryOAuthTokenModel", (Throwable)e);
            return null;
        }
    }

    private int countOAuthToken(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.osOAuthTokenMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthTokenServiceImpl.countOAuthToken", (Throwable)e);
        }
        return i;
    }

    @Override
    public Integer saveOAuthToken(OsOAuthTokenReDomainBean osOAuthTokenReDomainBean) throws ApiException {
        String msg = this.checkOAuthToken(osOAuthTokenReDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.saveOAuthToken.checkOAuthToken", msg);
        }
        OsOAuthToken osOAuthToken = this.makeOAuthToken(osOAuthTokenReDomainBean, null);
        this.setOAuthTokenDefault(osOAuthToken);
        return this.saveOAuthTokenModel(osOAuthToken);
    }

    @Override
    public void saveOAuthRightsList(OsOAuthTokenReDomainBean osOAuthTokenReDomainBean, List<OsOAuthRightsReDomainBean> osOAuthRightsReDomainBeanList) throws ApiException {
        Integer token_id = this.saveOAuthToken(osOAuthTokenReDomainBean);
        for (OsOAuthRightsReDomainBean osOAuthRightsReDomainBean : osOAuthRightsReDomainBeanList) {
            osOAuthRightsReDomainBean.setOauthTokenId(token_id);
            this.oauthRightsService.saveOAuthRights(osOAuthRightsReDomainBean);
        }
    }

    @Override
    public void saveOAuthRightsListByTokenId(Integer oAuthTokenId, List<OsOAuthRightsReDomainBean> osOAuthRightsReDomainBeanList) {
        this.oauthRightsService.deleteByTokenId(oAuthTokenId);
        for (OsOAuthRightsReDomainBean osOAuthRightsReDomainBean : osOAuthRightsReDomainBeanList) {
            osOAuthRightsReDomainBean.setOauthTokenId(oAuthTokenId);
            this.oauthRightsService.saveOAuthRights(osOAuthRightsReDomainBean);
        }
    }

    @Override
    public void updateOAuthTokenState(Integer oAuthTokenId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOAuthTokenModel(oAuthTokenId, dataState, oldDataState);
    }

    @Override
    public void updateOAuthToken(OsOAuthTokenReDomainBean osOAuthTokenReDomainBean) throws ApiException {
        String msg = this.checkOAuthToken(osOAuthTokenReDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.updateOAuthToken.checkOAuthToken", msg);
        }
        OsOAuthToken oldOsOAuthToken = this.getOAuthTokenModelById(osOAuthTokenReDomainBean.getOauthTokenId());
        if (null == oldOsOAuthToken) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthTokenServiceImpl.updateOAuthToken.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OsOAuthToken osOAuthToken = this.makeOAuthToken(osOAuthTokenReDomainBean, oldOsOAuthToken);
        this.setOAuthTokenUpdataDefault(osOAuthToken);
        this.updateOAuthTokenModel(osOAuthToken);
    }

    @Override
    public OsOAuthToken getOAuthToken(Integer oAuthTokenId) {
        return this.getOAuthTokenModelById(oAuthTokenId);
    }

    @Override
    public void deleteOAuthToken(Integer oAuthTokenId) throws ApiException {
        this.deleteOAuthTokenModel(oAuthTokenId);
    }

    @Override
    public QueryResult<OsOAuthToken> queryOAuthTokenPage(Map<String, Object> map) {
        List<OsOAuthToken> osOAuthTokenList = this.queryOAuthTokenModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOAuthToken(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(osOAuthTokenList);
        return queryResult;
    }

    @Override
    public List<OsOAuthToken> queryOAuthTokenList(Map<String, Object> map) throws ApiException {
        return this.queryOAuthTokenModelPage(map);
    }

    @Override
    public void queryOauthTokenCache() {
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.queryOauthTokenCache", "=======queryOauthTokenCache\u8c03\u5ea6start=======");
        List<OsOAuthToken> osTokenList = this.queryOAuthTokenList(this.getQueryParamMap("dataState", new Object[]{1}));
        if (osTokenList == null || osTokenList.isEmpty()) {
            DisUtil.delVer((String)"OsOAuthToken-oauthserver");
            this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.queryOauthTokenCache", "=======queryOauthTokenCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<OauthToken>> smap = new HashMap<String, List<OauthToken>>();
        for (OsOAuthToken osToken : osTokenList) {
            this.saveCache(osToken, smap);
        }
        DisUtil.setVer((String)"OsOAuthToken-oauthserver", (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.queryOauthTokenCache", "=======queryOauthTokenCache\u8c03\u5ea6end=======");
        this.getTokenService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenService getTokenService() {
        Object object = lock;
        synchronized (object) {
            if (null == tokenService) {
                tokenService = new TokenService((OsOAuthLoginService)SpringApplicationContextUtil.getBean((String)"osOAuthLoginService"));
                tokenService.addPollPool(new TokenPollThread(tokenService));
            }
            return tokenService;
        }
    }

    private OauthToken makeOauthToken(OsOAuthToken osToken) {
        if (null == osToken) {
            return null;
        }
        OauthToken token = new OauthToken();
        try {
            BeanUtils.copyAllPropertys((Object)token, (Object)((Object)osToken));
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthTokenServiceImpl.makeOauthToken", (Throwable)e);
        }
        return token;
    }

    private void refreshCache(OsOAuthToken osToken, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<OauthToken>> map = DisUtil.getMapByListJson((String)"OsOAuthToken-oauthserver", String.class, OauthToken.class);
        if (map == null) {
            map = new HashMap<String, List<OauthToken>>();
        }
        if (addflag) {
            this.saveCache(osToken, map);
        } else {
            this.deleteCache(osToken, map);
        }
        DisUtil.setVer((String)"OsOAuthToken-oauthserver", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(OsOAuthToken osToken, Map<String, List<OauthToken>> map) {
        if (osToken == null || map == null) {
            return;
        }
        String key = osToken.getOauthTokenToken() + "-" + osToken.getOauthTokenAppKey();
        List<OauthToken> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getOauthTokenId().equals(osToken.getOauthTokenId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(OsOAuthToken osToken, Map<String, List<OauthToken>> map) {
        if (osToken == null || map == null) {
            return;
        }
        OauthToken token = this.makeOauthToken(osToken);
        String key = osToken.getOauthTokenToken() + "-" + osToken.getOauthTokenAppKey();
        List<OauthToken> list = map.get(key);
        if (list == null) {
            list = new ArrayList<OauthToken>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getOauthTokenId().equals(osToken.getOauthTokenId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, token);
        } else {
            list.add(token);
        }
    }

    @Override
    public void insertBatch(List<OsOAuthToken> list) {
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.insertBatch", "=======insertBatch\u8c03\u5ea6start=======");
        this.insertBatchModel(list);
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.insertBatch", "=======insertBatch\u8c03\u5ea6end=======");
    }

    private void insertBatchModel(List<OsOAuthToken> list) {
        try {
            this.osOAuthTokenMapper.insertBatch(list);
        }
        catch (Exception e) {
            this.error(SYS_CODE, ".insertBatchModel.error", e);
        }
    }

    @Override
    public void backUpBatch(List<OsOAuthTokenHistory> bac_list) {
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.backUpBatch", "=======backUpBatch\u8c03\u5ea6start=======");
        this.backUpBatchModel(bac_list);
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.backUpBatch", "=======backUpBatch\u8c03\u5ea6end=======");
    }

    private void backUpBatchModel(List<OsOAuthTokenHistory> list) {
        try {
            this.osOAuthTokenHistoryMapper.insertBatch(list);
        }
        catch (Exception e) {
            this.error(SYS_CODE, ".backUpBatchModel.error", e);
        }
    }

    @Override
    public void delBatch(List<OsOAuthToken> del_list) {
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.delBatch", "=======delBatch\u8c03\u5ea6start=======");
        this.delBatchModel(del_list);
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.delBatch", "=======delBatch\u8c03\u5ea6end=======");
    }

    private void delBatchModel(List<OsOAuthToken> list) {
        try {
            this.osOAuthTokenMapper.deleteBatch(list);
        }
        catch (Exception e) {
            this.error(SYS_CODE, ".delBatchModel.error", e);
        }
    }

    @Override
    public void deleteByTokenBatch(List<OsOAuthToken> list) {
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.deleteByTokenBatch", "=======deleteByTokenBatch\u8c03\u5ea6start=======");
        this.deleteByTokenBatchModel(list);
        this.info("os.OAUTHSERVER.OsOAuthTokenServiceImpl.deleteByTokenBatch", "=======deleteByTokenBatch\u8c03\u5ea6end=======");
    }

    private void deleteByTokenBatchModel(List<OsOAuthToken> list) {
        try {
            this.osOAuthTokenMapper.deleteByTokenBatch(list);
        }
        catch (Exception e) {
            this.error(SYS_CODE, ".backUpBatchModel.error", e);
        }
    }

    @Override
    public void delUserSessionCache() {
        DisUtil.del((String)"UserSession_key");
        String TokenLogin = "TokenLogin_pk";
        DisUtil.del((String)TokenLogin);
    }

    @Override
    public void saveUpdate(OsOAuthToken osOAuthToken) {
        if (null == osOAuthToken) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("oauthTokenToken", osOAuthToken.getOauthTokenToken());
        parammap.put("tenantCode", osOAuthToken.getTenantCode());
        List<OsOAuthToken> list = this.queryOAuthTokenModelPage(parammap);
        OsOAuthTokenReDomainBean osOAuthTokenReDomainBean = new OsOAuthTokenReDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthTokenReDomainBean, (Object)((Object)osOAuthToken));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ListUtil.isEmpty(list)) {
            this.saveOAuthToken(osOAuthTokenReDomainBean);
        } else {
            osOAuthTokenReDomainBean.setOauthTokenId(list.get(0).getOauthTokenId());
            this.updateOAuthToken(osOAuthTokenReDomainBean);
        }
    }

    static {
        lock = new Object();
    }
}

