/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringUtils {
    private static final String ENCODING = "UTF-8";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static String formatToURL(Collection<? extends Map.Entry<String, Object>> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters) {
            String encodedValue;
            String value;
            String string = value = entry.getValue() == null ? null : String.valueOf(entry.getValue());
            if (StringUtils.isEmpty(entry.getKey()) || StringUtils.isEmpty(value)) continue;
            String encodedName = StringUtils.encode(entry.getKey(), encoding);
            String string2 = encodedValue = value != null ? StringUtils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    public static String formatToURL(Iterator<? extends Map.Entry<String, String[]>> parameters) {
        StringBuilder result = new StringBuilder();
        while (parameters.hasNext()) {
            String[] values;
            Map.Entry<String, String[]> parameter = parameters.next();
            String[] stringArray = values = parameter.getValue() == null ? null : parameter.getValue();
            if (StringUtils.isEmpty(parameter.getKey()) || values == null || values.length <= 0) continue;
            String encodedName = StringUtils.encode(parameter.getKey(), ENCODING);
            for (String value : values) {
                String encodedValue;
                String string = encodedValue = value != null ? StringUtils.encode(value, ENCODING) : "";
                if (result.length() > 0) {
                    result.append(PARAMETER_SEPARATOR);
                }
                result.append(encodedName);
                result.append(NAME_VALUE_SEPARATOR);
                result.append(encodedValue);
            }
        }
        return result.toString();
    }

    public static Map<String, Object> formatQueryStringToMap(String parametersString) {
        if (parametersString == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] parametersMap = parametersString.split(PARAMETER_SEPARATOR);
        for (int i = 0; i < parametersMap.length; ++i) {
            String[] paramMap = parametersMap[i].split(NAME_VALUE_SEPARATOR);
            map.put(paramMap[0], StringUtils.decode(paramMap[1], null));
        }
        return map;
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : ENCODING);
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    private static String decode(String content, String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : ENCODING);
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static String getSignCheckContentV1(Map<String, String[]> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String[] values;
            String key = (String)keys.get(i);
            for (String value : values = params.get(key)) {
                content.append((i == 0 ? "" : PARAMETER_SEPARATOR) + key + NAME_VALUE_SEPARATOR + value);
            }
        }
        return content.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }
}

