/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthEnvconfigMapper;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthEnvconfigDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthEnvconfigReDomain;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthEnvconfig;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthEnvconfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OsOAuthEnvconfigServiceImpl
extends BaseServiceImpl
implements OsOAuthEnvconfigService {
    private static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl";
    private OsOAuthEnvconfigMapper osOAuthEnvconfigMapper;

    public void setOsOAuthEnvconfigMapper(OsOAuthEnvconfigMapper osOAuthEnvconfigMapper) {
        this.osOAuthEnvconfigMapper = osOAuthEnvconfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.osOAuthEnvconfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOAuthEnvconfig(OsOAuthEnvconfigDomain osOAuthEnvconfigDomain) {
        if (null == osOAuthEnvconfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)osOAuthEnvconfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOAuthEnvconfigDefault(OsOAuthEnvconfig osOAuthEnvconfig) {
        if (null == osOAuthEnvconfig) {
            return;
        }
        if (null == osOAuthEnvconfig.getDataState()) {
            osOAuthEnvconfig.setDataState(0);
        }
        if (null == osOAuthEnvconfig.getGmtCreate()) {
            osOAuthEnvconfig.setGmtCreate(this.getSysDate());
        }
        osOAuthEnvconfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)osOAuthEnvconfig.getOauthEnvconfigCode())) {
            osOAuthEnvconfig.setOauthEnvconfigCode(this.createUUIDString());
        }
    }

    private int getOAuthEnvconfigMaxCode() {
        int code = 0;
        try {
            return this.osOAuthEnvconfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.getOAuthEnvconfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOAuthEnvconfigUpdataDefault(OsOAuthEnvconfig osOAuthEnvconfig) {
        if (null == osOAuthEnvconfig) {
            return;
        }
        osOAuthEnvconfig.setGmtModified(this.getSysDate());
    }

    private void saveOAuthEnvconfigModel(OsOAuthEnvconfig osOAuthEnvconfig) throws ApiException {
        if (null == osOAuthEnvconfig) {
            return;
        }
        try {
            this.osOAuthEnvconfigMapper.insert(osOAuthEnvconfig);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.saveOAuthEnvconfigModel.ex", (Throwable)e);
        }
    }

    private void saveOAuthEnvconfigBatchModel(List<OsOAuthEnvconfig> osOAuthEnvconfigList) throws ApiException {
        if (null == osOAuthEnvconfigList || osOAuthEnvconfigList.isEmpty()) {
            return;
        }
        try {
            this.osOAuthEnvconfigMapper.insertBatch(osOAuthEnvconfigList);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.saveOAuthEnvconfigBatchModel.ex", (Throwable)e);
        }
    }

    private OsOAuthEnvconfig getOAuthEnvconfigModelById(Integer oauthEnvconfigId) {
        if (null == oauthEnvconfigId) {
            return null;
        }
        try {
            return this.osOAuthEnvconfigMapper.selectByPrimaryKey(oauthEnvconfigId);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.getOAuthEnvconfigModelById", (Throwable)e);
            return null;
        }
    }

    private OsOAuthEnvconfig getOAuthEnvconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.osOAuthEnvconfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.getOAuthEnvconfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOAuthEnvconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthEnvconfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.delOAuthEnvconfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.delOAuthEnvconfigModelByCode.num");
        }
    }

    private void deleteOAuthEnvconfigModel(Integer oauthEnvconfigId) throws ApiException {
        if (null == oauthEnvconfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthEnvconfigMapper.deleteByPrimaryKey(oauthEnvconfigId);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.deleteOAuthEnvconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.deleteOAuthEnvconfigModel.num");
        }
    }

    private void updateOAuthEnvconfigModel(OsOAuthEnvconfig osOAuthEnvconfig) throws ApiException {
        if (null == osOAuthEnvconfig) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthEnvconfigMapper.updateByPrimaryKeySelective(osOAuthEnvconfig);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateOAuthEnvconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateOAuthEnvconfigModel.num");
        }
    }

    private void updateStateOAuthEnvconfigModel(Integer oauthEnvconfigId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == oauthEnvconfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthEnvconfigId", oauthEnvconfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.osOAuthEnvconfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateStateOAuthEnvconfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateStateOAuthEnvconfigModel.null");
        }
    }

    private void updateStateOAuthEnvconfigModelByCode(String tenantCode, String oauthEnvconfigCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)oauthEnvconfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("oauthEnvconfigCode", oauthEnvconfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.osOAuthEnvconfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateStateOAuthEnvconfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateStateOAuthEnvconfigModelByCode.null");
        }
    }

    private OsOAuthEnvconfig makeOAuthEnvconfig(OsOAuthEnvconfigDomain osOAuthEnvconfigDomain, OsOAuthEnvconfig osOAuthEnvconfig) {
        if (null == osOAuthEnvconfigDomain) {
            return null;
        }
        if (null == osOAuthEnvconfig) {
            osOAuthEnvconfig = new OsOAuthEnvconfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthEnvconfig, (Object)osOAuthEnvconfigDomain);
            return osOAuthEnvconfig;
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.makeOAuthEnvconfig", (Throwable)e);
            return null;
        }
    }

    private OsOAuthEnvconfigReDomain makeOsOAuthEnvconfigReDomain(OsOAuthEnvconfig osOAuthEnvconfig) {
        if (null == osOAuthEnvconfig) {
            return null;
        }
        OsOAuthEnvconfigReDomain osOAuthEnvconfigReDomain = new OsOAuthEnvconfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthEnvconfigReDomain, (Object)osOAuthEnvconfig);
            return osOAuthEnvconfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.makeOsOAuthEnvconfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OsOAuthEnvconfig> queryOAuthEnvconfigModelPage(Map<String, Object> parammap) {
        try {
            return this.osOAuthEnvconfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.queryOAuthEnvconfigModel", (Throwable)e);
            return null;
        }
    }

    private int countOAuthEnvconfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.osOAuthEnvconfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.countOAuthEnvconfig", (Throwable)e);
        }
        return i;
    }

    private OsOAuthEnvconfig createOsOAuthEnvconfig(OsOAuthEnvconfigDomain osOAuthEnvconfigDomain) {
        String msg = this.checkOAuthEnvconfig(osOAuthEnvconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.saveOAuthEnvconfig.checkOAuthEnvconfig", msg);
        }
        OsOAuthEnvconfig osOAuthEnvconfig = this.makeOAuthEnvconfig(osOAuthEnvconfigDomain, null);
        this.setOAuthEnvconfigDefault(osOAuthEnvconfig);
        return osOAuthEnvconfig;
    }

    @Override
    public String saveOAuthEnvconfig(OsOAuthEnvconfigDomain osOAuthEnvconfigDomain) throws ApiException {
        OsOAuthEnvconfig osOAuthEnvconfig = this.createOsOAuthEnvconfig(osOAuthEnvconfigDomain);
        this.saveOAuthEnvconfigModel(osOAuthEnvconfig);
        return osOAuthEnvconfig.getOauthEnvconfigCode();
    }

    @Override
    public String saveOAuthEnvconfigBatch(List<OsOAuthEnvconfigDomain> osOAuthEnvconfigDomainList) throws ApiException {
        if (null == osOAuthEnvconfigDomainList || osOAuthEnvconfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OsOAuthEnvconfig> osOAuthEnvconfigList = new ArrayList<OsOAuthEnvconfig>();
        String code = "";
        for (OsOAuthEnvconfigDomain osOAuthEnvconfigDomain : osOAuthEnvconfigDomainList) {
            OsOAuthEnvconfig osOAuthEnvconfig = this.createOsOAuthEnvconfig(osOAuthEnvconfigDomain);
            code = osOAuthEnvconfig.getOauthEnvconfigCode();
            osOAuthEnvconfigList.add(osOAuthEnvconfig);
        }
        this.saveOAuthEnvconfigBatchModel(osOAuthEnvconfigList);
        return code;
    }

    @Override
    public void updateOAuthEnvconfigState(Integer oauthEnvconfigId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOAuthEnvconfigModel(oauthEnvconfigId, dataState, oldDataState, map);
    }

    @Override
    public void updateOAuthEnvconfigStateByCode(String tenantCode, String oauthEnvconfigCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateOAuthEnvconfigModelByCode(tenantCode, oauthEnvconfigCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOAuthEnvconfig(OsOAuthEnvconfigDomain osOAuthEnvconfigDomain) throws ApiException {
        String msg = this.checkOAuthEnvconfig(osOAuthEnvconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateOAuthEnvconfig.checkOAuthEnvconfig", msg);
        }
        OsOAuthEnvconfig oldOsOAuthEnvconfig = this.getOAuthEnvconfigModelById(osOAuthEnvconfigDomain.getOauthEnvconfigId());
        if (null == oldOsOAuthEnvconfig) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.updateOAuthEnvconfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OsOAuthEnvconfig osOAuthEnvconfig = this.makeOAuthEnvconfig(osOAuthEnvconfigDomain, oldOsOAuthEnvconfig);
        this.setOAuthEnvconfigUpdataDefault(osOAuthEnvconfig);
        this.updateOAuthEnvconfigModel(osOAuthEnvconfig);
    }

    @Override
    public OsOAuthEnvconfig getOAuthEnvconfig(Integer oauthEnvconfigId) {
        return this.getOAuthEnvconfigModelById(oauthEnvconfigId);
    }

    @Override
    public void deleteOAuthEnvconfig(Integer oauthEnvconfigId) throws ApiException {
        this.deleteOAuthEnvconfigModel(oauthEnvconfigId);
    }

    @Override
    public QueryResult<OsOAuthEnvconfig> queryOAuthEnvconfigPage(Map<String, Object> map) {
        List<OsOAuthEnvconfig> osOAuthEnvconfigList = this.queryOAuthEnvconfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOAuthEnvconfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(osOAuthEnvconfigList);
        return queryResult;
    }

    @Override
    public OsOAuthEnvconfig getOAuthEnvconfigByCode(String tenantCode, String oauthEnvconfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("oauthEnvconfigCode", oauthEnvconfigCode);
        return this.getOAuthEnvconfigModelByCode(map);
    }

    @Override
    public void deleteOAuthEnvconfigByCode(String tenantCode, String oauthEnvconfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("oauthEnvconfigCode", oauthEnvconfigCode);
        this.delOAuthEnvconfigModelByCode(map);
    }

    @Override
    public List<OsOAuthEnvconfig> queryOAuthEnvconfigByEnvCode(String tenantCode, String oauthEnvCode, String proappCode) throws ApiException {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("proappCode", proappCode);
        List<OsOAuthEnvconfig> osList = this.queryOAuthEnvconfigModelPage(parammap);
        if (ListUtil.isEmpty(osList)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.queryOAuthEnvconfigByEnvCode.osList", (Object)((Object)parammap).toString());
            parammap.put("proappCode", "all");
            parammap.put("oauthEnvCode", oauthEnvCode);
            osList = this.queryOAuthEnvconfigModelPage(parammap);
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvconfigServiceImpl.queryOAuthEnvconfigByEnvCode.osList1", (Object)((Object)parammap).toString());
        }
        return osList;
    }
}

