/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.issuer;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthIssuer;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthSystemException;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthTokenProducer;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;

public class SaasOAuthTokenProducerImpl
implements OAuthTokenProducer<OsOAuthToken> {
    private OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private String SYSCODE = "com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthTokenProducerImpl";
    private OAuthIssuer uUUIDOAuthIssuer;

    public OAuthIssuer getuUUIDOAuthIssuer() {
        return this.uUUIDOAuthIssuer;
    }

    public void setuUUIDOAuthIssuer(OAuthIssuer uUUIDOAuthIssuer) {
        this.uUUIDOAuthIssuer = uUUIDOAuthIssuer;
    }

    @Override
    public OsOAuthToken accessToken(String appKey, String uid, String oauthTokenExpireIn, String browType, String tenantCode) {
        String code = null;
        String token = null;
        String refreshToken = null;
        try {
            code = this.uUUIDOAuthIssuer.authorizationCode().replace("-", "").toUpperCase();
            token = this.uUUIDOAuthIssuer.accessToken().replace("-", "").toUpperCase();
            refreshToken = this.uUUIDOAuthIssuer.refreshToken().replace("-", "");
            OsOAuthToken osOAuthToken = new OsOAuthToken();
            osOAuthToken.setOauthTokenCode(code);
            osOAuthToken.setOauthTokenToken(token);
            osOAuthToken.setOauthTokenRefreshToken(refreshToken);
            osOAuthToken.setOauthTokenAppKey(appKey);
            osOAuthToken.setOauthTokenUserAccount(uid);
            osOAuthToken.setOauthTokenUpdateTime(new Date());
            osOAuthToken.setTenantCode(tenantCode);
            osOAuthToken.setOauthTokenBrowtype(browType);
            if (StringUtils.isNotBlank((String)oauthTokenExpireIn)) {
                osOAuthToken.setOauthTokenExpireIn(Integer.parseInt(oauthTokenExpireIn));
            } else {
                osOAuthToken.setOauthTokenExpireIn(30000);
            }
            osOAuthToken.setOauthTokenState(2);
            osOAuthToken.setOauthTokenRemark("SAAS");
            osOAuthToken.setDataState(1);
            return osOAuthToken;
        }
        catch (OAuthSystemException e) {
            this.logger.error(this.SYSCODE, (Object)".accessToken.error", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(Integer.parseInt("6000000"));
    }
}

