/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.oauthserver.domain.OsDdDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthRightsReDomainBean;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthTokenReDomainBean;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthTokenVO;
import com.yqbsoft.laser.service.oauthserver.domain.ResponseInfo;
import com.yqbsoft.laser.service.oauthserver.domain.UserSessionBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthTokenHistory;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthAuthorizeService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthConfigService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthRightsService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthTokenService;
import com.yqbsoft.laser.service.oauthserver.token.cache.GroupUtil;
import com.yqbsoft.laser.service.oauthserver.token.cache.OAuthTokenCacheImpl;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthIssuer;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthSystemException;
import com.yqbsoft.laser.service.oauthserver.token.issuer.OAuthTokenProducer;
import com.yqbsoft.laser.service.oauthserver.token.process.SaasOAuthTokenWriteProcess;
import com.yqbsoft.laser.service.oauthserver.token.validate.ParamsOAuthTokenValidator;
import com.yqbsoft.laser.service.oauthserver.token.validate.SaasOAuthTokenValidator;
import com.yqbsoft.laser.service.oauthserver.util.CommonUtil;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OsOAuthAuthorizeServiceImpl
extends BaseServiceImpl
implements OsOAuthAuthorizeService {
    public static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl";
    private static final String DEL_KEY = "del";
    private static final String BAC_KEY = "bac";
    OsOAuthTokenService oauthTokenService;
    OsOAuthRightsService oauthRightsService;
    private OsOAuthConfigService osOAuthConfigService;
    private OAuthTokenProducer<OsOAuthToken> saasOAuthTokenProducer;
    private SaasOAuthTokenValidator saasOAuthTokenValidator;
    private OAuthIssuer uUUIDOAuthIssuer;
    String cacheUserkey = "os-UmUser";
    String cacheInfokey = "os-UmUserInfo";
    String cacheOpkey = "os-UpOpPermission";
    String cacheInfoUpdatekey = "os-UmUserInfoUpdate";
    String cacheuMOrderNum = "oc-UmOrderNum";

    public OsOAuthConfigService getOsOAuthConfigService() {
        return this.osOAuthConfigService;
    }

    public void setOsOAuthConfigService(OsOAuthConfigService osOAuthConfigService) {
        this.osOAuthConfigService = osOAuthConfigService;
    }

    public OsOAuthRightsService getOauthRightsService() {
        return this.oauthRightsService;
    }

    public void setOauthRightsService(OsOAuthRightsService oauthRightsService) {
        this.oauthRightsService = oauthRightsService;
    }

    public SaasOAuthTokenValidator getSaasOAuthTokenValidator() {
        if (null == this.saasOAuthTokenValidator) {
            this.setSaasOAuthTokenValidator((SaasOAuthTokenValidator)SpringApplicationContextUtil.getBean((String)"saasOAuthTokenValidator"));
        }
        return this.saasOAuthTokenValidator;
    }

    public void setSaasOAuthTokenValidator(SaasOAuthTokenValidator saasOAuthTokenValidator) {
        this.saasOAuthTokenValidator = saasOAuthTokenValidator;
    }

    public OAuthTokenProducer<OsOAuthToken> getSaasOAuthTokenProducer() {
        if (null == this.saasOAuthTokenProducer) {
            this.setSaasOAuthTokenProducer((OAuthTokenProducer)SpringApplicationContextUtil.getBean((String)"saasOAuthTokenProducer"));
        }
        return this.saasOAuthTokenProducer;
    }

    public void setSaasOAuthTokenProducer(OAuthTokenProducer<OsOAuthToken> saasOAuthTokenProducer) {
        this.saasOAuthTokenProducer = saasOAuthTokenProducer;
    }

    public OAuthIssuer getuUUIDOAuthIssuer() {
        return this.uUUIDOAuthIssuer;
    }

    public void setuUUIDOAuthIssuer(OAuthIssuer uUUIDOAuthIssuer) {
        this.uUUIDOAuthIssuer = uUUIDOAuthIssuer;
    }

    @Override
    public String getAuthAuthorizePage(int type, String code, String format, String uri, String clientId, String browType, String tenantCode) {
        String url = CommonUtil.getRes().getString("com.authAuthorizeSub.url");
        if (!this.checkLoginAndParam(code)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE HTML>");
        buffer.append("<HTML lang=\"en\">");
        buffer.append("<HEAD>");
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        buffer.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        buffer.append("<title>OPEN\u6388\u6743</title>");
        buffer.append("<style type=\"text/css\">");
        buffer.append("table {border: 0;width: 100%;}tr {border: 1px solid #333;}td {height: 30px;}.center-box {width: 400px;margin: 50px auto;overflow: hidden;}.buttongroup {text-align: center;}.buttongroup input {margin: 10px 20px;}");
        buffer.append("</style>");
        buffer.append("</HEAD>");
        buffer.append("<BODY>");
        buffer.append("<h1>Authorize</h1>");
        buffer.append("<div class=\"center-box\">");
        buffer.append("<form action=\"\" method=\"post\">");
        buffer.append("<table><tr><td><h2>\u6388\u6743\u64cd\u4f5c</h2></td></tr>");
        buffer.append("<tr><td colspan=\"2\">");
        type = 3;
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                String apiCode = CommonUtil.getRes().getString("com.authAuthorizeSub.type2");
                ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("appmanageType", "3");
                map.put("dataState", "1");
                params.put("map", JsonUtil.buildNormalBinder().toJson(map));
                this.internalInvoke(apiCode, params);
                break;
            }
            default: {
                String apiCode = CommonUtil.getRes().getString("com.authAuthorizeSub.type3");
                ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
                params.put("ddTable", "OsAppapi");
                params.put("ddColumn", "appapiApitype");
                String result = this.internalInvoke(apiCode, params);
                List businessList = (List)JsonUtil.buildNormalBinder().getJsonToList(result, OsDdDomain.class);
                for (int i = 0; businessList != null && i < businessList.size(); ++i) {
                    OsDdDomain entity = (OsDdDomain)businessList.get(i);
                    buffer.append("<input type=\"checkbox\" value=\"" + entity.getDdCode() + "\" id=\"businessType_" + entity.getDdCode() + "\" name=\"foreignKey\">");
                    buffer.append("<label for=\"businessType_" + entity.getDdCode() + "\">" + entity.getDdValue() + "</label><br>");
                }
            }
        }
        buffer.append("</td></tr>");
        buffer.append("<tr><td rowspan=\"2\"><input id=\"authorize_btn\" type=\"button\" value=\"\u6388\u6743\" onclick=\"onLogin()\"> <input type=\"reset\" value=\"\u91cd\u7f6e\"></td></tr>");
        buffer.append("</table></form></div>");
        buffer.append("</BODY></HTML>");
        buffer.append("<script type=\"text/javascript\">");
        buffer.append("var foreignKey,xmlHttpRequest;var foreignType=" + type + ";var red_url=\"" + uri + "\";var code=\"" + code + "\";function createXmlHttpRequest(){if(window.ActiveXObject){return new ActiveXObject(\"Microsoft.XMLHTTP\");}else if(window.XMLHttpRequest){return new XMLHttpRequest();}}function onLogin(){foreignKey = document.getElementsByName(\"foreignKey\");var objarray=foreignKey.length;var chestr=\"\";for (i=0;i<objarray;i++){if(foreignKey[i].checked == true){chestr+=foreignKey[i].value+\",\";}}chestr = chestr.substr(0,chestr.length-1);if(chestr == \"\"){alert(\"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5206\u7c7b\uff01\");}else{");
        buffer.append("var url = \"" + url + ";");
        buffer.append("xmlHttpRequest = createXmlHttpRequest();xmlHttpRequest.onreadystatechange = zswFun;xmlHttpRequest.open(\"POST\",url,true);xmlHttpRequest.send(null);}function zswFun(){if(xmlHttpRequest.readyState == 4 && xmlHttpRequest.status == 200){var b = xmlHttpRequest.responseText;var re = eval('('+b+')');if(re.os.oauthserver_validateAuthorize_response!=null) {var ret = re.os.oauthserver_validateAuthorize_response.result;var resultArray = ret.split(\":\");if(resultArray.length>0&&resultArray[0] == \"success\"){");
        buffer.append("window.location.href=\"" + uri + "\"+\"&clientId=\"+'" + clientId + "'+\"&code=\"+resultArray[1];}");
        buffer.append("}else{alert(\"\u6388\u6743\u5931\u8d25\uff01\");}}}}");
        buffer.append("</script>");
        return buffer.toString();
    }

    public OsOAuthTokenService getOauthTokenService() {
        return this.oauthTokenService;
    }

    public void setOauthTokenService(OsOAuthTokenService oauthTokenService) {
        this.oauthTokenService = oauthTokenService;
    }

    @Override
    public String validateAuthorize(String foreignType, String foreignKey, String code, String url, String clientId, String browType, String tenantCode) {
        if (foreignType != null && foreignKey != null && code != null) {
            String queryApiCode = "os.oauthserver.queryOAuthTokenList";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataState", "1");
            map.put("oauthTokenCode", code);
            ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
            queryMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            String list_Str = this.internalInvoke(queryApiCode, queryMap);
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(list_Str, OsOAuthToken.class);
            if (list != null && list.size() == 1) {
                OsOAuthToken entity = (OsOAuthToken)((Object)list.get(0));
                ArrayList<OsOAuthRightsReDomainBean> osOAuthRightsReDomainBeanList = new ArrayList<OsOAuthRightsReDomainBean>();
                if (foreignKey.indexOf(",") <= 0) {
                    OsOAuthRightsReDomainBean osOAuthRightsReDomainBean = new OsOAuthRightsReDomainBean();
                    osOAuthRightsReDomainBean.setOauthRightsForeignId(foreignKey);
                    osOAuthRightsReDomainBean.setOauthRightsType(foreignType != null ? Integer.parseInt(foreignType) : 0);
                    osOAuthRightsReDomainBean.setOauthRightsRemark("");
                    osOAuthRightsReDomainBean.setDataState(1);
                    osOAuthRightsReDomainBeanList.add(osOAuthRightsReDomainBean);
                } else {
                    String[] foreignKeys = foreignKey.split(",");
                    int type = Integer.parseInt(foreignType != null ? foreignType : "");
                    for (String key : foreignKeys) {
                        OsOAuthRightsReDomainBean osOAuthRightsReDomainBean = new OsOAuthRightsReDomainBean();
                        osOAuthRightsReDomainBean.setOauthRightsForeignId(key);
                        osOAuthRightsReDomainBean.setOauthRightsType(type);
                        osOAuthRightsReDomainBean.setOauthRightsRemark("");
                        osOAuthRightsReDomainBean.setDataState(1);
                        osOAuthRightsReDomainBeanList.add(osOAuthRightsReDomainBean);
                    }
                }
                OsOAuthTokenReDomainBean bean = new OsOAuthTokenReDomainBean();
                org.springframework.beans.BeanUtils.copyProperties((Object)((Object)entity), (Object)bean);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("osOAuthTokenReDomainBean", JsonUtil.buildNormalBinder().toJson((Object)bean));
                this.oauthTokenService.updateOAuthToken(bean);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("oAuthTokenId", bean.getOauthTokenId() + "");
                param.put("osOAuthRightsReDomainBeanList", JsonUtil.buildNormalBinder().toJson(osOAuthRightsReDomainBeanList));
                this.oauthTokenService.saveOAuthRightsListByTokenId(bean.getOauthTokenId(), osOAuthRightsReDomainBeanList);
                return "success:" + entity.getOauthTokenCode();
            }
        }
        return "error:0";
    }

    private boolean checkLoginAndParam(String oauthTokenCode) {
        boolean flag = false;
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, Object> map_param = new HashMap<String, Object>();
        map_param.put("oauthTokenState", "1");
        map_param.put("oauthTokenCode", oauthTokenCode);
        map_param.put("dataState", "1");
        params.put("map", JsonUtil.buildNormalBinder().toJson(map_param));
        List<OsOAuthToken> tokenList = this.oauthTokenService.queryOAuthTokenList(map_param);
        if (tokenList != null && tokenList.size() > 0) {
            OsOAuthToken oauthToken = tokenList.get(0);
            long time = new Date().getTime() - oauthToken.getOauthTokenUpdateTime().getTime();
            long timeout = Long.valueOf(oauthToken.getOauthTokenExpireIn().toString()) * 1000L - time;
            if (oauthToken.getOauthTokenState() == 1 && timeout >= 0L) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public String accessToken(String oauthTokenCode, String oauthRefreshToken, String oauthTokenState, String oauthGrantType, String oauthClientId, String browType, String tenantCode) {
        HashMap<String, String[]> resMap;
        block20: {
            resMap = new HashMap<String, String[]>();
            if (oauthClientId != null && oauthGrantType != null && (oauthTokenCode != null || oauthRefreshToken != null)) {
                boolean isValid = false;
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, Object> map_param = new HashMap<String, Object>();
                if ("access_token".equals(oauthGrantType)) {
                    isValid = true;
                    map_param.put("oauthTokenState", oauthTokenState);
                    map_param.put("oauthTokenCode", oauthTokenCode);
                } else if ("refresh_token".equals(oauthGrantType)) {
                    isValid = true;
                    map_param.put("oauthTokenRefreshToken", oauthRefreshToken);
                }
                if (isValid) {
                    map_param.put("dataState", "1");
                    map_param.put("oauthTokenAppKey", oauthClientId);
                    params.put("map", JsonUtil.buildNormalBinder().toJson(map_param));
                    try {
                        List<OsOAuthToken> tokenList = this.oauthTokenService.queryOAuthTokenList(map_param);
                        if (tokenList != null && tokenList.size() > 0) {
                            params = new HashMap();
                            OsOAuthToken oauthToken = tokenList.get(0);
                            long time = new Date().getTime() - oauthToken.getOauthTokenUpdateTime().getTime();
                            long timeout = Long.valueOf(oauthToken.getOauthTokenExpireIn().toString()) * 1000L - time;
                            if ("access_token".equals(oauthGrantType) && oauthToken.getOauthTokenState() == 1) {
                                if (timeout >= 0L) {
                                    oauthToken.setOauthTokenExpireIn(60480000);
                                    oauthToken.setOauthTokenUpdateTime(new Date());
                                    oauthToken.setOauthTokenState(2);
                                    oauthToken.setOauthTokenRemark("token state");
                                    resMap.put("access_token", new String[]{oauthToken.getOauthTokenToken()});
                                    resMap.put("expires_in", new String[]{oauthToken.getOauthTokenExpireIn() + ""});
                                    resMap.put("refresh_token", new String[]{oauthToken.getOauthTokenRefreshToken()});
                                } else {
                                    oauthToken.setOauthTokenState(3);
                                    oauthToken.setOauthTokenRemark("code timeout");
                                    resMap.put("error", new String[]{"business_error"});
                                    resMap.put("error_description", new String[]{"code timeout"});
                                }
                            } else if ("refresh_token".equals(oauthGrantType)) {
                                if (oauthToken.getOauthTokenState() == 2 || oauthToken.getOauthTokenState() == 4) {
                                    oauthToken.setOauthTokenExpireIn(60480000);
                                    oauthToken.setOauthTokenUpdateTime(new Date());
                                    oauthToken.setOauthTokenToken(this.uUUIDOAuthIssuer.accessToken().replace("-", "").toUpperCase());
                                    oauthToken.setOauthTokenRefreshToken(this.uUUIDOAuthIssuer.refreshToken().replace("-", ""));
                                    oauthToken.setOauthTokenState(2);
                                    oauthToken.setOauthTokenRemark("refresh_token ok");
                                    resMap.put("access_token", new String[]{oauthToken.getOauthTokenToken()});
                                    resMap.put("expires_in", new String[]{oauthToken.getOauthTokenExpireIn() + ""});
                                    resMap.put("refresh_token", new String[]{oauthToken.getOauthTokenRefreshToken()});
                                } else {
                                    oauthToken.setOauthTokenState(5);
                                    oauthToken.setDataState(0);
                                    oauthToken.setOauthTokenRemark("refresh_token timeout");
                                    resMap.put("error", new String[]{"business_error.error_status"});
                                    resMap.put("error_description", new String[]{"refresh_token timeout"});
                                }
                            } else {
                                resMap.put("error", new String[]{"parameters_error"});
                                resMap.put("error_description", new String[]{"\u4f20\u5165\u53c2\u6570\u5f02\u5e38"});
                                return JsonUtil.buildNormalBinder().toJson(resMap);
                            }
                            params.put("osOAuthTokenReDomainBean", JsonUtil.buildNormalBinder().toJson((Object)oauthToken));
                            try {
                                OsOAuthTokenReDomainBean osOAuthTokenReDomainBean = new OsOAuthTokenReDomainBean();
                                org.springframework.beans.BeanUtils.copyProperties((Object)((Object)oauthToken), (Object)osOAuthTokenReDomainBean);
                                this.oauthTokenService.updateOAuthToken(osOAuthTokenReDomainBean);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                resMap.clear();
                                resMap.put("error", new String[]{"business_exception"});
                                resMap.put("error_description", new String[]{"\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"});
                            }
                            break block20;
                        }
                        resMap.put("error", new String[]{"business_exception.token_not_found"});
                        resMap.put("error_description", new String[]{"\u4e1a\u52a1\u5904\u7406\u5f02\u5e38.\u672a\u627e\u5230\u5bf9\u5e94\u6388\u6743\u4fe1\u606f"});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        resMap.clear();
                        resMap.put("error", new String[]{"business_exception"});
                        resMap.put("error_description", new String[]{"\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"});
                    }
                } else {
                    resMap.put("error", new String[]{"parameters_error"});
                    resMap.put("error_description", new String[]{"\u4f20\u5165\u53c2\u6570[code/refreshToken]\u5f02\u5e38"});
                }
            } else {
                resMap.put("error", new String[]{"parameters_error"});
                resMap.put("error_description", new String[]{"\u4f20\u5165\u53c2\u6570\u5f02\u5e38"});
            }
        }
        return JsonUtil.buildNormalBinder().toJson(resMap);
    }

    @Override
    public Map<String, Object> saasAccessToken(String userId, String app_id, String oauthTokenExpireIn, String test_router_flag, String browType, String tenantCode) throws ApiException {
        this.logger.debug(SYS_CODE, (Object)(".saasAccessToken:userId:" + userId + ":app_Id:" + app_id + ":test_router_flag:" + test_router_flag + ",browType:" + browType + ",tenantCode:" + tenantCode));
        if (!ParamsOAuthTokenValidator.checkParams(userId, app_id, oauthTokenExpireIn, browType, tenantCode)) {
            this.logger.debug(SYS_CODE, (Object)".saasAccessToken.\u53c2\u6570\u4e3a\u7a7a\uff0c\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff01");
            throw new ApiException("001", "os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasAccessToken.\u53c2\u6570\u4e3a\u7a7a\uff0c\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff01");
        }
        if (!OAuthTokenCacheImpl.getInstance().isSuccess()) {
            this.logger.debug(SYS_CODE, (Object)".saasAccessToken.\u7f13\u5b58\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            throw new ApiException("002", "os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasAccessToken.\u7f13\u5b58\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        Map<String, Object> userInfoMap = this.queryMemberInfo(app_id, userId, test_router_flag, browType, tenantCode);
        if (MapUtil.isEmpty(userInfoMap)) {
            this.logger.debug(SYS_CODE, (Object)".saasAccessToken.userInfoMap.null");
            throw new ApiException("003", "os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasAccessToken.userInfoMap.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        OsOAuthToken osOAuthToken = this.getSaasOAuthTokenProducer().accessToken(app_id, userId, oauthTokenExpireIn, browType, tenantCode);
        String key = tenantCode + "_" + app_id + "_" + userId;
        OAuthTokenCacheImpl.getInstance().addToken(key, osOAuthToken);
        SaasOAuthTokenWriteProcess.getInstance().put(osOAuthToken);
        map.put("userInfo", userInfoMap);
        map.put("osOAuthToken", this.transToken(osOAuthToken));
        return map;
    }

    @Override
    public Map<String, Object> saasRefreshToken(String userId, String app_id, String oauthTokenRefreshToken, String browType, String tenantCode) {
        OsOAuthToken oauthToken = this.validateRefreshToken(userId, app_id, oauthTokenRefreshToken, browType, tenantCode);
        if (oauthToken != null) {
            oauthToken.setOauthTokenExpireIn(604800);
            oauthToken.setOauthTokenUpdateTime(new Date());
            try {
                oauthToken.setOauthTokenToken(this.uUUIDOAuthIssuer.accessToken().replace("-", "").toUpperCase());
                oauthToken.setOauthTokenRefreshToken(this.uUUIDOAuthIssuer.refreshToken().replace("-", ""));
            }
            catch (OAuthSystemException e) {
                e.printStackTrace();
            }
        } else {
            return null;
        }
        oauthToken.setOauthTokenState(2);
        oauthToken.setOauthTokenRemark("SAAS refresh_token ok");
        OsOAuthTokenReDomainBean osOAuthTokenReDomainBean = new OsOAuthTokenReDomainBean();
        org.springframework.beans.BeanUtils.copyProperties((Object)((Object)oauthToken), (Object)osOAuthTokenReDomainBean);
        this.oauthTokenService.updateOAuthToken(osOAuthTokenReDomainBean);
        HashMap<String, Object> re = new HashMap<String, Object>();
        re.put("osOAuthToken", this.transVO(osOAuthTokenReDomainBean));
        return re;
    }

    @Override
    public void saasTokenAnalysis() {
        if (OAuthTokenCacheImpl.getInstance().needToInit()) {
            this.logger.debug(SYS_CODE, (Object)(".saasTokenAnalysis.initCycle.begin.flag:" + OAuthTokenCacheImpl.getInstance().getInitFlag()));
            OAuthTokenCacheImpl.getInstance().initialize();
            this.logger.debug(SYS_CODE, (Object)(".saasTokenAnalysis.initCycle.end.flag:" + OAuthTokenCacheImpl.getInstance().getInitFlag()));
        }
        this.pollingAnalysisDataCached();
        this.pollingAnalysisDataInDB();
    }

    private void queryExternalMerchant(Map<String, Object> re, String app_id, String test_router_flag, String openUserCode) {
        String parterId = "";
        if (StringUtils.isEmpty((String)app_id)) {
            this.logger.debug(SYS_CODE, (Object)"app_id.null");
            return;
        }
        String key = app_id + "_" + openUserCode;
        String value = OAuthTokenCacheImpl.getInstance().getExternalMerchant(key);
        if (value != null) {
            this.logger.debug(SYS_CODE, (Object)("\u3002queryExternalMerchant\u3002key:" + key + ":value:" + value));
            re.put("parterId", parterId);
            return;
        }
        Map appManagerMap = LocalCache.getAppManagerMap();
        Collection appPropertys = appManagerMap.values();
        if (ListUtil.isEmpty(appPropertys)) {
            this.logger.debug(SYS_CODE, (Object)"appPropertys.null");
            return;
        }
        for (List appList : appPropertys) {
            AppProperty appProperty = (AppProperty)appList.get(0);
            if (appProperty == null || !StringUtils.isNotBlank((String)appProperty.getAppmanageAppkey()) || !appProperty.getAppmanageAppkey().equals(app_id)) continue;
            parterId = appProperty.getAppmanageExtappcode();
        }
        OAuthTokenCacheImpl.getInstance().addExternalMerchant(key, parterId);
        re.put("parterId", parterId);
    }

    public void queryCSS(Map<String, Object> re, String app_id, String test_router_flag, String openUserCode, String getEdit) {
        if (MapUtil.isEmpty(re)) {
            this.logger.debug(SYS_CODE, (Object)"os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryCSS.re.null");
            return;
        }
        if (StringUtils.isEmpty((String)app_id)) {
            this.logger.debug(SYS_CODE, (Object)"os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryCSS.app_id.null");
            return;
        }
        if (StringUtils.isEmpty((String)test_router_flag)) {
            this.logger.debug(SYS_CODE, (Object)"os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryCSS.test_router_flag.null");
            return;
        }
        if (StringUtils.isEmpty((String)openUserCode)) {
            this.logger.debug(SYS_CODE, (Object)"os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryCSS.openUserCode.null");
            return;
        }
        if (StringUtils.isEmpty((String)getEdit)) {
            this.logger.debug(SYS_CODE, (Object)"os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryCSS.getEdit.null");
            return;
        }
        String key = app_id + "_" + openUserCode + "_" + getEdit;
        String value = OAuthTokenCacheImpl.getInstance().getCss(key);
        if (StringUtils.isNotBlank((String)value)) {
            this.logger.debug(SYS_CODE, (Object)("\u3002queryCSS\u3002key:" + key + ":value:" + value));
            re.put("cssUrl", value);
            return;
        }
        String pconfigsetScope = "1";
        String pconfigsetType = "1";
        String api = "os.pconfig.getPConfigValueValue";
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("pconfigsetKey", "\u94b1\u5305\u6a21\u677f");
        paramMap.put("pconfigsetScope", pconfigsetScope);
        paramMap.put("userCode", openUserCode);
        paramMap.put("appmanageAppkey", app_id);
        paramMap.put("pconfigsetType", pconfigsetType);
        paramMap.put("getEdit", getEdit);
        try {
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImplqueryCssInfo:os.pconfig.params:", paramMap);
            String json = this.internalInvoke(api, paramMap);
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImplqueryCssInfo:os.pconfig.getPConfigValueValue:", (Object)json);
            OAuthTokenCacheImpl.getInstance().addCss(key, json);
            re.put("cssUrl", json);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken.queryMemberError." + e);
        }
    }

    private OsOAuthToken validateRefreshToken(String userId, String app_id, String oauthTokenRefreshToken, String browType, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthTokenUserAccount", userId);
        map.put("oauthTokenAppKey", app_id);
        map.put("oauthTokenRefreshToken", oauthTokenRefreshToken);
        map.put("tenantCode", tenantCode);
        map.put("oauthTokenBrowtype", browType);
        List<OsOAuthToken> list = this.oauthTokenService.queryOAuthTokenList(map);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private OsOAuthTokenVO transVO(OsOAuthTokenReDomainBean oauthToken) {
        OsOAuthTokenVO vo = new OsOAuthTokenVO();
        vo.setOauthTokenToken(oauthToken.getOauthTokenToken());
        vo.setOauthTokenRefreshToken(oauthToken.getOauthTokenRefreshToken());
        return vo;
    }

    private Object transToken(OsOAuthToken oauthToken) {
        OsOAuthTokenVO vo = new OsOAuthTokenVO();
        vo.setOauthTokenToken(oauthToken.getOauthTokenToken());
        vo.setOauthTokenRefreshToken(oauthToken.getOauthTokenRefreshToken());
        return vo;
    }

    private void setUrlparam(String parjson, Map<String, Object> paramMap, Map<String, Object> data) {
        if (StringUtils.isBlank((String)parjson)) {
            return;
        }
        if (null != data && !data.isEmpty()) {
            for (String key : data.keySet()) {
                parjson = parjson.replace("${" + key + "}", String.valueOf(data.get(key)));
            }
        }
        paramMap.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(parjson, String.class, Object.class));
    }

    private Map<String, Object> queryMemberInfo(String appKey, String uid, String test_router_flag, String browType, String tenantCode) {
        String key = appKey + "_" + uid;
        ResponseInfo responseInfo_cache = OAuthTokenCacheImpl.getInstance().getMemberInfo(key);
        if (responseInfo_cache != null && responseInfo_cache.getBaseMemberInfo() != null) {
            this.logger.debug(SYS_CODE, (Object)("\u3002queryCSS\u3002key:" + key + ":value:" + JsonUtil.buildNormalBinder().toJson((Object)responseInfo_cache)));
            HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
            try {
                userInfoMap.put("baseMemberInfo", responseInfo_cache.getBaseMemberInfo());
                userInfoMap.put("verifyInfos", responseInfo_cache.getVerifyInfos());
                userInfoMap.put("accountInfos", responseInfo_cache.getAccountInfos());
            }
            catch (Exception e) {
                this.logger.error("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryMemberInfo.e", (Object)"e", (Throwable)e);
            }
            return userInfoMap;
        }
        OsOAuthConfigReDomain osOAuthConfigReDomain = this.osOAuthConfigService.getOAuthConfigAll(tenantCode, appKey);
        if (null == osOAuthConfigReDomain) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.queryMemberInfo.null", "\u975e\u6cd5\u7ec8\u7aef");
        }
        ConcurrentHashMap<String, Object> paramMap = new ConcurrentHashMap<String, Object>();
        String parjson = osOAuthConfigReDomain.getOauthConfigUserparam();
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        data.put("appKey", appKey);
        data.put("uid", uid);
        data.put("test_router_flag", test_router_flag);
        data.put("tenantCode", tenantCode);
        data.put("browType", browType);
        this.setUrlparam(parjson, paramMap, data);
        paramMap.put("uId", uid);
        paramMap.put("app_id", appKey);
        paramMap.put("test_router_flag", test_router_flag);
        String api = osOAuthConfigReDomain.getOauthConfigUserurl();
        try {
            this.logger.debug("[params]:", paramMap);
            String json = this.internalInvoke(api, paramMap);
            ResponseInfo responseInfo = (ResponseInfo)JsonUtil.buildNormalBinder().getJsonToObject(json, ResponseInfo.class);
            if (responseInfo != null) {
                this.logger.debug(SYS_CODE, (Object)(".queryMemberInfo.[ResponseInfo]:" + JsonUtil.buildNormalBinder().toJson((Object)responseInfo)));
                if (responseInfo.getBaseMemberInfo() != null) {
                    HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
                    userInfoMap.put("baseMemberInfo", responseInfo.getBaseMemberInfo());
                    userInfoMap.put("verifyInfos", responseInfo.getVerifyInfos());
                    userInfoMap.put("accountInfos", responseInfo.getAccountInfos());
                    OAuthTokenCacheImpl.getInstance().addMemberInfo(key, responseInfo);
                    return userInfoMap;
                }
            } else {
                this.logger.debug(SYS_CODE, (Object)".queryMemberInfo.[ResponseInfo].null");
            }
        }
        catch (Exception e) {
            throw new ApiException("001", "os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.\u67e5\u8be2\u7528\u6237\u6570\u636e\u5f02\u5e38:" + e.getMessage());
        }
        this.logger.debug(SYS_CODE, (Object)".saasAccessToken.after queryMemberByUId");
        return null;
    }

    private void pollingAnalysisDataCached() {
        this.logger.debug(SYS_CODE, (Object)".pollingAnalysisDataCached.begin");
        Map<String, String> map = OAuthTokenCacheImpl.getInstance().getAllToken();
        if (map == null) {
            this.logger.debug(SYS_CODE, (Object)".pollingAnalysisDataCached.map.null");
            return;
        }
        Iterator<String> it = map.keySet().iterator();
        int del_counter = 0;
        while (it.hasNext()) {
            OsOAuthToken osOAuthToken;
            String value;
            String key = it.next();
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)(value = map.get(key))) || !this.needDel(osOAuthToken = (OsOAuthToken)((Object)JsonUtil.buildNormalBinder().getJsonToObject(value, OsOAuthToken.class)))) continue;
            OAuthTokenCacheImpl.getInstance().removeToken(key);
            OAuthTokenCacheImpl.getInstance().removeCss(key);
            OAuthTokenCacheImpl.getInstance().removeExternalMerchant(key);
            OAuthTokenCacheImpl.getInstance().removeMemberInfo(key);
            ++del_counter;
        }
        this.logger.debug(SYS_CODE, (Object)(".pollingAnalysisDataCached.end.del_counter:" + del_counter));
    }

    private boolean needDel(OsOAuthToken osOAuthToken) {
        this.logger.debug(SYS_CODE, (Object)".needDel.begin");
        if (this.getSaasOAuthTokenValidator().checkExpireTime(osOAuthToken, new Date())) {
            return false;
        }
        this.logger.debug(SYS_CODE, (Object)".needDel.end");
        return true;
    }

    private void pollingAnalysisDataInDB() {
        List bac_list;
        this.logger.debug(SYS_CODE, (Object)".pollingAnalysisDataInDB.begin");
        List<OsOAuthToken> list = this.oauthTokenService.queryOAuthTokenList(new HashMap<String, Object>());
        if (ListUtil.isEmpty(list)) {
            this.logger.debug(SYS_CODE, (Object)".pollingAnalysisDataInDB.list.null");
            return;
        }
        Map<String, Object> resultMap = this.checkDelDataFromList(list);
        List del_list = (List)resultMap.get(DEL_KEY);
        if (ListUtil.isNotEmpty((Collection)del_list)) {
            this.oauthTokenService.delBatch(del_list);
        }
        if (ListUtil.isNotEmpty((Collection)(bac_list = (List)resultMap.get(BAC_KEY)))) {
            this.oauthTokenService.backUpBatch(bac_list);
        }
        this.logger.info(SYS_CODE, (Object)(".pollingAnalysisDataInDB.end.delList\u3002size:" + del_list.size() + "||bacList.size:" + bac_list.size()));
    }

    private Map<String, Object> checkDelDataFromList(List<OsOAuthToken> list) {
        if (ListUtil.isEmpty(list)) {
            this.logger.debug(SYS_CODE, (Object)".checkDelDataFromList.list.null");
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, OsOAuthToken> map = new HashMap<String, OsOAuthToken>();
        ArrayList<OsOAuthTokenHistory> needBac = new ArrayList<OsOAuthTokenHistory>();
        ArrayList<OsOAuthToken> needDel = new ArrayList<OsOAuthToken>();
        for (OsOAuthToken v : list) {
            OsOAuthTokenHistory osOAuthTokenHistory;
            if (v == null) continue;
            String key = v.getOauthTokenAppKey() + "_" + v.getOauthTokenUserAccount();
            if (this.needDel(v)) {
                OsOAuthTokenHistory osOAuthTokenHistory2 = this.createHistoryRecord(v);
                needBac.add(osOAuthTokenHistory2);
                needDel.add(v);
                continue;
            }
            if (map.get(key) == null) {
                map.put(key, v);
                continue;
            }
            OsOAuthToken pre = (OsOAuthToken)((Object)map.get(key));
            Date pre_upd = pre.getOauthTokenUpdateTime();
            Date upd = v.getOauthTokenUpdateTime();
            if (pre_upd.getTime() > upd.getTime()) {
                osOAuthTokenHistory = this.createHistoryRecord(v);
                needBac.add(osOAuthTokenHistory);
                needDel.add(v);
                continue;
            }
            map.put(key, v);
            osOAuthTokenHistory = this.createHistoryRecord(pre);
            needBac.add(osOAuthTokenHistory);
            needDel.add(pre);
        }
        result.put(DEL_KEY, needDel);
        result.put(BAC_KEY, needBac);
        return result;
    }

    private OsOAuthTokenHistory createHistoryRecord(OsOAuthToken v) {
        OsOAuthTokenHistory osOAuthTokenHistory = new OsOAuthTokenHistory();
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthTokenHistory, (Object)((Object)v));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        osOAuthTokenHistory.setBacDate(DateUtil.getDateStr((String)"yyyyMMdd"));
        return osOAuthTokenHistory;
    }

    @Override
    public void saasTokenCacheInit() {
        this.logger.debug(SYS_CODE, (Object)(".saasTokenCacheInit.job.begin" + OAuthTokenCacheImpl.getInstance().getInitFlag()));
        OAuthTokenCacheImpl.getInstance().initialize();
        this.logger.debug(SYS_CODE, (Object)(".saasTokenCacheInit.job.end" + OAuthTokenCacheImpl.getInstance().getInitFlag()));
    }

    private UserSessionBean check(UserSessionBean userSessionBean, String appmanageGroup) {
        if (null == userSessionBean) {
            return null;
        }
        String userCode = userSessionBean.getUserCode();
        String userinfoCode = userSessionBean.getUserPcode();
        String tenantCode = userSessionBean.getTenantCode();
        String roleStr = userSessionBean.getRoleCode();
        Map<String, String> opver = userSessionBean.getOpver();
        if (null == opver) {
            opver = new HashMap<String, String>();
        }
        String cacheOpver = "";
        if (StringUtils.isNotBlank((String)roleStr)) {
            String[] roleS;
            for (String role : roleS = roleStr.split(",")) {
                cacheOpver = DisUtil.getMap((String)this.cacheOpkey, (String)(tenantCode + "-1-" + role));
                if (null == cacheOpver) {
                    cacheOpver = "";
                }
                if (cacheOpver.equals(StringUtils.isBlank((String)opver.get(tenantCode + "-1-" + role)) ? "" : opver.get(tenantCode + "-1-" + role))) continue;
                this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.check.role", (Object)(cacheOpver + "=" + opver.get(tenantCode + "-1-" + role)));
                return null;
            }
        }
        if (null == (cacheOpver = DisUtil.getMap((String)this.cacheOpkey, (String)(tenantCode + "-0-" + userCode)))) {
            cacheOpver = "";
        }
        if (!cacheOpver.equals(StringUtils.isBlank((String)opver.get(tenantCode + "-0-" + userCode)) ? "" : opver.get(tenantCode + "-0-" + userCode))) {
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.check.userCode", (Object)(cacheOpver + "=" + opver.get(tenantCode + "-0-" + userCode)));
            return null;
        }
        String cacver = userSessionBean.getUserver();
        if (null == cacver) {
            cacver = "";
        }
        if (null == (cacheOpver = DisUtil.getMap((String)this.cacheUserkey, (String)(tenantCode + "-" + userCode)))) {
            cacheOpver = "";
        }
        if (!cacver.equals(cacheOpver)) {
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.check.userCode1", (Object)(cacheOpver + "=" + cacver + "=" + tenantCode + "-" + userCode));
            return null;
        }
        cacver = userSessionBean.getUserinfover();
        if (null == cacver) {
            cacver = "";
        }
        if (null == (cacheOpver = DisUtil.getMap((String)this.cacheInfokey, (String)(tenantCode + "-" + userinfoCode)))) {
            cacheOpver = "";
        }
        if (!cacver.equals(cacheOpver)) {
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.check.userinfoCode", (Object)(cacheOpver + "=" + cacver + "=" + tenantCode + "-" + userinfoCode));
            return null;
        }
        cacver = userSessionBean.getUserinfoverUpdate();
        if (null == cacver) {
            cacver = "";
        }
        if (!cacver.equals(cacheOpver = DisUtil.getRemotMap((String)this.cacheInfoUpdatekey, (String)(tenantCode + "-" + userinfoCode)))) {
            String orderNum = DisUtil.getRemotMap((String)this.cacheuMOrderNum, (String)(tenantCode + "-" + userinfoCode));
            if (null != orderNum) {
                userSessionBean.setUserinfoOrder(Integer.parseInt(orderNum));
            }
            OAuthTokenCacheImpl.getInstance().setUserSession(userSessionBean.getTicketTokenid() + "-" + appmanageGroup, userSessionBean);
        }
        return userSessionBean;
    }

    @Override
    public UserSessionBean saasValidateToken(String oauthTokenToken, String app_id, String tenantCode) throws ApiException {
        boolean validateResult;
        UserSessionBean userSessionBean = new UserSessionBean();
        if (StringUtils.isEmpty((String)oauthTokenToken)) {
            this.logger.debug(SYS_CODE, (Object)".saasValidateToken.\u53c2\u6570\u4e3a\u7a7a\uff0c\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff01");
            userSessionBean.setFlag(false);
            return userSessionBean;
        }
        String appmanageGroup = GroupUtil.getGroupByCache(app_id, tenantCode);
        userSessionBean = OAuthTokenCacheImpl.getInstance().getUserSession(oauthTokenToken + "-" + appmanageGroup);
        if (userSessionBean == null) {
            OAuthTokenCacheImpl.getInstance().removeToken(oauthTokenToken);
            userSessionBean = new UserSessionBean();
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken.userSessionBean", (Object)(oauthTokenToken + "-" + appmanageGroup));
            userSessionBean.setFlag(false);
            return userSessionBean;
        }
        OsOAuthToken osOAuthToken = OAuthTokenCacheImpl.getInstance().getToken(oauthTokenToken);
        if (osOAuthToken == null) {
            userSessionBean.setFlag(false);
            OAuthTokenCacheImpl.getInstance().delUserSession(oauthTokenToken + "-" + appmanageGroup);
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken.osOAuthToken", (Object)(oauthTokenToken + "-" + appmanageGroup));
            return userSessionBean;
        }
        boolean bl = validateResult = this.getSaasOAuthTokenValidator().checkUserId(osOAuthToken, userSessionBean.getUserId().toString()) && this.getSaasOAuthTokenValidator().checkToken(osOAuthToken, oauthTokenToken) && this.getSaasOAuthTokenValidator().checkExpireTime(osOAuthToken, new Date());
        if (!validateResult) {
            OAuthTokenCacheImpl.getInstance().removeToken(oauthTokenToken);
            OAuthTokenCacheImpl.getInstance().delUserSession(oauthTokenToken + "-" + appmanageGroup);
            String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSessionBean.getUserName(), userSessionBean.getTenantCode(), osOAuthToken.getOauthTokenBrowtype());
            if (StringUtils.isNotBlank((String)tokenid)) {
                OAuthTokenCacheImpl.getInstance().ClearTokenExit(userSessionBean.getUserName(), userSessionBean.getTenantCode(), osOAuthToken.getOauthTokenBrowtype());
            }
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken.validateResult", (Object)(oauthTokenToken + "-" + appmanageGroup));
            return userSessionBean;
        }
        userSessionBean.setFlag(true);
        userSessionBean = this.check(userSessionBean, appmanageGroup);
        if (userSessionBean == null) {
            userSessionBean = new UserSessionBean();
            userSessionBean.setFlag(false);
            userSessionBean.setMsg("\u5b89\u5168\u53d8\u5316");
            OAuthTokenCacheImpl.getInstance().removeToken(oauthTokenToken);
            OAuthTokenCacheImpl.getInstance().delUserSession(oauthTokenToken + "-" + appmanageGroup);
            String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSessionBean.getUserName(), userSessionBean.getTenantCode(), osOAuthToken.getOauthTokenBrowtype());
            if (StringUtils.isNotBlank((String)tokenid)) {
                OAuthTokenCacheImpl.getInstance().ClearTokenExit(userSessionBean.getUserName(), userSessionBean.getTenantCode(), osOAuthToken.getOauthTokenBrowtype());
            }
            this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken.userSessionBean", (Object)(oauthTokenToken + "-" + appmanageGroup));
            return userSessionBean;
        }
        if (validateResult) {
            if (this.getSaasOAuthTokenValidator().delay(osOAuthToken)) {
                this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken:", (Object)(osOAuthToken.getOauthTokenToken() + ":key:" + oauthTokenToken + ".delaySuccess"));
            } else {
                this.logger.debug("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.saasValidateToken:", (Object)(osOAuthToken.getOauthTokenToken() + ":key:" + oauthTokenToken + ".delayFailed"));
            }
            return userSessionBean;
        }
        return userSessionBean;
    }

    @Override
    public void removeUserSession(Map<String, String> map) throws ApiException {
        if (map != null) {
            String userName = map.get("userName");
            String tenantCode = map.get("tenantCode");
            String browType = map.get("browType");
            String oauthTokenToken = OAuthTokenCacheImpl.getInstance().getTokenExit(userName, tenantCode, browType);
            String group = GroupUtil.getGroupByCache(map.get("appmanageIcode"), tenantCode);
            if (StringUtils.isNotBlank((String)oauthTokenToken)) {
                OsOAuthToken osOAuthToken = OAuthTokenCacheImpl.getInstance().getToken(oauthTokenToken);
                UserSessionBean userSessionBean = OAuthTokenCacheImpl.getInstance().getUserSession(oauthTokenToken + "-" + group);
                if (!"".equals((Object)osOAuthToken) && osOAuthToken != null) {
                    OAuthTokenCacheImpl.getInstance().removeToken(oauthTokenToken);
                }
                if (!"".equals(userSessionBean) && userSessionBean != null) {
                    DisUtil.del((String)(oauthTokenToken + "-" + group));
                    String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSessionBean.getUserName(), tenantCode, browType);
                    if (StringUtils.isNotBlank((String)tokenid)) {
                        OAuthTokenCacheImpl.getInstance().ClearTokenExit(userSessionBean.getUserName(), tenantCode, browType);
                    }
                }
                this.logger.error("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.removeUserSession:", (Object)("\u79df\u6237\uff1a" + tenantCode + ",userName:" + userName + "\u7684\u4f1a\u8bdd\u5df2\u6e05\u9664"));
            } else {
                this.logger.error("os.OAUTHSERVER.OsOAuthAuthorizeServiceImpl.removeUserSession:", (Object)("\u79df\u6237\uff1a" + tenantCode + ",userName:" + userName + "\u672a\u767b\u9646"));
            }
        }
    }
}

