/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oncustomerservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oncustomerservice.dao.OcsOcsconfigMapper;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsconfigDomain;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsconfigReDomain;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcserviceConfReDomain;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcserviceReDomain;
import com.yqbsoft.laser.service.oncustomerservice.model.OcsOcsconfig;
import com.yqbsoft.laser.service.oncustomerservice.model.OcsOcservice;
import com.yqbsoft.laser.service.oncustomerservice.model.OcsOcserviceConf;
import com.yqbsoft.laser.service.oncustomerservice.service.OcsOcsconfigService;
import com.yqbsoft.laser.service.oncustomerservice.service.OcsOcserviceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcsOcsconfigServiceImpl
extends BaseServiceImpl
implements OcsOcsconfigService {
    private static final String SYS_CODE = "ocs.OcsOcsconfigServiceImpl";
    private OcsOcsconfigMapper ocsOcsconfigMapper;
    private OcsOcserviceService ocsOcserviceService;

    public void setOcsOcsconfigMapper(OcsOcsconfigMapper ocsOcsconfigMapper) {
        this.ocsOcsconfigMapper = ocsOcsconfigMapper;
    }

    public OcsOcserviceService getOcsOcserviceService() {
        return this.ocsOcserviceService;
    }

    public void setOcsOcserviceService(OcsOcserviceService ocsOcserviceService) {
        this.ocsOcserviceService = ocsOcserviceService;
    }

    private Date getSysDate() {
        try {
            return this.ocsOcsconfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOcsconfig(OcsOcsconfigDomain ocsOcsconfigDomain) {
        if (null == ocsOcsconfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocsOcsconfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOcsconfigDefault(OcsOcsconfig ocsOcsconfig) {
        if (null == ocsOcsconfig) {
            return;
        }
        if (null == ocsOcsconfig.getDataState()) {
            ocsOcsconfig.setDataState(0);
        }
        if (null == ocsOcsconfig.getGmtCreate()) {
            ocsOcsconfig.setGmtCreate(this.getSysDate());
        }
        ocsOcsconfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocsOcsconfig.getOcsconfigCode())) {
            ocsOcsconfig.setOcsconfigCode(this.createUUIDString());
        }
    }

    private int getOcsconfigMaxCode() {
        int code = 0;
        try {
            return this.ocsOcsconfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.getOcsconfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOcsconfigUpdataDefault(OcsOcsconfig ocsOcsconfig) {
        if (null == ocsOcsconfig) {
            return;
        }
        ocsOcsconfig.setGmtModified(this.getSysDate());
    }

    private void saveOcsconfigModel(OcsOcsconfig ocsOcsconfig) throws ApiException {
        if (null == ocsOcsconfig) {
            return;
        }
        try {
            this.ocsOcsconfigMapper.insert(ocsOcsconfig);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.saveOcsconfigModel.ex", (Throwable)e);
        }
    }

    private void saveOcsconfigBatchModel(List<OcsOcsconfig> ocsOcsconfigList) throws ApiException {
        if (null == ocsOcsconfigList || ocsOcsconfigList.isEmpty()) {
            return;
        }
        try {
            this.ocsOcsconfigMapper.insertBatch(ocsOcsconfigList);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.saveOcsconfigBatchModel.ex", (Throwable)e);
        }
    }

    private OcsOcsconfig getOcsconfigModelById(Integer ocsconfigId) {
        if (null == ocsconfigId) {
            return null;
        }
        try {
            return this.ocsOcsconfigMapper.selectByPrimaryKey(ocsconfigId);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.getOcsconfigModelById", (Throwable)e);
            return null;
        }
    }

    private OcsOcsconfig getOcsconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocsOcsconfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.getOcsconfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOcsconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocsOcsconfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.delOcsconfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.delOcsconfigModelByCode.num");
        }
    }

    private void deleteOcsconfigModel(Integer ocsconfigId) throws ApiException {
        if (null == ocsconfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocsOcsconfigMapper.deleteByPrimaryKey(ocsconfigId);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.deleteOcsconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.deleteOcsconfigModel.num");
        }
    }

    private void updateOcsconfigModel(OcsOcsconfig ocsOcsconfig) throws ApiException {
        if (null == ocsOcsconfig) {
            return;
        }
        int i = 0;
        try {
            i = this.ocsOcsconfigMapper.updateByPrimaryKeySelective(ocsOcsconfig);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateOcsconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateOcsconfigModel.num");
        }
    }

    private void updateStateOcsconfigModel(Integer ocsconfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ocsconfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocsconfigId", ocsconfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocsOcsconfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateStateOcsconfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateStateOcsconfigModel.null");
        }
    }

    private void updateStateOcsconfigModelByCode(String tenantCode, String ocsconfigCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)ocsconfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ocsconfigCode", ocsconfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocsOcsconfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateStateOcsconfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateStateOcsconfigModelByCode.null");
        }
    }

    private OcsOcsconfig makeOcsconfig(OcsOcsconfigDomain ocsOcsconfigDomain, OcsOcsconfig ocsOcsconfig) {
        if (null == ocsOcsconfigDomain) {
            return null;
        }
        if (null == ocsOcsconfig) {
            ocsOcsconfig = new OcsOcsconfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsconfig, (Object)ocsOcsconfigDomain);
            return ocsOcsconfig;
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.makeOcsconfig", (Throwable)e);
            return null;
        }
    }

    private OcsOcsconfigReDomain makeOcsOcsconfigReDomain(OcsOcsconfig ocsOcsconfig) {
        if (null == ocsOcsconfig) {
            return null;
        }
        OcsOcsconfigReDomain ocsOcsconfigReDomain = new OcsOcsconfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsconfigReDomain, (Object)ocsOcsconfig);
            return ocsOcsconfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.makeOcsOcsconfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcsOcsconfig> queryOcsconfigModelPage(Map<String, Object> parammap) {
        try {
            return this.ocsOcsconfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.queryOcsconfigModel", (Throwable)e);
            return null;
        }
    }

    private int countOcsconfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocsOcsconfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.countOcsconfig", (Throwable)e);
        }
        return i;
    }

    private OcsOcsconfig createOcsOcsconfig(OcsOcsconfigDomain ocsOcsconfigDomain) {
        String msg = this.checkOcsconfig(ocsOcsconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.saveOcsconfig.checkOcsconfig", msg);
        }
        OcsOcsconfig ocsOcsconfig = this.makeOcsconfig(ocsOcsconfigDomain, null);
        this.setOcsconfigDefault(ocsOcsconfig);
        return ocsOcsconfig;
    }

    @Override
    public String saveOcsconfig(OcsOcsconfigDomain ocsOcsconfigDomain) throws ApiException {
        OcsOcsconfig ocsOcsconfig = this.createOcsOcsconfig(ocsOcsconfigDomain);
        this.saveOcsconfigModel(ocsOcsconfig);
        return ocsOcsconfig.getOcsconfigCode();
    }

    @Override
    public String saveOcsconfigBatch(List<OcsOcsconfigDomain> ocsOcsconfigDomainList) throws ApiException {
        if (null == ocsOcsconfigDomainList || ocsOcsconfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcsOcsconfig> ocsOcsconfigList = new ArrayList<OcsOcsconfig>();
        String code = "";
        for (OcsOcsconfigDomain ocsOcsconfigDomain : ocsOcsconfigDomainList) {
            OcsOcsconfig ocsOcsconfig = this.createOcsOcsconfig(ocsOcsconfigDomain);
            code = ocsOcsconfig.getOcsconfigCode();
            ocsOcsconfigList.add(ocsOcsconfig);
        }
        this.saveOcsconfigBatchModel(ocsOcsconfigList);
        return code;
    }

    @Override
    public void updateOcsconfigState(Integer ocsconfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOcsconfigModel(ocsconfigId, dataState, oldDataState);
    }

    @Override
    public void updateOcsconfigStateByCode(String tenantCode, String ocsconfigCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOcsconfigModelByCode(tenantCode, ocsconfigCode, dataState, oldDataState);
    }

    @Override
    public void updateOcsconfig(OcsOcsconfigDomain ocsOcsconfigDomain) throws ApiException {
        String msg = this.checkOcsconfig(ocsOcsconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateOcsconfig.checkOcsconfig", msg);
        }
        OcsOcsconfig oldOcsOcsconfig = this.getOcsconfigModelById(ocsOcsconfigDomain.getOcsconfigId());
        if (null == oldOcsOcsconfig) {
            throw new ApiException("ocs.OcsOcsconfigServiceImpl.updateOcsconfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcsOcsconfig ocsOcsconfig = this.makeOcsconfig(ocsOcsconfigDomain, oldOcsOcsconfig);
        this.setOcsconfigUpdataDefault(ocsOcsconfig);
        this.updateOcsconfigModel(ocsOcsconfig);
    }

    @Override
    public OcsOcsconfig getOcsconfig(Integer ocsconfigId) {
        return this.getOcsconfigModelById(ocsconfigId);
    }

    @Override
    public void deleteOcsconfig(Integer ocsconfigId) throws ApiException {
        this.deleteOcsconfigModel(ocsconfigId);
    }

    @Override
    public QueryResult<OcsOcsconfig> queryOcsconfigPage(Map<String, Object> map) {
        List<OcsOcsconfig> ocsOcsconfigList = this.classifiedQuery(map);
        OcsOcsconfigReDomain ocsOcsconfigReDomain = new OcsOcsconfigReDomain();
        for (OcsOcsconfig ocsOcsconfig : ocsOcsconfigList) {
            OcsOcservice ocserviceByCode = this.ocsOcserviceService.getOcserviceByCode(ocsOcsconfig.getTenantCode(), ocsOcsconfig.getOcserviceCode());
            ocsOcsconfigReDomain.setOcsOcserviceReDomain(this.makeOcsOcserviceReDomain(ocserviceByCode));
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOcsconfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocsOcsconfigList);
        return queryResult;
    }

    @Override
    public List<OcsOcsconfigReDomain> queryOcsconfigList(Map<String, Object> map) {
        List<OcsOcsconfig> ocsOcsconfigList = this.classifiedQuery(map);
        if (ListUtil.isEmpty(ocsOcsconfigList)) {
            return null;
        }
        ArrayList<OcsOcsconfigReDomain> ocsOcsconfigReDomainList = new ArrayList<OcsOcsconfigReDomain>();
        for (OcsOcsconfig ocsOcsconfig : ocsOcsconfigList) {
            OcsOcsconfigReDomain ocsOcsconfigReDomain = this.makeOcsOcsconfigReDomain(ocsOcsconfig);
            OcsOcservice ocsOcservice = this.ocsOcserviceService.getOcserviceByCode(ocsOcsconfig.getTenantCode(), ocsOcsconfig.getOcserviceCode());
            ocsOcsconfigReDomain.setOcsOcserviceReDomain(this.makeOcsOcserviceReDomain(ocsOcservice));
            ocsOcsconfigReDomainList.add(ocsOcsconfigReDomain);
        }
        return ocsOcsconfigReDomainList;
    }

    private OcsOcserviceReDomain makeOcsOcserviceReDomain(OcsOcservice ocsOcservice) {
        if (null == ocsOcservice) {
            return null;
        }
        OcsOcserviceReDomain ocsOcserviceReDomain = new OcsOcserviceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcserviceReDomain, (Object)ocsOcservice);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", ocsOcservice.getTenantCode());
            map.put("ocserviceCode", ocsOcservice.getOcserviceCode());
            QueryResult<OcsOcserviceConf> qlist = this.ocsOcserviceService.queryOcserviceConfPage(map);
            ocsOcserviceReDomain.setOcsOcserviceConfReDomainList(this.makeConfList(qlist.getList()));
            return ocsOcserviceReDomain;
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsconfigServiceImpl.makeOcsOcserviceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcsOcserviceConfReDomain> makeConfList(List<OcsOcserviceConf> ocsOcserviceConfList) {
        if (ListUtil.isEmpty(ocsOcserviceConfList)) {
            return null;
        }
        ArrayList<OcsOcserviceConfReDomain> ocsOcserviceConfReDomainList = new ArrayList<OcsOcserviceConfReDomain>();
        for (OcsOcserviceConf ocsOcserviceConf : ocsOcserviceConfList) {
            OcsOcserviceConfReDomain ocsOcserviceConfReDomain = new OcsOcserviceConfReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocsOcserviceConfReDomain, (Object)ocsOcserviceConf);
                ocsOcserviceConfReDomainList.add(ocsOcserviceConfReDomain);
            }
            catch (Exception e) {
                this.logger.error("ocs.OcsOcsconfigServiceImpl.makeOcsOcserviceReDomain", (Throwable)e);
            }
        }
        return ocsOcserviceConfReDomainList;
    }

    private List<OcsOcsconfig> classifiedQuery(Map<String, Object> map) {
        List<OcsOcsconfig> ocsOcsconfigList = null;
        if (map.containsKey("memberCode") && StringUtils.isNotBlank((String)((String)map.get("memberCode")))) {
            ocsOcsconfigList = this.queryOcsconfigModelPage(map);
            map.remove("memberCode");
            if (ListUtil.isNotEmpty(ocsOcsconfigList)) {
                return ocsOcsconfigList;
            }
        }
        if (map.containsKey("tginfoCode") && StringUtils.isNotBlank((String)((String)map.get("tginfoCode")))) {
            ocsOcsconfigList = this.queryOcsconfigModelPage(map);
            map.remove("tginfoCode");
            if (ListUtil.isNotEmpty(ocsOcsconfigList)) {
                return ocsOcsconfigList;
            }
        }
        if (map.containsKey("proappCode") && StringUtils.isNotBlank((String)((String)map.get("proappCode")))) {
            ocsOcsconfigList = this.queryOcsconfigModelPage(map);
            map.remove("proappCode");
            if (ListUtil.isNotEmpty(ocsOcsconfigList)) {
                return ocsOcsconfigList;
            }
        }
        ocsOcsconfigList = this.queryOcsconfigModelPage(map);
        return ocsOcsconfigList;
    }

    @Override
    public OcsOcsconfig getOcsconfigByCode(String tenantCode, String ocsconfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ocsconfigCode", ocsconfigCode);
        return this.getOcsconfigModelByCode(map);
    }

    @Override
    public void deleteOcsconfigByCode(String tenantCode, String ocsconfigCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ocsconfigCode", ocsconfigCode);
        this.delOcsconfigModelByCode(map);
    }
}

