/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oncustomerservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oncustomerservice.dao.OcsOcsTimeMapper;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsTimeDomain;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsTimeDto;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsTimeItDomain;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsTimeReDomain;
import com.yqbsoft.laser.service.oncustomerservice.domain.OcsOcsTimeScDomain;
import com.yqbsoft.laser.service.oncustomerservice.model.OcsOcsTime;
import com.yqbsoft.laser.service.oncustomerservice.model.OcsOcsTimeIt;
import com.yqbsoft.laser.service.oncustomerservice.model.OcsOcsTimeSc;
import com.yqbsoft.laser.service.oncustomerservice.service.OcsOcsTimeItService;
import com.yqbsoft.laser.service.oncustomerservice.service.OcsOcsTimeScService;
import com.yqbsoft.laser.service.oncustomerservice.service.OcsOcsTimeService;
import com.yqbsoft.laser.service.oncustomerservice.util.DateUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class OcsOcsTimeServiceImpl
extends BaseServiceImpl
implements OcsOcsTimeService {
    private static final String SYS_CODE = "ocs.OcsOcsTimeServiceImpl.";
    private OcsOcsTimeMapper ocsOcsTimeMapper;
    @Autowired
    private OcsOcsTimeItService ocsOcsTimeItService;
    @Autowired
    private OcsOcsTimeScService ocsOcsTimeScService;

    public void setOcsOcsTimeMapper(OcsOcsTimeMapper ocsOcsTimeMapper) {
        this.ocsOcsTimeMapper = ocsOcsTimeMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocsOcsTimeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOcsOcsTime(OcsOcsTimeDomain ocsOcsTimeDomain) {
        if (null == ocsOcsTimeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocsOcsTimeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOcsOcsTimeDefault(OcsOcsTime ocsOcsTime) {
        if (null == ocsOcsTime) {
            return;
        }
        if (null == ocsOcsTime.getDataState()) {
            ocsOcsTime.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocsOcsTime.getGmtCreate()) {
            ocsOcsTime.setGmtCreate(date);
        }
        ocsOcsTime.setGmtModified(date);
        if (StringUtils.isBlank((String)ocsOcsTime.getOcstimeCode())) {
            ocsOcsTime.setOcstimeCode(this.createUUIDString());
        }
    }

    private int getOcsOcsTimeMaxCode() {
        int code = 0;
        try {
            return this.ocsOcsTimeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..getOcsOcsTimeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOcsOcsTimeUpdataDefault(OcsOcsTime ocsOcsTime) {
        if (null == ocsOcsTime) {
            return;
        }
        ocsOcsTime.setGmtModified(this.getSysDate());
    }

    private void saveOcsOcsTimeModel(OcsOcsTime ocsOcsTime) throws ApiException {
        if (null == ocsOcsTime) {
            return;
        }
        try {
            this.ocsOcsTimeMapper.insert(ocsOcsTime);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..saveOcsOcsTimeModel.ex", (Throwable)e);
        }
    }

    private void saveOcsOcsTimeBatchModel(List<OcsOcsTime> ocsOcsTimeList) throws ApiException {
        if (null == ocsOcsTimeList || ocsOcsTimeList.isEmpty()) {
            return;
        }
        try {
            this.ocsOcsTimeMapper.insertBatch(ocsOcsTimeList);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..saveOcsOcsTimeBatchModel.ex", (Throwable)e);
        }
    }

    private OcsOcsTime getOcsOcsTimeModelById(Integer ocstimeId) {
        if (null == ocstimeId) {
            return null;
        }
        try {
            return this.ocsOcsTimeMapper.selectByPrimaryKey(ocstimeId);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..getOcsOcsTimeModelById", (Throwable)e);
            return null;
        }
    }

    private OcsOcsTime getOcsOcsTimeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocsOcsTimeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..getOcsOcsTimeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOcsOcsTimeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocsOcsTimeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..delOcsOcsTimeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..delOcsOcsTimeModelByCode.num");
        }
    }

    private void deleteOcsOcsTimeModel(Integer ocstimeId) throws ApiException {
        if (null == ocstimeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocsOcsTimeMapper.deleteByPrimaryKey(ocstimeId);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..deleteOcsOcsTimeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..deleteOcsOcsTimeModel.num");
        }
    }

    private void updateOcsOcsTimeModel(OcsOcsTime ocsOcsTime) throws ApiException {
        if (null == ocsOcsTime) {
            return;
        }
        int i = 0;
        try {
            i = this.ocsOcsTimeMapper.updateByPrimaryKey(ocsOcsTime);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateOcsOcsTimeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateOcsOcsTimeModel.num");
        }
    }

    private void updateStateOcsOcsTimeModel(Integer ocstimeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ocstimeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocstimeId", ocstimeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocsOcsTimeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateStateOcsOcsTimeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateStateOcsOcsTimeModel.null");
        }
    }

    private void updateStateOcsOcsTimeModelByCode(String tenantCode, String ocstimeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ocstimeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ocstimeCode", ocstimeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocsOcsTimeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateStateOcsOcsTimeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateStateOcsOcsTimeModelByCode.null");
        }
    }

    private OcsOcsTime makeOcsOcsTime(OcsOcsTimeDomain ocsOcsTimeDomain, OcsOcsTime ocsOcsTime) {
        if (null == ocsOcsTimeDomain) {
            return null;
        }
        if (null == ocsOcsTime) {
            ocsOcsTime = new OcsOcsTime();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsTime, (Object)ocsOcsTimeDomain);
            return ocsOcsTime;
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
            return null;
        }
    }

    private OcsOcsTimeReDomain makeOcsOcsTimeReDomain(OcsOcsTime ocsOcsTime) {
        if (null == ocsOcsTime) {
            return null;
        }
        OcsOcsTimeReDomain ocsOcsTimeReDomain = new OcsOcsTimeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsTimeReDomain, (Object)ocsOcsTime);
            return ocsOcsTimeReDomain;
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTimeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcsOcsTime> queryOcsOcsTimeModelPage(Map<String, Object> parammap) {
        try {
            return this.ocsOcsTimeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..queryOcsOcsTimeModel", (Throwable)e);
            return null;
        }
    }

    private int countOcsOcsTime(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocsOcsTimeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..countOcsOcsTime", (Throwable)e);
        }
        return i;
    }

    private OcsOcsTime createOcsOcsTime(OcsOcsTimeDomain ocsOcsTimeDomain) {
        String msg = this.checkOcsOcsTime(ocsOcsTimeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..saveOcsOcsTime.checkOcsOcsTime", msg);
        }
        OcsOcsTime ocsOcsTime = this.makeOcsOcsTime(ocsOcsTimeDomain, null);
        this.setOcsOcsTimeDefault(ocsOcsTime);
        return ocsOcsTime;
    }

    @Override
    public String saveOcsOcsTime(OcsOcsTimeDomain ocsOcsTimeDomain) throws ApiException {
        OcsOcsTime ocsOcsTime = this.createOcsOcsTime(ocsOcsTimeDomain);
        this.saveOcsOcsTimeModel(ocsOcsTime);
        return ocsOcsTime.getOcstimeCode();
    }

    @Override
    public String saveOcsOcsTimeBatch(List<OcsOcsTimeDomain> ocsOcsTimeDomainList) throws ApiException {
        if (null == ocsOcsTimeDomainList || ocsOcsTimeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcsOcsTime> ocsOcsTimeList = new ArrayList<OcsOcsTime>();
        String code = "";
        for (OcsOcsTimeDomain ocsOcsTimeDomain : ocsOcsTimeDomainList) {
            OcsOcsTime ocsOcsTime = this.createOcsOcsTime(ocsOcsTimeDomain);
            code = ocsOcsTime.getOcstimeCode();
            ocsOcsTimeList.add(ocsOcsTime);
        }
        this.saveOcsOcsTimeBatchModel(ocsOcsTimeList);
        return code;
    }

    @Override
    public void updateOcsOcsTimeState(Integer ocstimeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ocstimeId) {
            return;
        }
        this.updateStateOcsOcsTimeModel(ocstimeId, dataState, oldDataState, map);
    }

    @Override
    public void updateOcsOcsTimeStateByCode(String tenantCode, String ocstimeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ocstimeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOcsOcsTimeModelByCode(tenantCode, ocstimeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOcsOcsTime(OcsOcsTimeDomain ocsOcsTimeDomain) throws ApiException {
        String msg = this.checkOcsOcsTime(ocsOcsTimeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateOcsOcsTime.checkOcsOcsTime", msg);
        }
        OcsOcsTime oldOcsOcsTime = this.getOcsOcsTimeModelById(ocsOcsTimeDomain.getOcstimeId());
        if (null == oldOcsOcsTime) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl..updateOcsOcsTime.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcsOcsTime ocsOcsTime = this.makeOcsOcsTime(ocsOcsTimeDomain, oldOcsOcsTime);
        this.setOcsOcsTimeUpdataDefault(ocsOcsTime);
        this.updateOcsOcsTimeModel(ocsOcsTime);
    }

    @Override
    public OcsOcsTime getOcsOcsTime(Integer ocstimeId) {
        if (null == ocstimeId) {
            return null;
        }
        return this.getOcsOcsTimeModelById(ocstimeId);
    }

    @Override
    public void deleteOcsOcsTime(Integer ocstimeId) throws ApiException {
        if (null == ocstimeId) {
            return;
        }
        this.deleteOcsOcsTimeModel(ocstimeId);
    }

    @Override
    public QueryResult<OcsOcsTime> queryOcsOcsTimePage(Map<String, Object> map) {
        List<OcsOcsTime> ocsOcsTimeList = this.queryOcsOcsTimeModelPage(map);
        for (OcsOcsTime ocsOcsTime : ocsOcsTimeList) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("tenantCode", map.get("tenantCode"));
            temp.put("ocstimeCode", ocsOcsTime.getOcstimeCode());
            ocsOcsTime.setOcsOcsTimeIts(this.ocsOcsTimeItService.queryOcsOcsTimeItModelPage(temp));
            ocsOcsTime.setOcsOcsTimeScs(this.ocsOcsTimeScService.queryOcsOcsTimeScModelPage(temp));
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOcsOcsTime(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocsOcsTimeList);
        return queryResult;
    }

    @Override
    public OcsOcsTime getOcsOcsTimeByCode(String tenantCode, String ocstimeCode) throws ApiException {
        if (StringUtils.isBlank((String)ocstimeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ocstimeCode", ocstimeCode);
        return this.getOcsOcsTimeModelByCode(map);
    }

    @Override
    public void deleteOcsOcsTimeByCode(String tenantCode, String ocstimeCode) throws ApiException {
        if (StringUtils.isBlank((String)ocstimeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ocstimeCode", ocstimeCode);
        this.delOcsOcsTimeModelByCode(map);
        this.ocsOcsTimeItService.deleteOcsOcsTimeItByCode(tenantCode, ocstimeCode);
        this.ocsOcsTimeScService.deleteOcsOcsTimeScByCode(tenantCode, ocstimeCode);
    }

    public void saveOcsOcsTimeByRule(OcsOcsTimeDto ocsOcsTimeDto) {
        if (null == ocsOcsTimeDto) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveOcsOcsTimeByRule", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeScTyppe())) {
            this.saveDefaultRule(ocsOcsTimeDto);
        }
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeScTyppe())) {
            this.saveRuleByOcstimeItType(ocsOcsTimeDto);
        }
        if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeScTyppe())) {
            this.saveRuleByOcstimeScTyppe(ocsOcsTimeDto);
        }
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeScTyppe())) {
            this.saveRuleByOcstimeItType(ocsOcsTimeDto);
        }
    }

    private void saveDefaultRule(OcsOcsTimeDto ocsOcsTimeDto) {
        if (null == ocsOcsTimeDto) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveDefaultRule", "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcsOcsTimeDomain ocsOcsTimeDomain = new OcsOcsTimeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsTimeDomain, (Object)ocsOcsTimeDto);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
        }
        this.saveOcsOcsTime(ocsOcsTimeDomain);
    }

    private void saveRuleByOcstimeItType(OcsOcsTimeDto ocsOcsTimeDto) {
        if (null == ocsOcsTimeDto) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveRuleByOcstimeItType", "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcsOcsTimeDomain ocsOcsTimeDomain = new OcsOcsTimeDomain();
        OcsOcsTimeItDomain ocsOcsTimeItDomain = new OcsOcsTimeItDomain();
        OcsOcsTimeScDomain ocsOcsTimeScDomain = new OcsOcsTimeScDomain();
        if (ocsOcsTimeDto.getOcstimeItType().equals("week")) {
            if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItValue())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveRuleByOcstimeItType", "OcstimeItValue\u4e3a\u7a7a");
            }
            try {
                BeanUtils.copyAllPropertys((Object)ocsOcsTimeDomain, (Object)ocsOcsTimeDto);
            }
            catch (Exception e) {
                this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
            }
            ocsOcsTimeDomain.setChannelStartt(null);
            ocsOcsTimeDomain.setChannelEndt(null);
            String ocsOcsTimeCode = this.saveOcsOcsTime(ocsOcsTimeDomain);
            try {
                BeanUtils.copyAllPropertys((Object)ocsOcsTimeItDomain, (Object)ocsOcsTimeDto);
            }
            catch (Exception e) {
                this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
            }
            ocsOcsTimeItDomain.setOcstimeItStart(ocsOcsTimeDto.getChannelStartt());
            ocsOcsTimeItDomain.setOcstimeItEnd(ocsOcsTimeDto.getChannelEndt());
            ocsOcsTimeItDomain.setOcstimeCode(ocsOcsTimeCode);
            this.ocsOcsTimeItService.saveOcsOcsTimeIt(ocsOcsTimeItDomain);
            if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeScTyppe())) {
                try {
                    BeanUtils.copyAllPropertys((Object)ocsOcsTimeScDomain, (Object)ocsOcsTimeDto);
                }
                catch (Exception e) {
                    this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
                }
                ocsOcsTimeScDomain.setOcstimeCode(ocsOcsTimeCode);
                this.ocsOcsTimeScService.saveOcsOcsTimeSc(ocsOcsTimeScDomain);
            }
        } else {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveRuleByOcstimeItType", "\u672a\u6307\u5b9a\u7684\u5b58\u50a8\u89c4\u5219");
        }
    }

    private void saveRuleByOcstimeScTyppe(OcsOcsTimeDto ocsOcsTimeDto) {
        if (null == ocsOcsTimeDto) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveRuleByOcstimeItType", "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcsOcsTimeDomain ocsOcsTimeDomain = new OcsOcsTimeDomain();
        OcsOcsTimeScDomain ocsOcsTimeScDomain = new OcsOcsTimeScDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsTimeDomain, (Object)ocsOcsTimeDto);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
        }
        String ocsOcsTimeCode = this.saveOcsOcsTime(ocsOcsTimeDomain);
        try {
            BeanUtils.copyAllPropertys((Object)ocsOcsTimeScDomain, (Object)ocsOcsTimeDto);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..makeOcsOcsTime", (Throwable)e);
        }
        ocsOcsTimeScDomain.setOcstimeCode(ocsOcsTimeCode);
        this.ocsOcsTimeScService.saveOcsOcsTimeSc(ocsOcsTimeScDomain);
    }

    public String getServiceState(Map<String, Object> map) {
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.getServiceState", "tenantCode\u4e3a\u7a7a");
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        OcsOcsTimeDto ocsOcsTimeDto = this.getServiceStateByName(map);
        String sysDateStr = df.format(this.getSysDate());
        if (null == ocsOcsTimeDto) {
            return "true";
        }
        if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItType())) {
            boolean result = this.getResultByType(ocsOcsTimeDto.getChannelStartt(), ocsOcsTimeDto.getChannelEndt(), ocsOcsTimeDto.getChannelSort());
            if (!result) {
                return this.getServiceMsg(ocsOcsTimeDto);
            }
            return String.valueOf(result);
        }
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItType()) && "week".equals(ocsOcsTimeDto.getOcstimeItType())) {
            Calendar now = Calendar.getInstance();
            String week = this.getWeek(now.get(1), now.get(2) + 1, now.get(5));
            if (ocsOcsTimeDto.getOcstimeItValue().indexOf(week) == -1 && "1".equals(ocsOcsTimeDto.getChannelSort())) {
                return "true";
            }
            if (ocsOcsTimeDto.getOcstimeItValue().indexOf(week) == -1 && "0".equals(ocsOcsTimeDto.getChannelSort())) {
                return this.getServiceMsg(ocsOcsTimeDto);
            }
            if (ocsOcsTimeDto.getOcstimeItValue().indexOf(week) != -1) {
                boolean result = this.getResultByType(ocsOcsTimeDto.getOcstimeItStart(), ocsOcsTimeDto.getOcstimeItEnd(), ocsOcsTimeDto.getChannelSort());
                if (!result) {
                    return this.getServiceMsg(ocsOcsTimeDto);
                }
                return String.valueOf(result);
            }
        }
        throw new ApiException("ocs.OcsOcsTimeServiceImpl.getServiceState", "\u672a\u80fd\u5339\u914d");
    }

    private String getServiceMsg(OcsOcsTimeDto ocsOcsTimeDto) {
        String normal = "";
        String type = "";
        String start = "";
        String end = "";
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getChannelSort()) && "1".equals(ocsOcsTimeDto.getChannelSort())) {
            normal = "\u9664\u4e86";
        }
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItType()) && "week".equals(ocsOcsTimeDto.getOcstimeItType())) {
            type = "\u6bcf\u5468" + ocsOcsTimeDto.getOcstimeItValue() + "\u7684";
        }
        if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItType())) {
            type = "\u6bcf\u5929";
        }
        if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isNotBlank((String)ocsOcsTimeDto.getChannelStartt())) {
            start = ocsOcsTimeDto.getChannelStartt();
        }
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItStart())) {
            start = ocsOcsTimeDto.getOcstimeItStart();
        }
        if (StringUtils.isBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isNotBlank((String)ocsOcsTimeDto.getChannelEndt())) {
            end = ocsOcsTimeDto.getChannelEndt();
        }
        if (StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItType()) && StringUtils.isNotBlank((String)ocsOcsTimeDto.getOcstimeItEnd())) {
            end = ocsOcsTimeDto.getOcstimeItEnd();
        }
        return "\u8be5\u670d\u52a1\u7684\u751f\u6548\u65f6\u95f4\u6bb5\u4e3a" + normal + type + start + "\u5230" + end;
    }

    private boolean getResultByType(String start, String end, String sort) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        String sysDateStr = df.format(this.getSysDate());
        if ("0".equals(sort)) {
            try {
                Boolean result = this.isEffectiveDate(df.parse(sysDateStr), df.parse(start), df.parse(end));
                return result;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if ("1".equals(sort)) {
            try {
                Boolean result = this.isEffectiveDate(df.parse(sysDateStr), df.parse(start), df.parse(end));
                return result == false;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        throw new ApiException("ocs.OcsOcsTimeServiceImpl.getResultByType", "ChannelSort\u53ea\u80fd\u4e3a0\u62161,\u5f53\u524dChannelSort\u4e3a:" + sort);
    }

    private String getWeek(Integer y, Integer m, Integer d) {
        if (m < 3) {
            m = m + 12;
            y = y - 1;
        }
        Integer w = (d + 1 + 2 * m + 3 * (m + 1) / 5 + y + (y >> 2) - y / 100 + y / 400) % 7;
        return String.valueOf(w);
    }

    private boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    private OcsOcsTimeDto getServiceStateByName(Map<String, Object> map) {
        if (null == map || MapUtil.isEmpty(map)) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.getServiceStateByName", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            OcsOcsTimeDto ocsOcsTimeDto = this.ocsOcsTimeMapper.getServiceStateByName(map);
            return ocsOcsTimeDto;
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..getServiceStateByName", (Throwable)e);
            return null;
        }
    }

    private boolean checkOverlap(List<OcsOcsTimeItDomain> ocsOcsTimeItDomains) {
        if (null == ocsOcsTimeItDomains) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.checkOverlap", "ocsOcsTimeItDomains\u4e3a\u7a7a");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (OcsOcsTimeItDomain ocsOcsTimeItDomain : ocsOcsTimeItDomains) {
            if (StringUtils.isBlank((String)ocsOcsTimeItDomain.getOcstimeItStart()) || StringUtils.isBlank((String)ocsOcsTimeItDomain.getOcstimeItEnd())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveProgramme", "\u6bcf\u5929\u591a\u4e2a\u65f6\u95f4\u6bb5:\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u672a\u8bbe\u7f6e");
            }
            if (!DateUtils.compare2(ocsOcsTimeItDomain.getOcstimeItStart(), ocsOcsTimeItDomain.getOcstimeItEnd())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveProgramme", "\u5f00\u59cb\u65f6\u95f4\u4e0d\u5f97\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
            list.add(ocsOcsTimeItDomain.getOcstimeItStart() + "-" + ocsOcsTimeItDomain.getOcstimeItEnd());
        }
        return DateUtils.checkOverlap(list);
    }

    private void checkSc(List<OcsOcsTimeScDomain> ocsOcsTimeScDomains) {
        if (null == ocsOcsTimeScDomains) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.checkSc", "ocsOcsTimeScDomains\u4e3a\u7a7a");
        }
        for (OcsOcsTimeScDomain ocsOcsTimeScDomain : ocsOcsTimeScDomains) {
            if (StringUtils.isBlank((String)ocsOcsTimeScDomain.getOcstimeScTyppe())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.checkSc", "OcstimeScTyppe\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)ocsOcsTimeScDomain.getOcstimeScValue())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.checkSc", "OcstimeScValue\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((String)ocsOcsTimeScDomain.getOcstimeScName())) continue;
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.checkSc", "OcstimeScName\u4e3a\u7a7a");
        }
    }

    private boolean checkRepeat(OcsOcsTimeDomain ocsOcsTimeDomain) {
        List<OcsOcsTime> ocsOcsTimes;
        List<OcsOcsTimeScDomain> ocsOcsTimeScDomains;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean memberCode = false;
        map.put("tenantCode", ocsOcsTimeDomain.getTenantCode());
        if (StringUtils.isNotBlank((String)ocsOcsTimeDomain.getMemberCode())) {
            map.put("memberCode", ocsOcsTimeDomain.getMemberCode());
            memberCode = true;
        }
        if (ListUtil.isNotEmpty(ocsOcsTimeScDomains = ocsOcsTimeDomain.getOcsOcsTimeScDomains())) {
            for (OcsOcsTimeScDomain ocsOcsTimeScDomain : ocsOcsTimeScDomains) {
                map.put("ocstimeScTyppe", ocsOcsTimeScDomain.getOcstimeScTyppe());
            }
        }
        if (ListUtil.isEmpty(ocsOcsTimes = this.queryOcsOcsTimeModelPage(map))) {
            return true;
        }
        if (memberCode) {
            for (OcsOcsTime ocsOcsTime : ocsOcsTimes) {
                if (!StringUtils.isBlank((String)ocsOcsTime.getMemberCode())) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public void saveServiceByRule(OcsOcsTimeDomain ocsOcsTimeDomain) {
        String ocsOcsTimeCode;
        if (null == ocsOcsTimeDomain) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveProgramme", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!this.checkRepeat(ocsOcsTimeDomain)) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveServiceByRule", "\u5df2\u7ecf\u6709\u8be5\u89c4\u5219,\u8bf7\u76f4\u63a5\u4fee\u6539");
        }
        List<OcsOcsTimeItDomain> ocsOcsTimeItDomains = ocsOcsTimeDomain.getOcsOcsTimeItDomains();
        List<OcsOcsTimeScDomain> ocsOcsTimeScDomains = ocsOcsTimeDomain.getOcsOcsTimeScDomains();
        if (null == ocsOcsTimeItDomains) {
            if (StringUtils.isBlank((String)ocsOcsTimeDomain.getChannelStartt()) || StringUtils.isBlank((String)ocsOcsTimeDomain.getChannelEndt())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveProgramme", "\u6bcf\u5929\u4e00\u4e2a\u65f6\u95f4\u6bb5:\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u672a\u8bbe\u7f6e");
            }
            if (!DateUtils.compare2(ocsOcsTimeDomain.getChannelStartt(), ocsOcsTimeDomain.getChannelEndt())) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveProgramme", "\u5f00\u59cb\u65f6\u95f4\u4e0d\u5f97\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
            ocsOcsTimeCode = this.saveOcsOcsTime(ocsOcsTimeDomain);
            if (null != ocsOcsTimeScDomains) {
                this.checkSc(ocsOcsTimeScDomains);
                for (OcsOcsTimeScDomain ocsOcsTimeScDomain : ocsOcsTimeScDomains) {
                    ocsOcsTimeScDomain.setTenantCode(ocsOcsTimeDomain.getTenantCode());
                    ocsOcsTimeScDomain.setOcstimeCode(ocsOcsTimeCode);
                    this.ocsOcsTimeScService.saveOcsOcsTimeSc(ocsOcsTimeScDomain);
                }
            }
        }
        if (null != ocsOcsTimeItDomains) {
            ocsOcsTimeDomain.setChannelStartt(null);
            ocsOcsTimeDomain.setChannelEndt(null);
            ocsOcsTimeCode = this.saveOcsOcsTime(ocsOcsTimeDomain);
            boolean everyday = false;
            if (this.checkOverlap(ocsOcsTimeItDomains)) {
                throw new ApiException("ocs.OcsOcsTimeServiceImpl.saveProgramme", "\u591a\u4e2a\u65f6\u95f4\u6bb5\u5b58\u5728\u51b2\u7a81");
            }
            for (int i = 0; i < ocsOcsTimeItDomains.size(); ++i) {
                ocsOcsTimeItDomains.get(i).setTenantCode(ocsOcsTimeDomain.getTenantCode());
                ocsOcsTimeItDomains.get(i).setOcstimeItSort(ocsOcsTimeDomain.getChannelSort());
                if (StringUtils.isNotBlank((String)ocsOcsTimeItDomains.get(i).getOcstimeItType()) && "everyday".equals(ocsOcsTimeItDomains.get(i).getOcstimeItType())) {
                    everyday = true;
                    ocsOcsTimeItDomains.get(i).setOcstimeCode(ocsOcsTimeCode);
                    this.ocsOcsTimeItService.saveOcsOcsTimeIt(ocsOcsTimeItDomains.get(i));
                }
                if (!StringUtils.isNotBlank((String)ocsOcsTimeItDomains.get(i).getOcstimeItType()) || !"week".equals(ocsOcsTimeItDomains.get(i).getOcstimeItType())) continue;
                everyday = true;
                ocsOcsTimeItDomains.get(i).setOcstimeCode(ocsOcsTimeCode);
                this.ocsOcsTimeItService.saveOcsOcsTimeIt(ocsOcsTimeItDomains.get(i));
            }
            if (null != ocsOcsTimeScDomains && everyday) {
                this.checkSc(ocsOcsTimeScDomains);
                for (OcsOcsTimeScDomain ocsOcsTimeScDomain : ocsOcsTimeScDomains) {
                    ocsOcsTimeScDomain.setTenantCode(ocsOcsTimeDomain.getTenantCode());
                    ocsOcsTimeScDomain.setOcstimeCode(ocsOcsTimeCode);
                    this.ocsOcsTimeScService.saveOcsOcsTimeSc(ocsOcsTimeScDomain);
                }
            }
        }
    }

    @Override
    public String getServiceStateNew(Map<String, Object> map) {
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.getServiceState", "tenantCode\u4e3a\u7a7a");
        }
        OcsOcsTime userScOcsOcsTime = this.getOcsOcsTimeByMap(map);
        if (null == userScOcsOcsTime) {
            OcsOcsTime userOcsOcsTime = new OcsOcsTime();
            HashMap<String, Object> userScMap = new HashMap<String, Object>();
            userScMap.put("tenantCode", map.get("tenantCode"));
            userScMap.put("memberCode", map.get("memberCode"));
            List<OcsOcsTime> ocsOcsTimes1 = this.queryOcsOcsTimeModelPage(userScMap);
            for (OcsOcsTime ocsOcsTime : ocsOcsTimes1) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("tenantCode", ocsOcsTime.getTenantCode());
                temp.put("ocstimeCode", ocsOcsTime.getOcstimeCode());
                List<OcsOcsTimeSc> ocsOcsTimeScs = this.ocsOcsTimeScService.queryOcsOcsTimeScModelPage(temp);
                if (!ListUtil.isEmpty(ocsOcsTimeScs)) continue;
                HashMap<String, Object> temp1 = new HashMap<String, Object>();
                temp1.put("tenantCode", ocsOcsTime.getTenantCode());
                temp1.put("ocstimeCode", ocsOcsTime.getOcstimeCode());
                userOcsOcsTime = ocsOcsTime;
                userOcsOcsTime.setOcsOcsTimeIts(this.ocsOcsTimeItService.queryOcsOcsTimeItModelPage(temp1));
            }
            if (StringUtils.isBlank((String)userOcsOcsTime.getChannelSort())) {
                HashMap<String, Object> serviceMap = new HashMap<String, Object>();
                serviceMap.put("tenantCode", map.get("tenantCode"));
                serviceMap.put("ocstimeScTyppe", map.get("ocstimeScTyppe"));
                OcsOcsTime serviceOcsOcsTime = this.getOcsOcsTimeByMap(serviceMap);
                if (null == serviceOcsOcsTime) {
                    HashMap<String, Object> baseMap = new HashMap<String, Object>();
                    baseMap.put("tenantCode", map.get("tenantCode"));
                    List<OcsOcsTime> ocsOcsTimes = this.queryOcsOcsTimeModelPage(baseMap);
                    for (OcsOcsTime ocsOcsTime : ocsOcsTimes) {
                        if (!StringUtils.isBlank((String)ocsOcsTime.getMemberCode())) continue;
                        HashMap<String, Object> itMap = new HashMap<String, Object>();
                        itMap.put("ocstimeCode", ocsOcsTime.getOcstimeCode());
                        List<OcsOcsTimeIt> ocsOcsTimeIts = this.ocsOcsTimeItService.queryOcsOcsTimeItModelPage(itMap);
                        if (ListUtil.isEmpty(ocsOcsTimeIts)) {
                            boolean result = this.getResultByType(ocsOcsTime.getChannelStartt(), ocsOcsTime.getChannelEndt(), ocsOcsTime.getChannelSort());
                            if (result) {
                                return "true";
                            }
                            return this.getServiceMsgNew(ocsOcsTime);
                        }
                        ocsOcsTime.setOcsOcsTimeIts(ocsOcsTimeIts);
                        return this.checkIts(ocsOcsTimeIts, ocsOcsTime);
                    }
                    return "true";
                }
                List<OcsOcsTimeIt> ocsOcsTimeIts = serviceOcsOcsTime.getOcsOcsTimeIts();
                if (ListUtil.isEmpty(ocsOcsTimeIts)) {
                    boolean result = this.getResultByType(serviceOcsOcsTime.getChannelStartt(), serviceOcsOcsTime.getChannelEndt(), serviceOcsOcsTime.getChannelSort());
                    if (result) {
                        return "true";
                    }
                    return this.getServiceMsgNew(serviceOcsOcsTime);
                }
                return this.checkIts(ocsOcsTimeIts, serviceOcsOcsTime);
            }
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)userOcsOcsTime));
            List<OcsOcsTimeIt> ocsOcsTimeIts = userOcsOcsTime.getOcsOcsTimeIts();
            if (ListUtil.isEmpty(ocsOcsTimeIts)) {
                boolean result = this.getResultByType(userOcsOcsTime.getChannelStartt(), userOcsOcsTime.getChannelEndt(), userOcsOcsTime.getChannelSort());
                if (result) {
                    return "true";
                }
                return this.getServiceMsgNew(userOcsOcsTime);
            }
            return this.checkIts(ocsOcsTimeIts, userOcsOcsTime);
        }
        List<OcsOcsTimeIt> ocsOcsTimeIts = userScOcsOcsTime.getOcsOcsTimeIts();
        if (ListUtil.isEmpty(ocsOcsTimeIts)) {
            boolean result = this.getResultByType(userScOcsOcsTime.getChannelStartt(), userScOcsOcsTime.getChannelEndt(), userScOcsOcsTime.getChannelSort());
            if (result) {
                return "true";
            }
            return this.getServiceMsgNew(userScOcsOcsTime);
        }
        return this.checkIts(ocsOcsTimeIts, userScOcsOcsTime);
    }

    private String checkIts(List<OcsOcsTimeIt> ocsOcsTimeIts, OcsOcsTime ocsOcsTime) {
        Integer i = 0;
        for (OcsOcsTimeIt ocsOcsTimeIt : ocsOcsTimeIts) {
            if ("0".equals(ocsOcsTimeIt.getOcstimeItSort()) && this.checkIt(ocsOcsTimeIt)) {
                return "true";
            }
            if (!"1".equals(ocsOcsTimeIt.getOcstimeItSort()) || !this.checkIt(ocsOcsTimeIt)) continue;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (i.intValue() == ocsOcsTimeIts.size()) {
            return "true";
        }
        return this.getServiceMsgNew(ocsOcsTime);
    }

    private OcsOcsTime getOcsOcsTimeByMap(Map<String, Object> parammap) {
        try {
            return this.ocsOcsTimeMapper.getServiceStateNewByName(parammap);
        }
        catch (Exception e) {
            this.logger.error("ocs.OcsOcsTimeServiceImpl..queryone", (Throwable)e);
            return null;
        }
    }

    private boolean checkIt(OcsOcsTimeIt ocsOcsTimeIt) {
        if ("everyday".equals(ocsOcsTimeIt.getOcstimeItType())) {
            boolean result = this.getResultByType(ocsOcsTimeIt.getOcstimeItStart(), ocsOcsTimeIt.getOcstimeItEnd(), ocsOcsTimeIt.getOcstimeItSort());
            return result;
        }
        if ("week".equals(ocsOcsTimeIt.getOcstimeItType())) {
            Calendar now = Calendar.getInstance();
            String week = this.getWeek(now.get(1), now.get(2) + 1, now.get(5));
            if (ocsOcsTimeIt.getOcstimeItValue().indexOf(week) == -1 && "1".equals(ocsOcsTimeIt.getOcstimeItSort())) {
                return true;
            }
            if (ocsOcsTimeIt.getOcstimeItValue().indexOf(week) == -1 && "0".equals(ocsOcsTimeIt.getOcstimeItSort())) {
                return false;
            }
            if (ocsOcsTimeIt.getOcstimeItValue().indexOf(week) != -1) {
                boolean result = this.getResultByType(ocsOcsTimeIt.getOcstimeItStart(), ocsOcsTimeIt.getOcstimeItEnd(), ocsOcsTimeIt.getOcstimeItSort());
                if (!result) {
                    return false;
                }
                return result;
            }
        }
        throw new ApiException("ocs.OcsOcsTimeServiceImpl.checkIt", "\u672a\u80fd\u5339\u914d\u7684\u7c7b\u578b:" + ocsOcsTimeIt.getOcstimeItType());
    }

    private String getServiceMsgNew(OcsOcsTime ocsOcsTime) {
        if (null == ocsOcsTime) {
            throw new ApiException("ocs.OcsOcsTimeServiceImpl.getServiceMsgNew", "ocsOcsTime\u4e3a\u7a7a");
        }
        List<OcsOcsTimeIt> ocsOcsTimeIts = ocsOcsTime.getOcsOcsTimeIts();
        String normal = "";
        String type = "";
        ArrayList<String> time = new ArrayList<String>();
        if ("1".equals(ocsOcsTime.getChannelSort())) {
            normal = "\u9664\u4e86";
        }
        if (ListUtil.isEmpty(ocsOcsTimeIts)) {
            type = "\u6bcf\u5929";
            time.add(ocsOcsTime.getChannelStartt() + "\u5230" + ocsOcsTime.getChannelEndt() + " ,");
        }
        if (ListUtil.isNotEmpty(ocsOcsTimeIts)) {
            for (OcsOcsTimeIt ocsOcsTimeIt : ocsOcsTimeIts) {
                if ("everyday".equals(ocsOcsTimeIt.getOcstimeItType())) {
                    type = "\u6bcf\u5929";
                    time.add(ocsOcsTimeIt.getOcstimeItStart() + "\u5230" + ocsOcsTimeIt.getOcstimeItEnd() + ",");
                }
                if (!"week".equals(ocsOcsTimeIt.getOcstimeItType())) continue;
                type = "\u6bcf\u5468" + ocsOcsTimeIt.getOcstimeItValue();
                time.add(ocsOcsTimeIt.getOcstimeItStart() + "\u5230" + ocsOcsTimeIt.getOcstimeItEnd() + ",");
            }
        }
        String result = "\u8be5\u670d\u52a1\u7684\u751f\u6548\u65f6\u95f4\u6bb5\u4e3a" + normal + type + "\u7684";
        for (String s : time) {
            result = result + s;
        }
        return result;
    }

    @Override
    public void updateOcsTime(OcsOcsTimeDomain ocsOcsTimeDomain) {
        this.deleteOcsOcsTimeByCode(ocsOcsTimeDomain.getTenantCode(), ocsOcsTimeDomain.getOcstimeCode());
        this.saveServiceByRule(ocsOcsTimeDomain);
    }
}

