/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgCompanyMapper;
import com.yqbsoft.laser.service.organize.domain.OrgCompanyDomain;
import com.yqbsoft.laser.service.organize.domain.OrgCompanyReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.organize.model.OrgCompany;
import com.yqbsoft.laser.service.organize.service.OrgCompanyService;
import com.yqbsoft.laser.service.organize.service.OrgEmployeeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrgCompanyServiceImpl
extends BaseServiceImpl
implements OrgCompanyService {
    private static final String SYS_CODE = "org.OrgCompanyServiceImpl";
    private OrgCompanyMapper orgCompanyMapper;
    private OrgEmployeeService orgEmployeeService;
    private String cachekeydomain = "OrgCompany-companyCode";
    private String cachetreekeydomain = "OrgCompany-companyPcode";
    private String cacheallkeydomain = "OrgCompany-all";

    public void setOrgEmployeeService(OrgEmployeeService orgEmployeeService) {
        this.orgEmployeeService = orgEmployeeService;
    }

    public void setOrgCompanyMapper(OrgCompanyMapper orgCompanyMapper) {
        this.orgCompanyMapper = orgCompanyMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgCompanyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCompany(OrgCompanyDomain orgCompanyDomain) {
        if (null == orgCompanyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgCompanyDomain.getCompanyName())) {
            msg = msg + "CompanyName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgCompanyDomain.getUserinfoCode())) {
            msg = msg + "UserinfoCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgCompanyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCompanyDefault(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return;
        }
        if (null == orgCompany.getDataState()) {
            orgCompany.setDataState(0);
        }
        if (null == orgCompany.getGmtCreate()) {
            orgCompany.setGmtCreate(this.getSysDate());
        }
        orgCompany.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)orgCompany.getCompanyCode())) {
            orgCompany.setCompanyCode(this.createUUIDString());
        }
    }

    private int getCompanyMaxCode() {
        int code = 0;
        try {
            return this.orgCompanyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCompanyUpdataDefault(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return;
        }
        orgCompany.setGmtModified(this.getSysDate());
    }

    private void saveCompanyModel(OrgCompany orgCompany) throws ApiException {
        if (null == orgCompany) {
            return;
        }
        try {
            this.orgCompanyMapper.insert(orgCompany);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.saveCompanyModel.ex", (Throwable)e);
        }
    }

    private void saveCompanyBatchModel(List<OrgCompany> orgCompanyList) throws ApiException {
        if (null == orgCompanyList || orgCompanyList.isEmpty()) {
            return;
        }
        try {
            this.orgCompanyMapper.insertBatch(orgCompanyList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.saveCompanyBatchModel.ex", (Throwable)e);
        }
    }

    private OrgCompany getCompanyModelById(Integer companyId) {
        if (null == companyId) {
            return null;
        }
        try {
            return this.orgCompanyMapper.selectByPrimaryKey(companyId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyModelById", (Throwable)e);
            return null;
        }
    }

    private OrgCompany getCompanyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgCompanyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyModelByCode", (Throwable)e);
            return null;
        }
    }

    private OrgCompany getCompanyModelByName(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgCompanyMapper.getByName(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.getCompanyModelByName", (Throwable)e);
            return null;
        }
    }

    private void delCompanyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgCompanyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.delCompanyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgCompanyServiceImpl.delCompanyModelByCode.num");
        }
    }

    private void deleteCompanyModel(Integer companyId) throws ApiException {
        if (null == companyId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgCompanyMapper.deleteByPrimaryKey(companyId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompanyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompanyModel.num");
        }
    }

    private void updateCompanyModel(OrgCompany orgCompany) throws ApiException {
        if (null == orgCompany) {
            return;
        }
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateByPrimaryKeySelective(orgCompany);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyModel.num");
        }
    }

    private void updateStateCompanyModel(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == companyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", companyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModel.null");
        }
    }

    private void updateStateCompanyModelByCode(String tenantCode, String companyCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)companyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgCompanyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateStateCompanyModelByCode.null");
        }
    }

    private OrgCompany makeCompany(OrgCompanyDomain orgCompanyDomain, OrgCompany orgCompany) {
        if (null == orgCompanyDomain) {
            return null;
        }
        if (null == orgCompany) {
            orgCompany = new OrgCompany();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgCompany, (Object)orgCompanyDomain);
            return orgCompany;
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.makeCompany", (Throwable)e);
            return null;
        }
    }

    private OrgCompanyReDomain makeOrgCompanyReDomain(OrgCompany orgCompany) {
        if (null == orgCompany) {
            return null;
        }
        OrgCompanyReDomain orgCompanyReDomain = new OrgCompanyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgCompanyReDomain, (Object)orgCompany);
            return orgCompanyReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.makeOrgCompanyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgCompany> queryCompanyModelPage(Map<String, Object> parammap) {
        try {
            return this.orgCompanyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.queryCompanyModel", (Throwable)e);
            return null;
        }
    }

    private int countCompany(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgCompanyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgCompanyServiceImpl.countCompany", (Throwable)e);
        }
        return i;
    }

    private OrgCompany createOrgCompany(OrgCompanyDomain orgCompanyDomain) {
        String msg = this.checkCompany(orgCompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgCompanyServiceImpl.saveCompany.checkCompany", msg);
        }
        OrgCompany orgCompany = this.makeCompany(orgCompanyDomain, null);
        this.setCompanyDefault(orgCompany);
        return orgCompany;
    }

    @Override
    public String saveCompany(OrgCompanyDomain orgCompanyDomain) throws ApiException {
        OrgCompany orgCompany = this.createOrgCompany(orgCompanyDomain);
        this.saveCompanyModel(orgCompany);
        this.saveEmployeeBatch(orgCompany, orgCompanyDomain.getOrgEmployeeDomainList());
        if (StringUtils.isNotBlank((String)orgCompany.getUserinfoCode())) {
            DisUtil.setMap((String)this.cachekeydomain, (String)(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()), (String)orgCompany.getUserinfoCode());
        }
        if (StringUtils.isNotBlank((String)orgCompany.getCompanyPcode())) {
            DisUtil.setMap((String)this.cachetreekeydomain, (String)(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()), (String)orgCompany.getCompanyPcode());
        }
        DisUtil.setMap((String)this.cacheallkeydomain, (String)(orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)orgCompany));
        return orgCompany.getCompanyCode();
    }

    private void saveEmployeeBatch(OrgCompany orgCompany, List<OrgEmployeeDomain> orgEmployeeDomainList) {
        if (null == orgCompany || null == orgEmployeeDomainList || orgEmployeeDomainList.isEmpty()) {
            return;
        }
        for (OrgEmployeeDomain orgEmployeeDomain : orgEmployeeDomainList) {
            orgEmployeeDomain.setCompanyCode(orgCompany.getCompanyCode());
            orgEmployeeDomain.setCompanyShortname(orgCompany.getCompanyShortname());
        }
        this.orgEmployeeService.saveEmployeeBatch(orgEmployeeDomainList);
    }

    @Override
    public String saveCompanyBatch(List<OrgCompanyDomain> orgCompanyDomainList) throws ApiException {
        if (null == orgCompanyDomainList || orgCompanyDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgCompany> orgCompanyList = new ArrayList<OrgCompany>();
        String code = "";
        ArrayList<OrgEmployeeDomain> orgEmployeeDomainList = new ArrayList<OrgEmployeeDomain>();
        for (OrgCompanyDomain orgCompanyDomain : orgCompanyDomainList) {
            OrgCompany orgCompany = this.createOrgCompany(orgCompanyDomain);
            code = orgCompany.getCompanyCode();
            orgCompanyList.add(orgCompany);
            List<OrgEmployeeDomain> compOrgEmployeeDomainList = orgCompanyDomain.getOrgEmployeeDomainList();
            if (null == compOrgEmployeeDomainList || compOrgEmployeeDomainList.isEmpty()) continue;
            for (OrgEmployeeDomain orgEmployeeDomain : compOrgEmployeeDomainList) {
                orgEmployeeDomain.setCompanyCode(orgCompany.getCompanyCode());
                orgEmployeeDomain.setCompanyShortname(orgCompany.getCompanyShortname());
            }
            orgEmployeeDomainList.addAll(compOrgEmployeeDomainList);
        }
        this.saveCompanyBatchModel(orgCompanyList);
        this.orgEmployeeService.saveEmployeeBatch(orgEmployeeDomainList);
        for (OrgCompany orgCompanycache : orgCompanyList) {
            if (StringUtils.isNotBlank((String)orgCompanycache.getUserinfoCode())) {
                DisUtil.setMap((String)this.cachekeydomain, (String)(orgCompanycache.getCompanyCode() + "-" + orgCompanycache.getTenantCode()), (String)orgCompanycache.getUserinfoCode());
            }
            if (StringUtils.isNotBlank((String)orgCompanycache.getCompanyPcode())) {
                DisUtil.setMap((String)this.cachetreekeydomain, (String)(orgCompanycache.getCompanyCode() + "-" + orgCompanycache.getTenantCode()), (String)orgCompanycache.getCompanyPcode());
            }
            DisUtil.setMap((String)this.cacheallkeydomain, (String)(orgCompanycache.getUserinfoCode() + "-" + orgCompanycache.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)orgCompanycache));
        }
        return code;
    }

    @Override
    public void updateCompanyState(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCompanyModel(companyId, dataState, oldDataState);
        if (-1 == dataState) {
            OrgCompany orgCompany = this.getCompany(companyId);
            if (null == orgCompany) {
                throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyState.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
            }
            DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
            DisUtil.delMap((String)this.cachetreekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
            DisUtil.delMap((String)this.cacheallkeydomain, (String[])new String[]{orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()});
        }
    }

    @Override
    public void updateCompanyStateByCode(String tenantCode, String companyCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCompanyModelByCode(tenantCode, companyCode, dataState, oldDataState);
        if (-1 == dataState) {
            OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
            if (null == orgCompany) {
                throw new ApiException("org.OrgCompanyServiceImpl.updateCompanyStateByCode.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
            }
            DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
            DisUtil.delMap((String)this.cachetreekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
            DisUtil.delMap((String)this.cacheallkeydomain, (String[])new String[]{orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()});
        }
    }

    @Override
    public void updateCompany(OrgCompanyDomain orgCompanyDomain) throws ApiException {
        String msg = this.checkCompany(orgCompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompany.checkCompany", msg);
        }
        OrgCompany oldOrgCompany = this.getCompanyModelById(orgCompanyDomain.getCompanyId());
        if (null == oldOrgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.updateCompany.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgCompany orgCompany = this.makeCompany(orgCompanyDomain, oldOrgCompany);
        this.setCompanyUpdataDefault(orgCompany);
        this.updateCompanyModel(orgCompany);
    }

    @Override
    public OrgCompany getCompany(Integer companyId) {
        return this.getCompanyModelById(companyId);
    }

    @Override
    public void deleteCompany(Integer companyId) throws ApiException {
        OrgCompany orgCompany = this.getCompany(companyId);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompany.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteCompanyModel(companyId);
        DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMap((String)this.cachetreekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMap((String)this.cacheallkeydomain, (String[])new String[]{orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()});
    }

    @Override
    public QueryResult<OrgCompany> queryCompanyPage(Map<String, Object> map) {
        List<OrgCompany> orgCompanyList = this.queryCompanyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCompany(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgCompanyList);
        return queryResult;
    }

    @Override
    public OrgCompany getCompanyByCode(String tenantCode, String companyCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        return this.getCompanyModelByCode(map);
    }

    @Override
    public void deleteCompanyByCode(String tenantCode, String companyCode) throws ApiException {
        OrgCompany orgCompany = this.getCompanyByCode(tenantCode, companyCode);
        if (null == orgCompany) {
            throw new ApiException("org.OrgCompanyServiceImpl.deleteCompanyByCode.orgCompany", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        this.delCompanyModelByCode(map);
        DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMap((String)this.cachetreekeydomain, (String[])new String[]{orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode()});
        DisUtil.delMap((String)this.cacheallkeydomain, (String[])new String[]{orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode()});
    }

    @Override
    public void queryCompanyLoadCache() {
        this.logger.info("OrgCompanyService.queryMschannelConfigLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<OrgCompany> companyList = this.queryCompanyModelPage(parammap);
        if (null == companyList || companyList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachetreekeydomain);
            DisUtil.delVer((String)this.cacheallkeydomain);
            this.logger.info("OrgCompanyService.queryMschannelConfigLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> codeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> pcodeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> userMap = new ConcurrentHashMap<String, String>();
        for (OrgCompany orgCompany : companyList) {
            if (StringUtils.isNotBlank((String)orgCompany.getUserinfoCode())) {
                codeMap.put(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode(), orgCompany.getUserinfoCode());
            }
            if (StringUtils.isNotBlank((String)orgCompany.getCompanyPcode())) {
                pcodeMap.put(orgCompany.getCompanyCode() + "-" + orgCompany.getTenantCode(), orgCompany.getCompanyPcode());
            }
            userMap.put(orgCompany.getUserinfoCode() + "-" + orgCompany.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)orgCompany));
        }
        DisUtil.setMapVer((String)this.cachekeydomain, codeMap);
        DisUtil.setMapVer((String)this.cachetreekeydomain, pcodeMap);
        DisUtil.setMapVer((String)this.cacheallkeydomain, userMap);
        this.logger.info("OrgCompanyService.queryMschannelConfigLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public OrgCompany getCompanyByName(String tenantCode, String companyName) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("companyName", companyName);
        return this.getCompanyModelByName(map);
    }
}

