/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgGroupMapper;
import com.yqbsoft.laser.service.organize.dao.OrgGroupempMapper;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendDomain;
import com.yqbsoft.laser.service.organize.domain.OrgGroupDomain;
import com.yqbsoft.laser.service.organize.domain.OrgGroupReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgGroupempDomain;
import com.yqbsoft.laser.service.organize.domain.OrgGroupempReDomain;
import com.yqbsoft.laser.service.organize.model.OrgChannelsend;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.organize.model.OrgGroup;
import com.yqbsoft.laser.service.organize.model.OrgGroupemp;
import com.yqbsoft.laser.service.organize.service.OrgChannelsendService;
import com.yqbsoft.laser.service.organize.service.OrgEmployeeService;
import com.yqbsoft.laser.service.organize.service.OrgGroupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrgGroupServiceImpl
extends BaseServiceImpl
implements OrgGroupService {
    private static final String SYS_CODE = "org.OrgGroupServiceImpl";
    private OrgGroupMapper orgGroupMapper;
    private OrgGroupempMapper orgGroupempMapper;
    private OrgChannelsendService orgChannelsendService;
    private OrgEmployeeService orgEmployeeService;
    private String cachekeydomain = "OrgGroup-groupCode";
    private String cachekeyinfodomain = "OrgGroup-userinfoCode";
    private String cachekeyempdomain = "OrgGroup-orgUsercode";

    public OrgChannelsendService getOrgChannelsendService() {
        return this.orgChannelsendService;
    }

    public void setOrgChannelsendService(OrgChannelsendService orgChannelsendService) {
        this.orgChannelsendService = orgChannelsendService;
    }

    public void setOrgGroupMapper(OrgGroupMapper orgGroupMapper) {
        this.orgGroupMapper = orgGroupMapper;
    }

    public void setOrgGroupempMapper(OrgGroupempMapper orgGroupempMapper) {
        this.orgGroupempMapper = orgGroupempMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    public void setOrgEmployeeService(OrgEmployeeService orgEmployeeService) {
        this.orgEmployeeService = orgEmployeeService;
    }

    private String getUser(OrgGroupemp orgGroupemp) {
        if (null == orgGroupemp) {
            return null;
        }
        return orgGroupemp.getOrgUsercode() + "|GUP|" + orgGroupemp.getCompanyCode() + "|" + orgGroupemp.getGroupCode();
    }

    private String checkGroup(OrgGroupDomain orgGroupDomain) {
        if (null == orgGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgGroupDomain.getGroupName())) {
            msg = msg + "FtpserverCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgGroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupDefault(OrgGroup orgGroup) {
        if (null == orgGroup) {
            return;
        }
        if (null == orgGroup.getDataState()) {
            orgGroup.setDataState(0);
        }
        if (null == orgGroup.getGmtCreate()) {
            orgGroup.setGmtCreate(this.getSysDate());
        }
        orgGroup.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)orgGroup.getGroupCode())) {
            orgGroup.setGroupCode(this.createUUIDString());
        }
    }

    private int getGroupMaxCode() {
        int code = 0;
        try {
            return this.orgGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupUpdataDefault(OrgGroup orgGroup) {
        if (null == orgGroup) {
            return;
        }
        orgGroup.setGmtModified(this.getSysDate());
    }

    private void saveGroupModel(OrgGroup orgGroup) throws ApiException {
        if (null == orgGroup) {
            return;
        }
        try {
            this.orgGroupMapper.insert(orgGroup);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.saveGroupModel.ex", (Throwable)e);
        }
    }

    private void saveGroupBatchModel(List<OrgGroup> orgGroupList) throws ApiException {
        if (null == orgGroupList || orgGroupList.isEmpty()) {
            return;
        }
        try {
            this.orgGroupMapper.insertBatch(orgGroupList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.saveGroupBatchModel.ex", (Throwable)e);
        }
    }

    private OrgGroup getGroupModelById(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        try {
            return this.orgGroupMapper.selectByPrimaryKey(groupId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getGroupModelById", (Throwable)e);
            return null;
        }
    }

    private OrgGroup getGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.delGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgGroupServiceImpl.delGroupModelByCode.num");
        }
    }

    private void deleteGroupModel(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgGroupMapper.deleteByPrimaryKey(groupId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.deleteGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgGroupServiceImpl.deleteGroupModel.num");
        }
    }

    private void updateGroupModel(OrgGroup orgGroup) throws ApiException {
        if (null == orgGroup) {
            return;
        }
        int i = 0;
        try {
            i = this.orgGroupMapper.updateByPrimaryKeySelective(orgGroup);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroupModel.num");
        }
    }

    private void updateStateGroupModel(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == groupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupModel.null");
        }
    }

    private void updateStateGroupModelByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgGroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupModelByCode.null");
        }
    }

    private OrgGroup makeGroup(OrgGroupDomain orgGroupDomain, OrgGroup orgGroup) {
        if (null == orgGroupDomain) {
            return null;
        }
        if (null == orgGroup) {
            orgGroup = new OrgGroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgGroup, (Object)orgGroupDomain);
            return orgGroup;
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.makeGroup", (Throwable)e);
            return null;
        }
    }

    private OrgGroupReDomain makeOrgGroupReDomain(OrgGroup orgGroup) {
        if (null == orgGroup) {
            return null;
        }
        OrgGroupReDomain orgGroupReDomain = new OrgGroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgGroupReDomain, (Object)orgGroup);
            return orgGroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.makeOrgGroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgGroup> queryGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.orgGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.queryGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.countGroup", (Throwable)e);
        }
        return i;
    }

    private OrgGroup createOrgGroup(OrgGroupDomain orgGroupDomain) {
        String msg = this.checkGroup(orgGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgGroupServiceImpl.saveGroup.checkGroup", msg);
        }
        OrgGroup orgGroup = this.makeGroup(orgGroupDomain, null);
        this.setGroupDefault(orgGroup);
        return orgGroup;
    }

    private String checkGroupemp(OrgGroupempDomain orgGroupempDomain) {
        if (null == orgGroupempDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgGroupempDomain.getEmployeeCode())) {
            msg = msg + "EmployeeCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgGroupempDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupempDefault(OrgGroupemp orgGroupemp) {
        if (null == orgGroupemp) {
            return;
        }
        if (null == orgGroupemp.getDataState()) {
            orgGroupemp.setDataState(0);
        }
        if (null == orgGroupemp.getGmtCreate()) {
            orgGroupemp.setGmtCreate(this.getSysDate());
        }
        orgGroupemp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)orgGroupemp.getGroupempCode())) {
            orgGroupemp.setGroupempCode(this.createUUIDString());
        }
    }

    private int getGroupempMaxCode() {
        int code = 0;
        try {
            return this.orgGroupempMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getGroupempMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupempUpdataDefault(OrgGroupemp orgGroupemp) {
        if (null == orgGroupemp) {
            return;
        }
        orgGroupemp.setGmtModified(this.getSysDate());
    }

    private void saveGroupempModel(OrgGroupemp orgGroupemp) throws ApiException {
        if (null == orgGroupemp) {
            return;
        }
        try {
            this.orgGroupempMapper.insert(orgGroupemp);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.saveGroupempModel.ex", (Throwable)e);
        }
    }

    private void saveGroupempBatchModel(List<OrgGroupemp> orgGroupempList) throws ApiException {
        if (null == orgGroupempList || orgGroupempList.isEmpty()) {
            return;
        }
        try {
            this.orgGroupempMapper.insertBatch(orgGroupempList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.saveGroupempBatchModel.ex", (Throwable)e);
        }
    }

    private OrgGroupemp getGroupempModelById(Integer groupempId) {
        if (null == groupempId) {
            return null;
        }
        try {
            return this.orgGroupempMapper.selectByPrimaryKey(groupempId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getGroupempModelById", (Throwable)e);
            return null;
        }
    }

    private OrgGroupemp getGroupempModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgGroupempMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.getGroupempModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupempModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgGroupempMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.delGroupempModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgGroupServiceImpl.delGroupempModelByCode.num");
        }
    }

    private void deleteGroupempModel(Integer groupempId) throws ApiException {
        if (null == groupempId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgGroupempMapper.deleteByPrimaryKey(groupempId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.deleteGroupempModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgGroupServiceImpl.deleteGroupempModel.num");
        }
    }

    private void updateGroupempModel(OrgGroupemp orgGroupemp) throws ApiException {
        if (null == orgGroupemp) {
            return;
        }
        int i = 0;
        try {
            i = this.orgGroupempMapper.updateByPrimaryKeySelective(orgGroupemp);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroupempModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroupempModel.num");
        }
    }

    private void updateStateGroupempModel(Integer groupempId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == groupempId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupempId", groupempId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgGroupempMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupempModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupempModel.null");
        }
    }

    private void updateStateGroupempModelByCode(String tenantCode, String groupempCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)groupempCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupempCode", groupempCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgGroupempMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupempModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgGroupServiceImpl.updateStateGroupempModelByCode.null");
        }
    }

    private OrgGroupemp makeGroupemp(OrgGroupempDomain orgGroupempDomain, OrgGroupemp orgGroupemp) {
        if (null == orgGroupempDomain) {
            return null;
        }
        if (null == orgGroupemp) {
            orgGroupemp = new OrgGroupemp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgGroupemp, (Object)orgGroupempDomain);
            return orgGroupemp;
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.makeGroupemp", (Throwable)e);
            return null;
        }
    }

    private OrgGroupempReDomain makeOrgGroupempReDomain(OrgGroupemp orgGroupemp) {
        if (null == orgGroupemp) {
            return null;
        }
        OrgGroupempReDomain orgGroupempReDomain = new OrgGroupempReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgGroupempReDomain, (Object)orgGroupemp);
            return orgGroupempReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.makeOrgGroupempReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgGroupemp> queryGroupempModelPage(Map<String, Object> parammap) {
        try {
            return this.orgGroupempMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.queryGroupempModel", (Throwable)e);
            return null;
        }
    }

    private int countGroupemp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgGroupempMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgGroupServiceImpl.countGroupemp", (Throwable)e);
        }
        return i;
    }

    private OrgGroupemp createOrgGroupemp(OrgGroupempDomain orgGroupempDomain) {
        String msg = this.checkGroupemp(orgGroupempDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgGroupServiceImpl.saveGroupemp.checkGroupemp", msg);
        }
        OrgGroupemp orgGroupemp = this.makeGroupemp(orgGroupempDomain, null);
        this.setGroupempDefault(orgGroupemp);
        return orgGroupemp;
    }

    @Override
    public String saveGroup(OrgGroupDomain orgGroupDomain) throws ApiException {
        OrgGroup orgGroup = this.getOrgGroup(orgGroupDomain);
        return orgGroup.getGroupCode();
    }

    private void updateCache(OrgGroup orgGroup) {
        if (null == orgGroup) {
            return;
        }
        if (StringUtils.isNotBlank((String)orgGroup.getUserinfoCode())) {
            DisUtil.setMap((String)this.cachekeydomain, (String)(orgGroup.getGroupCode() + "-" + orgGroup.getCompanyCode() + "-" + orgGroup.getTenantCode()), (String)orgGroup.getUserinfoCode());
            DisUtil.setMap((String)this.cachekeyinfodomain, (String)(orgGroup.getUserinfoCode() + "-" + orgGroup.getTenantCode()), (String)orgGroup.getCompanyCode());
        }
    }

    private void delCache(OrgGroup orgGroup) {
        if (null == orgGroup) {
            return;
        }
        if (StringUtils.isNotBlank((String)orgGroup.getUserinfoCode())) {
            DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgGroup.getGroupCode() + "-" + orgGroup.getCompanyCode() + "-" + orgGroup.getTenantCode()});
            DisUtil.delMap((String)this.cachekeyinfodomain, (String[])new String[]{orgGroup.getUserinfoCode() + "-" + orgGroup.getTenantCode()});
        }
    }

    @Override
    public String saveGroupBatch(List<OrgGroupDomain> orgGroupDomainList) throws ApiException {
        if (null == orgGroupDomainList || orgGroupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgGroup> orgGroupList = new ArrayList<OrgGroup>();
        String code = "";
        for (OrgGroupDomain orgGroupDomain : orgGroupDomainList) {
            OrgGroup orgGroup = this.createOrgGroup(orgGroupDomain);
            code = orgGroup.getGroupCode();
            orgGroupList.add(orgGroup);
        }
        this.saveGroupBatchModel(orgGroupList);
        for (OrgGroup orgGroup2 : orgGroupList) {
            this.updateCache(orgGroup2);
        }
        return code;
    }

    @Override
    public void updateGroupState(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGroupModel(groupId, dataState, oldDataState);
        if (-1 == dataState) {
            OrgGroup orgGroup = this.getGroup(groupId);
            if (null == orgGroup) {
                throw new ApiException("org.OrgGroupServiceImpl.updateGroupState.orgGroup", "\u6570\u636e\u4e3a\u7a7a");
            }
            this.delCache(orgGroup);
        }
    }

    @Override
    public void updateGroupStateByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGroupModelByCode(tenantCode, groupCode, dataState, oldDataState);
        if (-1 == dataState) {
            OrgGroup orgGroup = this.getGroupByCode(tenantCode, groupCode);
            if (null == orgGroup) {
                throw new ApiException("org.OrgGroupServiceImpl.updateGroupStateByCode.orgGroup", "\u6570\u636e\u4e3a\u7a7a");
            }
            this.delCache(orgGroup);
        }
    }

    @Override
    public void updateGroup(OrgGroupDomain orgGroupDomain) throws ApiException {
        String msg = this.checkGroup(orgGroupDomain);
        OrgGroup orgGroup = this.getOrgGroup(orgGroupDomain, msg);
    }

    @Override
    public OrgGroup getGroup(Integer groupId) {
        return this.getGroupModelById(groupId);
    }

    @Override
    public void deleteGroup(Integer groupId) throws ApiException {
        OrgGroup orgGroup = this.getOrgGroup(groupId);
    }

    @Override
    public QueryResult<OrgGroup> queryGroupPage(Map<String, Object> map) {
        List<OrgGroup> orgGroupList = this.queryGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgGroupList);
        return queryResult;
    }

    @Override
    public OrgGroup getGroupByCode(String tenantCode, String groupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        return this.getGroupModelByCode(map);
    }

    @Override
    public void deleteGroupByCode(String tenantCode, String groupCode) throws ApiException {
        OrgGroup orgGroup = this.getOrgGroup(tenantCode, groupCode);
    }

    @Override
    public String saveGroupemp(OrgGroupempDomain orgGroupempDomain) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(orgGroupempDomain);
        return orgGroupemp.getGroupempCode();
    }

    @Override
    public String saveGroupempBatch(List<OrgGroupempDomain> orgGroupempDomainList) throws ApiException {
        if (null == orgGroupempDomainList || orgGroupempDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgGroupemp> orgGroupempList = new ArrayList<OrgGroupemp>();
        String code = "";
        for (OrgGroupempDomain orgGroupempDomain : orgGroupempDomainList) {
            OrgGroupemp orgGroupemp = this.createOrgGroupemp(orgGroupempDomain);
            code = orgGroupemp.getGroupempCode();
            orgGroupempList.add(orgGroupemp);
        }
        this.saveGroupempBatchModel(orgGroupempList);
        for (OrgGroupemp orgGroupemp2 : orgGroupempList) {
            this.updateEmpCache(orgGroupemp2);
        }
        return code;
    }

    @Override
    public void updateGroupempState(Integer groupempId, Integer dataState, Integer oldDataState) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(groupempId, dataState, oldDataState);
    }

    @Override
    public void updateGroupempStateByCode(String tenantCode, String groupempCode, Integer dataState, Integer oldDataState) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(tenantCode, groupempCode, dataState, oldDataState);
    }

    @Override
    public void updateGroupemp(OrgGroupempDomain orgGroupempDomain) throws ApiException {
        String msg = this.checkGroupemp(orgGroupempDomain);
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(orgGroupempDomain, msg);
    }

    @Override
    public OrgGroupemp getGroupemp(Integer groupempId) {
        return this.getGroupempModelById(groupempId);
    }

    @Override
    public void deleteGroupemp(Integer groupempId) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(groupempId);
    }

    @Override
    public QueryResult<OrgGroupemp> queryGroupempPage(Map<String, Object> map) {
        List<OrgGroupemp> orgGroupempList = this.queryGroupempModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroupemp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgGroupempList);
        return queryResult;
    }

    @Override
    public OrgGroupemp getGroupempByCode(String tenantCode, String groupempCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupempCode", groupempCode);
        return this.getGroupempModelByCode(map);
    }

    @Override
    public void deleteGroupempByCode(String tenantCode, String groupempCode) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(tenantCode, groupempCode);
    }

    private void deleteEmpCache(OrgGroupemp orgGroupemp) {
        if (null == orgGroupemp) {
            return;
        }
        if (StringUtils.isBlank((String)orgGroupemp.getOrgUsercode())) {
            return;
        }
        OrgEmployee orgEmployee = this.orgEmployeeService.getEmployeeByCode(orgGroupemp.getTenantCode(), orgGroupemp.getEmployeeCode());
        if (null == orgEmployee) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        String str = "";
        if (StringUtils.isNotBlank((String)json)) {
            String[] s;
            for (String string : s = json.split(",")) {
                if (string.equals(this.getUser(orgGroupemp))) continue;
                str = str + "," + string;
            }
        }
        if (StringUtils.isBlank((String)str)) {
            DisUtil.delMap((String)this.cachekeyempdomain, (String[])new String[]{orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)str);
        }
    }

    private void updateEmpCache(OrgGroupemp orgGroupemp) {
        if (null == orgGroupemp) {
            return;
        }
        if (StringUtils.isBlank((String)orgGroupemp.getOrgUsercode())) {
            return;
        }
        OrgEmployee orgEmployee = this.orgEmployeeService.getEmployeeByCode(orgGroupemp.getTenantCode(), orgGroupemp.getEmployeeCode());
        if (null == orgEmployee) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        boolean flag = true;
        if (StringUtils.isNotBlank((String)json)) {
            String[] s;
            for (String string : s = json.split(",")) {
                if (!string.equals(this.getUser(orgGroupemp))) continue;
                flag = false;
            }
            if (flag) {
                json = json + ",";
            }
        } else {
            json = "";
        }
        if (flag) {
            json = json + this.getUser(orgGroupemp);
        }
        DisUtil.setMapVer((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)json);
    }

    @Override
    public void queryGroupLoadCache() {
        this.logger.info("OrgGroupService.queryGroupLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<OrgGroup> groupList = this.queryGroupModelPage(parammap);
        if (null == groupList || groupList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachekeyinfodomain);
            DisUtil.delVer((String)this.cachekeyempdomain);
            this.logger.info("OrgGroupService.queryGroupLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> codeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> infocodeMap = new ConcurrentHashMap<String, String>();
        for (OrgGroup orgGroup : groupList) {
            if (!StringUtils.isNotBlank((String)orgGroup.getUserinfoCode())) continue;
            codeMap.put(orgGroup.getGroupCode() + "-" + orgGroup.getCompanyCode() + "-" + orgGroup.getTenantCode(), orgGroup.getUserinfoCode());
            infocodeMap.put(orgGroup.getUserinfoCode() + "-" + orgGroup.getTenantCode(), orgGroup.getUserinfoCode());
        }
        DisUtil.setMapVer((String)this.cachekeydomain, codeMap);
        DisUtil.setMapVer((String)this.cachekeyinfodomain, infocodeMap);
        this.logger.info("OrgGroupService.queryGroupLoadCache", (Object)"===========add-end==========");
        List<OrgGroupemp> emplist = this.queryGroupempModelPage(parammap);
        if (null == emplist || emplist.isEmpty()) {
            DisUtil.delVer((String)this.cachekeyempdomain);
            this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========delemp-end==========");
            return;
        }
        ConcurrentHashMap<String, String> empcodeMap = new ConcurrentHashMap<String, String>();
        for (OrgGroupemp orgGroupemp : emplist) {
            OrgEmployee orgEmployee;
            if (!StringUtils.isNotBlank((String)orgGroupemp.getOrgUsercode()) || null == (orgEmployee = this.orgEmployeeService.getEmployeeByCode(orgGroupemp.getTenantCode(), orgGroupemp.getEmployeeCode()))) continue;
            String valueorguserStr = (String)empcodeMap.get(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode());
            valueorguserStr = null == valueorguserStr ? "" : valueorguserStr + ",";
            valueorguserStr = valueorguserStr + this.getUser(orgGroupemp);
            empcodeMap.put(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode(), valueorguserStr);
        }
        DisUtil.setMapVer((String)this.cachekeyempdomain, empcodeMap);
        this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========addemp-end==========");
    }

    @Override
    public List<OrgChannelsend> sendSaveGroup(OrgGroupDomain orgGroupDomain) throws ApiException {
        OrgGroup orgGroup = this.getOrgGroup(orgGroupDomain);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroup> list = new ArrayList<OrgGroup>();
        list.add(orgGroup);
        resendList = this.buidPmChannelsend(list, "insert");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroup getOrgGroup(OrgGroupDomain orgGroupDomain) {
        OrgGroup orgGroup = this.createOrgGroup(orgGroupDomain);
        this.saveGroupModel(orgGroup);
        this.updateCache(orgGroup);
        return orgGroup;
    }

    @Override
    public List<OrgChannelsend> sendSaveGroupBatch(List<OrgGroupDomain> orgGroupDomainList) throws ApiException {
        if (null == orgGroupDomainList || orgGroupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsend> rePmChannelsendList = new ArrayList<OrgChannelsend>();
        for (OrgGroupDomain pmPromotionDomain : orgGroupDomainList) {
            List<OrgChannelsend> pmChannelsendList = this.sendSaveGroup(pmPromotionDomain);
            if (!ListUtil.isNotEmpty(pmChannelsendList)) continue;
            rePmChannelsendList.addAll(pmChannelsendList);
        }
        return rePmChannelsendList;
    }

    @Override
    public List<OrgChannelsend> sendUpdateGroupState(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGroupModel(groupId, dataState, oldDataState);
        OrgGroup orgGroup = this.getGroup(groupId);
        if (-1 == dataState) {
            if (null == orgGroup) {
                throw new ApiException("org.OrgGroupServiceImpl.sendUpdateGroupState.orgGroup", "\u6570\u636e\u4e3a\u7a7a");
            }
            this.delCache(orgGroup);
        }
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroup> list = new ArrayList<OrgGroup>();
        list.add(orgGroup);
        resendList = this.buidPmChannelsend(list, "update");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    @Override
    public List<OrgChannelsend> sendUpdateGroupStateByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState) throws ApiException {
        OrgGroup orgGroup = this.getGroupByCode(tenantCode, groupCode);
        this.updateStateGroupModelByCode(tenantCode, groupCode, dataState, oldDataState);
        if (-1 == dataState) {
            if (null == orgGroup) {
                throw new ApiException("org.OrgGroupServiceImpl.sendUpdateGroupStateByCode.orgGroup", "\u6570\u636e\u4e3a\u7a7a");
            }
            this.delCache(orgGroup);
        }
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroup> list = new ArrayList<OrgGroup>();
        list.add(orgGroup);
        resendList = this.buidPmChannelsend(list, "insert");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    @Override
    public List<OrgChannelsend> sendUpdateGroup(OrgGroupDomain orgGroupDomain) throws ApiException {
        String msg = this.checkGroup(orgGroupDomain);
        OrgGroup orgGroup = this.getOrgGroup(orgGroupDomain, msg);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroup> list = new ArrayList<OrgGroup>();
        list.add(orgGroup);
        resendList = this.buidPmChannelsend(list, "update");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroup getOrgGroup(OrgGroupDomain orgGroupDomain, String msg) {
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroup.checkGroup", msg);
        }
        OrgGroup oldOrgGroup = this.getGroupModelById(orgGroupDomain.getGroupId());
        if (null == oldOrgGroup) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgGroup orgGroup = this.makeGroup(orgGroupDomain, oldOrgGroup);
        this.setGroupUpdataDefault(orgGroup);
        this.updateGroupModel(orgGroup);
        this.updateCache(orgGroup);
        return orgGroup;
    }

    @Override
    public List<OrgChannelsend> sendDeleteGroup(Integer groupId) throws ApiException {
        OrgGroup orgGroup = this.getOrgGroup(groupId);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroup> list = new ArrayList<OrgGroup>();
        list.add(orgGroup);
        resendList = this.buidPmChannelsend(list, "insert");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroup getOrgGroup(Integer groupId) {
        OrgGroup orgGroup = this.getGroup(groupId);
        if (null == orgGroup) {
            throw new ApiException("org.OrgGroupServiceImpl.deleteGroup.orgGroup", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteGroupModel(groupId);
        this.delCache(orgGroup);
        return orgGroup;
    }

    @Override
    public List<OrgChannelsend> sendDeleteGroupByCode(String tenantCode, String groupCode) throws ApiException {
        OrgGroup orgGroup = this.getOrgGroup(tenantCode, groupCode);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroup> list = new ArrayList<OrgGroup>();
        list.add(orgGroup);
        resendList = this.buidPmChannelsend(list, "insert");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroup getOrgGroup(String tenantCode, String groupCode) {
        OrgGroup orgGroup = this.getGroupByCode(tenantCode, groupCode);
        if (null == orgGroup) {
            throw new ApiException("org.OrgGroupServiceImpl.deleteGroupByCode.orgGroup", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        this.delGroupModelByCode(map);
        this.delCache(orgGroup);
        return orgGroup;
    }

    @Override
    public List<OrgChannelsend> sendSaveGroupemp(OrgGroupempDomain orgGroupempDomain) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(orgGroupempDomain);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroupemp> list = new ArrayList<OrgGroupemp>();
        list.add(orgGroupemp);
        resendList = this.buidPmChannelsendStr(list, "insert");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroupemp getOrgGroupemp(OrgGroupempDomain orgGroupempDomain) {
        OrgGroupemp orgGroupemp = this.createOrgGroupemp(orgGroupempDomain);
        this.saveGroupempModel(orgGroupemp);
        this.updateEmpCache(orgGroupemp);
        return orgGroupemp;
    }

    @Override
    public List<OrgChannelsend> sendSaveGroupempBatch(List<OrgGroupempDomain> orgGroupempDomainList) throws ApiException {
        if (null == orgGroupempDomainList || orgGroupempDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsend> rePmChannelsendList = new ArrayList<OrgChannelsend>();
        for (OrgGroupempDomain pmPromotionDomain : orgGroupempDomainList) {
            List<OrgChannelsend> pmChannelsendList = this.sendSaveGroupemp(pmPromotionDomain);
            if (!ListUtil.isNotEmpty(pmChannelsendList)) continue;
            rePmChannelsendList.addAll(pmChannelsendList);
        }
        return rePmChannelsendList;
    }

    @Override
    public List<OrgChannelsend> sendUpdateGroupempState(Integer groupempId, Integer dataState, Integer oldDataState) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(groupempId, dataState, oldDataState);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroupemp> list = new ArrayList<OrgGroupemp>();
        list.add(orgGroupemp);
        resendList = this.buidPmChannelsendStr(list, "update");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroupemp getOrgGroupemp(Integer groupempId, Integer dataState, Integer oldDataState) {
        this.updateStateGroupempModel(groupempId, dataState, oldDataState);
        OrgGroupemp orgGroupemp = this.getGroupemp(groupempId);
        if (-1 == dataState) {
            this.deleteEmpCache(orgGroupemp);
        } else {
            this.updateEmpCache(orgGroupemp);
        }
        return orgGroupemp;
    }

    @Override
    public List<OrgChannelsend> sendUpdateGroupempStateByCode(String tenantCode, String groupempCode, Integer dataState, Integer oldDataState) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(tenantCode, groupempCode, dataState, oldDataState);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroupemp> list = new ArrayList<OrgGroupemp>();
        list.add(orgGroupemp);
        resendList = this.buidPmChannelsendStr(list, "update");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroupemp getOrgGroupemp(String tenantCode, String groupempCode, Integer dataState, Integer oldDataState) {
        this.updateStateGroupempModelByCode(tenantCode, groupempCode, dataState, oldDataState);
        OrgGroupemp orgGroupemp = this.getGroupempByCode(tenantCode, groupempCode);
        if (-1 == dataState) {
            this.deleteEmpCache(orgGroupemp);
        } else {
            this.updateEmpCache(orgGroupemp);
        }
        return orgGroupemp;
    }

    @Override
    public List<OrgChannelsend> sendUpdateGroupemp(OrgGroupempDomain orgGroupempDomain) throws ApiException {
        String msg = this.checkGroupemp(orgGroupempDomain);
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(orgGroupempDomain, msg);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroupemp> list = new ArrayList<OrgGroupemp>();
        list.add(orgGroupemp);
        resendList = this.buidPmChannelsendStr(list, "update");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroupemp getOrgGroupemp(OrgGroupempDomain orgGroupempDomain, String msg) {
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroupemp.checkGroupemp", msg);
        }
        OrgGroupemp oldOrgGroupemp = this.getGroupempModelById(orgGroupempDomain.getGroupempId());
        if (null == oldOrgGroupemp) {
            throw new ApiException("org.OrgGroupServiceImpl.updateGroupemp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteEmpCache(oldOrgGroupemp);
        OrgGroupemp orgGroupemp = this.makeGroupemp(orgGroupempDomain, oldOrgGroupemp);
        this.setGroupempUpdataDefault(orgGroupemp);
        this.updateGroupempModel(orgGroupemp);
        this.updateEmpCache(orgGroupemp);
        return orgGroupemp;
    }

    @Override
    public List<OrgChannelsend> sendDeleteGroupemp(Integer groupempId) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(groupempId);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroupemp> list = new ArrayList<OrgGroupemp>();
        list.add(orgGroupemp);
        resendList = this.buidPmChannelsendStr(list, "delete");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroupemp getOrgGroupemp(Integer groupempId) {
        this.deleteGroupempModel(groupempId);
        OrgGroupemp orgGroupemp = this.getGroupemp(groupempId);
        this.deleteEmpCache(orgGroupemp);
        return orgGroupemp;
    }

    @Override
    public List<OrgChannelsend> sendDeleteGroupempByCode(String tenantCode, String groupempCode) throws ApiException {
        OrgGroupemp orgGroupemp = this.getOrgGroupemp(tenantCode, groupempCode);
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgGroupemp> list = new ArrayList<OrgGroupemp>();
        list.add(orgGroupemp);
        resendList = this.buidPmChannelsendStr(list, "delete");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgGroupemp getOrgGroupemp(String tenantCode, String groupempCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupempCode", groupempCode);
        this.delGroupempModelByCode(map);
        OrgGroupemp orgGroupemp = this.getGroupempByCode(tenantCode, groupempCode);
        this.deleteEmpCache(orgGroupemp);
        return orgGroupemp;
    }

    private List<OrgChannelsend> buidPmChannelsend(List<OrgGroup> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<OrgChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<OrgChannelsendDomain> disChannelsendDomainList = new ArrayList<OrgChannelsendDomain>();
        for (OrgGroup promotion : pmPromotionList) {
            OrgChannelsendDomain pmChannelsendDomain = new OrgChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCompanyCode());
            pmChannelsendDomain.setChannelsendType("OrgOrgGroup");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.orgChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<OrgChannelsend> buidPmChannelsendStr(List<OrgGroupemp> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<OrgChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<OrgChannelsendDomain> disChannelsendDomainList = new ArrayList<OrgChannelsendDomain>();
        for (OrgGroupemp promotion : pmPromotionList) {
            OrgChannelsendDomain pmChannelsendDomain = new OrgChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCompanyCode());
            pmChannelsendDomain.setChannelsendType("OrgOrgDepartemp");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.orgChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

