/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgEmployeeMapper;
import com.yqbsoft.laser.service.organize.dao.OrgEmployeeauMapper;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeauDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeauReDomain;
import com.yqbsoft.laser.service.organize.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.organize.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.organize.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.organize.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.organize.model.OrgChannelsend;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.organize.model.OrgEmployeeau;
import com.yqbsoft.laser.service.organize.service.OrgChannelsendService;
import com.yqbsoft.laser.service.organize.service.OrgEmployeeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrgEmployeeServiceImpl
extends BaseServiceImpl
implements OrgEmployeeService {
    private static final String SYS_CODE = "org.OrgEmployeeServiceImpl";
    private OrgEmployeeMapper orgEmployeeMapper;
    private OrgEmployeeauMapper orgEmployeeauMapper;
    private OrgChannelsendService orgChannelsendService;
    private String cachekeydomain = "OrgEmployee-userinfoCode";
    private String cachekeyuserdomain = "OrgEmployee-userCode";
    private String cachekeyorguserdomain = "OrgEmployee-orgUsercode";

    public OrgChannelsendService getOrgChannelsendService() {
        return this.orgChannelsendService;
    }

    public void setOrgChannelsendService(OrgChannelsendService orgChannelsendService) {
        this.orgChannelsendService = orgChannelsendService;
    }

    public void setOrgEmployeeMapper(OrgEmployeeMapper orgEmployeeMapper) {
        this.orgEmployeeMapper = orgEmployeeMapper;
    }

    public void setOrgEmployeeauMapper(OrgEmployeeauMapper orgEmployeeauMapper) {
        this.orgEmployeeauMapper = orgEmployeeauMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgEmployeeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgEmployeeDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgEmployeeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEmployeeDefault(OrgEmployee orgEmployee) {
        if (null == orgEmployee) {
            return;
        }
        if (null == orgEmployee.getDataState()) {
            orgEmployee.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgEmployee.getGmtCreate()) {
            orgEmployee.setGmtCreate(date);
        }
        orgEmployee.setGmtModified(date);
        if (StringUtils.isBlank((String)orgEmployee.getEmployeeCode())) {
            orgEmployee.setEmployeeCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)orgEmployee.getEmployeeDp())) {
            orgEmployee.setEmployeeDp("0");
        }
        if (StringUtils.isBlank((String)orgEmployee.getEmployeeOrgin())) {
            orgEmployee.setEmployeeOrgin("1");
        }
    }

    private int getEmployeeMaxCode() {
        int code = 0;
        try {
            return this.orgEmployeeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getEmployeeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEmployeeUpdataDefault(OrgEmployee orgEmployee) {
        if (null == orgEmployee) {
            return;
        }
        orgEmployee.setGmtModified(this.getSysDate());
    }

    private void saveEmployeeModel(OrgEmployee orgEmployee) throws ApiException {
        if (null == orgEmployee) {
            return;
        }
        try {
            this.orgEmployeeMapper.insert(orgEmployee);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.saveEmployeeModel.ex", (Throwable)e);
        }
    }

    private void saveEmployeeBatchModel(List<OrgEmployee> orgEmployeeList) throws ApiException {
        if (null == orgEmployeeList || orgEmployeeList.isEmpty()) {
            return;
        }
        try {
            this.orgEmployeeMapper.insertBatch(orgEmployeeList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.saveEmployeeBatchModel.ex", (Throwable)e);
        }
    }

    private OrgEmployee getEmployeeModelById(Integer employeeId) {
        if (null == employeeId) {
            return null;
        }
        try {
            return this.orgEmployeeMapper.selectByPrimaryKey(employeeId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getEmployeeModelById", (Throwable)e);
            return null;
        }
    }

    private OrgEmployee getEmployeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgEmployeeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getEmployeeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEmployeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgEmployeeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.delEmployeeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgEmployeeServiceImpl.delEmployeeModelByCode.num");
        }
    }

    private void deleteEmployeeModel(Integer employeeId) throws ApiException {
        if (null == employeeId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgEmployeeMapper.deleteByPrimaryKey(employeeId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.deleteEmployeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgEmployeeServiceImpl.deleteEmployeeModel.num");
        }
    }

    private void updateEmployeeModel(OrgEmployee orgEmployee) throws ApiException {
        if (null == orgEmployee) {
            return;
        }
        int i = 0;
        try {
            i = this.orgEmployeeMapper.updateByPrimaryKeySelective(orgEmployee);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployeeModel.num");
        }
    }

    private void updateStateEmployeeModel(Integer employeeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == employeeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("employeeId", employeeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgEmployeeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeModel.null");
        }
    }

    private void updateStateEmployeeModelByCode(String tenantCode, String employeeCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)employeeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeCode", employeeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgEmployeeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeModelByCode.null");
        }
    }

    private void updateDpEmployeeModelByCode(String tenantCode, String employeeCode, String employeeDp) throws ApiException {
        if (StringUtils.isBlank((String)employeeCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeCode", employeeCode);
        map.put("employeeDp", employeeDp);
        int i = 0;
        try {
            i = this.orgEmployeeMapper.updateEmployeeDpByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateDpEmployeeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateDpEmployeeModelByCode.null" + ((Object)map).toString());
        }
    }

    private OrgEmployee makeEmployee(OrgEmployeeDomain orgEmployeeDomain, OrgEmployee orgEmployee) {
        if (null == orgEmployeeDomain) {
            return null;
        }
        if (null == orgEmployee) {
            orgEmployee = new OrgEmployee();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgEmployee, (Object)orgEmployeeDomain);
            return orgEmployee;
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.makeEmployee", (Throwable)e);
            return null;
        }
    }

    private OrgEmployeeReDomain makeOrgEmployeeReDomain(OrgEmployee orgEmployee) {
        if (null == orgEmployee) {
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = new OrgEmployeeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgEmployeeReDomain, (Object)orgEmployee);
            return orgEmployeeReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.makeOrgEmployeeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgEmployee> queryEmployeeModelPage(Map<String, Object> parammap) {
        try {
            return this.orgEmployeeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.queryEmployeeModel", (Throwable)e);
            return null;
        }
    }

    private int countEmployee(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgEmployeeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.countEmployee", (Throwable)e);
        }
        return i;
    }

    private OrgEmployee createOrgEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        String msg = this.checkEmployee(orgEmployeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgEmployeeServiceImpl.saveEmployee.checkEmployee", msg);
        }
        OrgEmployee orgEmployee = this.makeEmployee(orgEmployeeDomain, null);
        this.setEmployeeDefault(orgEmployee);
        return orgEmployee;
    }

    private String checkEmployeeau(OrgEmployeeauDomain orgEmployeeauDomain) {
        if (null == orgEmployeeauDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgEmployeeauDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgEmployeeauDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setEmployeeauDefault(OrgEmployeeau orgEmployeeau) {
        if (null == orgEmployeeau) {
            return;
        }
        if (null == orgEmployeeau.getDataState()) {
            orgEmployeeau.setDataState(0);
        }
        if (null == orgEmployeeau.getGmtCreate()) {
            orgEmployeeau.setGmtCreate(this.getSysDate());
        }
        orgEmployeeau.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)orgEmployeeau.getEmployeeauCode())) {
            orgEmployeeau.setEmployeeauCode(this.createUUIDString());
        }
    }

    private int getEmployeeauMaxCode() {
        int code = 0;
        try {
            return this.orgEmployeeauMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getEmployeeauMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setEmployeeauUpdataDefault(OrgEmployeeau orgEmployeeau) {
        if (null == orgEmployeeau) {
            return;
        }
        orgEmployeeau.setGmtModified(this.getSysDate());
    }

    private void saveEmployeeauModel(OrgEmployeeau orgEmployeeau) throws ApiException {
        if (null == orgEmployeeau) {
            return;
        }
        try {
            this.orgEmployeeauMapper.insert(orgEmployeeau);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.saveEmployeeauModel.ex", (Throwable)e);
        }
    }

    private void saveEmployeeauBatchModel(List<OrgEmployeeau> orgEmployeeauList) throws ApiException {
        if (null == orgEmployeeauList || orgEmployeeauList.isEmpty()) {
            return;
        }
        try {
            this.orgEmployeeauMapper.insertBatch(orgEmployeeauList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.saveEmployeeauBatchModel.ex", (Throwable)e);
        }
    }

    private OrgEmployeeau getEmployeeauModelById(Integer employeeauId) {
        if (null == employeeauId) {
            return null;
        }
        try {
            return this.orgEmployeeauMapper.selectByPrimaryKey(employeeauId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getEmployeeauModelById", (Throwable)e);
            return null;
        }
    }

    private OrgEmployeeau getEmployeeauModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgEmployeeauMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.getEmployeeauModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delEmployeeauModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgEmployeeauMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.delEmployeeauModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgEmployeeServiceImpl.delEmployeeauModelByCode.num");
        }
    }

    private void deleteEmployeeauModel(Integer employeeauId) throws ApiException {
        if (null == employeeauId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgEmployeeauMapper.deleteByPrimaryKey(employeeauId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.deleteEmployeeauModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgEmployeeServiceImpl.deleteEmployeeauModel.num");
        }
    }

    private void updateEmployeeauModel(OrgEmployeeau orgEmployeeau) throws ApiException {
        if (null == orgEmployeeau) {
            return;
        }
        int i = 0;
        try {
            i = this.orgEmployeeauMapper.updateByPrimaryKeySelective(orgEmployeeau);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployeeauModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployeeauModel.num");
        }
    }

    private void updateStateEmployeeauModel(Integer employeeauId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == employeeauId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("employeeauId", employeeauId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgEmployeeauMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeauModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeauModel.null");
        }
    }

    private void updateStateEmployeeauModelByCode(String tenantCode, String employeeauCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)employeeauCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeauCode", employeeauCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgEmployeeauMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeauModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateStateEmployeeauModelByCode.null");
        }
    }

    private OrgEmployeeau makeEmployeeau(OrgEmployeeauDomain orgEmployeeauDomain, OrgEmployeeau orgEmployeeau) {
        if (null == orgEmployeeauDomain) {
            return null;
        }
        if (null == orgEmployeeau) {
            orgEmployeeau = new OrgEmployeeau();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgEmployeeau, (Object)orgEmployeeauDomain);
            return orgEmployeeau;
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.makeEmployeeau", (Throwable)e);
            return null;
        }
    }

    private OrgEmployeeauReDomain makeOrgEmployeeauReDomain(OrgEmployeeau orgEmployeeau) {
        if (null == orgEmployeeau) {
            return null;
        }
        OrgEmployeeauReDomain orgEmployeeauReDomain = new OrgEmployeeauReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgEmployeeauReDomain, (Object)orgEmployeeau);
            return orgEmployeeauReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.makeOrgEmployeeauReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgEmployeeau> queryEmployeeauModelPage(Map<String, Object> parammap) {
        try {
            return this.orgEmployeeauMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.queryEmployeeauModel", (Throwable)e);
            return null;
        }
    }

    private int countEmployeeau(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgEmployeeauMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.countEmployeeau", (Throwable)e);
        }
        return i;
    }

    private OrgEmployeeau createOrgEmployeeau(OrgEmployeeauDomain orgEmployeeauDomain) {
        String msg = this.checkEmployeeau(orgEmployeeauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgEmployeeServiceImpl.saveEmployeeau.checkEmployeeau", msg);
        }
        OrgEmployeeau orgEmployeeau = this.makeEmployeeau(orgEmployeeauDomain, null);
        this.setEmployeeauDefault(orgEmployeeau);
        return orgEmployeeau;
    }

    @Override
    public List<OrgChannelsend> saveEmployee(OrgEmployeeDomain orgEmployeeDomain) throws ApiException {
        OrgEmployee orgEmployee = this.getOrgEmployee(orgEmployeeDomain);
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public List<OrgChannelsend> saveEmployeeBatch(List<OrgEmployeeDomain> orgEmployeeDomainList) throws ApiException {
        if (null == orgEmployeeDomainList || orgEmployeeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsend> relist = new ArrayList<OrgChannelsend>();
        for (OrgEmployeeDomain orgEmployeeDomain : orgEmployeeDomainList) {
            List<OrgChannelsend> list = this.saveEmployee(orgEmployeeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<OrgChannelsend> updateEmployeeState(Integer employeeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEmployeeModel(employeeId, dataState, oldDataState);
        OrgEmployee orgEmployee = this.getEmployee(employeeId);
        if (-1 == dataState) {
            this.deleteEmployeeCache(orgEmployee);
        } else {
            this.updateEmployeeCache(orgEmployee);
        }
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<OrgChannelsend> updateEmployeeStateByCode(String tenantCode, String employeeCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEmployeeModelByCode(tenantCode, employeeCode, dataState, oldDataState);
        OrgEmployee orgEmployee = this.getEmployeeByCode(tenantCode, employeeCode);
        if (-1 == dataState) {
            this.deleteEmployeeCache(orgEmployee);
        } else {
            this.updateEmployeeCache(orgEmployee);
        }
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<OrgChannelsend> updateEmployee(OrgEmployeeDomain orgEmployeeDomain) throws ApiException {
        String msg = this.checkEmployee(orgEmployeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployee.checkEmployee", msg);
        }
        OrgEmployee oldOrgEmployee = this.getEmployeeModelById(orgEmployeeDomain.getEmployeeId());
        String userinfoCode = oldOrgEmployee.getUserinfoCode();
        if (null == oldOrgEmployee) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployee.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteEmployeeCache(oldOrgEmployee);
        OrgEmployee orgEmployee = this.makeEmployee(orgEmployeeDomain, oldOrgEmployee);
        this.setEmployeeUpdataDefault(orgEmployee);
        this.updateEmployeeModel(orgEmployee);
        this.updateEmployeeCache(orgEmployee);
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        if (StringUtils.isBlank((String)orgEmployee.getUserinfoCode())) {
            orgEmployee.setUserinfoCode(userinfoCode);
        }
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public OrgEmployee getEmployee(Integer employeeId) {
        return this.getEmployeeModelById(employeeId);
    }

    @Override
    public List<OrgChannelsend> deleteEmployee(Integer employeeId) throws ApiException {
        OrgEmployee orgEmployee = this.getOrgEmployee(employeeId);
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public QueryResult<OrgEmployee> queryEmployeePage(Map<String, Object> map) {
        List<OrgEmployee> orgEmployeeList = this.queryEmployeeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEmployee(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgEmployeeList);
        return queryResult;
    }

    @Override
    public OrgEmployee getEmployeeByCode(String tenantCode, String employeeCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeCode", employeeCode);
        return this.getEmployeeModelByCode(map);
    }

    @Override
    public List<OrgChannelsend> deleteEmployeeByCode(String tenantCode, String employeeCode) throws ApiException {
        OrgEmployee orgEmployee = this.getOrgEmployee(tenantCode, employeeCode);
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public String saveEmployeeau(OrgEmployeeauDomain orgEmployeeauDomain) throws ApiException {
        OrgEmployeeau orgEmployeeau = this.createOrgEmployeeau(orgEmployeeauDomain);
        this.saveEmployeeauModel(orgEmployeeau);
        return orgEmployeeau.getEmployeeauCode();
    }

    @Override
    public String saveEmployeeauBatch(List<OrgEmployeeauDomain> orgEmployeeauDomainList) throws ApiException {
        if (null == orgEmployeeauDomainList || orgEmployeeauDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgEmployeeau> orgEmployeeauList = new ArrayList<OrgEmployeeau>();
        String code = "";
        for (OrgEmployeeauDomain orgEmployeeauDomain : orgEmployeeauDomainList) {
            OrgEmployeeau orgEmployeeau = this.createOrgEmployeeau(orgEmployeeauDomain);
            code = orgEmployeeau.getEmployeeauCode();
            orgEmployeeauList.add(orgEmployeeau);
        }
        this.saveEmployeeauBatchModel(orgEmployeeauList);
        return code;
    }

    @Override
    public void updateEmployeeauState(Integer employeeauId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEmployeeauModel(employeeauId, dataState, oldDataState);
    }

    @Override
    public void updateEmployeeauStateByCode(String tenantCode, String employeeauCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateEmployeeauModelByCode(tenantCode, employeeauCode, dataState, oldDataState);
    }

    @Override
    public void updateEmployeeau(OrgEmployeeauDomain orgEmployeeauDomain) throws ApiException {
        String msg = this.checkEmployeeau(orgEmployeeauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployeeau.checkEmployeeau", msg);
        }
        OrgEmployeeau oldOrgEmployeeau = this.getEmployeeauModelById(orgEmployeeauDomain.getEmployeeauId());
        if (null == oldOrgEmployeeau) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateEmployeeau.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgEmployeeau orgEmployeeau = this.makeEmployeeau(orgEmployeeauDomain, oldOrgEmployeeau);
        this.setEmployeeauUpdataDefault(orgEmployeeau);
        this.updateEmployeeauModel(orgEmployeeau);
    }

    @Override
    public OrgEmployeeau getEmployeeau(Integer employeeauId) {
        return this.getEmployeeauModelById(employeeauId);
    }

    @Override
    public void deleteEmployeeau(Integer employeeauId) throws ApiException {
        this.deleteEmployeeauModel(employeeauId);
    }

    @Override
    public QueryResult<OrgEmployeeau> queryEmployeeauPage(Map<String, Object> map) {
        List<OrgEmployeeau> orgEmployeeauList = this.queryEmployeeauModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countEmployeeau(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgEmployeeauList);
        return queryResult;
    }

    @Override
    public OrgEmployeeau getEmployeeauByCode(String tenantCode, String employeeauCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeauCode", employeeauCode);
        return this.getEmployeeauModelByCode(map);
    }

    @Override
    public void deleteEmployeeauByCode(String tenantCode, String employeeauCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeauCode", employeeauCode);
        this.delEmployeeauModelByCode(map);
    }

    private void deleteEmployeeCache(OrgEmployee orgEmployee) {
        String[] s;
        if (null == orgEmployee) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekeydomain, (String)(orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        String str = "";
        if (StringUtils.isNotBlank((String)json)) {
            for (String string : s = json.split(",")) {
                if (string.equals(orgEmployee.getCompanyCode())) continue;
                str = str + "," + string;
            }
        }
        if (StringUtils.isBlank((String)str)) {
            DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cachekeydomain, (String)(orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)str);
        }
        json = DisUtil.getMap((String)this.cachekeyuserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        str = "";
        if (StringUtils.isNotBlank((String)json)) {
            for (String string : s = json.split(",")) {
                if (string.equals(orgEmployee.getCompanyCode())) continue;
                str = str + "," + string;
            }
        }
        if (StringUtils.isBlank((String)str)) {
            DisUtil.delMap((String)this.cachekeyuserdomain, (String[])new String[]{orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cachekeyuserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)str);
        }
        if (StringUtils.isBlank((String)orgEmployee.getOrgUsercode())) {
            return;
        }
        json = DisUtil.getMap((String)this.cachekeyorguserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        str = "";
        if (StringUtils.isNotBlank((String)json)) {
            for (String string : s = json.split(",")) {
                if (string.equals(this.getUser(orgEmployee))) continue;
                str = str + "," + string;
            }
        }
        if (StringUtils.isBlank((String)str)) {
            DisUtil.delMap((String)this.cachekeyorguserdomain, (String[])new String[]{orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cachekeyorguserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)str);
        }
    }

    private void updateEmployeeCache(OrgEmployee orgEmployee) {
        String[] s;
        if (null == orgEmployee) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekeydomain, (String)(orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        boolean flag = true;
        if (StringUtils.isNotBlank((String)json)) {
            for (String string : s = json.split(",")) {
                if (!string.equals(orgEmployee.getCompanyCode())) continue;
                flag = false;
            }
            if (flag) {
                json = json + ",";
            }
        } else {
            json = "";
        }
        if (flag) {
            json = json + orgEmployee.getCompanyCode();
        }
        DisUtil.setMapVer((String)this.cachekeydomain, (String)(orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)json);
        json = DisUtil.getMap((String)this.cachekeyuserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        flag = true;
        if (StringUtils.isNotBlank((String)json)) {
            for (String string : s = json.split(",")) {
                if (!string.equals(orgEmployee.getCompanyCode())) continue;
                flag = false;
            }
            if (flag) {
                json = json + ",";
            }
        } else {
            json = "";
        }
        if (flag) {
            json = json + orgEmployee.getCompanyCode();
        }
        DisUtil.setMapVer((String)this.cachekeyuserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)json);
        if (StringUtils.isBlank((String)orgEmployee.getOrgUsercode())) {
            return;
        }
        json = DisUtil.getMap((String)this.cachekeyorguserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        flag = true;
        if (StringUtils.isNotBlank((String)json)) {
            for (String string : s = json.split(",")) {
                if (!string.equals(this.getUser(orgEmployee))) continue;
                flag = false;
            }
            if (flag) {
                json = json + ",";
            }
        } else {
            json = "";
        }
        if (flag) {
            json = json + this.getUser(orgEmployee);
        }
        DisUtil.setMapVer((String)this.cachekeyorguserdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)json);
    }

    @Override
    public void queryEmployeeLoadCache() {
        this.logger.info("OrgEmployeeService.queryEmployeeLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<OrgEmployee> employeeList = this.queryEmployeeModelPage(parammap);
        if (null == employeeList || employeeList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachekeyuserdomain);
            DisUtil.delVer((String)this.cachekeyorguserdomain);
            this.logger.info("OrgEmployeeService.queryEmployeeLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> codeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> codeuserMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> codeorguserMap = new ConcurrentHashMap<String, String>();
        for (OrgEmployee orgEmployee : employeeList) {
            if (!StringUtils.isNotBlank((String)orgEmployee.getUserinfoCode())) continue;
            String valueStr = (String)codeMap.get(orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode());
            String valueuserStr = (String)codeuserMap.get(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode());
            valueStr = null == valueStr ? "" : valueStr + ",";
            valueuserStr = null == valueuserStr ? "" : valueuserStr + ",";
            valueStr = valueStr + orgEmployee.getCompanyCode();
            valueuserStr = valueuserStr + orgEmployee.getCompanyCode();
            codeMap.put(orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode(), valueStr);
            codeuserMap.put(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode(), valueuserStr);
            if (!StringUtils.isNotBlank((String)orgEmployee.getOrgUsercode())) continue;
            String valueorguserStr = (String)codeorguserMap.get(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode());
            valueorguserStr = null == valueorguserStr ? "" : valueorguserStr + ",";
            valueorguserStr = valueorguserStr + this.getUser(orgEmployee);
            codeorguserMap.put(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode(), valueorguserStr);
        }
        DisUtil.setMapVer((String)this.cachekeydomain, codeMap);
        DisUtil.setMapVer((String)this.cachekeyuserdomain, codeuserMap);
        DisUtil.setMapVer((String)this.cachekeyorguserdomain, codeorguserMap);
        this.logger.info("OrgEmployeeService.queryEmployeeLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public boolean queryEmployeeByPhone(String employeePhone, String tenantCode) {
        if (StringUtils.isBlank((String)employeePhone) && StringUtils.isBlank((String)tenantCode)) {
            return false;
        }
        OrgEmployee orgEmployee = this.orgEmployeeMapper.getByEmployeePhone(employeePhone, tenantCode);
        return orgEmployee != null;
    }

    @Override
    public OrgEmployee queryEmployeeByNum(String employeePhone, String tenantCode) {
        if (StringUtils.isBlank((String)employeePhone) && StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgEmployee orgEmployee = this.orgEmployeeMapper.getByEmployeePhone(employeePhone, tenantCode);
        if (orgEmployee == null) {
            return null;
        }
        return orgEmployee;
    }

    private String getUser(OrgEmployee orgEmployee) {
        if (null == orgEmployee) {
            return null;
        }
        return orgEmployee.getOrgUsercode() + "|" + "EMP" + "|" + orgEmployee.getCompanyCode() + "|" + orgEmployee.getEmployeeCode();
    }

    private void deleteEmployeeHandle(OrgEmployee orgEmployee) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", orgEmployee.getUserCode());
        map.put("tenantCode", orgEmployee.getTenantCode());
        String umUser = "";
        try {
            umUser = (String)this.getInternalRouter().inInvoke("um.user.getUserByUserCode", map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.deleteEmployee.getUserByUserCode", (Object)umUser);
        }
        UmUserReDomainBean UmUserStr = null;
        try {
            UmUserStr = (UmUserReDomainBean)JsonUtil.buildNonDefaultBinder().getJsonToObject(umUser, UmUserReDomainBean.class);
        }
        catch (Exception e) {
            this.logger.error("deleteEmployee.umUserStr", (Object)UmUserStr, (Throwable)e);
        }
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserDomainBean, (Object)UmUserStr);
        }
        catch (Exception e) {
            this.logger.error("deleteEmployee.umUserStrcopy", (Object)UmUserStr, (Throwable)e);
        }
        umUserDomainBean.setRoleCode(null);
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        try {
            this.getInternalRouter().inInvoke("um.user.updateUser", mapStr);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.deleteEmployee.updateUser", (Throwable)e);
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("userinfoCode", orgEmployee.getUserinfoCode());
        map1.put("tenantCode", orgEmployee.getTenantCode());
        String umUserinfo = "";
        try {
            umUserinfo = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", map1);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.deleteEmployee.getUserinfoByUserCode", (Object)umUserinfo);
        }
        UmUserinfoReDomainBean umUserinfoStr = null;
        try {
            umUserinfoStr = (UmUserinfoReDomainBean)JsonUtil.buildNonDefaultBinder().getJsonToObject(umUserinfo, UmUserinfoReDomainBean.class);
        }
        catch (Exception e) {
            this.logger.error("deleteEmployee.umUserinfoStr", (Object)umUserinfoStr, (Throwable)e);
        }
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUserinfoStr);
        }
        catch (Exception e) {
            this.logger.error("deleteEmployee.umUserStrcopycopy", (Object)UmUserStr, (Throwable)e);
        }
        umUserinfoDomainBean.setRoleCode(null);
        umUserinfoDomainBean.setUserinfoQuality("buy");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        try {
            this.getInternalRouter().inInvoke("um.user.updateUserinfoByUserinfoCode", param);
        }
        catch (Exception e) {
            this.logger.error("org.OrgEmployeeServiceImpl.deleteEmployee.updateUserinfoByUserinfoCode", (Throwable)e);
        }
    }

    private OrgEmployee getOrgEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        OrgEmployee orgEmployee = this.createOrgEmployee(orgEmployeeDomain);
        this.saveEmployeeModel(orgEmployee);
        this.updateEmployeeCache(orgEmployee);
        orgEmployeeDomain.setEmployeeCode(orgEmployee.getEmployeeCode());
        return orgEmployee;
    }

    private OrgEmployee getOrgEmployee(Integer employeeId) {
        OrgEmployee orgEmployee = this.getEmployee(employeeId);
        this.deleteEmployeeModel(employeeId);
        this.deleteEmployeeCache(orgEmployee);
        this.deleteEmployeeHandle(orgEmployee);
        return orgEmployee;
    }

    @Override
    public void updateEmployeeDpByCode(String tenantCode, String employeeCode, String employeeDp) throws ApiException {
        this.updateDpEmployeeModelByCode(tenantCode, employeeCode, employeeDp);
    }

    private List<OrgChannelsend> getOrgChannelsends(OrgEmployee orgEmployee) {
        Collection sendList = null;
        List<OrgChannelsend> resendList = null;
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        resendList = this.buidPmChannelsend(list, "delete");
        if (ListUtil.isNotEmpty(sendList)) {
            resendList.addAll(sendList);
        }
        return resendList;
    }

    private OrgEmployee getOrgEmployee(String tenantCode, String employeeCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeCode", employeeCode);
        OrgEmployee orgEmployee = this.getEmployeeByCode(tenantCode, employeeCode);
        this.delEmployeeModelByCode(map);
        this.deleteEmployeeCache(orgEmployee);
        return orgEmployee;
    }

    private List<OrgChannelsend> buidPmChannelsend(List<OrgEmployee> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<OrgChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<OrgChannelsendDomain> disChannelsendDomainList = new ArrayList<OrgChannelsendDomain>();
        for (OrgEmployee promotion : pmPromotionList) {
            OrgChannelsendDomain pmChannelsendDomain = new OrgChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getEmployeeCode());
            pmChannelsendDomain.setChannelsendType("orgEmployee");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.orgChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<OrgEmployeeReDomain> queryEmployeeReDomain(String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)companyCode)) {
            return null;
        }
        List<OrgEmployee> orgEmployeeList = this.queryEmployeeModelPage(this.getQueryMapParam("companyCode,employeeDp,tenantCode", new Object[]{companyCode, "0", tenantCode}));
        return this.makeTree(orgEmployeeList);
    }

    private List<OrgEmployeeReDomain> makeTree(List<OrgEmployee> orgEmployeeList) {
        if (ListUtil.isEmpty(orgEmployeeList)) {
            return null;
        }
        ArrayList<OrgEmployeeReDomain> orgEmployeeReDomainList = new ArrayList<OrgEmployeeReDomain>();
        for (OrgEmployee orgEmployee : orgEmployeeList) {
            OrgEmployeeReDomain orgEmployeeReDomain = this.makeReDomain(orgEmployee);
            if (null == orgEmployeeReDomain) continue;
            orgEmployeeReDomainList.add(orgEmployeeReDomain);
        }
        return orgEmployeeReDomainList;
    }

    private OrgEmployeeReDomain makeReDomain(OrgEmployee orgEmployee) {
        if (null == orgEmployee) {
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = new OrgEmployeeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgEmployeeReDomain, (Object)orgEmployee);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orgEmployeeReDomain;
    }

    private void updateUserinfoCode(String tenantCode, String employeeCode, String userinfoCode) {
        if (StringUtils.isBlank((String)employeeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("employeeCode", employeeCode);
        map.put("userinfoCode", userinfoCode);
        int i = 0;
        try {
            i = this.orgEmployeeMapper.updateUserinfoCodeByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateUserinfoCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateUserinfoCode.null", ((Object)map).toString());
        }
    }

    @Override
    public List<OrgChannelsend> updateUserinfoCodeByCode(String tenantCode, String employeeCode, String userinfoCode) throws ApiException {
        this.updateUserinfoCode(tenantCode, employeeCode, userinfoCode);
        OrgEmployee orgEmployee = this.getEmployeeByCode(tenantCode, employeeCode);
        if (null == orgEmployee) {
            throw new ApiException("org.OrgEmployeeServiceImpl.updateUserinfoCodeByCode.orgEmployee", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateEmployeeCache(orgEmployee);
        ArrayList<OrgEmployee> list = new ArrayList<OrgEmployee>();
        list.add(orgEmployee);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public void saveOrUpdateEmpBatch(List<OrgEmployeeDomain> orgEmployeeDomainList) throws ApiException {
        if (ListUtil.isEmpty(orgEmployeeDomainList)) {
            this.logger.error("org.OrgEmployeeServiceImpl.saveOrUpdateStoreGoodsBatch", (Object)"whStoreGoodsDomainList is null");
            return;
        }
        for (OrgEmployeeDomain orgEmployeeDomain : orgEmployeeDomainList) {
            if (orgEmployeeDomain.getEmployeeId() == null) {
                this.saveEmployee(orgEmployeeDomain);
                continue;
            }
            this.updateEmployee(orgEmployeeDomain);
        }
    }
}

